
/****************************************************************************
 *									 B m p . c p p							*
 ****************************************************************************/										 
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "stdafx.h"
#include "bmp.h"


/*
	To do: Generate Funktion weiter ausbauen:
	Aufbau der Bitmap ist als Grauskala fertig.
	Es fehlt noch:

	BMFH,
	BMIH,
	RGBQUAD array 
	BITMAPINFO = BMIH + RGBQUAD array
*/

/****************************************************************************
 *	CBmpImage.cpp				C B m p I m a g e				Constructor	*
 ****************************************************************************/
CBmpImage::CBmpImage ()
{
	m_bForPC = TRUE;

	m_szExt = "bmp";
	m_dwROP = SRCCOPY;
	m_dwLength = 0L;
    m_nBitsPerPix    = 0;
	
	m_lpBMIHbuffer = NULL;	// RGBQUAD list
	m_lpData	 = NULL;	// bitmap data 

	m_ptOldPal = NULL;



									// initialize BITMAPFILEHEADER (14 Bytes)

	m_BMFH.bfType = 0x4d42;
	m_BMFH.bfSize = 0;				// total file size in bytes
	m_BMFH.bfReserved1 = 0;
	m_BMFH.bfReserved2 = 0;
	m_BMFH.bfOffBits = 1078;		// start of lpData in file = BMFH + BMIH + RGBQUAD-Array



									// initialize BITMAPINFOHEADER (40 Bytes)
	m_BMIH.biSize = sizeof (BITMAPINFOHEADER);
	m_BMIH.biWidth = 0;					// see SetSize
	m_BMIH.biHeight = 0;				// see SetSize

	m_BMIH.biPlanes = 1;
	m_BMIH.biBitCount = 8;				// see SetSize
 
	m_BMIH.biCompression = 0;
	m_BMIH.biSizeImage = 0;				// see SetSize
	m_BMIH.biXPelsPerMeter = 0;
	m_BMIH.biYPelsPerMeter = 0;
	m_BMIH.biClrUsed = 0;
	m_BMIH.biClrImportant = 0;
}


/************************************************************************
 *  Bmp.cpp						D e s t r u c t o r 					*
 ************************************************************************/
CBmpImage::~CBmpImage()
{
	this->DestructImage();
}




/****************************************************************************
 *	HL_tools.c				R e v e r s e S H O R T							*
 ****************************************************************************/
short ReverseSHORT (short DOSShort)
{
short MACShort;
short	VARlen, i;

VARlen = 2;
for (i=0; i<VARlen; i++)
	*((unsigned char*)&MACShort + VARlen - 1 - i) = *((unsigned char*)&DOSShort + i); 
return MACShort;
}

/****************************************************************************
 *	HL_tools.c					R e v e r s e L O N G						*
 ****************************************************************************/
long ReverseLONG (long DOSLong)
{
long MACLong;
short	VARlen, i;

VARlen = 4;
for (i=0; i<VARlen; i++)
	*((unsigned char*)&MACLong + VARlen - 1 - i) = *((unsigned char*)&DOSLong + i); 
return MACLong;
}


/****************************************************************************
 *	bmp.cpp						R e v e r s e B M F H 						*
 ****************************************************************************/										 
void ReverseBMFH (PBITMAPFILEHEADER ptBMFH)
{
ptBMFH->bfType = (UINT)ReverseSHORT (ptBMFH->bfType);
ptBMFH->bfSize = (DWORD)ReverseLONG (ptBMFH->bfSize);
ptBMFH->bfReserved1 = (UINT)ReverseSHORT (ptBMFH->bfReserved1);
ptBMFH->bfReserved2 = (UINT)ReverseSHORT (ptBMFH->bfReserved2);
ptBMFH->bfOffBits = (DWORD)ReverseLONG (ptBMFH->bfOffBits);
}

/****************************************************************************
 *	bmp.cpp						R e v e r s e B M I H 						*
 ****************************************************************************/										 
void ReverseBMIH (PBITMAPINFOHEADER ptBMIH)
{
ptBMIH->biSize = (DWORD)ReverseLONG (ptBMIH->biSize);
ptBMIH->biWidth = (LONG)ReverseLONG (ptBMIH->biWidth);
ptBMIH->biHeight = (LONG)ReverseLONG (ptBMIH->biHeight);

ptBMIH->biPlanes = (WORD)ReverseSHORT (ptBMIH->biPlanes);
ptBMIH->biBitCount = (WORD)ReverseSHORT (ptBMIH->biBitCount);
 
ptBMIH->biCompression = (DWORD)ReverseLONG (ptBMIH->biCompression);
ptBMIH->biSizeImage = (DWORD)ReverseLONG (ptBMIH->biSizeImage);
ptBMIH->biXPelsPerMeter = (LONG)ReverseLONG (ptBMIH->biXPelsPerMeter);
ptBMIH->biYPelsPerMeter = (LONG)ReverseLONG (ptBMIH->biYPelsPerMeter);
ptBMIH->biClrUsed = (DWORD)ReverseLONG (ptBMIH->biClrUsed);
ptBMIH->biClrImportant = (DWORD)ReverseLONG (ptBMIH->biClrImportant);
}

/****************************************************************************
 *	bmp.cpp				G e t B m p B y t e s P e r R o w					*
 ****************************************************************************/										 
long GetBmpBytesPerRow (LONG lWidth, WORD wBitCount)
{
// Unabhngig  von der Farbtiefe und der tatschlichen Breite des Bildes setzt sich jede
// Bitmap-Zeile aus einer ganzzahling durch vier teilbaren Anzahl von Bytes zusammen, d.h.
// wird notfalls auf der rechten Seite mit 0-Bits bzw. Bytes aufgefllt.

long lBitsPerRow, lMinBytesPerRow, lRest, lBytesPerRow;

lBitsPerRow = 	lWidth *			// Pixels per Row
				wBitCount;			// Bits per Pixel
				

lMinBytesPerRow = lBitsPerRow / 8;
lRest = lBitsPerRow % 8;
if (lRest > 0) lMinBytesPerRow++;

lRest = lMinBytesPerRow % 4;

if (lRest == 0)
	{
	lBytesPerRow = lMinBytesPerRow;
	}
else{
	long lAddBytes;
	lAddBytes = 4 - lRest;
	lBytesPerRow = lMinBytesPerRow + lAddBytes;
	}
					
return lBytesPerRow;
}

/****************************************************************************
 *	bmp.cpp						R e a d B M F H								*
 ****************************************************************************/
BOOL CBmpImage::ReadBMFH (CFile& file, BOOL* ptReverse, BITMAPFILEHEADER* ptBMFH)
{
BOOL	bOK = FALSE;
UINT	lBytesToRead;

lBytesToRead = sizeof (BITMAPFILEHEADER);	// lBytesToRead = 14

lBytesToRead = sizeof (short);				// 2
file.Read((void*)&ptBMFH->bfType, lBytesToRead);
lBytesToRead = sizeof (DWORD);				// 4
file.Read((void*)&ptBMFH->bfSize, lBytesToRead);
lBytesToRead = sizeof (short);				// 2
file.Read((void*)&ptBMFH->bfReserved1, lBytesToRead);
lBytesToRead = sizeof (short);				// 2
file.Read((void*)&ptBMFH->bfReserved2, lBytesToRead);
lBytesToRead = sizeof (DWORD);				// 4
lBytesToRead = file.Read((void*)&ptBMFH->bfOffBits, lBytesToRead);

if (lBytesToRead > 0)
	{
	*ptReverse = (ptBMFH->bfType == 0x424d);	// if wrong file order: convert
												// Type should be 0x4d42 !!
	if (*ptReverse)
		ReverseBMFH (ptBMFH);

	bOK = TRUE;
	}
	
return bOK;
}

/****************************************************************************
 *	bmp.cpp						R e a d B M I H								*
 ****************************************************************************/
BOOL ReadBMIH (CFile& file, BOOL bReverse, BITMAPINFOHEADER* ptBMIH)
{
BOOL	bOK = FALSE;
UINT	lBytesToRead;

lBytesToRead = sizeof (BITMAPINFOHEADER);	
lBytesToRead = file.Read((void*)ptBMIH, lBytesToRead);

if (lBytesToRead > 0)
	{
	bOK = TRUE;
	if (bReverse)
		ReverseBMIH (ptBMIH);
	}
	

return bOK;
}



/****************************************************************************
 *	bmp.cpp						R e a d R G B Q U A D						*
 ****************************************************************************/
BOOL CBmpImage::ReadRGBQUAD (CFile& file, short nCnt, RGBQUAD* ptRGB)
{
	BOOL	bOK = TRUE;
	UINT	lBytesToRead;

	lBytesToRead = sizeof (RGBQUAD);	

	for (int i=0; i<nCnt && bOK; i++)
	{
		bOK = (lBytesToRead == file.Read((void*)(ptRGB + i), lBytesToRead));
	}

	return bOK;
}

/****************************************************************************
 *	bmp.cpp						W r i t e R G B Q U A D						*
 ****************************************************************************/
BOOL CBmpImage::WriteRGBQUAD (CFile& file, short nCnt, RGBQUAD* ptRGB)
{
	BOOL	bOK = TRUE;
	UINT	uBytesToWrite;

	uBytesToWrite = sizeof (RGBQUAD);	

	for (int i=0; i<nCnt && bOK; i++)
	{
		file.Write((void*)(ptRGB + i), uBytesToWrite);
	}

	return TRUE;
}


/****************************************************************************
 *	Bmp.cpp						S e t S i z e								*
 ****************************************************************************/
void CBmpImage::SetSize (long lHeight, long lWidth, unsigned short wBitCount, long lFileRowBytes)
{
	m_BMIH.biHeight = lHeight;
	m_BMIH.biWidth  = lWidth;
	m_BMIH.biBitCount = wBitCount;
	m_nNextRowOffs = (short)lFileRowBytes;
	m_BMIH.biSizeImage = lFileRowBytes * lHeight;		// 17472
}

/****************************************************************************
 *	Bmp.cpp						S e t S i z e								*
 ****************************************************************************/
BOOL CBmpImage::GetSize(CSize* ptSize)
{
	BOOL bOK = FALSE;

	if (m_dwLength != 0L)
	{
		ptSize->cy = m_BMIH.biHeight;
		ptSize->cx = m_BMIH.biWidth;
		bOK = TRUE;
	}
	else
	{
		ptSize->cy = ptSize->cx = 0;
	}

	return bOK;
}


/****************************************************************************
 *	Bmp.cpp						S e t R e s o l u t i o n					*
 ****************************************************************************/
void CBmpImage::SetResolution (long lPixPerMeterX, long lPixPerMeterY)
{
	m_BMIH.biXPelsPerMeter = lPixPerMeterX;
	m_BMIH.biYPelsPerMeter = lPixPerMeterY;
}


/****************************************************************************
 *	Bmp.cpp						S e t D a t a P t r 	 	 	 	 	 	*
 ****************************************************************************/
void CBmpImage::SetDataPtr(LPSTR lpData)
{
	if (m_lpData != NULL)					// free old memory!!
	{
		delete [] m_lpData;
		m_lpData = NULL;
	}
	
	m_lpData = lpData;
}

/****************************************************************************
 *	Bmp.cpp				G e n e r a t e P i x e l M a p						*
 ****************************************************************************/
BOOL CBmpImage::GenerateBmpPixelMap ()
{
	long	lFileRowBytes;
	DWORD	dwMemSize;
	BOOL	bOK = TRUE;
	UINT	uBytesToRead;

	BOOL bRGBDirect = (m_nBitsPerPix==24);			// 24 bit pixel??

	lFileRowBytes = GetBmpBytesPerRow (m_BMIH.biWidth, m_BMIH.biBitCount);

					// 24 bit pixels must be converted to 32 bit pixels
	m_nNextRowOffs = (short)((bRGBDirect)? 4*m_BMIH.biWidth : lFileRowBytes);

	dwMemSize = (short)m_BMIH.biHeight * m_nNextRowOffs;

	if (m_lpData != NULL)					// free old memory!!
	{
		delete [] m_lpData;
		m_lpData = NULL;
	}
	
	if (m_lpData == NULL)
		m_lpData = (LPSTR)new char[dwMemSize];

	if (m_lpData != NULL)
	{
		short nLine;
							// read rows of bitmap and store it in m_lpData
		for (int i=0; i< m_BMIH.biHeight && bOK; i++)
		{					
					// PC: start reading first row of pixels
					// Mac: start reading last row of pixels
			nLine = m_bForPC? i : (short)m_BMIH.biHeight - 1 - i;

									// for every line of 1-2-4-8-bit-pixels:
			uBytesToRead = m_nNextRowOffs;
			for (int j=0; j < m_nNextRowOffs; j++)
			{
				unsigned char pixel = (unsigned char)(255.0 * j / m_nNextRowOffs);
				*(m_lpData + nLine * m_nNextRowOffs + j) = (char)pixel;
			}
			
		} // for line...
	}
return bOK;
}


/****************************************************************************
 *	Bmp.cpp					R e a d P i x e l M a p							*
 ****************************************************************************/
BOOL CBmpImage::ReadBmpPixelMap (CFile& file)
{
	long	lFileRowBytes;
	DWORD	dwMemSize;
	BOOL	bOK = TRUE;
	UINT	lBytesToRead;

	BOOL bRGBDirect = (m_nBitsPerPix==24);			// 24 bit pixel??

	lFileRowBytes = GetBmpBytesPerRow (m_BMIH.biWidth, m_BMIH.biBitCount);

					// 24 bit pixels must be converted to 32 bit pixels
	m_nNextRowOffs = (short)((bRGBDirect)? 4*m_BMIH.biWidth : lFileRowBytes);

	dwMemSize = (short)m_BMIH.biHeight * m_nNextRowOffs;

	if (m_lpData != NULL)					// free old memory!!
	{
		delete [] m_lpData;
		m_lpData = NULL;
	}
	
	if (m_lpData == NULL)
		m_lpData = (LPSTR)new char[dwMemSize];

	if (m_lpData != NULL)
	{
		short nLine;
		LPSTR ptLine24=NULL;

		if (bRGBDirect)
		{					// allocate memory to read one line of pixels	
			ptLine24 = (LPSTR)new char[lFileRowBytes];
		}

							// read rows of bitmap and store it in m_lpData
		for (int i=0; i< m_BMIH.biHeight && bOK; i++)
		{					
					// PC: start reading first row of pixels
					// Mac: start reading last row of pixels
			nLine = m_bForPC? i : (short)m_BMIH.biHeight - 1 - i;

			if (bRGBDirect)
			{					// for every line of 24-bit-pixels:
				// read 3 bytes per pixel from file and
				// write 4 bytes per pixel into memory (first byte = 0)
				// reason: CopyBits supports only 16 or 32 bits per pixel!!
				
				short nPixIndex;
				short nBytesOfScrPix = m_BMIH.biBitCount / 8;
				short nOffs = 4 - nBytesOfScrPix;
				memset ((m_lpData + nLine * m_nNextRowOffs), 0, m_nNextRowOffs);
				if (ptLine24 != NULL)
				{	
					lBytesToRead = lFileRowBytes;		// read line of 24-bit-pixels
					bOK = (lBytesToRead == file.Read((void*)ptLine24, lBytesToRead));

					for (nPixIndex=0; nPixIndex<m_BMIH.biWidth; nPixIndex++)
					{							// for every pixel of this line:
						short nByteIndex;		// expand to line of 32-bit-pixels
						long lMemoryOffs = nLine * m_nNextRowOffs + nPixIndex*4 + nOffs;
						
						if (m_bForPC)
						{
							for (nByteIndex=0; nByteIndex<nBytesOfScrPix; nByteIndex++)
								*(m_lpData + lMemoryOffs + nByteIndex) = *(ptLine24 + nPixIndex*3 + nByteIndex);
						}
						else
						{			// for mac:
							for (nByteIndex=0; nByteIndex<nBytesOfScrPix; nByteIndex += 3)
							{				// Mac Order: BGR, Bmp Order: RGB => exchange Blue and Red
								*(m_lpData + lMemoryOffs + nByteIndex+0) = *(ptLine24 + nPixIndex*3 + nByteIndex+2);
								*(m_lpData + lMemoryOffs + nByteIndex+1) = *(ptLine24 + nPixIndex*3 + nByteIndex+1);
								*(m_lpData + lMemoryOffs + nByteIndex+2) = *(ptLine24 + nPixIndex*3 + nByteIndex+0);
							}
						}
					}
				}
			}
		else{							// for every line of 1-2-4-8-bit-pixels:
			lBytesToRead = m_nNextRowOffs;
			bOK = (lBytesToRead == file.Read((void*)(m_lpData + nLine * m_nNextRowOffs), lBytesToRead));
			}
		} // for line...

		if (ptLine24 != NULL)
		{
			delete [] ptLine24;
			ptLine24 = NULL;
		}
	}
return bOK;
}

/****************************************************************************
 *	Bmp.cpp					W r i t e P i x e l M a p						*
 ****************************************************************************/
BOOL CBmpImage::WriteBmpPixelMap (CFile& file)
{

	BOOL bWritten = FALSE;

	BOOL bRGBDirect = (m_nBitsPerPix==24);			// 24 bit pixel??

	if (bRGBDirect)
	{

	}
	else
	{							// for every line of 1-2-4-8-bit-pixels:
		UINT uBytesToWrite = m_nNextRowOffs * m_BMIH.biHeight;		
		file.Write((void*)(m_lpData), uBytesToWrite);
		bWritten = TRUE;
	}

	return bWritten;
}

/************************************************************************
 *  Dib.cpp 					R e a d									*
 *	Purpose: Reads a *.BMP. pFile must be opened						*
 ************************************************************************/
BOOL CBmpImage::Read(CFile& file)
{
	BOOL bRead = FALSE;
	BOOL bReverse;
	ASSERT(m_dwLength == 0L); 	// DIB must be empty
	m_dwLength = (DWORD)file.GetLength();

							// read bitmap file header
	if(ReadBMFH (file, &bReverse, &m_BMFH))
	{
		if (m_BMFH.bfType != 0x4d42) 
		{
			AfxMessageBox("Invalid bitmap file");
			return FALSE;
		}
	}


								// read bitmap info header	
	if(ReadBMIH (file, bReverse, &m_BMIH))
	{
		ASSERT((m_BMIH.biBitCount == 1) || (m_BMIH.biBitCount == 4) ||
			   (m_BMIH.biBitCount == 8) || (m_BMIH.biBitCount == 24));
		m_nBitsPerPix = m_BMIH.biBitCount;

		if ((m_BMIH.biBitCount == 1) || 
			(m_BMIH.biBitCount == 4) ||
      		(m_BMIH.biBitCount == 8) || 
			(m_BMIH.biBitCount == 24))
		{		
			m_nBitsPerPix = m_BMIH.biBitCount;		//Farbbits pro Pixel
			
			
			m_rgbPal.palVersion 	= 0x300;
			m_rgbPal.palNumEntries	= 0;
			
			if (m_BMIH.biBitCount > 0)
				m_rgbPal.palNumEntries	= (WORD)(1L << (long)m_BMIH.biBitCount);
			if (m_BMIH.biClrUsed > 0)
				m_rgbPal.palNumEntries = (WORD)m_BMIH.biClrUsed;




									// create buffer to build BITMAPINFO struct
			DWORD dwMemSize = sizeof (BITMAPINFOHEADER) + 
							m_rgbPal.palNumEntries * sizeof (RGBQUAD);

			m_lpBMIHbuffer = (LPSTR) new char[dwMemSize];
			
									// copy BITMAPINFOHEATER into buffer
			memcpy (m_lpBMIHbuffer, &m_BMIH, sizeof (BITMAPINFOHEADER));

									// read RGBQUAD array into buffer	
			RGBQUAD* ptRGBQuads = (RGBQUAD*)(m_lpBMIHbuffer + sizeof (BITMAPINFOHEADER));
			
			if (ReadRGBQUAD (file, m_rgbPal.palNumEntries, ptRGBQuads))

								// use buffer to make BITMAPINFO struct
				m_lpBMI = (LPBITMAPINFO)m_lpBMIHbuffer;
		}





		for (int i=0; i<m_rgbPal.palNumEntries; i++)
		{
			PALETTEENTRY PalEntry = m_rgbPal.palPalEntry[i];
			RGBQUAD rgb = m_lpBMI->bmiColors[i];
				
										// copy RGBQUAD into PALETTEENTRY
			PalEntry.peRed		= rgb.rgbRed;
			PalEntry.peGreen	= rgb.rgbGreen;
			PalEntry.peBlue		= rgb.rgbBlue;
			PalEntry.peFlags	= rgb.rgbReserved;
		}

	
//		if (m_Palette.CreatePalette((LOGPALETTE*) &m_rgbPal) == 0)
//			AfxMessageBox ("Bad Create Palette!");				

		long lOffs = m_BMFH.bfOffBits;		// Startadresse der Bitmap daten
		file.Seek(lOffs, CFile::begin);
		if (this->ReadBmpPixelMap (file))
		{
			bRead = TRUE;
		}		
	}

return bRead;
}


/************************************************************************
 *  Bmp.cpp 				S e t C o l o r T a b l e					*
 *	Purpose: defines RGBQUAD array and number of palette entries		*
 ************************************************************************/
void CBmpImage::SetColorTable(short nEntries, RGBQUAD* ptRGBQuads)
{
	m_rgbPal.palNumEntries = nEntries;
	
	short nPalSize = m_rgbPal.palNumEntries * sizeof (RGBQUAD);

	DWORD dwMemSize = sizeof (BITMAPINFOHEADER) + nPalSize;

	if (m_lpBMIHbuffer != NULL)
		delete [] m_lpBMIHbuffer;

	m_lpBMIHbuffer = (LPSTR) new char[dwMemSize];
	
							// copy BITMAPINFOHEATER into buffer
	memcpy (m_lpBMIHbuffer, &m_BMIH, sizeof (BITMAPINFOHEADER));

							// read RGBQUAD array into buffer	
	RGBQUAD* ptDestQuads = (RGBQUAD*)(m_lpBMIHbuffer + sizeof (BITMAPINFOHEADER));
	
	memcpy (ptDestQuads, ptRGBQuads, nPalSize);

								// use buffer to make BITMAPINFO struct
	m_lpBMI = (LPBITMAPINFO)m_lpBMIHbuffer;


//typedef struct tagLOGPALETTE8
//	{
//	WORD		palVersion;
//	WORD		palNumEntries;
//	PALETTEENTRY	palPalEntry[256];	// PC: PALETTEENTRY: red,green,blue,flags
//	} LOGPALETTE8;

//	LOGPALETTE8 m_rgbPal
										// define m_rgbPal struct
	m_rgbPal.palVersion 	= 0x300;
	for (int i=0; i<m_rgbPal.palNumEntries; i++)
	{
		RGBQUAD rgb = m_lpBMI->bmiColors[i];

		m_rgbPal.palPalEntry[i].peRed	= rgb.rgbRed;
		m_rgbPal.palPalEntry[i].peGreen = rgb.rgbGreen;
		m_rgbPal.palPalEntry[i].peBlue	= rgb.rgbBlue;
		m_rgbPal.palPalEntry[i].peFlags = rgb.rgbReserved;
	}

	
//	m_Palette.DeleteObject();  // vorher lschen!
//	if (m_Palette.CreatePalette((LOGPALETTE*) &m_rgbPal) == 0)
//		AfxMessageBox ("Bad Create Palette!");				

}

/************************************************************************
 *  Bmp.cpp 					G e n e r a t e							*
 *	Purpose: Reads a *.BMP. pFile must be opened						*
 ************************************************************************/
BOOL CBmpImage::Generate()
{
	BOOL bRead = FALSE;

	ASSERT((m_BMIH.biBitCount == 1) || (m_BMIH.biBitCount == 4) ||
		   (m_BMIH.biBitCount == 8) || (m_BMIH.biBitCount == 24));
	m_nBitsPerPix = m_BMIH.biBitCount;

	if ((m_BMIH.biBitCount == 1) || 
		(m_BMIH.biBitCount == 4) ||
      	(m_BMIH.biBitCount == 8) || 
		(m_BMIH.biBitCount == 24))
	{		
		m_nBitsPerPix = m_BMIH.biBitCount;		//Farbbits pro Pixel
		
		
		m_rgbPal.palVersion 	= 0x300;
		m_rgbPal.palNumEntries	= 0;
		
		if (m_BMIH.biBitCount > 0)
			m_rgbPal.palNumEntries	= (WORD)(1L << (long)m_BMIH.biBitCount);
		if (m_BMIH.biClrUsed > 0)
			m_rgbPal.palNumEntries = (WORD)m_BMIH.biClrUsed;

	}

	long lOffs =	sizeof (BITMAPFILEHEADER) + 
					sizeof(BITMAPINFOHEADER) +
					m_rgbPal.palNumEntries * sizeof (RGBQUAD);
	m_dwLength =	lOffs +	m_BMIH.biSizeImage;

	m_BMFH.bfType = 0x4d42;
	m_BMFH.bfSize = m_dwLength;		// total file size in bytes (18550)
	m_BMFH.bfReserved1 = 0;
	m_BMFH.bfReserved2 = 0;
	m_BMFH.bfOffBits = lOffs;		// start of lpData in file = BMFH + BMIH + RGBQUAD-Array (1078)

return TRUE;
}

/****************************************************************************
 *	HL_tools.c				I m a g e R o w T o H e x						*
 ****************************************************************************/										 
void ImageRowToHex (CFile* ptFile, char* ptRow, short nBitsPerPixel, short nBytesPerRow)
{
UINT	lDataSize;
short i, nByteOfRow;
char	szMsg[255];

nByteOfRow = 1;
for (i=0; i<nBytesPerRow; i++)
	{
	unsigned char	hex;
	hex = *(ptRow + i);
	
	lDataSize = (UINT)sprintf(szMsg,"%02x ",hex);
	ptFile->Write((void*)szMsg, lDataSize);
	
	if (nBitsPerPixel == 24)
		{			// insert separator after every 4. byte
		if (nByteOfRow/4 == (float)nByteOfRow/4)
			{
			lDataSize = (UINT) sprintf(szMsg,"  ");
			ptFile->Write((void*)szMsg, lDataSize);
			}
		}
		
	if (nByteOfRow/20 == (float)nByteOfRow/20.)
		{
		lDataSize = (UINT) sprintf(szMsg,"\n");
		ptFile->Write((void*)szMsg, lDataSize);
		nByteOfRow = 0;
		}
		
	nByteOfRow++;	
	}		

lDataSize = (long) sprintf(szMsg,"\n");
ptFile->Write((void*)szMsg, lDataSize);
}

/****************************************************************************
 *	bmp.cpp						I n f o F i l e								*
 ****************************************************************************/										 
BOOL CBmpImage::InfoFile (CString szFileTitle)
{
	BOOL bLength=FALSE;

	if (szFileTitle.GetLength() > 0)
	{
		CFile* ptFile = new CFile ();
		ptFile->Open(szFileTitle, CFile::modeCreate | CFile::modeNoInherit | CFile::modeWrite, NULL); 

	
		unsigned char* ptBuff = NULL;
		char szMsg[256];
		UINT	lDataSize;

		lDataSize = (UINT)szFileTitle.GetLength();		// title
		ptFile->Write((void*)(LPCTSTR)szFileTitle, lDataSize);
		
		lDataSize = (UINT)sprintf(szMsg,"\n\nAus File Header:\n");	
		ptFile->Write((void*)szMsg, lDataSize);
		
		lDataSize = (UINT)sprintf(szMsg,"bfType: 0%2x \n",m_BMFH.bfType);	
		ptFile->Write((void*)szMsg, lDataSize);
		
		lDataSize = (UINT)sprintf(szMsg,"Dateigre in Bytes: %ld\n",m_BMFH.bfSize);	
		ptFile->Write((void*)szMsg, lDataSize);
		
		lDataSize = (UINT)sprintf(szMsg,"\n\nAus Info Header:\n");	
		ptFile->Write((void*)szMsg, lDataSize);

		lDataSize = (UINT)sprintf(szMsg,"Breite in Pixeln: %ld\n",m_BMIH.biWidth);	
		ptFile->Write((void*)szMsg, lDataSize);
		
		lDataSize = (UINT)sprintf(szMsg,"Hhe in Pixeln: %ld\n",m_BMIH.biHeight);	
		ptFile->Write((void*)szMsg, lDataSize);
		
		lDataSize = (UINT)sprintf(szMsg,"Planes: %d\n",m_BMIH.biPlanes);	
		ptFile->Write((void*)szMsg, lDataSize);

		lDataSize = (UINT)sprintf(szMsg,"Farbbits pro Pixel: %d\n",m_BMIH.biBitCount);	
		ptFile->Write((void*)szMsg, lDataSize);

		lDataSize = (UINT)sprintf(szMsg,"Kennziffer fr Kompimierung: %ld\n",m_BMIH.biCompression);	
		ptFile->Write((void*)szMsg, lDataSize);

		lDataSize = (UINT)sprintf(szMsg,"Bitmap in Bytes: %ld\n",m_BMIH.biSizeImage);	
		ptFile->Write((void*)szMsg, lDataSize);

		lDataSize = (UINT)sprintf(szMsg,"Horizontal: Pixel pro Meter: %ld\n",m_BMIH.biXPelsPerMeter);	
		ptFile->Write((void*)szMsg, lDataSize);

		lDataSize = (UINT)sprintf(szMsg,"Vertikal: Pixel pro Meter: %ld\n",m_BMIH.biYPelsPerMeter);	
		ptFile->Write((void*)szMsg, lDataSize);

		lDataSize = (UINT)sprintf(szMsg,"Anzahl verwendeter Farben: %ld\n",m_BMIH.biClrUsed);	
		ptFile->Write((void*)szMsg, lDataSize);

		lDataSize = (UINT)sprintf(szMsg,"Anzahl wichtiger Farben: %ld\n",m_BMIH.biClrImportant);	
		ptFile->Write((void*)szMsg, lDataSize);

		
		if (m_lpData != NULL)
			{			
			long lOffs;							// offset to middle line of pixels
													// print bytes of middle row
			lOffs = (long)m_nNextRowOffs * (long)(m_BMIH.biHeight/2);
			ImageRowToHex (ptFile, m_lpData+lOffs, m_nBitsPerPix, m_nNextRowOffs);
				
			lOffs += m_nNextRowOffs;			// print bytes of next row
			ImageRowToHex (ptFile, m_lpData+lOffs, m_nBitsPerPix, m_nNextRowOffs);
			}

		
		lDataSize = (UINT)sprintf(szMsg,"\n\nFarbtabelle:\n");	
		ptFile->Write((void*)szMsg, lDataSize);
		
		lDataSize = (UINT)sprintf(szMsg,"Anzahl der Indexfarben: %d\n",m_rgbPal.palNumEntries);	
		ptFile->Write((void*)szMsg, lDataSize);
								
																// read color table		

		short i;
		for (i=0; i<m_rgbPal.palNumEntries; i++)
		{
			PALETTEENTRY palEntry = m_rgbPal.palPalEntry[i];
			lDataSize = (UINT)sprintf(szMsg,"Index %03d: %3d %3d %3d\n",
					i, (int)palEntry.peRed, (int)palEntry.peGreen, (int)palEntry.peBlue);
			ptFile->Write((void*)szMsg, lDataSize);
		}

		
		ptFile->Close();		/* Close destination file			*/
		bLength = TRUE;
		}

return (bLength);
}


/************************************************************************
 *  Bmp.cpp 					S e t M o n o C o l o r s				*
 ************************************************************************/
void CBmpImage::SetMonoColors(DWORD dwForeground, DWORD dwBackground)
{
if (m_nBitsPerPix != 1) 
    return;

	*((long*)(m_rgbPal.palPalEntry + 0)) = dwForeground;
	*((long*)(m_rgbPal.palPalEntry + 1)) = dwBackground;
	
return;
}

/************************************************************************
 *  Bmp.cpp 					G e t M o n o C o l o r s				*
 ************************************************************************/
BOOL CBmpImage::GetMonoColors(DWORD& dwForeground, DWORD& dwBackground)
{
	if (m_nBitsPerPix != 1) 
		return FALSE;

	dwForeground = *((long*)(m_rgbPal.palPalEntry + 0));
	dwBackground = *((long*)(m_rgbPal.palPalEntry + 1));

return TRUE;
}


/************************************************************************
 *  Bmp.cpp 					M a k e B i t m a p						*
 ************************************************************************/
CBitmap* CBmpImage::MakeBitmap(CDC* pDC, CSize& bmSize)
{
		    // replaces the DC's existing bitmap with a new one from the DIB
		    // returns the old one
BITMAP bm;
DWORD  dwFore, dwBack;

			// checks to see whether DIB buffer is properly loaded
if (m_dwLength == 0L) 
	{
    bmSize.cx = bmSize.cy = 0;
    return NULL;
    }

   			 // this code conditions the bitmap for mono or color
int nPlanes = pDC->GetDeviceCaps(PLANES);
int nBitsPixel = pDC->GetDeviceCaps(BITSPIXEL);

CBitmap* pConfigurationBmp = new CBitmap;
char bits[100];

if (m_BMIH.biBitCount == 1) 
	{
    pConfigurationBmp->CreateBitmap(1, 1, 1, 1, bits);
    }
else{
    pConfigurationBmp->CreateBitmap(1, 1, nPlanes, nBitsPixel, bits);
    }

CBitmap* pOldBmpOfDC = (CBitmap*)pDC->SelectObject(pConfigurationBmp);

	// CreateDIBitmap "switches bits" for mono bitmaps, depending on colors,
	//  so we'll fool it
if (GetMonoColors(dwFore, dwBack)) 
	SetMonoColors(0L, 0xFFFFFFL);
   
#ifdef _WIN32
    HBITMAP hBitmap = ::CreateDIBitmap(pDC->GetSafeHdc(), &m_lpBMI->bmiHeader,
		CBM_INIT, (CONST BYTE*) (m_lpData),
            m_lpBMI, DIB_RGB_COLORS);		  	// DIB_RGB_COLORS or DIB_PAL_COLORS
#else
    HBITMAP hBitmap = ::CreateDIBitmap(pDC->GetSafeHdc(), &m_lpBMI->bmiHeader,
            CBM_INIT, (LPSTR) (m_lpData),
            m_lpBMI, DIB_RGB_COLORS);		   	// or: DIB_PAL_COLORS
#endif

if (hBitmap == NULL) 
	{
    TRACE("null bitmap\n");  
    delete pDC->SelectObject(pOldBmpOfDC); // delete config bitmap
    return NULL; // untested error logic
    }
    
SetMonoColors(dwFore, dwBack);

			// Can't use CBitmap::FromHandle here because we need to
			//  delete the object later
CBitmap* pNewBmpOfDC = new CBitmap;		// deleted in CBmpImage::Deselect
pNewBmpOfDC->Attach(hBitmap);
pNewBmpOfDC->GetObject(sizeof(bm), &bm);
bmSize.cx = bm.bmWidth;
bmSize.cy = bm.bmHeight;
delete pDC->SelectObject(pNewBmpOfDC); // deletes pConfigurationBmp

return pOldBmpOfDC;
}


/************************************************************************
 *  Dib.cpp 				C r e a t e P a l e t t e					*
 ************************************************************************/
BOOL CBmpImage::CreatePalette(CDC* pDC)
{
	if (m_Palette.CreatePalette((LOGPALETTE*) &m_rgbPal) == 0)
	{
		AfxMessageBox ("Bad Create Palette!");	
		return FALSE;
	}

	BOOL bForceBackground = FALSE;
	m_ptOldPal = pDC->SelectPalette (&m_Palette, bForceBackground); 
	if (m_ptOldPal != NULL)
		pDC->RealizePalette();

	return TRUE;
}

/************************************************************************
 *  Dib.cpp 				D e l e t e P a l e t t e					*
 ************************************************************************/
void CBmpImage::DeletePalette(CDC* pDC)
{
	if (m_ptOldPal != NULL)
	{
		BOOL bForceBackground = FALSE;
		if (pDC->SelectPalette (m_ptOldPal, bForceBackground) != NULL) 
		{
			pDC->RealizePalette();
			m_Palette.DeleteObject();
			m_ptOldPal = NULL;
		}
	}
}



/************************************************************************
 *  Dib.cpp 					D i s p l a y							*
 ************************************************************************/
BOOL CBmpImage::Display(CDC* pDC, CPoint origin)
{
	BOOL bOK = TRUE;
    // direct to device--bypass the GDI bitmap
	if (!m_lpData) 
		return FALSE; // nothing to display

	if (this->CreatePalette(pDC))
	{

		if (!::SetDIBitsToDevice(pDC->GetSafeHdc(), origin.x, origin.y,
		   (DWORD) m_BMIH.biWidth, (DWORD) abs(m_BMIH.biHeight), 0, 0, 
		   (UINT)0,(UINT)abs(m_BMIH.biHeight), m_lpData, m_lpBMI,
		   DIB_RGB_COLORS))  				// DIB_RGB_COLORS or DIB_PAL_COLORS
		{
			DWORD dwErr = GetLastError();
			CString szMsg;
			szMsg.Format ("CBmpImage::Display SetDIBitsToDevice Error = %d", dwErr);
			if (dwErr != NO_ERROR)
				AfxMessageBox (szMsg);
			bOK = FALSE;
		}

		this->DeletePalette(pDC);
	}

return bOK;
}


/************************************************************************
 *  Dib.cpp 					S t r e t c h							*
 ************************************************************************/
BOOL CBmpImage::Stretch(CDC* pDC, CPoint origin, CSize size)
{
	BOOL bOK = TRUE;
   			 // direct to device--bypass the GDI bitmap
	if (!m_lpData)
		return FALSE; // nothing to display

	if (this->CreatePalette(pDC))
	{
		WORD wSrcPixSizeY = (WORD)((m_BMIH.biHeight > 0)? m_BMIH.biHeight : -m_BMIH.biHeight); 



		if (!::StretchDIBits(
					pDC->GetSafeHdc(),	// handle of device context 
					origin.x,			// x-coordinate of upper-left corner of dest. rect. 
					origin.y,			// y-coordinate of upper-left corner of dest. rect. 
					size.cx,			// width of destination rectangle 
					size.cy,			// height of destination rectangle 
					0,					// x-coordinate of upper-left corner of source rect. 
					0,					// y-coordinate of upper-left corner of source rect. 
					(int)m_BMIH.biWidth,	// width of source rectangle 
					(int)wSrcPixSizeY,		// height of source rectangle 
					m_lpData,			// address of bitmap bits 
					m_lpBMI,			// address of bitmap data (BITMAPINFO *)
					DIB_RGB_COLORS,		// usage 
					m_dwROP				// raster operation code 
					))
			{
			bOK = FALSE;
			}
		this->DeletePalette(pDC);
	}

return bOK;
}

/************************************************************************
 *  CBmpImage.cpp 					W r i t e 							*
 ************************************************************************/
BOOL CBmpImage::Write(CFile& file)
{

TRY {
		file.Write((void*)&m_BMFH, sizeof (BITMAPFILEHEADER));
		file.Write((void*)&m_BMIH, sizeof (BITMAPINFOHEADER));
	
		WriteRGBQUAD (file, m_rgbPal.palNumEntries, m_lpBMI->bmiColors);
		WriteBmpPixelMap(file);
    }

CATCH (CException, e) 
	{
    AfxMessageBox("Write error--possible disk full condition");
    return FALSE;
    }
END_CATCH

return TRUE;
}

/************************************************************************
 *  Bmp.cpp						D e s t r u c t I m a g e				*
 ************************************************************************/
void CBmpImage::DestructImage()
{
	if (m_lpBMIHbuffer != NULL)
	{						// free bitmap file header
		delete [] m_lpBMIHbuffer;
		m_lpBMIHbuffer = NULL;
	}
	
	if (m_lpData != NULL) 
	{
		delete [] m_lpData;
		m_lpData    = NULL;
	}

	m_dwLength = 0;
}
