
#ifndef __BMP_TYPE__
#define __BMP_TYPE__

/****************************************************************************
 *									b m p . h 								*
 ****************************************************************************/
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

typedef struct tagLOGPALETTE8
	{
	WORD		palVersion;
	WORD		palNumEntries;
	PALETTEENTRY	palPalEntry[256];	// PC: PALETTEENTRY: red,green,blue,flags
	} LOGPALETTE8;
										// Mac: RGBQUAD: blue,green,red,reserved

long GetBmpBytesPerRow (LONG lWidth, WORD wBitCount);

class CBmpImage : public CObject
{
private:
	CString		m_szExt;
	char*		m_hData;
    DWORD    	m_dwLength; // total buffer length, including file header
    int       	m_nBitsPerPix;    // number of color bits per pixel
	short		m_nNextRowOffs;
	DWORD		m_dwROP;

    //pointers for internal use
    BITMAPFILEHEADER m_BMFH;
	BITMAPINFOHEADER m_BMIH;

    BITMAPINFO*      m_lpBMI;		// contains BITMAPINFOHEADER and RGBQUAD list
	LPSTR			 m_lpBMIHbuffer;

    LPSTR           m_lpData; 

	LOGPALETTE8 m_rgbPal;
	CPalette	m_Palette;
	CPalette*	m_ptOldPal;

	CDC* 	m_pDisplayMemDC;
	HBITMAP m_hOldDisplayBitmap;

	BOOL m_bForPC;

public:
	CBmpImage();
//    CBmpImage(CDC* pDC, int nBt = 0, BOOL bCompr = TRUE);
    // nBt = 0 means use default bits/pixel
    ~CBmpImage();

	void SetROPCode (DWORD dwROP) { m_dwROP = dwROP; }
	CBitmap* MakeBitmap(CDC* pDC, CSize& bmSize);

//    virtual void Serialize(CArchive &ar);
	void SetSize (long lHeight, long lWidth, unsigned short wBitCount, long lFileRowBytes);
	BOOL GetSize(CSize* ptSize);
	void SetResolution (long lPixPerMeterX, long lPixPerMeterY);
	void SetDataPtr(LPSTR lpData);
	BOOL Generate();
	void SetColorTable(short nEntries, RGBQUAD* ptRGBQuads);
    BOOL Read(CFile& file);
    BOOL Write(CFile& file);

	BOOL Display(CDC* pDC, CPoint origin);
	BOOL Stretch(CDC* pDC, CPoint origin, CSize size);

	BOOL InfoFile (CString szFileTitle);
	void DestructImage();

private:
	void SetMonoColors(DWORD dwForeground, DWORD dwBackground);
	BOOL GetMonoColors(DWORD& dwForeground, DWORD& dwBackground);
	BOOL ReadBMFH (CFile& file, BOOL* ptReverse, BITMAPFILEHEADER* ptBMFH);
	BOOL ReadRGBQUAD (CFile& file, short nCnt, RGBQUAD* ptRGB);
	BOOL WriteRGBQUAD (CFile& file, short nCnt, RGBQUAD* ptRGB);

	BOOL GenerateBmpPixelMap ();
	BOOL ReadBmpPixelMap (CFile& file);
	BOOL WriteBmpPixelMap (CFile& file);
	BOOL CreatePalette(CDC* pDC);
	void DeletePalette(CDC* pDC);

};

#endif
