// CDirSelectDlg.cpp: implementation of the CDirSelectDlg class.
//
// Author:	Bill Oatman
// Version:	1.0
// WebPage:	http://www.netacc.net/~waterbry/dirbrowse/dirbrowse.htm
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "DirBrDlg.h"
#include <shlobj.h>

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

/****************************************************************************
 *	DirBrDlg.cpp				C D i r S e l e c t D l g		Constructor	*
 ****************************************************************************/
CDirSelectDlg::CDirSelectDlg(CString szTitle)
{
m_title = szTitle;
m_directory = "";
}

/****************************************************************************
 *	DirBrDlg.cpp				~ C D i r S e l e c t D l g 	Destructor	*
 ****************************************************************************/
CDirSelectDlg::~CDirSelectDlg()
{

}

/****************************************************************************
 *	DirBrDlg.cpp					S e t T i t l e							*
 ****************************************************************************/
void CDirSelectDlg::SetTitle(CString szTitle)
{
//char m_szDlgInfo[128];
//wsprintf ((LPSTR)m_szDlgInfo, (LPCTSTR)szTitle);

m_title = szTitle;
}

/****************************************************************************
 *	DirBrDlg.cpp					D o M o d a l							*
 ****************************************************************************/
bool CDirSelectDlg::DoModal()
{
BROWSEINFO bi;
char DirName[MAX_PATH];
int imageIndex = 0;
LPITEMIDLIST pidl;
LPMALLOC pmalloc = NULL;

SHGetMalloc(&pmalloc);

bi.hwndOwner = NULL;
bi.pidlRoot = NULL;
bi.pszDisplayName = DirName;
bi.lpszTitle = (LPCTSTR)m_title;
bi.ulFlags = BIF_RETURNONLYFSDIRS;
bi.lpfn = NULL;
bi.lParam = NULL;
bi.iImage = imageIndex;

pidl = SHBrowseForFolder(&bi);

if(pidl)
	{
	SHGetPathFromIDList(pidl, DirName);
	m_directory = DirName;
	pmalloc->Free(pidl);
	}

pmalloc->Release();

if(pidl)
	return TRUE;
else
	return FALSE;
}

/****************************************************************************
 *	DirBrDlg.cpp					G e t D i r e c t o r y					*
 ****************************************************************************/
void CDirSelectDlg::GetDirectory(CString& directory)
{
directory = m_directory;
}
