/************************************************************************
 *  							i m a g e . c p p 	  					*
 ************************************************************************/
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "stdafx.h"
#include "image.h"

#include "DIRECT.H"			// getcwd

/****************************************************************************
 *	mImage.c					C I m a g e 					Constructor	*
 ****************************************************************************/
CImage::CImage ()
{
	this->Init();		
}

/****************************************************************************
 *	mImage.c					C I m a g e 					Constructor	*
 ****************************************************************************/
CImage::CImage (IMAGEFORMAT Format)
{
	this->Init();		
	m_Format = Format;
	NewImage (Format);
}

/****************************************************************************
 *	mImage.c						I n i t									*
 ****************************************************************************/
void CImage::Init ()
{
	m_szPath	= "";
	m_szFileName= "";
	m_Format	= IMG_UNKNOWN;

	m_Tiff		= NULL;
	m_Pict		= NULL;
	m_Bmp		= NULL;

	m_bLoaded	= false;
}


/****************************************************************************
 *	mImage.c					N e w I m a g e 							*
 *  Purpose: create new specialized image object for specified image type	*
 ****************************************************************************/
BOOL CImage::NewImage (IMAGEFORMAT Format)
{
	BOOL bOK = FALSE;

	switch (Format)
	{
	case IMG_TIFF:
		if (m_Tiff == NULL)
			m_Tiff = new CTiffImage();		
		bOK = (m_Tiff != NULL);
		break;
	case IMG_PICT:
		if (m_Pict == NULL)
			m_Pict = new CPictImage();
		bOK = (m_Pict != NULL);
		break;
	case IMG_BMP:
		if (m_Bmp == NULL)
			m_Bmp  = new CBmpImage();
		bOK = (m_Bmp != NULL);
		break;
	default:
		break;
	}

	return bOK;
}

/****************************************************************************
 *	mImage.c						O p e n D l g							*
 ****************************************************************************/
BOOL CImage::OpenDlg (CWnd* ptWnd, CString* ptPath)
{
	//static char szFilter[] = "Bitmap (*.bmp) | *.bmp | Tiff (*.tif) | *.tif | All Files (*.*) | *.* ||"; 
	static char szFilter[] = "Bitmap (*.bmp)|*.bmp||"; 

	BOOL bDefined = FALSE;

	CFileDialog dlg(TRUE, 	  					// File Open dialog
					NULL,						// no default extension
					"*.bmp",					// initial filename
					OFN_HIDEREADONLY |	  		// dwFlags
					OFN_OVERWRITEPROMPT,
					szFilter,
					ptWnd);						// parent window

	//CString szPath = this->GetActPathName();	// without NameExt
	//dlg.m_ofn.lpstrInitialDir = (LPCTSTR)szPath;

	int ret = dlg.DoModal();
	if (ret == IDOK)
	{
		m_szPath		= dlg.GetPathName();  
		m_szFileName	= dlg.GetFileName();

		CString szExt = dlg.GetFileExt();
		if (szExt.CompareNoCase("tif")==0)	m_Format = IMG_TIFF;
		if (szExt.CompareNoCase("pic")==0)	m_Format = IMG_PICT;
		if (szExt.CompareNoCase("bmp")==0)	m_Format = IMG_BMP;

		*ptPath = m_szPath;
		bDefined = true;
	}
		
return bDefined;
}


/****************************************************************************
 *	mImage.c						O p e n D l g							*
 ****************************************************************************/
BOOL CImage::OpenDlg (CWnd* ptWnd, CString* ptPath, IMAGEFORMAT* ptFormat)
{
	//static char szFilter[] = "Bitmap (*.bmp) | *.bmp | Tiff (*.tif) | *.tif | All Files (*.*) | *.* ||"; 
	static char szFilter[] = "Bitmap (*.bmp)|*.bmp||"; 

	BOOL bDefined = FALSE;
	m_Format = IMG_UNKNOWN;

	CFileDialog dlg(TRUE, 	  					// File Open dialog
					NULL,						// no default extension
					"*.bmp",					// initial filename
					OFN_HIDEREADONLY |	  		// dwFlags
					OFN_OVERWRITEPROMPT,
					szFilter,
					ptWnd);						// parent window

	//CString szPath = this->GetActPathName();	// without NameExt
	//dlg.m_ofn.lpstrInitialDir = (LPCTSTR)szPath;

	int ret = dlg.DoModal();
	if (ret == IDOK)
	{
		m_szPath		= dlg.GetPathName();  
		m_szFileName	= dlg.GetFileName();

		CString szExt	= dlg.GetFileExt();
		if (szExt.CompareNoCase("tif")==0)	m_Format = IMG_TIFF;
		if (szExt.CompareNoCase("pic")==0)	m_Format = IMG_PICT;
		if (szExt.CompareNoCase("bmp")==0)	m_Format = IMG_BMP;

		*ptPath = m_szPath;
		*ptFormat = m_Format;

		bDefined = true;
	}
			
return bDefined;
}


/****************************************************************************
 *	mImage.c						O p e n D l g							*
 ****************************************************************************/
BOOL CImage::OpenDlg (CWnd* ptWnd)
{
	BOOL bDefined=FALSE;

	CString		szPath;
	IMAGEFORMAT	ImgFormat;

	if (this->OpenDlg (ptWnd, &szPath, &ImgFormat))
	{
		DisposeImagePtr ();		// dispose old IMAGE memory, not whole class data
		
		m_szPath = szPath;
		m_Format = ImgFormat;	// store new format AFTER deleting old memory
		bDefined = true;
	}

return bDefined;
}

/********************************************************************
 *  Image.cpp				S a v e A s D i a l o g					*
 *  Purpose: Shows file save as dialog								*
 *	ptFilter: static char szFilter[] = "Bitmap (*.bmp)|*.bmp||";	*
 *	szExt: "bmp"													*
 ********************************************************************/
CString CImage::SaveAsDialog (CWnd* ptWnd, char* ptFilter, CString szExt, CString szDlgTitle, CString szDfltName)
{
char	szTitle[32];
char	szPath[256];
char	szFileExt[256];
char	szDfltExt[256];
CString szFullName;

strcpy (szTitle, (LPCTSTR)szDlgTitle);
getcwd(szPath, 256);
	
wsprintf (szFileExt, "%s.%s", (LPCTSTR)szDfltName, (LPCTSTR)szExt);
wsprintf (szDfltExt, "*.%s", (LPCTSTR)szExt);


CFileDialog dlg(FALSE, 	  					// File SaveAs dialog
				NULL,						// no default extension
				szDfltExt,					// initial filename
				OFN_HIDEREADONLY |	  		// dwFlags
				OFN_OVERWRITEPROMPT,
				ptFilter,
				ptWnd);						// parent window

dlg.m_ofn.lpstrInitialDir = (LPCTSTR)szPath;
dlg.m_ofn.lpstrFileTitle = (LPTSTR)szFileExt;
dlg.m_ofn.lpstrTitle = (LPTSTR)szTitle;

int ret = dlg.DoModal();
if (ret == IDOK)
	{
	szFullName = dlg.GetPathName();  
	}

return szFullName;
}

/****************************************************************************
 *	mImage.c					S a v e A s D l g							*
 ****************************************************************************/
CString CImage::SaveAsDlg (CWnd* ptWnd, CString szDlgTitle, CString szDfltName)
{
	static char szFilter[] = "Bitmap (*.bmp)|*.bmp||"; 
	m_szFileToSave = this->SaveAsDialog (ptWnd, szFilter, "bmp", szDlgTitle, szDfltName);
	return m_szFileToSave;
}


/*********************************************************************
 *  Image.cpp				S a v e A s T e x t B o x			     *
 *********************************************************************/
CString CImage::SaveAsTextBox (CWnd* ptWnd, CString szDlgTitle, CString szDfltName)
{
	CString szFullName;
	static char szFilter[] = "Text (*.txt)|*.txt||"; 
	szFullName = this->SaveAsDialog (ptWnd, szFilter, "txt", szDlgTitle, szDfltName);
	return szFullName;
}



/****************************************************************************
 *	mImage.c					G e t F i l e N a m e						*
 ****************************************************************************/
void CImage::GetFileName (unsigned char* ptName)
{
//	short nLen = m_szFileName.GetLength();
//	memcpy (ptName, (LPCTSTR)m_szFileName, nLen);
//	*(ptName + nLen) = 0;

	strcpy ((char*)ptName, (LPCTSTR)m_szFileName);
}

/****************************************************************************
 *	mImage.c					G e t F i l e N a m e						*
 ****************************************************************************/
CString CImage::GetFileName ()
{
return m_szFileName;
}


/****************************************************************************
 *	mImage.c				G e t P a t h A n d F o r m a t 				*
 ****************************************************************************/
void CImage::GetPathAndFormat (CString* ptPath, IMAGEFORMAT* ptFormat) 
{
	*ptPath = m_szPath;
	*ptFormat = m_Format;
}

/****************************************************************************
 *	mImage.c						S e t P a t h  							*
 ****************************************************************************/
void CImage::SetPath (CString* ptPath)
{
	m_szPath = *ptPath;
}

/****************************************************************************
 *						G e t F i l e F r o m P a t h						*
 ****************************************************************************/
CString CImage::GetFileFromPath(CString& szPath)
{
	CString szFile;

	short nSlash = szPath.ReverseFind('\\');
	if (nSlash > 0)
		szFile = szPath.Right(szPath.GetLength()-nSlash-1);
	else
		szFile = szPath;

	return szFile;
}

/****************************************************************************
 *						G e t E x t F r o m F i l e							*
 ****************************************************************************/
CString CImage::GetExtFromFile(CString& szFile)
{
	CString szExt;

	short nDot = szFile.ReverseFind('.');
	if (nDot > 0)
		szExt = szFile.Right(szFile.GetLength()-nDot-1);
	else
		szExt = "";

	return szExt;
}

/****************************************************************************
 *	mImage.c						R e a d 								*
 *  Purpose: Reads image, using specified file								*
 ****************************************************************************/
BOOL CImage::Read (CFile& file)
{
	BOOL bRead = FALSE;

	m_szPath	 = file.GetFilePath();
	m_szFileName = file.GetFileName();
	CString szExt = GetExtFromFile(m_szFileName);

	DisposeImagePtr ();		// dispose old memory

	m_Format = IMG_UNKNOWN;
	if (szExt.CompareNoCase("tif")==0)	m_Format = IMG_TIFF;
	if (szExt.CompareNoCase("pic")==0)	m_Format = IMG_PICT;
	if (szExt.CompareNoCase("bmp")==0)	m_Format = IMG_BMP;

						// call read func for each format
	if (NewImage(m_Format))
	{
		switch (m_Format)
		{
		case IMG_TIFF:
			bRead = m_Tiff->Read (file);		
			break;
		case IMG_PICT:
			bRead = m_Pict->Read (file);		
			break;
		case IMG_BMP:
			bRead = m_Bmp->Read (file);		
			break;
		}
		
		m_bLoaded = bRead;
	}

	return bRead;
}

/****************************************************************************
 *	mImage.c					I s T o S a v e								*
 *  Purpose: If fileToSave is defined, we want to save image in that file	*
 ****************************************************************************/
BOOL CImage::IsToSave()
{
	return (m_szFileToSave.GetLength() > 0);
}

/****************************************************************************
 *	mImage.c				E m p t y F i l e T o S a v e 					*
 *  Purpose: delete fileToSave to avoid saving image again					*
 ****************************************************************************/
void CImage::EmptyFileToSave()
{
	m_szFileToSave.Empty();	// avoid save image again	
}

/****************************************************************************
 *	mImage.c					S a v e I m a g e							*
 *  Purpose: Writes image into specified file								*
 ****************************************************************************/
BOOL CImage::SaveImage(CString szFileName)
{
	BOOL bSaved = FALSE;
	if (szFileName.GetLength() > 0)
	{		// Save As dialog OK
		CFile file;
		if (file.Open((LPCTSTR)szFileName, CFile::modeCreate | CFile::modeNoInherit | CFile::modeWrite, NULL)) 
		{
			this->Write(file);
			file.Close();			
			bSaved = TRUE;
		}
	}
	return bSaved;
}

/****************************************************************************
 *	mImage.c						W r i t e 								*
 *  Purpose: Writes image, using specified file								*
 ****************************************************************************/
BOOL CImage::Write (CFile& file)
{
	BOOL bWritten = FALSE;

	switch (m_Format)
	{
	case IMG_TIFF:
		bWritten = m_Tiff->Write (file);		
		break;
	case IMG_PICT:
		bWritten = m_Pict->Write (file);		
		break;
	case IMG_BMP:
		bWritten = m_Bmp->Write (file);		
		break;

	}

	return bWritten;

}

/****************************************************************************
 *	mImage.c					S e t S i z e								*
 ****************************************************************************/
void CImage::SetSize (long lHeight, long lWidth, unsigned short wBitCount, long lFileRowBytes)
{
	DisposeImagePtr ();		// dispose old memory

	switch (m_Format)
	{
	case IMG_TIFF:
		m_Tiff->SetSize (lHeight, lWidth, wBitCount, lFileRowBytes);		
		break;
	case IMG_PICT:
		m_Pict->SetSize (lHeight, lWidth, wBitCount, lFileRowBytes);		
		break;
	case IMG_BMP:
		m_Bmp->SetSize (lHeight, lWidth, wBitCount, lFileRowBytes);		
		break;
	}
}

/****************************************************************************
 *	mImage.c					S e t D a t a P t r 	 	 	 	 	 	*
 ****************************************************************************/
void CImage::SetDataPtr(LPSTR lpData)
{
	m_bLoaded = (lpData != NULL);
 
	switch (m_Format)
	{
	case IMG_TIFF:
		m_Tiff->SetDataPtr(lpData);		
		break;
	case IMG_PICT:
		m_Pict->SetDataPtr(lpData);			
		break;
	case IMG_BMP:
		m_Bmp->SetDataPtr(lpData);			
		break;
	default:
		m_bLoaded = FALSE;
		break;
	}


}

/************************************************************************
 *  Dib.cpp 				G e t P i x e l s P e r M e t e r			*
 ************************************************************************/
void CImage::GetPixelsPerMeter (CDC* pDC, long* ptPpmX, long* ptPpmY)
{
	double dDevXPixPerInch = pDC->GetDeviceCaps (LOGPIXELSX);	// 96 pixels/inch
	double dDevYPixPerInch = pDC->GetDeviceCaps (LOGPIXELSY);	// 96 pixels/inch
	double dXPixPerMeter = 100 * dDevXPixPerInch / 2.54;		// 3779.52 pixels/meter
	double dYPixPerMeter = 100 * dDevYPixPerInch / 2.54;		// 3779.52 pixels/meter
	
	*ptPpmX = (long)dXPixPerMeter;
	*ptPpmY = (long)dYPixPerMeter;
}



/****************************************************************************
 *	mImage.c						G e n e r a t e							*
 *  Purpose: Reads image, using specified path								*
 ****************************************************************************/
BOOL CImage::Generate (long lHeight, long lWidth, 
						unsigned short wBitCount, long lFileRowBytes, 
						long lPixPerMeterX, long lPixPerMeterY, 
						LPSTR lpData)
{
	m_bLoaded = (lpData != NULL);
	if (!m_bLoaded) return FALSE;

	CString szExt;

						// call read func for each format
	switch (m_Format)
	{
	case IMG_TIFF:
		szExt = "tif";
		m_Tiff->SetSize (lHeight, lWidth, wBitCount, lFileRowBytes);	
		m_Tiff->SetResolution (lPixPerMeterX, lPixPerMeterY);
		m_Tiff->SetDataPtr(lpData);		
		m_Tiff->Generate ();		
		break;
	case IMG_PICT:
		szExt = "pic";
		m_Pict->SetSize (lHeight, lWidth, wBitCount, lFileRowBytes);		
		m_Pict->SetResolution (lPixPerMeterX, lPixPerMeterY);
		m_Pict->SetDataPtr(lpData);		
		m_Pict->Generate ();		
		break;
	case IMG_BMP:
		szExt = "bmp";
		m_Bmp->SetSize (lHeight, lWidth, wBitCount, lFileRowBytes);		
		m_Bmp->SetResolution (lPixPerMeterX, lPixPerMeterY);
		m_Bmp->SetDataPtr(lpData);		
		m_Bmp->Generate ();		
		break;
	default:
		m_bLoaded = FALSE;
		break;
	}
	
	return m_bLoaded;
}

/****************************************************************************
 *	mImage.c				S e t C o l o r T a b l e						*
 *  Purpose: copies array of RGBQUAD and number of entries into image		*
 ****************************************************************************/
void CImage::SetColorTable(short nEntries, RGBQUAD* ptRGBQuads)
{
						// call SetColorTable func for each format
	switch (m_Format)
	{
	case IMG_TIFF:
		m_Tiff->SetColorTable(nEntries, ptRGBQuads);		
		break;
	case IMG_PICT:
		m_Pict->SetColorTable(nEntries, ptRGBQuads);		
		break;
	case IMG_BMP:
		m_Bmp->SetColorTable(nEntries, ptRGBQuads);	
		break;
	}

}

/****************************************************************************
 *	mImage.c						R e a d 								*
 *  Purpose: Reads image, using specified path								*
 ****************************************************************************/
BOOL CImage::Read (CString szPath)
{
	BOOL bRead = FALSE;
	CFile file;
	if (file.Open((LPCTSTR)szPath, CFile::modeRead)) 
	{
		m_bLoaded = this->Read(file);
		bRead = m_bLoaded;
	}	// good file
	
return bRead;
}

/****************************************************************************
 *	mImage.c						R e a d 								*
 *  Purpose: Reads image, using m_szPath stored in OpenDlg()				*
 ****************************************************************************/
BOOL CImage::Read ()
{
	return this->Read(m_szPath);
}



/****************************************************************************
 *	mImage.c					I n f o F i l e								*
 ****************************************************************************/
BOOL CImage::InfoFile (CWnd* ptWnd)
{
	BOOL bOK = false;
	
	switch (m_Format)
	{
	case IMG_TIFF:
		m_szFileName = SaveAsTextBox (ptWnd, "Tiff Info File", "ImageInfo");
		if (m_szFileName.GetLength() > 0)
			m_Tiff->InfoFile(m_szFileName);
		break;
	case IMG_PICT:
		m_szFileName = SaveAsTextBox (ptWnd, "PICT Info File", "ImageInfo");
		if (m_szFileName.GetLength() > 0)
			m_Pict->InfoFile(m_szFileName);
		break;
	case IMG_BMP:
		m_szFileName = SaveAsTextBox (ptWnd, "BMP Info File", "ImageInfo");
		if (m_szFileName.GetLength() > 0)
			m_Bmp->InfoFile(m_szFileName);
		break;
	}

	bOK = (m_szFileName.GetLength() > 0);

return bOK;
}


/****************************************************************************
 *	mImage.c						G e t S i z e D P						*
 ****************************************************************************/
BOOL CImage::GetSize (CSize* ptSize)
{
	BOOL bOK = TRUE;
	ptSize->cx = 0;
	ptSize->cy = 0;

	switch (m_Format)
	{
	case IMG_TIFF:
		bOK = m_Tiff->GetSize (ptSize);		
		break;
	case IMG_PICT:
		bOK = m_Pict->GetSize (ptSize);		
		break;
	case IMG_BMP:
		bOK = m_Bmp->GetSize (ptSize);		
		break;
	default:
		bOK = FALSE;
		break;
	}

	return bOK;
}

/****************************************************************************
 *	mImage.c						G e t S i z e L P						*
 *   to be deleted....
 ****************************************************************************/
/*
BOOL CImage::GetSizeLP (CDC* pDC, short nMapMode, CSize* ptSize)
{
	BOOL bOK = FALSE;

	if (m_bLoaded)
	{
		pDC->SetMapMode(nMapMode);
		if (this->GetSize(ptSize))
		{
			pDC->DPtoLP(ptSize);
			bOK = TRUE;
		}
	}
	else
	{
		ptSize->cx = ptSize->cy = 0;
	}

	return bOK;
}
*/

/****************************************************************************
 *	mImage.c						G e t S i z e L P						*
 ****************************************************************************/
BOOL CImage::GetSizeLP (CDC* pDC, CSize* ptSize)
{
	BOOL bOK = FALSE;

	if (m_bLoaded)
	{
		if (this->GetSize(ptSize))
		{
			pDC->DPtoLP(ptSize);
			bOK = TRUE;
		}
	}
	else
	{
		ptSize->cx = ptSize->cy = 0;
	}

	return bOK;
}

/****************************************************************************
 *	mImage.c					S e t R O P C o d e							*
 ****************************************************************************/
void CImage::SetROPCode (unsigned long dwROP)
{
	switch (m_Format)
	{
	case IMG_TIFF:
		m_Tiff->SetROPCode (dwROP);		
		break;
	case IMG_PICT:
		m_Pict->SetROPCode (dwROP);
		break;
	case IMG_BMP:
		m_Bmp->SetROPCode (dwROP);
		break;
	}
}





/****************************************************************************
 *	mImage.c						D i s p l a y							*
 ****************************************************************************/
BOOL CImage::Display (CDC* pDC, CPoint origin)
{
	BOOL bOK = false;
	switch (m_Format)
	{
	case IMG_TIFF:
		bOK = m_Tiff->Display (pDC, origin);
		break;
	case IMG_PICT:
		bOK = m_Pict->Display (pDC, origin);
		break;
	case IMG_BMP:
		bOK = m_Bmp->Display(pDC, origin);
		break;
	}
	
return bOK;
}



/****************************************************************************
 *	mImage.c						S t r e t c h							*
 ****************************************************************************/
BOOL CImage::Stretch (CDC* pDC, CPoint origin, CSize size)
{
	BOOL bOK = false;
						
	switch (m_Format)
	{
	case IMG_TIFF:
		bOK = m_Tiff->Stretch(pDC, origin, size);
		break;
	case IMG_PICT:
		bOK = m_Pict->Stretch(pDC, origin, size);
		break;
	case IMG_BMP:
		bOK = m_Bmp->Stretch(pDC, origin, size);
		break;
	}
return bOK;
}



/****************************************************************************
 *	mImage.c					I s L o a d e d 							*
 ****************************************************************************/
BOOL CImage::IsLoaded ()
{
	return m_bLoaded;
}


/****************************************************************************
 *	mImage.c						DisposeImagePtr							*
 ****************************************************************************/
void CImage::DisposeImagePtr ()
{
if (m_bLoaded)
	{
	switch (m_Format)
		{
		case IMG_TIFF:
			m_Tiff->DestructImage();
			break;
		case IMG_PICT:
			m_Pict->DestructImage();
			break;
		case IMG_BMP:
			m_Bmp->DestructImage();
			break;
		}
		
	m_bLoaded = FALSE;
	}
}



/****************************************************************************
 *	mImage.c						C I m a g e				Destructor		*
 ****************************************************************************/
CImage::~CImage ()
{
	if (m_Tiff != NULL)
	{
		delete m_Tiff;
		m_Tiff = NULL;
	}

	if (m_Pict != NULL)
	{
		delete m_Pict;
		m_Pict = NULL;
	}

	if (m_Bmp != NULL)
	{
		delete m_Bmp;
		m_Bmp = NULL;
	}
}



 

