#ifndef __M_IMAGE__
#define __M_IMAGE__
/****************************************************************************
 *									i m a g e. h							*
 ****************************************************************************/
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "tiff.h"
#include "pict.h"
#include "bmp.h"


typedef enum	
	{
	IMG_TIFF,
	IMG_PICT,
	IMG_BMP,
	IMG_UNKNOWN
	} IMAGEFORMAT;
	
	
/*  Macintosh ROP codes:
	srcCopy						= 0,							
	srcOr						= 1,
	srcXor						= 2,
	srcBic						= 3,
	notSrcCopy					= 4,
	notSrcOr					= 5,
	notSrcXor					= 6,
	notSrcBic					= 7,
*/	

//#define SRCCOPY	srcCopy
//#define SRCAND	srcOr			// SRCAND ?? nicht SRCOR ??


class CImage
{
private:
	CString		m_szPath;
	CString		m_szFileName;
	CString		m_szFileToSave;		// to create bmp file from generated image
	IMAGEFORMAT m_Format;
	BOOL		m_bLoaded;

	CTiffImage*	m_Tiff;
	CPictImage*	m_Pict;
	CBmpImage*	m_Bmp;

public:

	CImage();
	CImage (IMAGEFORMAT Format);
	~CImage();

	BOOL OpenDlg (CWnd* ptWnd, CString* ptPath);
	BOOL OpenDlg (CWnd* ptWnd, CString* ptPath, IMAGEFORMAT* ptFormat);
	BOOL OpenDlg (CWnd* ptWnd);
	void GetFileName (unsigned char* ptName);
	CString GetFileName ();

	void GetPathAndFormat (CString* ptPath, IMAGEFORMAT* ptFormat);
	void SetPath (CString* ptPath);
	inline CString GetPath () { return m_szPath; }
	
	void SetSize (long lHeight, long lWidth, unsigned short wBitCount, long lFileRowBytes);
	BOOL GetSize (CSize* ptSize);

	void SetDataPtr(LPSTR lpData);
	static void GetPixelsPerMeter (CDC* pDC, long* ptPpmX, long* ptPpmY);
	BOOL Generate (long lHeight, long lWidth, 
						unsigned short wBitCount, long lFileRowBytes, 
						long lPixPerMeterX, long lPixPerMeterY, 
						LPSTR lpData);
	void SetColorTable(short nEntries, RGBQUAD* ptRGBQuads);
	BOOL Read (CFile& file);
	BOOL Read (CString ptPath);
	BOOL Read ();

	CString SaveAsDlg (CWnd* ptWnd, CString szDlgTitle, CString szDfltName);
	BOOL IsToSave();
	CString GetFileToSave() { return m_szFileToSave; }
	void EmptyFileToSave();
	BOOL SaveImage(CString szFileName);

	BOOL Write (CFile& file);

//	BOOL GetSizeLP (CDC* pDC, short nMapMode, CSize* ptSize); // to be deleted
	BOOL GetSizeLP (CDC* pDC, CSize* ptSize);

	void SetROPCode (unsigned long dwROP);
	BOOL Display (CDC* pDC, CPoint origin);
	BOOL Stretch (CDC* pDC, CPoint origin, CSize size);

	BOOL IsLoaded ();

	BOOL InfoFile (CWnd* ptWnd);
	void DisposeImagePtr ();
	
private:
	CString GetFileFromPath(CString& szPath);
	CString GetExtFromFile(CString& szFile);
	void Init ();
	BOOL NewImage (IMAGEFORMAT Format);
	CString SaveAsDialog (CWnd* ptWnd, char* ptFilter, CString szExt, CString szDlgTitle, CString szDfltName);
	CString SaveAsTextBox (CWnd* ptWnd, CString szDlgTitle, CString szDfltName);

};

	

#endif