
#ifndef __PICT_TYPE__
#define __PICT_TYPE__

/****************************************************************************
 *									p i c t . h 							*
 ****************************************************************************/
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de


class CPictImage : public CObject
{
private:
	CString		m_szExt;
    char* 		m_lpBuf;    // DIB data buffer
    DWORD    	m_dwLength; // total buffer length, including file header
    int       	m_nBits;    // number of color bits per pixel
	DWORD		m_dwROP;

	CPalette	m_Palette;
	CPalette*	m_ptOldPal;

	CDC* 	m_pDisplayMemDC;
	HBITMAP m_hOldDisplayBitmap;

public:
	CPictImage();
//    CPictImage(CDC* pDC, int nBt = 0, BOOL bCompr = TRUE);
    // nBt = 0 means use default bits/pixel
    ~CPictImage();

	void SetROPCode (DWORD dwROP) { m_dwROP = dwROP; }

//    virtual void Serialize(CArchive &ar);
	void SetSize (long lHeight, long lWidth, unsigned short wBitCount, long lFileRowBytes);
	BOOL GetSize(CSize* ptSize);
	void SetResolution (long lPixPerMeterX, long lPixPerMeterY);
	void SetDataPtr(LPSTR lpData);
    BOOL Generate();
	void SetColorTable(short nEntries, RGBQUAD* ptRGBQuads);
    BOOL Read(CFile& file);
    BOOL Write(CFile& file);

	BOOL Display(CDC* pDC, CPoint origin);
	BOOL Stretch(CDC* pDC, CPoint origin, CSize size);

	BOOL InfoFile (CString szFileTitle);
	void DestructImage();

private:
    BOOL AllocateMemory(BOOL bRealloc = FALSE);
};

#endif
