/****************************************************************************
 *							P o l y g o n . c p p							*
 ****************************************************************************/										 
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "stdafx.h"
#include "math.h"

#include "Vektor.h"
#include "Polygon.h"


/////////////////////////////////////////////////////////////////////////////
// CPolygon

/////////////////////////////////////////////////////////////////////////////
// CPolygon construction/destruction

/************************************************************************
 *  Polygon.cpp					C P o l y g o n							*
 *  use CreatePointsArray to define m_ptPoints, if Draw is used!!!		*
 ************************************************************************/
CPolygon::CPolygon()
{
	// TODO: add one-time construction code here  
m_ptPoints = NULL;
m_nNextIndex = 0;
m_nCnt = 0;
}

/************************************************************************
 *  Polygon.cpp					C P o l y g o n							*
 *  prepares m_ptPoints for nCnt points									*
 ************************************************************************/
CPolygon::CPolygon(short nCnt)
{
	// TODO: add one-time construction code here  
m_ptPoints = (CPoint*)new CPoint[nCnt];
m_nNextIndex = 0;
m_nCnt = nCnt;
}

CPolygon::~CPolygon()
{   
	this->DeleteArrayOf (&m_Vektors);

	if (m_ptPoints != NULL)
		delete [] m_ptPoints;
}

/************************************************************************
 *  Polygon.cpp				D e l e t e A r r a y O f 					*
 ************************************************************************/
void CPolygon::DeleteArrayOf (CPtrArray* ptArray)
{
int i, nEntryCnt;	
											
nEntryCnt = ptArray->GetSize();
for (i=0; i<nEntryCnt; i++)
	{
	CVektor* ptEntry;
	if ((ptEntry = (CVektor*)ptArray->GetAt(i)) != NULL)
		{
		delete ptEntry;				// delete original element
		}
	}
ptArray->RemoveAll();
}      


/************************************************************************
 *  Polygon.cpp						S e t								*
 *  set point of polygon to be drawn									*
 ************************************************************************/
BOOL CPolygon::Set (CPoint ptPolyPoint)
{
BOOL bOK = FALSE;
if (m_nNextIndex < m_nCnt)
	{
	*(m_ptPoints + m_nNextIndex) = ptPolyPoint;
	m_nNextIndex++;
	bOK = TRUE;
	}
return bOK;
}

/************************************************************************
 *  Polygon.cpp						S e t								*
 *  set point of polygon to be drawn									*
 ************************************************************************/
BOOL CPolygon::Set (long x, long y)
{
BOOL bOK = FALSE;
if (m_nNextIndex < m_nCnt)
	{
	(m_ptPoints + m_nNextIndex)->x = x;
	(m_ptPoints + m_nNextIndex)->y = y;
	m_nNextIndex++;
	bOK = TRUE;
	}
return bOK;
}

/************************************************************************
 *  Polygon.cpp						S e t								*
 *  set point of polygon to be drawn									*
 ************************************************************************/
BOOL CPolygon::Set (short x, short y)
{
return this->Set ((long)x, (long)y);
}

/************************************************************************
 *  Polygon.cpp			C r e a t e P o i n t s A r r a y				*
 *  copies entries of CPtrArray into CPoints* array, used within Draw	*
 ************************************************************************/
void CPolygon::CreatePointsArray()
{
	m_nCnt = m_Vektors.GetSize();
	m_ptPoints = (CPoint*)new CPoint[m_nCnt];

	for (int i=0; i<m_nCnt; i++)
    {
		CVektor* ptVektor = (CVektor*)m_Vektors.GetAt(i);
		Set((long)ptVektor->x, (long)ptVektor->y);
	}
}

/************************************************************************
 *  Polygon.cpp						D r a w								*
 *  draws a polygon, using m_ptPoints									*
 ************************************************************************/
void CPolygon::Draw (CDC* pDC)
{
	pDC->Polygon (m_ptPoints, m_nNextIndex);
}

/****************************************************************************
 *	Polygon.cpp						O f f s e t								*
 ****************************************************************************/
void CPolygon::Offset (long nX0, long nY0)
{ 
short i;
for (i=0; i<m_nCnt; i++)
	{
	(m_ptPoints + i)->x += nX0;
	(m_ptPoints + i)->y += nY0;
	}
}

/****************************************************************************
 *	Polygon.cpp						D r a w   								*
 *  draws a polygon, using m_ptPoints										*
 ****************************************************************************/
void CPolygon::Draw (CDC* pDC, int BrushID)
{
CBrush* ptOldBrush = (CBrush*)pDC->SelectStockObject (BrushID);
pDC->Polygon (m_ptPoints, m_nNextIndex);
pDC->SelectObject (ptOldBrush);
}

/****************************************************************************
 *	Polygon.cpp						D r a w   								*
 *  draws a polygon, using m_ptPoints										*
 ****************************************************************************/
void CPolygon::Draw (CDC* pDC, CBrush* ptNewBrush)
{
CBrush* ptOldBrush = (CBrush*)pDC->SelectObject (ptNewBrush);
pDC->Polygon (m_ptPoints, m_nNextIndex);
pDC->SelectObject (ptOldBrush);
}

/************************************************************************
 *  Polygon.cpp					R e s e t								*
 *  removes all points and vektors from polygon							*
 ************************************************************************/
void CPolygon::Reset()
{
	this->DeleteArrayOf (&m_Vektors);

	if (m_ptPoints != NULL)
		delete [] m_ptPoints;

	m_ptPoints = NULL;
	m_nNextIndex = 0;
	m_nCnt = 0;
}

/************************************************************************
 *  Polygon.cpp					G e t S i z e							*
 *  returns number of currently stored points or vektors				*
 ************************************************************************/
int CPolygon::GetSize()
{
	int nSize = 0;

	if (m_ptPoints != NULL)
		nSize = m_nCnt;
	else
		nSize = m_Vektors.GetSize();

	return nSize;
}


/************************************************************************
 *  Polygon.cpp					A d d V e k t o r						*
 *  adds a point of polygon												*
 *  use CreatePointsArray to define m_ptPoints, if Draw is used!!!		*
 ************************************************************************/
BOOL CPolygon::AddVektor (CVektor ptPolyVektor)
{
	BOOL bAdded = FALSE;

	short nOldCnt = m_Vektors.GetSize();

	CVektor* ptVektor = new CVektor(ptPolyVektor);
	m_Vektors.Add(ptVektor);

	bAdded = (m_Vektors.GetSize() == nOldCnt+1);
	return bAdded;
}

/************************************************************************
 *  Polygon.cpp					A d d V e k t o r						*
 *  adds a point of polygon												*
 *  use CreatePointsArray to define m_ptPoints, if Draw is used!!!		*
 ************************************************************************/
BOOL CPolygon::AddVektor (double x, double y)
{
	BOOL bAdded = FALSE;

	short nOldCnt = m_Vektors.GetSize();

	CVektor* ptVektor = new CVektor(x, y);
	m_Vektors.Add(ptVektor);

	bAdded = (m_Vektors.GetSize() == nOldCnt+1);
	return bAdded;
}

/************************************************************************
 *  Polygon.cpp					G e t V e k t o r						*
 *  gets a vektor of a polygon											*
 ************************************************************************/
CVektor* CPolygon::GetVektor (short nIndex)
{
	CVektor* ptVektor = NULL;

	if (0 <= nIndex && nIndex < m_Vektors.GetSize())
	{
		ptVektor = (CVektor*)m_Vektors.GetAt(nIndex);
	}

	return ptVektor;
}


/********************************************************************
 *	Polygon.cpp			G e t I n p u t D i r e c t i o n 			*
 *  output: 1 for clockwise input, else -1							*
 ********************************************************************/
int CPolygon::GetInputDirection()
{
	int inputDirection=0;
	double dAngleSum = 0;
	double EPS = 0.000001;		/* Grenzwert fuer Genauigkeit	 */
	double pi=3.1414926;
	short i=0;

	short nIndex0, nIndex1, nIndex2;

	int cnt = m_Vektors.GetSize();

	if (cnt < 3)				// too less vektors to calculate
		return inputDirection;

	CVektor vRNorth(0,1,0);

	while (i<cnt)
	{
		nIndex0 = i;			// cnt = 7
		nIndex1 = i+1;
		nIndex2 = i+2;

				// end of last segment is begin of first segment
				// end of other segments is begin of next segment
		if (i==cnt-1)			// i=6
		{
			nIndex1 = 0;
			nIndex2 = 1;
		}

		if (i==cnt-2)			// i=5
		{
			nIndex2 = 0;
		}

		CVektor* ptV0 = (CVektor*)m_Vektors.GetAt(nIndex0);
		CVektor* ptV1 = (CVektor*)m_Vektors.GetAt(nIndex1);
		CVektor* ptV2 = (CVektor*)m_Vektors.GetAt(nIndex2);

		CVektor vR01 = *ptV1 - *ptV0;
		CVektor vR12 = *ptV2 - *ptV1;

		double dRad1 = vRNorth.VektorAngle(vR01);
		if (vR01.x < 0) dRad1=2*pi-dRad1;
		double dA1 = 180*dRad1/pi;

		double dRad2 = vRNorth.VektorAngle(vR12);
		if (vR12.x < 0) dRad2=2*pi-dRad2;
		double dA2 = 180*dRad2/pi;

		double dA = dA2 + (180-dA1);
		if (dA<0) dA += 360;
		if (dA>360) dA -=360;

		dAngleSum += dA;

		i++;
	}

	double dAngleSumClockWise = ((double)cnt/2 +1) * 360;
	double dAngleSumCounterClockWise = ((double)cnt/2 -1) * 360;

	if (fabs(dAngleSum-dAngleSumClockWise) < EPS) 
		inputDirection = 1;

	if (fabs(dAngleSum-dAngleSumCounterClockWise) < EPS)
		inputDirection = -1;

	return inputDirection;
}


/********************************************************************
 *	Polygon.cpp	     S C H N I T T P U N K T					    *
 *  dBv = Basis-Vektor, Punkt auf Linie, dRv = Richtungsvektor		*
 *  // Fakt * Length(Rv1) = dist from dBv1 to ptX,ptY				*
 ********************************************************************/
BOOL CPolygon::Schnittpunkt (double dBv1x, double dBv1y, double dRv1x, double dRv1y, 
				  double dBv2x, double dBv2y, double dRv2x, double dRv2y, 
				  double* ptX,double* ptY, double* ptFakt)
{
	double DET0;
		
	DET0 = dRv1x*(-dRv2y) - dRv1y*(-dRv2x);
	
	if (DET0 == 0.) 	/* this are parallel lines! */
		return FALSE;
	else    *ptFakt = ((dBv2x-dBv1x)*(-dRv2y) - (dBv2y-dBv1y)*(-dRv2x))/DET0;

	*ptX = dBv1x + (*ptFakt) * dRv1x;
	*ptY = dBv1y + (*ptFakt) * dRv1y;
	return TRUE;
}



/********************************************************************
 *	Polygon.cpp   		N e x t L i n e s 							*
 *  Purpose: get segments around px, py								*
 *  bHorz=TRUE: L1a, L1b is segment left of px,py					*
 *				L2a, L2b is segment right of px,py					*
 *  bHorz=FALSE:L1a, L1b is segment below px, py					*
 *				L2a, L2b is segment above px, py					*
 ********************************************************************/
void CPolygon::NextLines(double px,double py, BOOL bHorz, 
			  CVektor** ptptL1a, CVektor** ptptL1b,
			  CVektor** ptptL2a, CVektor** ptptL2b)
{
	BOOL SchnPt;
	double xsp,ysp,sp,p,max_sp,min_sp;
	double x0,y0,x1,y1;
	double dFakt;
 
	int cnt = m_Vektors.GetSize();


	short i=0;

	while (i<cnt)
	{
				// end of last segment is begin of first segment
				// end of other segments is begin of next segment
		short nNextPtIndex = (i==cnt-1)? 0 : i+1;

		CVektor* ptVi = (CVektor*)m_Vektors.GetAt(i);
		CVektor* ptVnext = (CVektor*)m_Vektors.GetAt(nNextPtIndex);

		x0 = (double)ptVi->x;
		y0 = (double)ptVi->y;
		x1 = (double)ptVnext->x;
		y1 = (double)ptVnext->y;

		if(bHorz)
		{
			SchnPt = Schnittpunkt (px,py,1.,0.,
						x0,y0,x1-x0,y1-y0,
						&xsp,&ysp,&dFakt);
				
			sp=xsp; 
			p=px; 
		}
		else
		{
			SchnPt = Schnittpunkt (px,py,0.,1.,
						x0,y0,x1-x0,y1-y0,
						&xsp,&ysp,&dFakt);
			
			sp=ysp; 
			p=py; 
		}

		if (SchnPt && 
			(x0<=xsp && xsp<=x1  ||  x1<=xsp && xsp<x0) &&	// xsp btn x0 and x1?
			(y0<=ysp && ysp<=y1  ||  y1<=ysp && ysp<y0))	// ysp btn y0 and y1?
		{
			if (sp>p) 
			{ 
				if(*ptptL2a==NULL)   
				{
					min_sp=sp; 
					*ptptL2a=ptVi;
					*ptptL2b=ptVnext;
				}	
				else 
				{ 
					if(sp<min_sp)  
					{
						min_sp=sp; 
						*ptptL2a=ptVi;
						*ptptL2b=ptVnext;
					} 
				}
			}

			if (sp<=p)
			{ 
				if(*ptptL1a==NULL)   
				{
					max_sp=sp; 
					*ptptL1a=ptVi;
					*ptptL1b=ptVnext;
				}
				else 
				{ 
					if(sp>max_sp)  
					{
						max_sp=sp; 
						*ptptL1a=ptVi;
						*ptptL1b=ptVnext;
					}
				}
			}
		} /* end if (SchnPt...)*/

		i++;
	}/* end while */ 
}




/********************************************************************
 *	Polygon.cpp				I s I n s i d e	 						*
 *  input: Px Py (point to test),									*
 *  inputDirection 1 for clockwise, else -1							*
 ********************************************************************/
BOOL CPolygon::IsInside(double Px, double Py, int inputDirection)
{
	double  x0,y0,x1,y1,x,y,Rv1x,Rv1y,Rv2x,Rv2y;
	VektorPtr 	ptVektL[8];
	CVektor*	LineStart; 
	CVektor*	LineEnd; 
	int 	i;
	double 	Fa[4];
	double EPS = 0.000001;		/* Grenzwert fuer Genauigkeit	 */

// CXX0017
// This error can occur when trying to typecast a variable in order to watch the variable during debugging. 
// The typedef declares a new name for a type, but it does not define a new type. 
// The typecast attempted in the debugger requires the name of a defined type.


	for (i=0; i<8; i++)
		ptVektL[i]=NULL;

	BOOL bHorz = TRUE;
	NextLines(Px,Py,bHorz, &ptVektL[0],&ptVektL[1],	// segment left of Px,Py
								&ptVektL[4],&ptVektL[5]);	// segment right of Px,Py
	bHorz = FALSE;
	NextLines(Px,Py,bHorz, &ptVektL[2],&ptVektL[3],	// segment below Px,Py
								&ptVektL[6],&ptVektL[7]);	// segment above Px,Py


	for (i=0;i<4;i++)
	{				// check the four found segments: left, bottom, right, top
		short nPointIndex = 2*i;
		if ((ptVektL+nPointIndex) != NULL &&
			(ptVektL+nPointIndex+1)!= NULL)
		{
			LineStart=*(ptVektL+nPointIndex);	
			LineEnd=*(ptVektL+nPointIndex+1);	

			if (LineEnd != NULL)
			{ 
				x0 = (double)LineStart->x;
				y0 = (double)LineStart->y;
				x1 = (double)LineEnd->x;
				y1 = (double)LineEnd->y;


				Rv1x= inputDirection*(y0-y1);	Rv2x= inputDirection*(x0-x1);	
				Rv1y= inputDirection*(x1-x0);	Rv2y= inputDirection*(y0-y1);
				Schnittpunkt((double)Px,(double)Py,	Rv1x,Rv1y,
								x0,			y0,	Rv2x,Rv2y,
							&x,&y,&Fa[i]);		// Fa * Length(Rv1) = dist from Px,Py to x,y
			}
			else 
			{ 
				Fa[i]=-1.;
			}
		} // good ptVektL
		else
		{
			return FALSE;
		}
	} /* end for i... */ 	  	

	if (Fa[0]>EPS && Fa[1]>EPS && Fa[2]>EPS && Fa[3]>EPS) 
		 return TRUE;
	else return FALSE;
}

/********************************************************************
 *	Polygon.cpp				A r c T o P o l y 						*
 *  calculates arc polygon points via CVektor::RotateXY				*
 *  input: Co-ords of start, end and center point					*
 *  adds CVektor objects to m_Vektors								*
 ********************************************************************/
void CPolygon::ArcToPoly(double dStartX, double dStartY, 
						 double dEndX, double dEndY,
						 double dCenterX, double dCenterY)
{
	double pi=3.1414926;

	CVektor vCenter(dCenterX, dCenterY);
	CVektor* ptVstart = new CVektor(dStartX, dStartY);
	CVektor* ptVend = new CVektor(dEndX, dEndY);

	CVektor vRNorth(0,1,0);

	CVektor vRstart = *ptVstart - vCenter;
	CVektor vRend = *ptVend - vCenter;
	
	double dRad1 = vRNorth.VektorAngle(vRstart);
	if (vRstart.x < 0) dRad1=2*pi-dRad1;
	double dA1 = 180*dRad1/pi;

	double dRad2 = vRNorth.VektorAngle(vRend);
	if (vRend.x < 0) dRad2=2*pi-dRad2;
	double dA2 = 180*dRad2/pi;

	if (dA2 < dA1)
		dA2 += 360;

	double dArcAngle = dA2-dA1;
	short nSteps = (short)(dArcAngle * 12/180);
	

	m_Vektors.Add(ptVstart);

	for (int i=1; i<nSteps; i++)
	{
		double dPolyAngle = -dArcAngle * i/nSteps;

		CVektor* ptArcPoint = new CVektor;
		*ptArcPoint = ptVstart->RotateXY(vCenter, dPolyAngle*pi/180);
		m_Vektors.Add(ptArcPoint);
	}

	delete ptVend;		// because this vector is not added to list,
						// it cannot be deleted later
//	m_Vektors.Add(ptVend);	// replaced by start point of next segment
}
