#ifndef __PF_POLYGON__
#define __PF_POLYGON__
/****************************************************************************
 *								P o l y g o n . h							*
 ****************************************************************************/	
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de
 
typedef CVektor*	VektorPtr;


class CPolygon : public CObject
{         
private:
	CPtrArray	m_Vektors;		// array of CVektor 


	CPoint* m_ptPoints;			// used to draw only
	short	m_nCnt;
	short	m_nNextIndex;
// Operations
public:           
	CPolygon();
	CPolygon(short nCnt);
	virtual ~CPolygon();  


	BOOL Set (CPoint pPoint);
	BOOL Set (long x, long y);
	BOOL Set (short x, short y);
	void Offset (long nX0, long nY0);
	void Draw (CDC* pDC);
	void Draw (CDC* pDC, int BrushID);
	void Draw (CDC* pDC, CBrush* ptNewBrush);


	void Reset();
	int GetSize();
	BOOL AddVektor (CVektor ptPolyVektor);
	BOOL AddVektor (double x, double y);
	CVektor* GetVektor (short nIndex);
	int GetInputDirection();
	BOOL IsInside(double Px, double Py, int inputDirection);

	void ArcToPoly(double dStartX, double dStartY, 
							 double dEndX, double dEndY,
							 double dCenterX, double dCenterY);


private:
	void CreatePointsArray();
	void DeleteArrayOf (CPtrArray* ptArray);
	BOOL Schnittpunkt (double dBv1x, double dBv1y, double dRv1x, double dRv1y, 
				  double dBv2x, double dBv2y, double dRv2x, double dRv2y, 
				  double* ptX,double* ptY, double* ptFakt);
	void NextLines(double px,double py, BOOL bHorz, 
			  CVektor** ptptL1a, CVektor** ptptL1b,
			  CVektor** ptptL2a, CVektor** ptptL2b);

};



#endif		// __PF_POLYGON__