/*********************************************************************
 *				         S e r C o m . c p p					     *
 *********************************************************************/
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "stdafx.h"
#include "SerCom.h"
#include "Defines.h"
#include <direct.h>					// for _getcwd

char	szBuffer [256];
#define TRANS_SIZE 80


/************************************************************************
 *  SerCom.cpp			S e r S h o w S t a t u s						*
 *  Purpose: check general  timeout										*
 *  input    - DWORD  - NULL or initialising time in sec,				*
 *	       value CHECK_INIT, CHECK_TIME									*
 *  return   - TRUE / FALSE												*
 ************************************************************************/
BOOL CheckTimeOut (DWORD delta_t, WORD wStatus)
{
static DWORD dwTime;
static DWORD dwStart;
static DWORD dwLast;
static DWORD dwTimeOut;
DWORD dwDelta;

delta_t *= 1000;

switch (wStatus)
    {
    case CHECK_INIT:
		dwStart		= GetCurrentTime ();	    // 1/1000 sec
		dwLast		= dwStart;
		dwTimeOut   = delta_t;
		return FALSE; 
    default:
		dwTime = GetCurrentTime ();
		dwLast = dwTime;
		if (dwTime >= dwStart)
			{
			dwDelta = dwTime - dwStart ;
			}
		else{
			dwDelta = (DWORD)((-1L)*(dwTime - dwStart)) ;
			}
		if (dwDelta > dwTimeOut) 
			return TRUE ;
		return FALSE;
    }
}

/************************************************************************
 *  SerCom.cpp				S e r N u m O f C o m 						*
 ************************************************************************/
short SerNumOfCom ()
{
short i;
short nComPorts = 0;

for (i=0; i<4; i++)
	{
	CSerCom Ser (4800, 8, (float)1.0, NO);

	if (Ser.IsAvailable(i))		// opens and closes connection
		{
		nComPorts++;
		}
	}

return nComPorts;
}

/*********************************************************************
 *  SerCom.cpp			C o n v e r t B i n T o H e x			     *
 *********************************************************************/
void CSerCom::ConvertBinToHex (unsigned char* szBin, long lBin, char* szHex, long* ptHexLen)
{
short i;
char	szHexVal[6];	// 0x00_

*szHexVal = 0;
strcpy (szHex, szHexVal);

for (i=0; i<lBin; i++)
    {
    sprintf (szHexVal, "%02X ", *((unsigned char FAR*)szBin + i));
    strcat (szHex, szHexVal);
    }
	
*ptHexLen = strlen (szHex);
}

/*********************************************************************
 *  SerCom.cpp				 W a i t T e n t h S e c			     *
 *********************************************************************/
void WaitTenthSec (short nTime)
{
long dwStart, dwEnd;
BOOL	bCont = TRUE;

dwStart  = GetCurrentTime ();	    // 1/1000 sec
do  {
    dwEnd  = GetCurrentTime ();	   // 1/1000 sec
    bCont = ((dwEnd - dwStart) < (nTime * 100));
    } while (bCont);
}

/*********************************************************************
 *  SerCom.cpp				S a v e A s T e x t B o x			     *
 *********************************************************************/
CString SaveAsTextBox (CWnd* ptWnd, CString szDlgTitle, CString szDfltName)
{
char	szTitle[32];
char	szPath[256];
char	szFileExt[256];
CString szFullName;

strcpy (szTitle, (LPCTSTR)szDlgTitle);
_getcwd(szPath, 256);
wsprintf (szFileExt, "%s.txt", (LPCTSTR)szDfltName);

static char szFilter[] = "Text (*.txt)|*.txt||"; 

CFileDialog dlg(FALSE, 	  					// File SaveAs dialog
				NULL,						// no default extension
				"*.txt",					// initial filename
				OFN_HIDEREADONLY |	  		// dwFlags
				OFN_OVERWRITEPROMPT,
				szFilter,
				ptWnd);						// parent window

dlg.m_ofn.lpstrInitialDir = (LPCTSTR)szPath;
dlg.m_ofn.lpstrFileTitle = (LPTSTR)szFileExt;
dlg.m_ofn.lpstrTitle = (LPTSTR)szTitle;

int ret = dlg.DoModal();
if (ret == IDOK)
	{
	szFullName = (CString)dlg.m_ofn.lpstrFileTitle;
	}

return szFullName;
}


/*********************************************************************
 *  SerCom.cpp					S e n d F i l e 				     *
 *********************************************************************/
BOOL SendFile (CWnd* ptWnd)
{
BOOL	bOK = TRUE;
CString	szFileTitle;

szFileTitle = SaveAsTextBox (ptWnd, "Sent File:", "Send");
if (szFileTitle.GetLength() > 0)
	{
	CFile SourceFile (szFileTitle, CFile::modeRead);
	DWORD dwSendLen = (DWORD)SourceFile.GetLength ();

    if (dwSendLen > 0)
		{
		CSerCom Ser (4800, 8, (float)1.0, NO);
		Ser.TextMode ((char)4);

		bOK = Ser.WriteFromFile (SourceFile);
		if (Ser.GetError() == SER_BADWRITE)
			{
			ptWnd->MessageBox((LPSTR)"WriteFromFile: bad Write Comm",
				(LPSTR)"E R R O R", MB_OK|MB_ICONHAND);
			}

		SourceFile.Close();
		}
	}

return bOK;
}

/*********************************************************************
 *  SerCom.cpp				R e c e i v e F i l e 				     *
 *********************************************************************/
BOOL ReceiveFile (CWnd* ptWnd)
{
BOOL	bOK = TRUE;
CString	szFileTitle;

szFileTitle = SaveAsTextBox (ptWnd, "Received File:", "Received");
if (szFileTitle.GetLength() > 0)
	{
	CFile DestFile (szFileTitle, CFile::modeCreate || CFile::modeWrite);

    bOK = TRUE;
    if (bOK)
		{
		CSerCom Ser(4800, 8, (float)1.0, NO);
		Ser.TextMode ((char)4);

		bOK = Ser.ReadIntoFile (DestFile);
		if (Ser.GetError() == SER_TIMEOUT)
			{
			ptWnd->MessageBox((LPSTR)"SerReadIntoFile: Timeout",
			(LPSTR)"E R R O R", MB_OK|MB_ICONHAND);
			}
		if (Ser.GetError() == SER_BADREAD)
			{
			ptWnd->MessageBox((LPSTR)"SerReadIntoFile: bad Read Comm",
			(LPSTR)"E R R O R", MB_OK|MB_ICONHAND);
			}
		if (Ser.GetError() == SER_OK)
			{
			ptWnd->MessageBox((LPSTR)"SerReadIntoFile: Fertig",
			(LPSTR)"E R R O R", MB_OK|MB_ICONHAND);
			}

		DestFile.Close();
        }
	}

return bOK;
}



// Class CSerCom:

/************************************************************************
 *  SerCom.cpp				C S e r C o m				CONSTRUCTOR		*
 ************************************************************************/
CSerCom::CSerCom (long lBaud, short nData, float fStop, short nParity, BOOL bBinary)
{										
memset (&m_Status, 0, sizeof (COMSTAT));
memset (&m_Control, 0, sizeof (DCB));
m_Control.DCBlength = sizeof(DCB);

m_uBaud			= (UINT)0;
m_btData		= (BYTE)0;		   /* 4, ... 8 		*/
m_btStop		= (BYTE)0;
m_btParity		= (BYTE)0;
m_Error			= SER_OK;
m_cEndOfSession =(char)0;
m_bEndOfSession = FALSE;

m_bOpened		= FALSE;
m_hConnection	= NULL;

switch (lBaud)
    {       
    case 110   :  m_uBaud = CBR_110   ;  break;
    case 300   :  m_uBaud = CBR_300   ;  break;
    case 600   :  m_uBaud = CBR_600   ;  break;
    case 1200  :  m_uBaud = CBR_1200  ;  break;
    case 2400  :  m_uBaud = CBR_2400  ;  break;
    case 4800  :  m_uBaud = CBR_4800  ;  break;
    case 9600  :  m_uBaud = CBR_9600  ;  break;
    case 14400 :  m_uBaud = CBR_14400 ;  break;
    case 19200 :  m_uBaud = CBR_19200 ;  break;
    case 38400 :  m_uBaud = CBR_38400 ;  break;
    case 56000 :  m_uBaud = CBR_56000 ;  break;
    case 128000:  m_uBaud = CBR_128000;  break;
    case 256000:  m_uBaud = CBR_256000;  break;
	default:		m_uBaud = CBR_4800;	 break;
    }

m_btData = (BYTE)nData;

short nStop = 10 * (short)fStop;
switch (nStop)
    {
    case 10: m_btStop = (BYTE)ONESTOPBIT;	 break;
    case 15: m_btStop = (BYTE)ONE5STOPBITS;  break;
    case 20: m_btStop = (BYTE)TWOSTOPBITS;   break;
    }

switch (nParity)
    {
    case NO:	m_btParity = NOPARITY;	break;
    case ODD:	m_btParity = ODDPARITY;	break;
    case EVEN:	m_btParity = EVENPARITY;	break;
    case MARK:	m_btParity = MARKPARITY;	break;
    default: break;
    }

m_bBinary = bBinary;

m_ptWnd = NULL;
m_lpInit = NULL;
m_bProgressDlg = FALSE;
m_lpOut= NULL;
m_lpInp= NULL;
m_bUseUSB = FALSE;
m_ptUSB = NULL;

}


/************************************************************************
 *  SerCom.cpp				~ C S e r C o m				  DESTRUCTOR	*
 ************************************************************************/
CSerCom::~CSerCom()
{

}


/*********************************************************************
 *  SerCom.cpp				S h o w S t a t u s					     *
 *********************************************************************/
void CSerCom::ShowStatus ()
{
BOOL bCTShold = (m_Status.fCtsHold == 1);
BOOL bDSRhold = (m_Status.fDsrHold == 1);
BOOL bRLShold = (m_Status.fRlsdHold == 1);
BOOL bXOFFhold = (m_Status.fXoffHold == 1);
BOOL bXOFFsent = (m_Status.fXoffSent == 1);
BOOL bEOFreceived = (m_Status.fEof == 1);
BOOL bCharWaiting = (m_Status.fTxim == 1);


//m_Status.cbInQue		// numb of chars in receive queue
//m_Status.cbOutQue	// numb of chars in transmitt queue

sprintf (szBuffer, "Status: CTS=%d, DSR=%d, RLS=%d, XOFFhold=%d, XOFFsent=%d EOF=%d ChWait=%d, RecQ=%d, TransQ=%d",
	bCTShold, bDSRhold, bRLShold, bXOFFhold, bXOFFsent, bEOFreceived,
    bCharWaiting,
    (int)m_Status.cbInQue, (int)m_Status.cbOutQue);
AfxMessageBox (szBuffer);
}

/*********************************************************************
 *  SerCom.cpp					T e x t M o d e					     *
 *********************************************************************/
void CSerCom::TextMode (char cEndOfSession)
{
m_Control.fBinary	= 0;		// nonbinary mode: use EofChar
m_Control.EofChar = cEndOfSession;

m_cEndOfSession = cEndOfSession;
}

/*********************************************************************
 *  SerCom.cpp					B i n M o d e					     *
 *********************************************************************/
void CSerCom::BinMode ()
{
m_Control.fBinary	= 1;	  // binary mode: don't use EofChar
m_Control.EofChar = 0;

m_cEndOfSession = 0;
}

/*********************************************************************
 *  SerCom.cpp				P r o g r e s s D l g				     *
 *********************************************************************/
void CSerCom::ProgressDlg(CWnd* ptWnd, FARPROC lpInit)
{
m_ptWnd = ptWnd;
m_lpInit = lpInit;
m_bProgressDlg = TRUE;
}


/*********************************************************************
 *  SerCom.cpp					X o n X o f f					     *
 *********************************************************************/
void CSerCom::XonXoff (unsigned char uXon, unsigned char uXoff)
{

//m_Control.fOutxCtsFlow = (BYTE)1;
//m_Control.fOutxDsrFlow = (BYTE)0;	/* NICHT 1 */

					// Xon-Xoff
m_Control.fOutX	  = 1;
m_Control.fInX	  = 1;
	
m_Control.XonChar	= uXon;
m_Control.XoffChar	= uXoff;
}


/************************************************************************
 *  SerCom.cpp				I s A v a i l a b l e						*
 ************************************************************************/
BOOL CSerCom::IsAvailable(short nPort)
{
BOOL	bAvailable = FALSE;
char	szName[32];

m_Error = SER_OK;
if (nPort >=1 && nPort <= 4)
    {
    sprintf (szName, "\\\\.\\COM%d", nPort);
    }
else{
    m_Error = SER_BADPORT;
    return bAvailable;
    }

DWORD	fdwAccess, fdwShareMode, fdwCreate, fdwAttrsAndFlags;
fdwAccess			= 0;	// Specifies device query access to the object.
							// An application can query device attributes without
							// accessing the device.
fdwShareMode		= FILE_SHARE_READ | FILE_SHARE_WRITE;
fdwCreate			= OPEN_EXISTING;
fdwAttrsAndFlags	= FILE_ATTRIBUTE_NORMAL;

m_hConnection = CreateFile (szName, 
		fdwAccess, 
		fdwShareMode, 
		NULL, 
		fdwCreate, 
		fdwAttrsAndFlags, 
		NULL);

if (m_hConnection != INVALID_HANDLE_VALUE)
	{
	DWORD dwErrors;

	ClearCommError(m_hConnection, &dwErrors, &m_Status);

	bAvailable = TRUE;
	if (CloseHandle (m_hConnection))
		{
		m_hConnection = NULL;
		}
	}
else{
    m_Error = SER_BADPORT;
	}

return bAvailable;
}


/****************************************************************************
 *	SerCom.cpp			W a i t F o r S i g n a l e d I O E v e n t			*
 ****************************************************************************/
BOOL CSerCom::WaitForSignaledIOEvent (HANDLE hObject, CString* ptMsg, BOOL* ptCritical)
{
	return WaitForSignaledEvent (hObject, ptMsg, ptCritical, IO_WAIT_SEC);
}

/****************************************************************************
 *	SerCom.cpp			W a i t F o r S i g n a l e d E v e n t				*
 ****************************************************************************/
BOOL CSerCom::WaitForSignaledEvent (HANDLE hObject, CString* ptMsg, BOOL* ptCritical)
{
	return WaitForSignaledEvent (hObject, ptMsg, ptCritical, THREAD_WAIT_SEC);
}

/****************************************************************************
 *	SerCom.cpp				W a i t F o r S i g n a l e d E v e n t			*
 ****************************************************************************/
BOOL CSerCom::WaitForSignaledEvent (HANDLE hObject, CString* ptMsg, BOOL* ptCritical, short nWait_sec)
{
	BOOL bSignaled = FALSE;

	BOOL bCritical = FALSE;
	DWORD dwRet;
	dwRet = WaitForSingleObject(hObject, nWait_sec * 1000);
			
	DWORD dwErr=0;
	switch (dwRet)
	{
		case WAIT_FAILED:
			dwErr = GetLastError();
			ErrorIDtoText(dwErr, ptMsg);
			break;
		case WAIT_ABANDONED:
			*ptMsg = "WAIT_ABANDONED";
			break;
		case WAIT_OBJECT_0:
			*ptMsg = "The state of the specified object is signaled.";
			bSignaled = TRUE;
			break;
		case WAIT_TIMEOUT:
			*ptMsg = "The time-out interval elapsed";
			bCritical = TRUE;
			break;
		default:
			*ptMsg = "unknown return";
			break;
	}

	if (ptCritical != NULL)
		*ptCritical = bCritical;

return bSignaled;
}

/************************************************************************
 *  SerCom.cpp						O p e n U S B						*
 ************************************************************************/
BOOL CSerCom::OpenUSB(short nPort, short nInpLen, short nOutLen)
{
	m_bOpened = FALSE;

	BOOL	bMemOK	= TRUE;
	if (nInpLen > 0)
		{
		if (m_lpInp != NULL)
			delete [] m_lpInp;

		m_lpInp	= new unsigned char[nInpLen];
		if (m_lpInp == NULL)
			bMemOK = FALSE;
		}

	if (nOutLen > 0)
		{
		if (m_lpOut != NULL)
			delete [] m_lpOut;

 		m_lpOut	= new unsigned char[nOutLen];
		if (m_lpOut == NULL)
			bMemOK = FALSE;
		}

	if (!bMemOK)
		{
		m_Error = SER_BADOPEN;
		return m_bOpened;
		}


		m_ptUSB = new CUsb();
		m_ptUSB->EnumInterfaceDevices("{2C9C45C2-8E7D-4C08-A12D-816BBAE722C0}");

		m_Error = SER_OK;

		if (nPort >= 0 && nPort < m_ptUSB->GetDeviceCnt())
		{		// try to find path of driver and open it
			CUsbDevice* ptDevice = m_ptUSB->GetDevicePtr(nPort);
			if (ptDevice != NULL)
			{
				m_hConnection = ptDevice->Open(ptDevice->GetDevicePath());
				if (m_hConnection != INVALID_HANDLE_VALUE)
				{
					m_bOpened = TRUE;
					m_bUseUSB = TRUE;

					DWORD dwUSBPacketSize=0;
					DWORD theBytesReturned = 0;

					HANDLE hGpsEvent = CreateEvent(NULL, false, false, NULL);
					OVERLAPPED overlapped;
					memset (&overlapped, 0, sizeof(OVERLAPPED));
					overlapped.hEvent = hGpsEvent;

					int nRetVal = DeviceIoControl(m_hConnection,
								 IOCTL_USB_PACKET_SIZE,
								 NULL,
								 0,
								 &dwUSBPacketSize,		// need for writing to USB
								 ASYNC_DATA_SIZE,		// 64 oder sizeof( dwUSBPacketSize ),		
								 &theBytesReturned,
								 &overlapped);
					if (!nRetVal && (GetLastError() == ERROR_IO_PENDING))
					{
						CString szMsg;
						if (!WaitForSignaledIOEvent(hGpsEvent, &szMsg))
						{
							m_bOpened = FALSE;
							m_Error = SER_BADOPEN;
							AfxMessageBox(szMsg);
						}
				//		ResetEvent(hGpsEvent);
					}

					if (nRetVal != 0)
					{
						this->SetPacketSize(dwUSBPacketSize);
						CString msg;
						msg.Format("BytesReturned=%ld PacketSize: %ld", theBytesReturned, dwUSBPacketSize);
					//	AfxMessageBox (msg);
					}
					CloseHandle (hGpsEvent);
				}
				else
				{
					m_Error = SER_BADOPEN;
				}
			}
		}
		else
		{
			m_Error = SER_BADPORT;
		}



return m_bOpened;

}
    
 
/************************************************************************
 *  SerCom.cpp						O p e n 							*
 ************************************************************************/
BOOL CSerCom::Open(short nPort, short nInpLen, short nOutLen)
{
BOOL	bOpened = FALSE;
char	szName[32];

BOOL	bMemOK	= TRUE;
if (nInpLen > 0)
    {
	if (m_lpInp != NULL)
		delete [] m_lpInp;

	m_lpInp	= new unsigned char[nInpLen];
	if (m_lpInp == NULL)
		bMemOK = FALSE;
    }

if (nOutLen > 0)
    {
	if (m_lpOut != NULL)
		delete [] m_lpOut;

 	m_lpOut	= new unsigned char[nOutLen];
	if (m_lpOut == NULL)
		bMemOK = FALSE;
    }

if (!bMemOK)
    {
    m_Error = SER_BADOPEN;
    return bOpened;
    }

m_Error = SER_OK;
if (nPort >=1 && nPort <= 8)
    {
    sprintf (szName, "\\\\.\\COM%d", nPort);
    }
else{
    m_Error = SER_BADPORT;
    return bOpened;
    }

DWORD	fdwAccess, fdwShareMode, fdwCreate, fdwAttrsAndFlags;
fdwAccess = GENERIC_READ | GENERIC_WRITE;
fdwShareMode = 0;
fdwCreate = OPEN_EXISTING;
fdwAttrsAndFlags = FILE_ATTRIBUTE_NORMAL;

m_hConnection = CreateFile (szName, 
		fdwAccess, 
		fdwShareMode, 
		NULL, 
		fdwCreate, 
		fdwAttrsAndFlags, 
		NULL);

if (m_hConnection != INVALID_HANDLE_VALUE)
	{
	m_Control.BaudRate	= m_uBaud;
	m_Control.ByteSize	= m_btData;
	m_Control.Parity	= m_btParity;
	m_Control.StopBits	= m_btStop;

 	m_Control.fBinary = (m_bBinary)? 1 : 0;

//	if ((m_Control.fOutX == 1) || (m_Control.fInX == 1))
//		{				    // Xon / Xoff activated:
//		m_Control.XonLim	= 30;
//		m_Control.XoffLim	= (nInpLen/2)+1;
//		}
 

	if (SetCommState(m_hConnection, &m_Control))
		{
		m_bOpened = TRUE;
		bOpened = TRUE;
		}
	else{
		m_Error = SER_COMMSTATE;
		}
	}
else{
    m_Error = SER_BADOPEN;
	}

//FlushComm (m_Control.Id, 0);   // transmission queue is flushed
//FlushComm (m_Control.Id, 1);   // receiving queue is flushed
return bOpened;
}

/*********************************************************************
 *  SerCom.cpp				S e t B a u d R a t e				     *
 *********************************************************************/
BOOL CSerCom::SetBaudRate (short nBaud)
{
BOOL bSet = FALSE;
m_Control.BaudRate	= nBaud;

if (SetCommState(m_hConnection, &m_Control))
	{
	m_Error = SER_OK;
	bSet = TRUE;
	}
else{
	m_Error = SER_COMMSTATE;
    }
return bSet;
}

/*********************************************************************
 *  SerCom.cpp					C l o s e						     *
 *********************************************************************/
BOOL CSerCom::Close ()
{
BOOL bClosed = FALSE;
m_Error = SER_OK;

if (!m_bOpened)
    return TRUE;

if (m_lpInp != NULL)
    {
	delete [] m_lpInp;         
    m_lpInp = NULL;
    }

if (m_lpOut != NULL)
    {
	delete [] m_lpOut;         
    m_lpOut = NULL;
    }


if (m_hConnection != NULL)
	{
	bClosed = CloseHandle (m_hConnection);
	if (bClosed)
		{
		m_hConnection = NULL;
		}
	else{
		m_Error = SER_BADCLOSE;
		}
	}

if (m_ptUSB != NULL)
{
	delete m_ptUSB;
	m_ptUSB = NULL;
}


return bClosed;
}


/*********************************************************************
 *  SerCom.cpp					W r i t e						     *
 *********************************************************************/
BOOL CSerCom::Write (unsigned char* lpBuffer, long lBytes)
{
DWORD	dwErrors;
BOOL	bWritten = FALSE;
DWORD	BytesWritten = 0;
BOOL	bWait, bTimeout;

m_Error = SER_OK;

			 /* E r r o r	C h e c k	   */
ClearCommError(m_hConnection, &dwErrors, &m_Status);

CheckTimeOut (10, CHECK_INIT);
do  {
    bTimeout = CheckTimeOut (0L, CHECK_TIME);
    ClearCommError(m_hConnection, &dwErrors, &m_Status);
    //bWait = ( (m_Status.fXoffHold == 1) );
    bWait = (m_Status.fXoffHold != 0);
    } while (bWait && !bTimeout);


if (!bTimeout)
	{
	bWritten = WriteFile (m_hConnection, lpBuffer, (DWORD)lBytes,
			                     		&BytesWritten, NULL);
	if (!bWritten)
		{
		ClearCommError(
				m_hConnection,	// handle to communications device
				&dwErrors,	// pointer to variable to receive error codes
				&m_Status	// pointer to buffer for communications status  
			   );

		//   ShowStatus ();
		m_Error = SER_BADWRITE;
		}
	}
else{
	m_Error = SER_TIMEOUT;
	}

return bWritten;
}

/*********************************************************************
 *  SerCom.cpp					W r i t e U S B					     *
 *********************************************************************/
BOOL CSerCom::WriteUSB (unsigned char* lpBuffer, long lBytes)
{
	BOOL	bWritten = FALSE;
	DWORD	BytesWritten = 0;

	m_Error = SER_OK;

	HANDLE hGpsEvent = CreateEvent(NULL, false, false, NULL);
	OVERLAPPED overlapped;
	memset (&overlapped, 0, sizeof(OVERLAPPED));
	overlapped.hEvent = hGpsEvent;

	BOOL bSendEmptyWrite = FALSE;
	if (lBytes == (long)m_dwPacketSize)
	{
		bSendEmptyWrite = TRUE;
	}


	int nRetVal = WriteFile (m_hConnection, lpBuffer, (DWORD)lBytes,
			                     		&BytesWritten, &overlapped);

	if (!nRetVal && (GetLastError() == ERROR_IO_PENDING))
	{
		CString szMsg;
		if (WaitForSignaledIOEvent(hGpsEvent, &szMsg))
		{
			if (GetOverlappedResult(m_hConnection, &overlapped, &BytesWritten, TRUE))
			{
				bWritten = TRUE;
			}
			ResetEvent(hGpsEvent);
		}
		else
		{
			m_Error = SER_BADWRITE;
			AfxMessageBox(szMsg);
		}
	}

	if (lBytes != (long)BytesWritten)
		bWritten = FALSE;

	CloseHandle (hGpsEvent);

	if (bSendEmptyWrite)
		this->WriteUSB(lpBuffer, 0);

	if (!bWritten)
	{
		//   ShowStatus ();
		m_Error = SER_BADWRITE;
	}
	else
	{
		m_Error = SER_OK;
	}

return bWritten;
}


/************************************************************************
 *  SerCom.cpp				 B y t e s I n Q u e u e					*
 ************************************************************************/
short CSerCom::BytesInQueue (short nCnt)
{
DWORD	dwErrors;
BOOL	bWait;
BOOL	bTimeout = FALSE;

memset (&m_Status, 0, sizeof (COMSTAT));
if (this->m_bUseUSB)
{
	m_Status.cbInQue = 1;
}
else
{
CheckTimeOut (5, CHECK_INIT);		    // 5	sec
do  {
    BOOL bRet = ClearCommError(m_hConnection, &dwErrors, &m_Status);
    if (dwErrors == 0)
		{
		bWait = (m_Status.cbInQue < (UINT)nCnt);
		}
    else{
		return FALSE;
		}
   bTimeout = CheckTimeOut (0L, CHECK_TIME);
   } while (bWait && !bTimeout);
}

m_Error = (bTimeout)? SER_TIMEOUT : SER_OK;
return (short)m_Status.cbInQue;
}


/*********************************************************************
 *  SerCom.cpp						R e a d	U S B				     *
 *********************************************************************/
BOOL CSerCom::ReadUSB(short nReadMode, unsigned char* lpBuffer, DWORD dwMaxBytesToRead, DWORD* ptBytesRead)
{
	BOOL bOK = FALSE;

	if (nReadMode == CSerCom::ReadMode_InterruptPipe)
	{
		bOK = ReadUSB(lpBuffer, dwMaxBytesToRead, ptBytesRead);

	}
	if (nReadMode == CSerCom::ReadMode_BulkPipe)
	{
		bOK = ReadUSBFile(lpBuffer, dwMaxBytesToRead, ptBytesRead);
	}

	return bOK;
}

/*********************************************************************
 *  SerCom.cpp						R e a d	U S B				     *
 *  uses DeviceIOControl											 *
 *********************************************************************/
BOOL CSerCom::ReadUSB(unsigned char* lpBuffer, DWORD dwMaxBytesToRead, DWORD* ptBytesRead)
{
	BOOL bStopThread = FALSE;
	DWORD	dwBytesRead = 0;
	BOOL bSuccess = FALSE;
	BOOL bTryAgain = TRUE;
	BOOL bManualReset = FALSE;
	BOOL bInitialState = FALSE;
	BOOL nLoops = 0;
	*ptBytesRead = 0;

	m_Error = SER_OK;

	do
	{		
		HANDLE hGpsEvent = CreateEvent(NULL, bManualReset, bInitialState, NULL);
		if (hGpsEvent != NULL)
		{
			OVERLAPPED overlapped;
			memset (&overlapped, 0, sizeof(OVERLAPPED));
			overlapped.hEvent = hGpsEvent;

			bSuccess = FALSE;

			int nRetVal = DeviceIoControl(m_hConnection,
					 IOCTL_ASYNC_IN,
					 0,
					 0,
					 lpBuffer,		
					 dwMaxBytesToRead,		
					 &dwBytesRead,
					 &overlapped);


			if (nRetVal != 0)
			{
				bSuccess = TRUE;
			}
			else
			{
				DWORD dwErr = GetLastError();
				if (dwErr == ERROR_IO_PENDING)
				{
					CString szMsg;
					if (WaitForSignaledIOEvent(hGpsEvent, &szMsg))
					{
						if (GetOverlappedResult(m_hConnection, &overlapped, &dwBytesRead, TRUE))
						{
							bSuccess = TRUE;
						}	
						else
						{
							m_Error = SER_BADREAD;
							AfxMessageBox ("GetOverlappedResult returned FALSE");
							bStopThread = TRUE;
						}
					}
					else
					{		// schreibt: berlappender Ein-/Ausgabebereich wird berarbeitet
						m_Error = SER_BADREAD;
						AfxMessageBox("WaitForSingleEvent: " + szMsg);
						bStopThread = TRUE;
					}
				}
				else
				{		// other error occured
					CString szErr;
					ErrorIDtoText(dwErr, &szErr);
					CString szMsg;
					szMsg.Format("DeviceIoControl %s (%ld)", (LPCTSTR)szErr, dwErr); 
					AfxMessageBox(szMsg);

					bStopThread = TRUE;
					m_Error = SER_BADREAD;
				}
			}


			if (!bSuccess || bStopThread)
				dwBytesRead = 0;

			ResetEvent(hGpsEvent);
			CloseHandle(hGpsEvent);
		} // good hGpsEvent

		bTryAgain = (dwBytesRead == 0 || !bSuccess); 
		nLoops++;
		if (nLoops > 10)
		{
			bStopThread = TRUE;
			AfxMessageBox("CSerCom::ReadUSB, nLoops > 10");
		}
	} while (bTryAgain && !bStopThread);

	*ptBytesRead = dwBytesRead;

	return !bStopThread;		// return TRUE for good result
} 

/********************************************************************
 *  SerCom.cpp						R e a d	U S B F i l e		    *
 *  uses ReadFile													*
 ********************************************************************/
BOOL CSerCom::ReadUSBFile(unsigned char* lpBuffer, DWORD dwMaxBytesToRead, DWORD* ptBytesRead)
{
	BOOL bStopThread = FALSE;
	DWORD	dwBytesRead = 0;
	BOOL bSuccess = FALSE;
	BOOL bTryAgain = TRUE;
	BOOL bManualReset = FALSE;
	BOOL bInitialState = FALSE;
	BOOL nLoops = 0;
	*ptBytesRead = 0;

	m_Error = SER_OK;

	do
	{		
		HANDLE hGpsEvent = CreateEvent(NULL, bManualReset, bInitialState, NULL);
		if (hGpsEvent != NULL)
		{
			OVERLAPPED overlapped;
			memset (&overlapped, 0, sizeof(OVERLAPPED));
			overlapped.hEvent = hGpsEvent;

			bSuccess = FALSE;

			bSuccess = ReadFile(m_hConnection, lpBuffer, dwMaxBytesToRead, &dwBytesRead, &overlapped);

			if (!bSuccess)
			{
				DWORD dwErr = GetLastError();
				if (dwErr == ERROR_IO_PENDING)
				{
					CString szMsg;
					if (WaitForSignaledIOEvent(hGpsEvent, &szMsg))
					{
						if (GetOverlappedResult(m_hConnection, &overlapped, &dwBytesRead, TRUE))
						{
							bSuccess = TRUE;
						}	
						else
						{
							m_Error = SER_BADREAD;
							AfxMessageBox ("GetOverlappedResult returned FALSE");
							bStopThread = TRUE;
						}
					}
					else
					{	// The time-out interval elapsed (while looking for zero packets after transfer completed
						m_Error = SER_BADREAD;
				//		AfxMessageBox("WaitForSingleEvent: " + szMsg);
						bStopThread = TRUE;
					}
				}
				else
				{		// other error occured
					CString szErr;
					ErrorIDtoText(dwErr, &szErr);
					CString szMsg;
					szMsg.Format("ReadFile %s (%ld)", (LPCTSTR)szErr, dwErr); 
					AfxMessageBox(szMsg);

					bStopThread = TRUE;
					m_Error = SER_BADREAD;
				}
			}


			if (!bSuccess || bStopThread)
				dwBytesRead = 0;

			ResetEvent(hGpsEvent);
			CloseHandle(hGpsEvent);
		} // good hGpsEvent

		bTryAgain = (dwBytesRead == 0 || !bSuccess); 
		nLoops++;
		if (nLoops > 10)
		{
			bStopThread = TRUE;
			AfxMessageBox("CSerCom::ReadUSBFile, nLoops > 10");
		}
	} while (bTryAgain && !bStopThread);

	*ptBytesRead = dwBytesRead;

	return !bStopThread;		// return TRUE for good result
} 


/*********************************************************************
 *  SerCom.cpp						R e a d	C o m m				     *
 *********************************************************************/
DWORD CSerCom::ReadComm (unsigned char* lpBuffer, DWORD dwBytesToRead)
{
DWORD	dwBytesRead = 0;
ReadFile (m_hConnection, lpBuffer, dwBytesToRead, &dwBytesRead, NULL);
return dwBytesRead;
} 

/*********************************************************************
 *  SerCom.cpp						R e a d						     *
 *********************************************************************/
BOOL CSerCom::Read (unsigned char* lpBuffer, short nBytesToRead, long* ptRead)
{
BOOL	bOK = TRUE;
BOOL	bTimeout = FALSE;
DWORD	dwErrors;
DWORD	dwReadLen = 0;
DWORD	BytesRead = 0;
BOOL	bWait;

*ptRead = 0;
memset (&m_Status, 0, sizeof (COMSTAT));

CheckTimeOut (5, CHECK_INIT);
do  {
    ClearCommError(m_hConnection, &dwErrors, &m_Status);
    bWait = (m_Status.cbInQue < (UINT)nBytesToRead);

    bTimeout = CheckTimeOut (0L, CHECK_TIME);
   } while (bWait && !bTimeout);

BytesRead = 0;
if (m_Status.cbInQue > 0)
	{
	dwReadLen = (bTimeout)? m_Status.cbInQue : nBytesToRead;
	bOK = ReadFile (m_hConnection, lpBuffer, dwReadLen, &BytesRead, NULL);
    }
    
if (BytesRead > 0 && (m_Control.fBinary != 1))
    {
    DWORD   i;
    for (i=0; i<BytesRead && !m_bEndOfSession; i++)
		{
		m_bEndOfSession = (*(lpBuffer + i) == m_cEndOfSession);
	   //	m_bEndOfSession = (m_Status.fEof == 1);
		}

    if (m_bEndOfSession)
		{
		AfxMessageBox ((LPSTR)"EndByte found!");
		m_Error = SER_OK;
		bTimeout = FALSE;
		}
    }

if (bTimeout)
    {
    m_Error = SER_TIMEOUT;
    m_bEndOfSession = TRUE;
    }

if (!bOK)
    {				// Error occured!
    ClearCommError(m_hConnection, &dwErrors, &m_Status);
    this->ShowStatus ();
    m_Error = SER_BADREAD;
    }  
    
if (BytesRead < 0)
	BytesRead *= -1;  
	
*ptRead = BytesRead;

return bOK;
}

/*********************************************************************
 *  SerCom.cpp					R e a d B i n					     *
 *********************************************************************/
BOOL CSerCom::ReadBin (unsigned char* lpBuffer, short nBytesToRead, long* ptRead)
{
BOOL	bOK = TRUE;
BOOL	bTimeout = FALSE;
DWORD	dwErrors;
DWORD	dwReadLen = 0;
DWORD	BytesRead = 0;
BOOL	bWait;

*ptRead = 0;

CheckTimeOut (5, CHECK_INIT);
do  {
    ClearCommError(m_hConnection, &dwErrors, &m_Status);
    bWait = (m_Status.cbInQue < (UINT)nBytesToRead);

    bTimeout = CheckTimeOut (0L, CHECK_TIME);
   } while (bWait && !bTimeout);

BytesRead = 0;
if (m_Status.cbInQue > 0)
	{
	dwReadLen = (bTimeout)? m_Status.cbInQue : nBytesToRead;
	bOK = ReadFile (m_hConnection, lpBuffer, dwReadLen, &BytesRead, NULL);
	}


if (bTimeout)
    {
    m_Error = SER_TIMEOUT;
    m_bEndOfSession = TRUE;
    }

if (!bOK)
    {				// Error occured!
    ClearCommError(m_hConnection, &dwErrors, &m_Status);
    this->ShowStatus ();
    m_Error = SER_BADREAD;
    BytesRead *= -1;
    }

*ptRead = BytesRead;

return bOK;
}

/****************************************************************************
 *	SerCom.cpp					R e a d B y t e s							*
 ****************************************************************************/
BOOL CSerCom::ReadBytes (long* ptRead, unsigned char* szBinBuff, CFile* ptFile)
{
BOOL	bStop = TRUE;
long	lLen;
int		iRead;

iRead = this->BytesInQueue ((short)*ptRead);
if (iRead < *ptRead)
	{		
	lLen = sprintf (szBuffer, "\nlRead<%d, STOP", *ptRead);
    if (ptFile != NULL)
		ptFile->Write ((const void*)szBuffer, (UINT)lLen);
	return bStop;
	}
	
iRead = (int)*ptRead;
iRead = this->ReadComm(szBinBuff, (int)iRead);

if (iRead == *ptRead)
	{
	char szHexBuff[1024];
	long	lHexLen = 0;
	*szHexBuff = 0;
	
	ConvertBinToHex (szBinBuff, iRead, szHexBuff, &lHexLen);
	szHexBuff[lHexLen] = 0;
    if (ptFile != NULL)
		ptFile->Write ((const void*)szHexBuff, (UINT)lHexLen);
 	
	bStop = FALSE;
	}
return bStop;
}

/*********************************************************************
 *  SerCom.cpp				W r i t e F r o m F i l e			     *
 *********************************************************************/
BOOL CSerCom::WriteFromFile (CFile& SourceFile)
{
unsigned char	szTransBuff[TRANS_SIZE];
char	InpB[TRANS_SIZE];
BOOL bOK = TRUE;
unsigned ReadBuffSize;
long	lFileLen;
long	lRest;
UINT	uRead;

lFileLen = (long)SourceFile.GetLength();
bOK = (lFileLen > 0);
*InpB = 0;			    // to avoid compiler warning...


this->XonXoff (0xD3, 0xD1);

if (this->Open(1, TRANS_SIZE, TRANS_SIZE))
    {
    lRest = lFileLen;

    while (lRest > 0 && bOK)
		{
		if (lRest > TRANS_SIZE)
			{
			ReadBuffSize = TRANS_SIZE;
			lRest -= TRANS_SIZE;
			}
		else{
			ReadBuffSize = (unsigned)lRest;
			lRest = 0;
			}

		uRead = SourceFile.Read ((void*)szTransBuff, (UINT)ReadBuffSize );
		bOK = (uRead == ReadBuffSize);

		if (bOK)
			{
			this->Write (szTransBuff, ReadBuffSize);
			if (m_Error == SER_BADWRITE)
				{
				bOK = FALSE;
				}
			}
		}    // while (lRest > 0)...

    this->Close ();
    }
return bOK;
}

/*********************************************************************
 *  SerCom.cpp				R e a d I n t o F i l e				     *
 *********************************************************************/
BOOL CSerCom::ReadIntoFile (CFile& DestFile)
{
unsigned char	OutB[TRANS_SIZE];
unsigned char	InpB[TRANS_SIZE];
BOOL bOK = TRUE;
long	lRead;

*OutB = 0;			    // to avoid compiler warning...


this->XonXoff (0xD3, 0xD1);
if (this->Open(1, TRANS_SIZE, TRANS_SIZE))
    {
    do	{
		if (this->Read (InpB, TRANS_SIZE, &lRead))
			{
			DestFile.Write ((const void*)InpB, (UINT)lRead);
			bOK = TRUE;
			}
		} while (!m_bEndOfSession && bOK);

    this->Close ();
    }

return bOK;
}


/****************************************************************************
 *							E r r o r I D t o T e x t		 				*
 *  Input: dwErr, a system error ID											*
 *	Output: ptErr, the corresponding error message							*
 ****************************************************************************/
BOOL CSerCom::ErrorIDtoText (DWORD dwErr, CString* ptErr)
{
LPVOID lpMsgBuf;

DWORD dwCnt = FormatMessage( 
	FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM,
	NULL,
	dwErr,
	MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), // Default language
	(LPTSTR) &lpMsgBuf,
	0,
	NULL);

if (dwCnt > 0)
	{				
	ptErr->Format ("%s", (char*)lpMsgBuf);		// copy the string.
	LocalFree( lpMsgBuf );			// Free the buffer.
	return TRUE;
	}
else{
	ErrorIDtoText (GetLastError(), ptErr);
	return FALSE;
	}
}


/////////////////////////////////////////////////////////////////////////////
// CSerCom diagnostics

#ifdef _DEBUG
void CSerCom::AssertValid() const
{
	CObject::AssertValid();
}

void CSerCom::Dump(CDumpContext& dc) const
{
	CObject::Dump(dc);
}
#endif //_DEBUG

IMPLEMENT_DYNAMIC(CSerCom, CObject)
