#ifndef __SERCOM__
#define __SERCOM__

/*********************************************************************
 *							S e r C o m . h						     *
 *********************************************************************/
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "USB.h"

				/* for CheckTimeOut...		    */
#define CHECK_INIT		0
#define CHECK_TIME      1
			
//#define IO_WAIT_SEC		20		// good tmes for WaitForSingleObject and ReadMode_InterruptPipe
//#define THREAD_WAIT_SEC	60

//#define IO_WAIT_SEC		1		// good tmes for WaitForSingleObject and ReadMode_BulkPipe
//#define THREAD_WAIT_SEC	5
			
#define IO_WAIT_SEC		3		// times for WaitForSingleObject good for both??
#define THREAD_WAIT_SEC	20

#define PROGRESS_STRLEN 32

enum SER_PARITY { NO, ODD, EVEN, MARK};
enum SER_ERROR {SER_OK,
			SER_BADPORT,
			SER_COMMSTATE,
	       SER_BADOPEN,
	       SER_BADREAD,
	       SER_BADWRITE,
	       SER_BADCLOSE,
	       SER_TIMEOUT,
			SER_BADMEMORY};

BOOL CheckTimeOut (DWORD delta_t, WORD wStatus);
short SerNumOfCom ();
void WaitTenthSec (short nTime);
CString SaveAsTextBox (CWnd* ptWnd, CString szDlgTitle, CString szDfltName);
BOOL SendFile (CWnd* ptWnd);
BOOL ReceiveFile (CWnd* ptWnd);


class CSerCom : public CObject
{
DECLARE_DYNAMIC(CSerCom)

private:
    UINT	m_uBaud;
    BYTE	m_btData;		    /* 4, ... 8 		*/
    BYTE	m_btStop;
    BYTE	m_btParity;
	BOOL	m_bBinary;
    enum SER_ERROR m_Error;

    DCB m_Control;		    /* CBR_110, CBR_9600	*/
    COMSTAT m_Status;
    char m_cEndOfSession;
    BOOL m_bEndOfSession;

    CWnd*    m_ptWnd;
 //   char    szProgress[PROGRESS_STRLEN];
    FARPROC m_lpInit;
    BOOL    m_bProgressDlg;
    BOOL    m_bOpened;
	HANDLE	m_hConnection;

	BOOL	m_bUseUSB;
	CUsb*	m_ptUSB;
	DWORD	m_dwPacketSize;

protected:
    unsigned char*	m_lpOut;
    unsigned char*	m_lpInp;

public:
	enum
	{
		ReadMode_InterruptPipe = 0,
		ReadMode_BulkPipe = 1
	};


public:						/* default contructor	*/
	CSerCom (long lBaud=CBR_9600, short nData=8, float fStop=ONESTOPBIT, 
				short nParity=NOPARITY, BOOL bBinary = FALSE);
    ~CSerCom();									/* destructor			*/
	void ShowStatus ();
	void TextMode (char cEndOfSession);
	void BinMode ();
	void ProgressDlg(CWnd* ptWnd, FARPROC lpInit);
	void XonXoff (unsigned char uXon, unsigned char uXoff);
	BOOL IsAvailable(short nPort);
	BOOL OpenUSB(short nPort, short nInpLen, short nOutLen);
	BOOL Open(short nPort, short nInpLen, short nOutLen);
	BOOL SetBaudRate(short nBaud);
	BOOL Close ();
	BOOL WriteUSB (unsigned char* lpBuffer, long lBytes);
	void SetPacketSize(DWORD dwPacketSize) { m_dwPacketSize = dwPacketSize; }
	DWORD GetPacketSize() { return m_dwPacketSize; }

	BOOL Write (unsigned char* lpBuffer, long lBytes);
	short BytesInQueue (short nCnt);

	BOOL ReadUSB(short nReadMode, unsigned char* lpBuffer, DWORD dwMaxBytesToRead, DWORD* ptBytesRead);
	BOOL ReadUSB(unsigned char* lpBuffer, DWORD dwMaxBytesToRead, DWORD* ptBytesRead);
	BOOL ReadUSBFile(unsigned char* lpBuffer, DWORD dwMaxBytesToRead, DWORD* ptBytesRead);

	DWORD ReadComm (unsigned char* lpBuffer, DWORD dwBytesToRead);
	BOOL Read (unsigned char* lpBuffer, short nBytesToRead, long* ptRead);
	BOOL ReadBin (unsigned char* lpBuffer, short nBytesToRead, long* ptRead);
	BOOL ReadBytes (long* ptRead, unsigned char* szBinBuff, CFile* ptFile);
	BOOL WriteFromFile (CFile& SourceFile);
	BOOL ReadIntoFile (CFile& DestFile);
	SER_ERROR GetError () { return m_Error; }
	BOOL IsConnected() { return (m_hConnection != NULL); }

	static BOOL WaitForSignaledIOEvent (HANDLE hObject, CString* ptMsg, BOOL* ptCritical=FALSE);
	static BOOL WaitForSignaledEvent (HANDLE hObject, CString* ptMsg, BOOL* ptCritical=FALSE);
	static BOOL WaitForSignaledEvent (HANDLE hObject, CString* ptMsg, BOOL* ptCritical, short nWait_sec);
	static void ConvertBinToHex (unsigned char* szBin, long lBin, char* szHex, long* ptHexLen);
	static BOOL ErrorIDtoText (DWORD dwErr, CString* ptErr);


//protected: 					// in abgeleiteten Obj. verfgbar

#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

};

#endif
