/****************************************************************************
 *								 T i f f . c p p							*
 ****************************************************************************/										 
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "stdafx.h"
#include "tiff.h"


/****************************************************************************
 *	CTiffImage.cpp				C P i c t I m a g e				Constructor	*
 ****************************************************************************/
CTiffImage::CTiffImage ()
{
/* mac:
	m_lType 		= 'PICT';
	m_nROP			= srcCopy;
	m_dwLength 		= 0;
	m_hData  		= nil;
	m_nBitsPerPix    = 0;
	m_nNextRowOffs    = 0;
	m_hColTab		= nil;
*/


	m_szExt = "tif";
	m_dwROP = SRCCOPY;
	m_dwLength = 0L;
    m_nBits    = 0;
    m_lpBuf    = NULL;
	m_ptOldPal = NULL;

}


/************************************************************************
 *  CTiffImage.cpp 				D e s t r u c t o r 					*
 ************************************************************************/
CTiffImage::~CTiffImage()
{
	this->DestructImage();
}




/************************************************************************
 *  pict.cpp 				A l l o c a t e M e m o r y					*
 ************************************************************************/
BOOL CTiffImage::AllocateMemory(BOOL bRealloc) // bRealloc default = FALSE
{
if (bRealloc) 
	{  
	if (m_lpBuf != NULL)
		delete [] m_lpBuf;
    m_lpBuf = (LPSTR) new char [m_dwLength];
    }
else{
    m_lpBuf = (LPSTR) new char [m_dwLength];
    }

if (!m_lpBuf) 
	{
    AfxMessageBox("Unable to allocate DIB memory");
    m_dwLength = 0L;
    m_nBits = 0;
    return FALSE;
    }

return TRUE;
}


/************************************************************************
 *  pict.cpp 					R e a d									*
 *	Purpose: Reads a *.TIFF. pFile must be opened						*
 ************************************************************************/
BOOL CTiffImage::Read(CFile& file)
{
	BOOL bRead = FALSE;

	ASSERT(m_dwLength == 0L); 	// DIB must be empty
	m_dwLength = (DWORD)file.GetLength();
	if (!AllocateMemory())
		return FALSE;       

	DWORD dwCount = file.Read(m_lpBuf, m_dwLength);
	if (dwCount != m_dwLength) 
		{
		AfxMessageBox("Read error");
		return FALSE;
		}


return bRead;
}

/************************************************************************
 *  Tiff.cpp 				S e t C o l o r T a b l e					*
 *	Purpose: defines RGBQUAD array and number of palette entries		*
 ************************************************************************/
void CTiffImage::SetColorTable(short nEntries, RGBQUAD* ptRGBQuads)
{
}

/****************************************************************************
 *	Tiff.cpp					S e t S i z e								*
 ****************************************************************************/
void CTiffImage::SetSize (long lHeight, long lWidth, unsigned short wBitCount, long lFileRowBytes)
{
	//m_BMIH.biHeight = lHeight;
	//m_BMIH.biWidth  = lWidth;
	//m_BMIH.biBitCount = wBitCount;
	//m_nNextRowOffs = lFileRowBytes;
}

/****************************************************************************
 *	Tiff.cpp					S e t S i z e								*
 ****************************************************************************/
BOOL CTiffImage::GetSize(CSize* ptSize)
{
	BOOL bOK = FALSE;

	if (m_dwLength != 0L)
	{
	//	ptSize->cy = m_BMIH.biHeight;
	//	ptSize->cx = m_BMIH.biWidth;
	//	bOK = TRUE;
	}
	else
	{
		ptSize->cy = ptSize->cx = 0;
	}

	return bOK;
}

/****************************************************************************
 *	Tiff.cpp					S e t R e s o l u t i o n					*
 ****************************************************************************/
void CTiffImage::SetResolution (long lPixPerMeterX, long lPixPerMeterY)
{
//	m_BMIH.biXPelsPerMeter = lPixPerMeterX;
//	m_BMIH.biYPelsPerMeter = lPixPerMeterY;
}

/****************************************************************************
 *	Tiff.cpp					S e t D a t a P t r 	 	 	 	 	 	*
 ****************************************************************************/
void CTiffImage::SetDataPtr(LPSTR lpData)
{
/*	if (m_lpData != NULL)					// free old memory!!
	{
		delete [] m_lpData;
		m_lpData = NULL;
	}
	
	m_lpData = lpData;

  */
}


/************************************************************************
 *  Tiff.cpp 					G e n e r a t e							*
 *	Purpose: Reads a *.TIFF. pFile must be opened						*
 ************************************************************************/
BOOL CTiffImage::Generate()
{
	BOOL bRead = FALSE;



return bRead;
}

/****************************************************************************
 *	pict.cpp						I n f o F i l e							*
 ****************************************************************************/										 
BOOL CTiffImage::InfoFile (CString szFileTitle)
{
	BOOL bLength=FALSE;

	if (szFileTitle.GetLength() > 0)
	{
		CFile* ptFile = new CFile ();
		ptFile->Open(szFileTitle, CFile::modeCreate | CFile::modeNoInherit | CFile::modeWrite, NULL); 

	
		unsigned char* ptBuff = NULL;
		char szMsg[256];
		UINT	lDataSize;

		lDataSize = (UINT)szFileTitle.GetLength();		// title
		ptFile->Write((void*)(LPCTSTR)szFileTitle, lDataSize);

		lDataSize = (UINT)sprintf(szMsg,"\n\nWeitere Informationen:\n");	
		ptFile->Write((void*)szMsg, lDataSize);
		
		// add more information here...


		ptFile->Close();		/* Close destination file			*/
		bLength = TRUE;
		}

return (bLength);
}



/************************************************************************
 *  Dib.cpp 					D i s p l a y							*
 ************************************************************************/
BOOL CTiffImage::Display(CDC* pDC, CPoint origin)
{
    // direct to device--bypass the GDI bitmap
if (!m_lpBuf) 
	return FALSE; // nothing to display

/*
if (!::SetDIBitsToDevice(pDC->GetSafeHdc(), origin.x, origin.y,
       (DWORD) m_lpBMIH->biWidth, (DWORD) abs(m_lpBMIH->biHeight), 0, 0, 
	   (UINT)0,(UINT)abs(m_lpBMIH->biHeight), m_lpData, m_lpBMI,
       DIB_RGB_COLORS))  				// or: DIB_PAL_COLORS
	{
	DWORD dwErr = GetLastError();
	return FALSE;
    }
*/

return FALSE;
}


/************************************************************************
 *  Dib.cpp 					S t r e t c h							*
 ************************************************************************/
BOOL CTiffImage::Stretch(CDC* pDC, CPoint origin, CSize size)
{
   			 // direct to device--bypass the GDI bitmap
if (!m_lpBuf)
    return FALSE; // nothing to display

/*
WORD wSrcPixSizeY = (WORD)((m_lpBMIH->biHeight > 0)? m_lpBMIH->biHeight : -m_lpBMIH->biHeight); 

if (!::StretchDIBits(pDC->GetSafeHdc(), 
		origin.x, origin.y, size.cx, size.cy, 	   					// DestRect	LogUnits 			
		0, 0, (WORD) m_lpBMIH->biWidth, wSrcPixSizeY, 				// SourceRect Pixels  
		m_lpData, m_lpBMI, DIB_RGB_COLORS, m_dwROP)) 				// or: DIB_PAL_COLORS				 
 	{
	return FALSE;
    }
*/

return FALSE;
}

/************************************************************************
 *  CTiff.cpp 						W r i t e 							*
 ************************************************************************/
BOOL CTiffImage::Write(CFile& file)
{
TRY {
    file.Write(m_lpBuf, m_dwLength);
    }
CATCH (CException, e) 
	{
    AfxMessageBox("Write error--possible disk full condition");
    return FALSE;
    }
END_CATCH

return TRUE;
}


/************************************************************************
 *  Pict.cpp					D e s t r u c t I m a g e				*
 ************************************************************************/
void CTiffImage::DestructImage()
{
	if (m_lpBuf) 
	{						 // free the DIB memory
	delete [] m_lpBuf;
	m_lpBuf    = NULL;
    }
}