// TxVwTool.cpp : implementation of the CTextViewTool class
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "stdafx.h"
#include "TxVwTool.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern BOOL bMMText;

/////////////////////////////////////////////////////////////////////////////
// CTextViewTool

IMPLEMENT_DYNCREATE(CTextViewTool, CScrollView)

BEGIN_MESSAGE_MAP(CTextViewTool, CScrollView)
	//{{AFX_MSG_MAP(CTextViewTool)
	ON_WM_KEYDOWN()
	ON_WM_SIZE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CTextViewTool construction/destruction

/************************************************************************
 *  TxVwTool.cpp    		   CTextViewTool			Constructor		*
 ************************************************************************/
CTextViewTool::CTextViewTool()
{
m_sizeTotal.cx = 0;
m_sizeTotal.cy = 0;
m_bDraw = FALSE;
m_lfHeight = 0;

m_bMore = FALSE;
m_dX	= 0;
m_dY	= 0;
m_Ybottom	= 0;
m_bForPrinter = FALSE;
m_dwLinesPerPage = 0;
m_nPages = 0;

// m_FontName and m_wPointSize  defined in parent constructor!!
}

/************************************************************************
 *  TxVwTool.cpp    		   ~CTextViewTool			Destructor		*
 ************************************************************************/
CTextViewTool::~CTextViewTool()
{
}
                          
/************************************************************************
 *  TxVwTool.cpp   		 C o p y T o C l i p b o a r d					*
 ************************************************************************/
void CTextViewTool::CopyToClipboard()
{
CBitmap     cBmp;
CClientDC   cWndDC(this);   // View is an hWnd, so we can use "this"
CDC         cMemDC;         // Handle to a memory DC
CRect     rWndLP, rWndDP;   // For storing the size of the window

cMemDC.CreateCompatibleDC(&cWndDC); // Create the memory DC.

PrepareXTabs(&cMemDC);

rWndLP.SetRect (0,0,m_sizeTotal.cx, -m_sizeTotal.cy);
rWndDP = rWndLP;
cMemDC.LPtoDP (rWndDP);

if (cBmp.CreateCompatibleBitmap(&cMemDC, rWndDP.Width(),rWndDP.Height() ))
	{
					// Keep the old bitmap
	CBitmap* pOldBitmap = cMemDC.SelectObject(&cBmp);


							// to erase background
	CBrush backgroundBrush ((COLORREF) ::GetSysColor(COLOR_WINDOW));
	CBrush* pOldBrush = cMemDC.SelectObject (&backgroundBrush);
							// PatBlt erases background
	if (cMemDC.PatBlt (rWndLP.left, rWndLP.top, rWndLP.Width(), rWndLP.Height(), PATCOPY)!=0)
		{
		m_bDraw = TRUE;
		OnDraw (&cMemDC);   // draw contens of actual view
		}
	cMemDC.SelectObject (pOldBrush);

	// here are the actual clipboard functions.
	AfxGetApp()->m_pMainWnd->OpenClipboard() ;
	EmptyClipboard() ;
	SetClipboardData (CF_BITMAP, cBmp.GetSafeHandle() ) ;
	CloseClipboard () ;
		// next we select the old bitmap back into the memory DC
		// so that our bitmap is not deleted when cMemDC is destroyed.
		// Then we detach the bitmap handle from the cBmp object so that
		// the bitmap is not deleted when cBmp is destroyed.
	cMemDC.SelectObject(pOldBitmap);
	cBmp.Detach();
	}
}

/************************************************************************
 *  TxVwTool.cpp			G  e t D r a w S i z e		 				*
 *  Input: Size of bitmap, Size of available drawing area				*
 *  Output: drawing size, to fit into available area (ohne Verzerrung)	*
 ************************************************************************/
CSize CTextViewTool::GetDrawSize (CSize sTotalBitmap, CSize sOutputArea)
{
	CSize sVisibleBitmap = sTotalBitmap;
	return GetDrawSize(sTotalBitmap, sVisibleBitmap, sOutputArea);
}

/************************************************************************
 *  TxVwTool.cpp			G  e t D r a w S i z e		 				*
 *  Input: Size of bitmap, Size of available drawing area				*
 *  Output: drawing size, to fit into available area (ohne Verzerrung)	*
 ************************************************************************/
CSize CTextViewTool::GetDrawSize (CSize sTotalBitmap, CSize sVisibleBitmap, CSize sOutputArea)
{
	CSize sDraw;

	double dFaktX = (double)sOutputArea.cx / sVisibleBitmap.cx;
	double dFaktY = (double)sOutputArea.cy / sVisibleBitmap.cy;

	double dFakt = (dFaktX < dFaktY)? dFaktX : dFaktY;

	sDraw.cx = (int)(dFakt * sTotalBitmap.cx);
	sDraw.cy = (int)(dFakt * sTotalBitmap.cy);

	return sDraw;
}

			 
/************************************************************************
 *  TxVwTool.cpp			G e t E x p a n d e d S i z e				*
 *  Input: Size of bitmap, Size of available drawing area				*
 *  Output: drawing size, to fill available area (ohne Verzerrung)		*
 ************************************************************************/
CSize CTextViewTool::GetExpandedSize (CSize sBitmap, CSize sArea)
{
CSize sDraw;

double dFaktX = (double)sArea.cx / sBitmap.cx;
double dFaktY = (double)sArea.cy / sBitmap.cy;

double dFakt = (dFaktX >= dFaktY)? dFaktX : dFaktY;

sDraw.cx = (int)(dFakt * sBitmap.cx);
sDraw.cy = (int)(dFakt * sBitmap.cy);

return sDraw;
}


/************************************************************************
 *  TxVwTool.cpp   		  P r e C r e a t e W i n d o w					*
 ************************************************************************/
BOOL CTextViewTool::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CScrollView::PreCreateWindow(cs);
}


/************************************************************************
 *  TxVwTool.cpp			S e t S c r o l l S i z e					*
 ************************************************************************/
void CTextViewTool::SetScrollSize (CSize& sizeTotal)
{
CRect rView;
CClientDC dc (this);
dc.SetMapMode (MM_LOMETRIC);


this->GetClientRect (rView);				// get view size in LP
dc.DPtoLP((LPPOINT)&rView, 2);
int PageX = abs(rView.right - rView.left);
int PageY = abs(rView.bottom - rView.top);

CSize sizePage (PageX, PageY);
CSize sizeLine (sizePage.cx/10, 100);		// set line size
SetScrollSizes(MM_LOMETRIC, sizeTotal, sizePage, sizeLine);
}


/************************************************************************
 *  TxVwTool.cpp    		   S e t T o t a l H e i g h t				*
 ************************************************************************/
void CTextViewTool::SetTotalHeight (int nHeight)
{
int nAbsHeight = abs (nHeight);
//if (m_sizeTotal.cy < nAbsHeight)
	m_sizeTotal.cy = nAbsHeight;
}

/************************************************************************
 *  TxVwTool.cpp    		   S e t T o t a l W i d t h 				*
 ************************************************************************/
void CTextViewTool::SetTotalWidth (int nWidth)
{
//if (m_sizeTotal.cx < nWidth)
	m_sizeTotal.cx = nWidth;
}

/************************************************************************
 *  CourseVw.cpp   	G e t L e f t M a r g i n A n d C h a r X _ L P		*
 ************************************************************************/
void CTextViewTool::GetLeftMarginAndCharX_LP (WORD wPointSize, int* ptCharWidthLP)
{
m_LeftMargin = 130;		// 13 mm for MM_LOMETRIC
*ptCharWidthLP = (int)(12 * wPointSize/3);		// in LP
}

/************************************************************************
 *  TxVwTool.cpp    		  P r e p a r e X T a b s					*
 ************************************************************************/
void CTextViewTool::PrepareXTabs(CDC* pDC)
{                                
}

/************************************************************************
 *  TxVwTool.cpp    		  U p d a t e F o n t s						*
 ************************************************************************/
void CTextViewTool::UpdateFonts(CDC* pDC)
{                                
}

/************************************************************************
 *  TxVwTool.cpp    		   O n D r a w 								*
 ************************************************************************/
void CTextViewTool::OnDraw(CDC* pDC)
{                                
}

/************************************************************************
 *  TxVwTool.cpp				OnInitialUpdate							*
 *  Calls OnUpdate														*
 ************************************************************************/
void CTextViewTool::OnInitialUpdate()
{
	CScrollView::OnInitialUpdate();
	// TODO: calculate the total size of this view

//m_sizeTotal.cx = 100;
//m_sizeTotal.cy = 100;
//this->SetScrollSize (m_sizeTotal);
}


/************************************************************************
 *  TxVwTool.cpp    		   O n K e y D o w n						*
 ************************************************************************/
void CTextViewTool::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags)
{	
	// TODO: Add your message handler code here and/or call default
switch (nChar)
	{
	case VK_HOME:
		OnVScroll (SB_TOP, 0, NULL); 
		OnHScroll (SB_LEFT, 0, NULL);
		break;
	case VK_END:
		OnVScroll (SB_BOTTOM, 0, NULL);
		OnHScroll (SB_RIGHT, 0, NULL);
		break;
	case VK_UP:
		OnVScroll (SB_LINEUP, 0, NULL);
		break;
	case VK_DOWN:
		OnVScroll (SB_LINEDOWN, 0, NULL);
		break;
	case VK_PRIOR:
		OnVScroll (SB_PAGEUP, 0, NULL);
		break;
	case VK_NEXT:
		OnVScroll (SB_PAGEDOWN, 0, NULL);
		break;
	case VK_LEFT:
		OnHScroll (SB_LINELEFT, 0, NULL);
		break;
	case VK_RIGHT:
		OnHScroll (SB_LINERIGHT, 0, NULL);
		break;       
	default:
		break;
	}	
}


/************************************************************************
 *  TxVwTool.cpp    			 O n S i z e							*
 ************************************************************************/
void CTextViewTool::OnSize(UINT nType, int cx, int cy) 
{
	CScrollView::OnSize(nType, cx, cy);
	
	// TODO: Add your message handler code here
this->SetScrollSize (m_sizeTotal);
}


/************************************************************************
 *  TxVwTool.cpp    		   G e t T e x t P a r a m s				*
 ************************************************************************/
void CTextViewTool::GetTextParams (CDC* pDC, int* ptCharX, int* ptLineY)
{
TEXTMETRIC	tm;

pDC->GetTextMetrics (&tm);

*ptCharX = tm.tmAveCharWidth;
*ptLineY = tm.tmHeight + tm.tmExternalLeading;
}

/************************************************************************
 *  TxVwTool.c					G e t C h a r S i z e					*
 ************************************************************************/
void CTextViewTool::GetCharSize (CDC* pDC, CFont* ptNewFont, int* ptCapsX, int* ptLineY) 
{
TEXTMETRIC	tm;
CFont* ptOldFont;
//int	CharX;

ptOldFont = pDC->SelectObject (ptNewFont);
                  
pDC->GetTextMetrics (&tm);
//*ptCapsX = tm.tmAveCharWidth;
*ptCapsX = tm.tmMaxCharWidth;

if (bMMText)	*ptLineY = tm.tmHeight + tm.tmExternalLeading;
	else		*ptLineY = -(tm.tmHeight + tm.tmExternalLeading);

pDC->SelectObject (ptOldFont);
}

/************************************************************************
 *  TxVwTool.cpp		G e t L o g P i x T o U s e						*
 ************************************************************************/
void CTextViewTool::GetLogPixToUse (CDC* pDC, int* ptX, int* ptY)
{
POINT ptUseSize;
int   DevPixSize, DevPixLogInch, DevPixXtoUse, DevPixYtoUse;

DevPixSize  = pDC->GetDeviceCaps (HORZRES);
DevPixLogInch = pDC->GetDeviceCaps (LOGPIXELSX);
DevPixXtoUse   = DevPixSize; // - 1*DevPixLogInch;

DevPixSize  = pDC->GetDeviceCaps (VERTRES);
DevPixLogInch = pDC->GetDeviceCaps (LOGPIXELSY);
DevPixYtoUse   = DevPixSize - 1*DevPixLogInch;

ptUseSize.x = DevPixXtoUse;
ptUseSize.y = DevPixYtoUse;
pDC->DPtoLP ((LPPOINT)&ptUseSize, 1);
*ptX = abs (ptUseSize.x);
*ptY = abs (ptUseSize.y);
}

/************************************************************************
 *  TxVwTool.cpp			G e t M a x L i n e s						*
 ************************************************************************/
int CTextViewTool::GetMaxLines (CDC* pDC, int LineY)
{				    /* LineY: external leading + height	*/
int   MaxLines, LogPixXToUse, LogPixYToUse;

GetLogPixToUse(pDC, (int*)&LogPixXToUse, (int*)&LogPixYToUse);
MaxLines = LogPixYToUse / abs (LineY);

return MaxLines;
}          

/************************************************************************
 *  TxVwTool.cpp			G e t R i g h t P o s						*
 ************************************************************************/
int CTextViewTool::GetRightPos (CDC* pDC, int Xoffs, CString szText)
{
int	Xright;
CSize	TextSize;

TextSize = pDC->GetTextExtent (szText, szText.GetLength());
Xright = Xoffs + TextSize.cx;

return Xright;                      
}

/************************************************************************
 *  TxVwTool.cpp			G e t R i g h t P o s						*
 ************************************************************************/
int CTextViewTool::GetRightPos (CDC* pDC, int Xoffs, UINT nID)
{
int	Xright;
CString szText; 
CSize	TextSize;

szText.LoadString (nID);
TextSize = pDC->GetTextExtent (szText, szText.GetLength());
Xright = Xoffs + TextSize.cx;

return Xright;                      
}

/************************************************************************
 *  TxVwTool.cpp			Y _ P o i n t T o L P						*
 ************************************************************************/
short CTextViewTool::Y_PointToLP (CDC* pDC, WORD wPointSize)
{
short	yLogPixPerInch;
short	yDevicePixels;
POINT	LP;

//  H [mm] = H [pt] *  25.4/72 [mm/pt]
//  H [mm] = H [IN] * 25.4 [mm/IN]
//  DP = H [IN] * yLogPixPerInch

yLogPixPerInch = pDC->GetDeviceCaps (LOGPIXELSY);
yDevicePixels = (int)((double)wPointSize * yLogPixPerInch / 72);

LP.x = 0;
LP.y = yDevicePixels;
pDC->DPtoLP((LPPOINT) &LP, 1);
return (short)LP.y;
}

/************************************************************************
 *  TxVwTool.cpp    	    C r e a t e N e w F o n t					*
 ************************************************************************/
BOOL CTextViewTool::CreateNewFont (CFont* ptFont)
{    
BOOL	bOK = FALSE;
LOGFONT lfNewFont;

memset (&lfNewFont, 0, sizeof (LOGFONT));
lfNewFont.lfHeight = m_lfHeight;
lfNewFont.lfCharSet = DEFAULT_CHARSET;
strcpy (lfNewFont.lfFaceName, m_FontName);

bOK = ptFont->CreateFontIndirect ((LOGFONT FAR*)&lfNewFont);    
return bOK;
}



/************************************************************************
 *  TxVwTool.cpp    	    C r e a t e B o l d F o n t					*
 ************************************************************************/
BOOL CTextViewTool::CreateBoldFont (CFont* ptFont)
{    
BOOL	bOK = FALSE;
LOGFONT lfNewFont;

memset (&lfNewFont, 0, sizeof (LOGFONT));
lfNewFont.lfHeight = m_lfHeight;
lfNewFont.lfWeight = FW_BOLD;
lfNewFont.lfCharSet = DEFAULT_CHARSET;
strcpy (lfNewFont.lfFaceName, m_FontName);

bOK = ptFont->CreateFontIndirect ((LOGFONT FAR*)&lfNewFont);    
return bOK;
}

/************************************************************************
 *  TxVwTool.cpp    	    C r e a t e S p e c i a l F o n t			*
 ************************************************************************/
BOOL CTextViewTool::CreateSpecialFont (CFont* ptFont, char* szName, long lHeight, BOOL bBold)
{    
BOOL	bOK = FALSE;
LOGFONT lfNewFont;

memset (&lfNewFont, 0, sizeof (LOGFONT));
lfNewFont.lfHeight = lHeight;
if (bBold) lfNewFont.lfWeight = FW_BOLD;
lfNewFont.lfCharSet = DEFAULT_CHARSET;
strcpy (lfNewFont.lfFaceName, szName);

bOK = ptFont->CreateFontIndirect ((LOGFONT FAR*)&lfNewFont);    
return bOK;
}

/************************************************************************
 *  TxVwTool.cpp			C h o o s e F o n t 						*
 ************************************************************************/
void CTextViewTool::ChooseFont()
{
LOGFONT lfNewFont;
memset (&lfNewFont, 0, sizeof (LOGFONT));

CDC* pDC = GetDC();
lfNewFont.lfHeight = this->Y_PointToLP (pDC, m_wPointSize);
ReleaseDC(pDC);

lfNewFont.lfCharSet = DEFAULT_CHARSET;
strcpy (lfNewFont.lfFaceName, m_FontName);

CFontDialog FontDlg(&lfNewFont, CF_BOTH, NULL, this);
int RetVal = FontDlg.DoModal();	
switch (RetVal)
	{
	case IDOK:
	//	FontDlg.m_cf.lpLogFont;		//LPLOGFONT
		m_wPointSize = (WORD)FontDlg.m_cf.iPointSize/10;
		strcpy (m_FontName, lfNewFont.lfFaceName); 
		strcpy (m_FontName, FontDlg.m_cf.lpLogFont->lfFaceName); 
		this->InvalidateRect(NULL);
		break;
	case IDCANCEL:
		DWORD dwError = CommDlgExtendedError();
		break;
	}
}

/************************************************************************
 *  TxVwTool.cpp			S e t F o n t N a m e S i z e				*
 ************************************************************************/
void CTextViewTool::SetFontNameSize (char* szName, WORD wPointSize)
{
strcpy (m_FontName, szName);	 // max: LF_FACESIZE
m_wPointSize = wPointSize;
}

/************************************************************************
 *  TxVwTool.cpp			D r a w H o r z L i n e						*
 ************************************************************************/
short CTextViewTool::DrawHorzLine (CDC* pDC, int nY, int nX0, int nX1)
{
if (m_bDraw)
	{
	pDC->MoveTo (nX0, nY);
	pDC->LineTo (nX1+1, nY);
	}
return nY;
}

/************************************************************************
 *  TxVwTool.cpp			D r a w H o r z L i n e						*
 ************************************************************************/
short CTextViewTool::DrawHorzLine (CDC* pDC, int nY)
{
	return DrawHorzLine (pDC, nY, m_Xleft, m_Xright);
}

/************************************************************************
 *  TxVwTool.cpp			D r a w G r a y H o r z L i n e				*
 ************************************************************************/
short CTextViewTool::DrawGrayHorzLine (CDC* pDC, int nY, int nX0, int nX1)
{
if (m_bDraw)
	{
	CPen BlackDotPen (PS_DOT, 1, RGB (0, 0, 0));
	CPen* ptOldPen = (CPen*)pDC->SelectObject (&BlackDotPen);
	pDC->MoveTo (nX0, nY);
	pDC->LineTo (nX1+1, nY);
	pDC->SelectObject (ptOldPen);
	}
return nY;
}

/************************************************************************
 *  TxVwTool.cpp			D r a w G r a y H o r z L i n e				*
 ************************************************************************/
short CTextViewTool::DrawGrayHorzLine (CDC* pDC, int nY)
{
	return DrawGrayHorzLine (pDC, nY, m_Xleft, m_Xright);
}

/************************************************************************
 *  TxVwTool.cpp			D r a w V e r t L i n e s					*
 ************************************************************************/
void CTextViewTool::DrawVertLines (CDC* pDC, int nX0, int nX1, 
									int nTopY, int nBottomY) 
{
if (m_bDraw)
	{
	pDC->MoveTo (nX0, nTopY);
	pDC->LineTo (nX0, nBottomY);

	pDC->MoveTo (nX1, nTopY);
	pDC->LineTo (nX1, nBottomY);
	}
}

/************************************************************************
 *  TxVwTool.cpp				R e c t a n g l e						*
 ************************************************************************/
void CTextViewTool::Rectangle (CDC* pDC, CRect& rRect, COLORREF clr)
{
COLORREF cBackGrnd = pDC->GetBkColor();		// save actual background color

if (clr != 0x80000000)
  	pDC->FillSolidRect(rRect, clr);		    // changes actual background color !!!

pDC->SetBkColor(cBackGrnd);					// restores actual background color

this->Rectangle (pDC, rRect.left, rRect.top, rRect.right, rRect.bottom);
}

/************************************************************************
 *  TxVwTool.cpp				R e c t a n g l e						*
 ************************************************************************/
void CTextViewTool::Rectangle (CDC* pDC, int nLeft, int nTop, int nRight, int nBottom)
{
pDC->MoveTo (nLeft,  nTop);
pDC->LineTo (nRight, nTop);
pDC->LineTo (nRight, nBottom);
pDC->LineTo (nLeft,  nBottom);
pDC->LineTo (nLeft,  nTop);
}

/************************************************************************
 *  TxVwTool.cpp				F o r m a t								*
 ************************************************************************/
CString CTextViewTool::Format (short nID, ...)
{
CString szFormat;
char	szBuffer[256];   

szFormat.LoadString (nID);
va_list ptArgs;
va_start(ptArgs, nID);
short nLen = vsprintf (szBuffer, (LPCTSTR)szFormat, ptArgs);
va_end( ptArgs );

return (CString)szBuffer;
}

/************************************************************************
 *  TxVwTool.cpp			T e x t A l i g n L e f t					*
 ************************************************************************/
void CTextViewTool::TextAlignLeft (CDC* pDC, long lX, long lY, CString szText)
{ 
if (m_bDraw)
	{
	pDC->SetTextAlign (TA_LEFT | TA_TOP);
	pDC->TextOut (lX, lY, szText);
	}
}

/************************************************************************
 *  TxVwTool.cpp			T e x t A l i g n C e n t e r				*
 ************************************************************************/
void CTextViewTool::TextAlignCenter (CDC* pDC, long lX, long lY, CString szText)
{ 
if (m_bDraw)
	{
	pDC->SetTextAlign (TA_CENTER | TA_TOP);
	pDC->TextOut (lX, lY, szText);
	}
}

/************************************************************************
 *  TxVwTool.cpp			T e x t A l i g n R i g h t					*
 ************************************************************************/
void CTextViewTool::TextAlignRight (CDC* pDC, long lX, long lY, CString szText)
{ 
if (m_bDraw)
	{
	pDC->SetTextAlign (TA_RIGHT | TA_TOP);
	pDC->TextOut (lX, lY, szText);
	}
}

/************************************************************************
 *  TxVwTool.cpp			R s r c A l i g n L e f t					*
 ************************************************************************/
void CTextViewTool::RsrcAlignLeft (CDC* pDC, long lX, long lY, short nID)
{
CString szText;
szText.LoadString (nID);
TextAlignLeft (pDC, lX, lY, szText);
}

/************************************************************************
 *  TxVwTool.cpp			R s r c A l i g n C e n t e r				*
 ************************************************************************/
void CTextViewTool::RsrcAlignCenter (CDC* pDC, long lX, long lY, short nID)
{
CString szText;
szText.LoadString (nID);
TextAlignCenter (pDC, lX, lY, szText);
}

/************************************************************************
 *  TxVwTool.cpp			R s r c A l i g n R i g h t					*
 ************************************************************************/
void CTextViewTool::RsrcAlignRight (CDC* pDC, long lX, long lY, short nID)
{
CString szText;
szText.LoadString (nID);
TextAlignRight (pDC, lX, lY, szText);
}

/************************************************************************
 *  TxVwTool.cpp			R s r c A l i g n L e f t E x				*
 ************************************************************************/
void CTextViewTool::RsrcAlignLeftEx (CDC* pDC, long lX, long lY, short nID, ...)
{
CString szFormat;
char	szBuffer[256];   

szFormat.LoadString (nID);
//char szVal[32];
va_list ptArgs;
va_start(ptArgs, nID);
//strcpy (szVal, (char*)va_arg( ptArgs, char* ));
short nLen = vsprintf (szBuffer, (LPCTSTR)szFormat, ptArgs);
va_end( ptArgs );

if (m_bDraw)
	{
	pDC->SetTextAlign (TA_LEFT | TA_TOP);
	pDC->TextOut (lX, lY, szBuffer, nLen);
	}
}


/************************************************************************
 *  TxVwTool.cpp			R s r c A l i g n C e n t e r E x			*
 ************************************************************************/
void CTextViewTool::RsrcAlignCenterEx (CDC* pDC, long lX, long lY, short nID, ...)
{
CString szFormat;
char	szBuffer[256];   

szFormat.LoadString (nID);

va_list ptArgs;
va_start(ptArgs, nID);
short nLen = vsprintf (szBuffer, (LPCTSTR)szFormat, ptArgs);
va_end( ptArgs );

if (m_bDraw)
	{
	pDC->SetTextAlign (TA_CENTER | TA_TOP);
	pDC->TextOut (lX, lY, szBuffer, nLen);
	}
}

/************************************************************************
 *  TxVwTool.cpp			R s r c A l i g n R i g h t E x				*
 ************************************************************************/
void CTextViewTool::RsrcAlignRightEx (CDC* pDC, long lX, long lY, short nID, ...)
{
CString szFormat;
char	szBuffer[256];   

szFormat.LoadString (nID);

va_list ptArgs;
va_start(ptArgs, nID);
short nLen = vsprintf (szBuffer, (LPCTSTR)szFormat, ptArgs);
va_end( ptArgs );

if (m_bDraw)
	{
	pDC->SetTextAlign (TA_RIGHT | TA_TOP);
	pDC->TextOut (lX, lY, szBuffer, nLen);
	}
}

  