#ifndef __TXVWTOOL__
#define __TXVWTOOL__ 
   
/************************************************************************
 *  				 		T x V w T o o l . h							*
 ************************************************************************/
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

									// font size in logical coords
#define POINT_SIZE_5	-20
#define POINT_SIZE_8	-26
#define POINT_SIZE_10	-34
#define POINT_SIZE_12	-41
#define POINT_SIZE_14	-48
#define POINT_SIZE_18	-62

class CTextViewTool : public CScrollView
{                          
protected:
	BOOL	m_bForPrinter;
	BOOL	m_bDraw;
	CSize	m_sizeTotal;				// for SetScrollSizes


	BOOL	m_bMore;
	DWORD 	m_dwLinesPerPage;
    UINT	m_nPages;
      
	int		m_LeftMargin;
    int		m_dX, m_dY;
	int		m_Xleft, m_Xright; 
	int		m_Ybottom;
                          				// font handling
    WORD	m_wPointSize; 
	TCHAR	m_FontName[LF_FACESIZE]; 
	int		m_lfHeight;
           
                
	DECLARE_DYNCREATE(CTextViewTool)

// Attributes
public:
	CTextViewTool();
	virtual ~CTextViewTool();

	void CopyToClipboard();
	static CSize GetDrawSize (CSize sTotalBitmap, CSize sOutputArea);
	static CSize GetDrawSize (CSize sTotalBitmap, CSize sVisibleBitmap, CSize sOutputArea);
	static CSize GetExpandedSize (CSize sBitmap, CSize sArea);

	void SetScrollSize (CSize& sizeTotal);
	void SetTotalHeight (int nHeight);
	void SetTotalWidth (int nWidth);

	void GetTextParams (CDC* pDC, int* ptCharX, int* ptLineY);   
	void GetCharSize (CDC* pDC, CFont* ptNewFont, int* ptCapsX, int* ptLineY); 
 	void GetLogPixToUse (CDC* pDC, int* ptX, int* ptY);
	int GetMaxLines (CDC* pDC, int LineY);              
	int GetRightPos (CDC* pDC, int Xoffs, CString szText);
	int GetRightPos (CDC* pDC, int Xoffs, UINT nID);
    short Y_PointToLP (CDC* pDC, WORD wPointSize);
	BOOL CreateNewFont (CFont* ptFont);
	BOOL CreateBoldFont (CFont* ptFont);
	BOOL CreateSpecialFont (CFont* ptFont, char* szName, long lHeight, BOOL bBold);

	void ChooseFont();      
	void SetFontNameSize (char* szName, WORD wPointSize);

	void ActivateDrawing (BOOL bDraw) { m_bDraw = bDraw; }

	short DrawHorzLine (CDC* pDC, int nY, int nX0, int nX1);
	short DrawHorzLine (CDC* pDC, int nY);
	short DrawGrayHorzLine (CDC* pDC, int nY, int nX0, int nX1);
	short DrawGrayHorzLine (CDC* pDC, int nY);
	void DrawVertLines (CDC* pDC, int nX0, int nX1, 
							int nTopY, int nBottomY); 

	void Rectangle (CDC* pDC, CRect& rRect, COLORREF clr=0x80000000);
	void Rectangle (CDC* pDC, int nLeft, int nTop, int nRight, int nBottom);

	static CString Format (short nID, ...);
	void TextAlignLeft (CDC* pDC, long lX, long lY, CString szText);
	void TextAlignCenter (CDC* pDC, long lX, long lY, CString szText);
	void TextAlignRight (CDC* pDC, long lX, long lY, CString szText);

	void RsrcAlignLeft (CDC* pDC, long lX, long lY, short nID);
	void RsrcAlignCenter (CDC* pDC, long lX, long lY, short nID);
	void RsrcAlignRight (CDC* pDC, long lX, long lY, short nID);

	void RsrcAlignLeftEx (CDC* pDC, long lX, long lY, short nID, ...);
	void RsrcAlignCenterEx (CDC* pDC, long lX, long lY, short nID, ...);
	void RsrcAlignRightEx (CDC* pDC, long lX, long lY, short nID, ...);

	void SetLeftLP (int nLeft) { m_Xleft = nLeft; }
	void SetRightLP (int nRight) { m_Xright = nRight; }
	void GetLeftMarginAndCharX_LP (WORD wPointSize, int* ptCharWidthLP);

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CMusterView)
	public:
	virtual void PrepareXTabs (CDC* pDC);
	virtual void UpdateFonts (CDC* pDC);
	virtual void OnDraw(CDC* pDC);  // overridden to draw this view
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	protected:
	virtual void OnInitialUpdate();			// called first time after construct
	//}}AFX_VIRTUAL



// Generated message map functions
protected:
	//{{AFX_MSG(CTextViewTool)
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnSize(UINT nType, int cx, int cy);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

#endif
