/************************************************************************
 *  						U s b . c p p								*
 ************************************************************************/
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "stdafx.h"
#include "Usb.h"


#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CUsb


/************************************************************************
 *  Usb.cpp						C U s b									*
 ************************************************************************/
CUsb::CUsb()
{ 
	m_szError		= "";
}


/************************************************************************
 *  Usb.cpp					~ C U s b									*
 ************************************************************************/
CUsb::~CUsb()
{
	this->DeleteArrayOf (&m_Devices);

} 

/************************************************************************
 *  Usb.cpp				D e l e t e A r r a y O f 						*
 ************************************************************************/
void CUsb::DeleteArrayOf (CPtrArray* ptArray)
{
	int i, nEntryCnt;	
												
	nEntryCnt = ptArray->GetSize();
	for (i=0; i<nEntryCnt; i++)
	{
		CUsbDevice* ptEntry;
		if ((ptEntry = (CUsbDevice*)ptArray->GetAt(i)) != NULL)
		{
			delete ptEntry;				// delete original element
		}
	}
	ptArray->RemoveAll();
}          

/************************************************************************
 *  Usb.cpp					C h e c k E r r o r							*
 ************************************************************************/
void CUsb::CheckError(DWORD dwError)
{
	if( dwError != 0 )
	{
		char msg[256];
		FormatMessage( FORMAT_MESSAGE_FROM_SYSTEM, NULL, dwError, 0, msg, 256, NULL );
		m_szError = msg;
	}
}


/********************************************************************************************
 *	Usb.cpp							H e x S t r i n g T o B y t e							*
 ********************************************************************************************/
BYTE CUsb::HexStringToByte(CString szHexByte)
{
	BYTE byte=0;

	short nTemp=0;
	sscanf ((LPCTSTR)szHexByte, "%hx", &nTemp);
	byte = (BYTE)nTemp;
	return byte;
}

/********************************************************************************************
 *	Usb.cpp								G e t H i d G u i d									*
 ********************************************************************************************/
void CUsb::GetHidGuid(CString szGuid, GUID* ptGuid)
{
								//0123456789012345678901234567890123456789
	if (szGuid.GetLength() == 38)
	{						//{6bdd1fc6-810f-11d0-bec7-08002be2092f}
		short nFirst = 1;
		short nCount = 8;
		CString szData1(szGuid.Mid(nFirst, nCount));	// 6bdd1fc6

		nFirst = 10;
		nCount = 4;
		CString szData2(szGuid.Mid(nFirst, nCount));	// 810f
	
		nFirst = 15;
		nCount = 4;
		CString szData3(szGuid.Mid(nFirst, nCount));	// 11d0

		sscanf ((LPCTSTR)szData1, "%lx", &ptGuid->Data1);		// DWORD
		sscanf ((LPCTSTR)szData2, "%hx", &ptGuid->Data2);		// WORD
		sscanf ((LPCTSTR)szData3, "%hx", &ptGuid->Data3);		// WORD


		nFirst = 20;
		nCount = 2;
		ptGuid->Data4[0] = CUsb::HexStringToByte(szGuid.Mid(nFirst, nCount));// be
		nFirst = 22;
		ptGuid->Data4[1] = CUsb::HexStringToByte(szGuid.Mid(nFirst, nCount));// c7

		int nData4Index = 2;
		for (nFirst = 25; nFirst < 37; nFirst+=2)	// last nFirst = 35
		{											// 08002be2092f
			ptGuid->Data4[nData4Index++] = CUsb::HexStringToByte(szGuid.Mid(nFirst, nCount));
		}
	}

	// {A12A4C5A-E1A3-4151-9927-7F724CA5DC92}
/*		ptGuid->Data1 = 0xA12A4C5A;		// DWORD
	ptGuid->Data2 = 0xE1A3;			// WORD
	ptGuid->Data3 = 0x4151;			// WORD

	ptGuid->Data4[0] = 0x99;		// BYTE
	ptGuid->Data4[1] = 0x27;

	ptGuid->Data4[2] = 0x7F;
	ptGuid->Data4[3] = 0x72;
	ptGuid->Data4[4] = 0x4C;
	ptGuid->Data4[5] = 0xA5;
	ptGuid->Data4[6] = 0xDC;
	ptGuid->Data4[7] = 0x92;
*/
}


/************************************************************************
 *  Usb.cpp				G e t W i n d o w s V e r s i o n				*
 ************************************************************************/
long CUsb::GetWindowsVersion(CString* ptVersion)
{
	OSVERSIONINFO versInf;
	memset(&versInf, 0, sizeof(OSVERSIONINFO));
	versInf.dwOSVersionInfoSize = sizeof(OSVERSIONINFO);

	::GetVersionEx(&versInf);

    long lMajorVersion = versInf.dwMajorVersion;
	long lMinorVersion = versInf.dwMinorVersion;
	long lPlatformID = versInf.dwPlatformId;

	if (ptVersion != NULL)
	{
		switch(lMajorVersion)
		{
		case 6:
				*ptVersion = "Major=6";
				break;
		case 5: 
				*ptVersion = "Windows 2000";
				break;
		case 4: 
	//		#define VER_PLATFORM_WIN32s             0
	//		#define VER_PLATFORM_WIN32_WINDOWS      1
	//		#define VER_PLATFORM_WIN32_NT           2

				if (lPlatformID == VER_PLATFORM_WIN32_NT) 
					*ptVersion = "Windows NT 4.0"; 
				else 
					if (lMinorVersion == 0)
						*ptVersion = "Windows 95";
					if (lMinorVersion == 90)
						*ptVersion = "Windows ME";
					
				break;
		case 3: 
				if (lPlatformID == VER_PLATFORM_WIN32_NT) 
					*ptVersion = "Windows NT 3.x";
				else 
					*ptVersion = "Windows 3.x";
				break;
		default: 
				*ptVersion = "Unknown Windows Version"; 
				break;
		}
	}
    
	return lMajorVersion;
}

/************************************************************************
 *  Usb.cpp				E n u m I n t e r f a c e D e v i c e s			*
 ************************************************************************/
short CUsb::EnumInterfaceDevices(CString szInterfaceClassGuid)
{
	struct _GUID ClassGuid;
	int nMemberIndex;
	BOOL bSuccess;
    HDEVINFO hDeviceInfoSet;

	BOOL bMoreItems;

	if (szInterfaceClassGuid.GetLength() == 0)
		szInterfaceClassGuid = "{a5dcbf10-6530-11d2-901f-00c04fb951ed}";

	GetHidGuid(szInterfaceClassGuid, &ClassGuid);

							// enumerator of SetupDiGetClassDevs depends on windows version!!
	CString szVersion;
	long lMajorVers = this->GetWindowsVersion(&szVersion);
	char szEnumerator[32];
	strcpy(szEnumerator, "USB");	// PCTSTR enumerator: "USB" for Win ME, NULL for Win XP

	char* ptEnum1 = NULL;			// ptEnum1: param for first attempt
	char* ptEnum2 = szEnumerator;	// ptEnum2: param for second attempt, if first fails

	if (lMajorVers <= 4)
	{
		ptEnum1 = szEnumerator;		// ptEnum1: param for first attempt
		ptEnum2 = NULL;				// ptEnum2: param for second attempt, if first fails
	}
							/*		#define DIGCF_PRESENT           0x00000002
									#define DIGCF_ALLCLASSES        0x00000004
									#define DIGCF_PROFILE           0x00000008
									#define DIGCF_DEVICEINTERFACE   0x00000010
							*/

							// first attempt:
	DWORD dwMode = DIGCF_PRESENT | DIGCF_DEVICEINTERFACE;		// if dwMode sets DIGCF_DEVICEINTERFACE: 
	hDeviceInfoSet = SetupDiGetClassDevs(&ClassGuid,			// GUID of an interface class
							ptEnum1,	// PCTSTR enumerator
							NULL,		// hwndParent
							dwMode);	// flags

    if (hDeviceInfoSet == INVALID_HANDLE_VALUE )
	{						// second attempt:
		hDeviceInfoSet = SetupDiGetClassDevs(&ClassGuid,			// GUID of an interface class
							ptEnum2,	// PCTSTR enumerator
							NULL,		// hwndParent
							dwMode);	// flags
	}

    if (hDeviceInfoSet != INVALID_HANDLE_VALUE )
	{	

		bMoreItems = TRUE;
		nMemberIndex = 0;

		do
		{
			SP_DEVICE_INTERFACE_DATA DeviceInterfaceData;

										 // Length of data structure in bytes
			memset (&DeviceInterfaceData, 0, sizeof(SP_DEVICE_INTERFACE_DATA));
			DeviceInterfaceData.cbSize = sizeof(DeviceInterfaceData);
		
								// Is there a HID device at this table entry
			bSuccess = SetupDiEnumInterfaceDevice(hDeviceInfoSet, // returned by SetupDiGetClassVev
						NULL,				// DeviceInfoData, to constrain the search 
						(LPGUID)&ClassGuid,	// to specify device interface class for requested interface
						nMemberIndex, 
						&DeviceInterfaceData);	// pointer to receive info for the device interface
			if (bSuccess) 
			{
				DWORD needed;			// get the required length
				SetupDiGetDeviceInterfaceDetail(hDeviceInfoSet,
						&DeviceInterfaceData,	// created from SetupDiEnumInterfaceDevice
						NULL, 0,		// no device interface detail data pointer !!
						&needed,		// required size includes fix part of struct
						NULL);





				PSP_DEVICE_INTERFACE_DETAIL_DATA ptDetail =
					(PSP_DEVICE_INTERFACE_DETAIL_DATA)malloc(needed);
				if (ptDetail != NULL)
				{						// good data for detail info
					memset (ptDetail, 0, sizeof(SP_DEVICE_INTERFACE_DETAIL_DATA));
										// cbSize for fix part of struct only
					ptDetail->cbSize = sizeof(SP_DEVICE_INTERFACE_DETAIL_DATA);


					SP_DEVINFO_DATA  devinfo;
					devinfo.cbSize = sizeof(devinfo);


					/*
					SetupDiGetDeviceInterfaceDetailA(
						IN  HDEVINFO                           DeviceInfoSet,
						IN  PSP_DEVICE_INTERFACE_DATA          DeviceInterfaceData,
						OUT PSP_DEVICE_INTERFACE_DETAIL_DATA_A DeviceInterfaceDetailData,     OPTIONAL
						IN  DWORD                              DeviceInterfaceDetailDataSize,
						OUT PDWORD                             RequiredSize,                  OPTIONAL
						OUT PSP_DEVINFO_DATA                   DeviceInfoData                 OPTIONAL
						);
					*/

					
					bSuccess = SetupDiGetDeviceInterfaceDetail(hDeviceInfoSet, &DeviceInterfaceData, 
						ptDetail, needed, 
						NULL,			// no pointer to get required size (already known)
						&devinfo);		// pointer for SP_DEVINFO_DATA
					if (bSuccess) 
					{	

						CUsbDevice* ptDevice = new CUsbDevice();
						if (ptDevice != NULL)
						{
							ptDevice->SetProperties(hDeviceInfoSet,&devinfo);
							ptDevice->SetDevicePath(ptDetail->DevicePath);
						
							m_Devices.Add(ptDevice);
						}
					}
					else
					{
						DWORD errCode = GetLastError(); 
					    CheckError(errCode);	
					}


					free((LPVOID) ptDetail);
				}	// ptDetail
				else
				{	// bad ptDetail
					AfxMessageBox ("Bad ptDetail pointer");
				}
			} // if (SetupDiEnumInterfaceDevice . .
			else
			{		// bad SetupDiEnumInterfaceDevice
				DWORD dwError = GetLastError();

				bMoreItems = (dwError != ERROR_NO_MORE_ITEMS);
				if (!bMoreItems)
					CheckError(dwError);
			}
			nMemberIndex++;
		} while (bMoreItems);

		SetupDiDestroyDeviceInfoList(hDeviceInfoSet);
	}
	else
	{			// bad hDeviceInfoSet
		DWORD dwError = GetLastError();
		CheckError(dwError);
	}

    return m_Devices.GetSize();
}

/************************************************************************
 *  Usb.cpp					G e t D e v i c e C n t						*
 ************************************************************************/
short CUsb::GetDeviceCnt()
{
	return m_Devices.GetSize();
}

/************************************************************************
 *  Usb.cpp				G e t D e v i c e P t r							*
 ************************************************************************/
CUsbDevice* CUsb::GetDevicePtr(short nIndex)
{
	CUsbDevice* ptData = NULL;

	if (nIndex >= 0 && nIndex < m_Devices.GetSize())
	{
		ptData = (CUsbDevice*)m_Devices.GetAt(nIndex);
	}
	return ptData;
}


