#ifndef __USB__      
#define __USB__

// Usb.h
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "UsbDevice.h"

#include <winioctl.h>


#define IOCTL_ASYNC_IN        CTL_CODE (FILE_DEVICE_UNKNOWN, 0x850, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_USB_PACKET_SIZE CTL_CODE (FILE_DEVICE_UNKNOWN, 0x851, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define MAX_BUFFER_SIZE 4096
#define ASYNC_DATA_SIZE 64


class CUsb : public CObject
{

// Attributes
private:    
	CPtrArray	m_Devices;
	CString		m_szError;

// Implementation
public:
	CUsb();		
	~CUsb();        

	void DeleteArrayOf (CPtrArray* ptArray);
	void CheckError(DWORD dwError);
	static BYTE HexStringToByte(CString szHexByte);
	static void GetHidGuid(CString szGuid, GUID* ptGuid);

	short EnumInterfaceDevices(CString szInterfaceClassGuid="");
	short GetDeviceCnt();
	CUsbDevice* GetDevicePtr(short nIndex);

	void SetError(CString szError) { m_szError = szError; }
	CString GetError() { return m_szError; }

private:
	long GetWindowsVersion(CString* ptVersion=NULL);


};
#endif 

