/************************************************************************
 *  					U s b D e v i c e . c p p	  					*
 ************************************************************************/
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "stdafx.h"
#include "UsbDevice.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CUsbDevice


/************************************************************************
 *  UsbDevice.cpp			CUsbDevice									*
 ************************************************************************/
CUsbDevice::CUsbDevice()
{ 
	m_szDeviceID = "";		
	m_lState=0;			
	m_lProblem=0;			
	m_szService = "";		
	m_lCapabilities=0;	
	m_lConfigFlags=0;		
	m_szDevNode = "";
	m_szClass = "";			
	m_szInfFile = "";
	m_szManufacturer = "";	
	m_szHardwareID = "";		
	m_szCompatibleIDs = "";	
	m_szClassGuid = "";		
	m_szLocation = "";		
	m_lBusNumber=0;		
	m_szEnumeratorName = "";	
	m_szDescription = "";	
	m_szFriendlyName = "";	
	m_szDriver = "";			
	m_szPhysicalObjectName = "";
	m_lUINumber=0;		
	m_szUpperFilters = "";
	m_szLowerFilters = "";
	m_szBusTypeGUID = "";
	m_lLegacyBusType=0;	

	m_szDevicePath = "";
}

/************************************************************************
 *  UsbDevice.cpp			CUsbDevice							*
 ************************************************************************/
CUsbDevice::CUsbDevice(const CUsbDevice& Source)
{ 
	m_szDeviceID			= Source.m_szDeviceID;		
	m_lState				= Source.m_lState;			
	m_lProblem				= Source.m_lProblem;			
	m_szService				= Source.m_szService;		
	m_lCapabilities			= Source.m_lCapabilities;	
	m_lConfigFlags			= Source.m_lConfigFlags;		
	m_szDevNode				= Source.m_szDevNode;
	m_szClass				= Source.m_szClass;			
	m_szInfFile				= Source.m_szInfFile;
	m_szManufacturer		= Source.m_szManufacturer;	
	m_szHardwareID			= Source.m_szHardwareID;		
	m_szCompatibleIDs		= Source.m_szCompatibleIDs;	
	m_szClassGuid			= Source.m_szClassGuid;		
	m_szLocation			= Source.m_szLocation;		
	m_lBusNumber			= Source.m_lBusNumber;		
	m_szEnumeratorName		= Source.m_szEnumeratorName;	
	m_szDescription			= Source.m_szDescription;	
	m_szFriendlyName		= Source.m_szFriendlyName;	
	m_szDriver				= Source.m_szDriver;			
	m_szPhysicalObjectName	= Source.m_szPhysicalObjectName;
	m_lUINumber				= Source.m_lUINumber;		
	m_szUpperFilters		= Source.m_szUpperFilters;
	m_szLowerFilters		= Source.m_szLowerFilters;
	m_szBusTypeGUID			= Source.m_szBusTypeGUID;
	m_lLegacyBusType		= Source.m_lLegacyBusType;
	m_szDevicePath			= Source.m_szDevicePath;
}

/************************************************************************
 *  UsbDevice.cpp			CUsbDevice							*
 ************************************************************************/
CUsbDevice::CUsbDevice(CString szDescription, CString szClassGuid, CString szFriendlyName)
{ 
	m_szDescription = szDescription;
	m_szClassGuid	= szClassGuid;
	m_szFriendlyName= szFriendlyName;
}



/************************************************************************
 *  UsbDevice.cpp			~CUsbDevice							*
 ************************************************************************/
CUsbDevice::~CUsbDevice()
{
} 

/************************************************************************
 *  UsbDevice.cpp				operator=							*
 ************************************************************************/
const CUsbDevice& CUsbDevice::operator=(const CUsbDevice& Source)
{

	m_szDeviceID			= Source.m_szDeviceID;		
	m_lState				= Source.m_lState;			
	m_lProblem				= Source.m_lProblem;			
	m_szService				= Source.m_szService;		
	m_lCapabilities			= Source.m_lCapabilities;	
	m_lConfigFlags			= Source.m_lConfigFlags;		
	m_szDevNode				= Source.m_szDevNode;
	m_szClass				= Source.m_szClass;			
	m_szInfFile				= Source.m_szInfFile;
	m_szManufacturer		= Source.m_szManufacturer;	
	m_szHardwareID			= Source.m_szHardwareID;		
	m_szCompatibleIDs		= Source.m_szCompatibleIDs;	
	m_szClassGuid			= Source.m_szClassGuid;		
	m_szLocation			= Source.m_szLocation;		
	m_lBusNumber			= Source.m_lBusNumber;		
	m_szEnumeratorName		= Source.m_szEnumeratorName;	
	m_szDescription			= Source.m_szDescription;	
	m_szFriendlyName		= Source.m_szFriendlyName;	
	m_szDriver				= Source.m_szDriver;			
	m_szPhysicalObjectName	= Source.m_szPhysicalObjectName;
	m_lUINumber				= Source.m_lUINumber;		
	m_szUpperFilters		= Source.m_szUpperFilters;
	m_szLowerFilters		= Source.m_szLowerFilters;
	m_szBusTypeGUID			= Source.m_szBusTypeGUID;
	m_lLegacyBusType		= Source.m_lLegacyBusType;	

	m_szDevicePath			= Source.m_szDevicePath;

	return *this;
}

	void CUsbDevice::CheckError(DWORD dwError)
	{
	  if( dwError != 0 )
	  {
		char msg[256];
		FormatMessage( FORMAT_MESSAGE_FROM_SYSTEM, NULL, dwError, 0, msg, 256, NULL );
		AfxMessageBox(msg);
	  }

	}

	void CUsbDevice::CheckWin32Error()
	{
	  DWORD errCode = GetLastError(); 
	  CheckError(errCode);
	}



/************************************************************************
 *  UsbDevice.cpp				B u f f e r T o L o n g					*
 ************************************************************************/
long CUsbDevice::BufferToLong(const char* ptBuff, int bufferSize)
{
	long lValue= 0;

	for (int i=0; i<bufferSize; i++)
	{
		unsigned char ch = (unsigned char)*(ptBuff+i);
		if (ch != 0)
		{
			lValue = (lValue << 8);
			lValue += (int)ch;
		}
	}
	return lValue;
}

/********************************************************************************************
 *									S e t P r o p e r t i e s								*
 ********************************************************************************************/
void CUsbDevice::SetProperties(HDEVINFO hDeviceInfoSet, PSP_DEVINFO_DATA ptDevInfo)
{
	BYTE    ByteBuffer[200];
	DWORD    BufferSize = 0;
	DWORD    DataType;

	if (SetupDiGetDeviceRegistryProperty(hDeviceInfoSet,ptDevInfo,SPDRP_DEVICEDESC, 
		&DataType, ByteBuffer,sizeof(ByteBuffer),&BufferSize))
	{
		this->SetDescription ((const char *) ByteBuffer);
	}

	if (SetupDiGetDeviceRegistryProperty(hDeviceInfoSet,ptDevInfo,SPDRP_HARDWAREID, 
		&DataType, ByteBuffer,sizeof(ByteBuffer),&BufferSize))
	{
		this->SetHardwareID ((const char *) ByteBuffer);
	}

	if (SetupDiGetDeviceRegistryProperty(hDeviceInfoSet,ptDevInfo,SPDRP_COMPATIBLEIDS, 
		&DataType, ByteBuffer,sizeof(ByteBuffer),&BufferSize))
	{
		this->SetCompatibleIDs ((const char *) ByteBuffer);
	}

	if (SetupDiGetDeviceRegistryProperty(hDeviceInfoSet,ptDevInfo,SPDRP_SERVICE, 
		&DataType, ByteBuffer,sizeof(ByteBuffer),&BufferSize))
	{
		this->SetService ((const char *) ByteBuffer);
	}

	if (SetupDiGetDeviceRegistryProperty(hDeviceInfoSet,ptDevInfo,SPDRP_CONFIGURATION, 
		&DataType, ByteBuffer,sizeof(ByteBuffer),&BufferSize))
	{
// ???
	}

	if (SetupDiGetDeviceRegistryProperty(hDeviceInfoSet,ptDevInfo,SPDRP_CONFIGURATIONVECTOR, 
		&DataType, ByteBuffer,sizeof(ByteBuffer),&BufferSize))
	{
// ???
	}

	if (SetupDiGetDeviceRegistryProperty(hDeviceInfoSet,ptDevInfo,SPDRP_CLASS, 
		&DataType, ByteBuffer,sizeof(ByteBuffer),&BufferSize))
	{
		this->SetClass ((const char *) ByteBuffer);
	}

	if (SetupDiGetDeviceRegistryProperty(hDeviceInfoSet,ptDevInfo,SPDRP_CLASSGUID, 
		&DataType, ByteBuffer,sizeof(ByteBuffer),&BufferSize))
	{
		this->SetClassGuid((const char *) ByteBuffer);
	}

	if (SetupDiGetDeviceRegistryProperty(hDeviceInfoSet,ptDevInfo,SPDRP_DRIVER, 
		&DataType, ByteBuffer,sizeof(ByteBuffer),&BufferSize))
	{
		this->SetDriver((const char *) ByteBuffer);
	}

	if (SetupDiGetDeviceRegistryProperty(hDeviceInfoSet,ptDevInfo,SPDRP_CONFIGFLAGS, 
		&DataType, ByteBuffer,sizeof(ByteBuffer),&BufferSize))
	{
		long lValue = BufferToLong((const char *)ByteBuffer, BufferSize);
		this->SetConfigFlags(lValue);
	}

	if (SetupDiGetDeviceRegistryProperty(hDeviceInfoSet,ptDevInfo,SPDRP_MFG, 
		&DataType, ByteBuffer,sizeof(ByteBuffer),&BufferSize))
	{
		this->SetManufacturer((const char *) ByteBuffer);
	}

	if (SetupDiGetDeviceRegistryProperty(hDeviceInfoSet,ptDevInfo,SPDRP_FRIENDLYNAME, 
		&DataType, ByteBuffer,sizeof(ByteBuffer),&BufferSize))
	{
		this->SetFriendlyName( (const char *) ByteBuffer);
	}

	if (SetupDiGetDeviceRegistryProperty(hDeviceInfoSet,ptDevInfo,SPDRP_LOCATION_INFORMATION, 
		&DataType, ByteBuffer,sizeof(ByteBuffer),&BufferSize))
	{
		this->SetLocation((const char *) ByteBuffer);
	}

	if (SetupDiGetDeviceRegistryProperty(hDeviceInfoSet,ptDevInfo,SPDRP_PHYSICAL_DEVICE_OBJECT_NAME, 
		&DataType, ByteBuffer,sizeof(ByteBuffer),&BufferSize))
	{
		this->SetPhysicalObjectName((const char *) ByteBuffer);
	}

	if (SetupDiGetDeviceRegistryProperty(hDeviceInfoSet,ptDevInfo,SPDRP_CAPABILITIES, 
		&DataType, ByteBuffer,sizeof(ByteBuffer),&BufferSize))
	{
		long lValue = BufferToLong((const char *)ByteBuffer, BufferSize);
		this->SetCapabilities(lValue);

	}

	if (SetupDiGetDeviceRegistryProperty(hDeviceInfoSet,ptDevInfo,SPDRP_UI_NUMBER, 
		&DataType, ByteBuffer,sizeof(ByteBuffer),&BufferSize))
	{
		long lValue = BufferToLong((const char *)ByteBuffer, BufferSize);
		this->SetUINumber(lValue);
	}

	if (SetupDiGetDeviceRegistryProperty(hDeviceInfoSet,ptDevInfo,SPDRP_UPPERFILTERS, 
		&DataType, ByteBuffer,sizeof(ByteBuffer),&BufferSize))
	{
//		cout << "UpperFilters: " << (const char *) ByteBuffer << endl;
//							cout << "DataType: " << DataType << endl;  // 7

	}

	if (SetupDiGetDeviceRegistryProperty(hDeviceInfoSet,ptDevInfo,SPDRP_LOWERFILTERS, 
		&DataType, ByteBuffer,sizeof(ByteBuffer),&BufferSize))
	{
//		cout << "LowerFilters: " << (const char *) ByteBuffer << endl;
//							cout << "DataType: " << DataType << endl; // 7

	}

	if (SetupDiGetDeviceRegistryProperty(hDeviceInfoSet,ptDevInfo,SPDRP_MAXIMUM_PROPERTY, 
		&DataType, ByteBuffer,sizeof(ByteBuffer),&BufferSize))
	{
		long lValue = BufferToLong((const char *)ByteBuffer, BufferSize);
//		cout << "Upper bound on ordinals (Max. Property): " << lValue << endl;

	}

	if (SetupDiGetDeviceRegistryProperty(hDeviceInfoSet,ptDevInfo,SPDRP_NEW14, 
		&DataType, ByteBuffer,sizeof(ByteBuffer),&BufferSize))
	{
//		cout << "New14: " << (const char *) ByteBuffer << endl;
//		cout << "DataType: " << DataType << endl;
// ???
	}						
	
	if (SetupDiGetDeviceRegistryProperty(hDeviceInfoSet,ptDevInfo,SPDRP_NEW15, 
		&DataType, ByteBuffer,sizeof(ByteBuffer),&BufferSize))
	{
//		cout << "New15: " << (const char *) ByteBuffer << endl;
//		cout << "DataType: " << DataType << endl;
// ???
	}

}


/************************************************************************
 *  UsbDevice.cpp				O p e n 								*
 ************************************************************************/
HANDLE CUsbDevice::Open(CString szDevicePath)
{ 	
	HANDLE deviceHandle = INVALID_HANDLE_VALUE;

	deviceHandle = CreateFile (szDevicePath,
                               GENERIC_READ | GENERIC_WRITE,
                               FILE_SHARE_READ | FILE_SHARE_WRITE,
                               NULL,        // no SECURITY_ATTRIBUTES structure
                               OPEN_EXISTING, // No special create flags
                               FILE_ATTRIBUTE_NORMAL | FILE_FLAG_OVERLAPPED, 
                               NULL);       // No template file
	if (deviceHandle == INVALID_HANDLE_VALUE)
	{
		CheckWin32Error();
	}
	else 
	{
		CString msg;
		msg.Format("DevicePath %s OK!!", (LPCTSTR)szDevicePath);
//		AfxMessageBox (msg);
	}


	return deviceHandle;		
}



/************************************************************************
 *  UsbDevice.cpp				C l o s e								*
 ************************************************************************/
void CUsbDevice::Close(HANDLE hDevice)
{
	CloseHandle(hDevice);
}