#ifndef __USB_DEVICE__      
#define __USB_DEVICE__

// UsbDevice.h
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "inc\setupapi.h"

class CUsbDevice : public CObject
{

// Attributes
private:    
	CString m_szDescription;		// Garmin USB GPS
	CString m_szHardwareID;			// USB\Vid_091e&Pid_0003&Rev:0001
	CString m_szCompatibleIDs;		// USB\Class_ff&SubClass_ff&Prot_ff
	CString m_szDeviceID;			// USB\VID_091E&PID_OOO3\5&2C5E0B65&0&2
	long	m_lState;				// 0x0180600a
	long	m_lProblem;				// 0x00000000
	CString m_szService;			// grmnusb
	long	m_lCapabilities;		// 0x00000084
	long	m_lConfigFlags;			// 0x00000000
	CString m_szDevNode;
	CString m_szClass;				// GARMIN Devices
	CString m_szInfFile;
	CString m_szManufacturer;		// Garmin
	CString m_szClassGuid;			// {A12A4C5A-E1A3-4151-9927-7F724CA5DC92}
	CString m_szLocation;			// USB Device
	long	m_lBusNumber;			// 0x00000000
	CString m_szEnumeratorName;		// USB
	CString m_szFriendlyName;		// Garmin USB GPS
    CString m_szDriver;				// {A12A4C5A-E1A3-4151-9927-7F724CA5DC92}\0000
	CString m_szPhysicalObjectName;	// \Device\USBPD0-4
	long	m_lUINumber;			// 0x00000000
	CString m_szUpperFilters;
	CString m_szLowerFilters;
	CString m_szBusTypeGUID;
	long	m_lLegacyBusType;		// 0x0000000f

	CString m_szDevicePath;

	/*
#define SPDRP_DEVICEDESC                  (0x00000000)  // DeviceDesc (R/W)
#define SPDRP_HARDWAREID                  (0x00000001)  // HardwareID (R/W)
#define SPDRP_COMPATIBLEIDS               (0x00000002)  // CompatibleIDs (R/W)
#define SPDRP_NTDEVICEPATHS               (0x00000003)  // Unsupported, DO NOT USE
#define SPDRP_SERVICE                     (0x00000004)  // Service (R/W)
#define SPDRP_CONFIGURATION               (0x00000005)  // Configuration (R)
#define SPDRP_CONFIGURATIONVECTOR         (0x00000006)  // ConfigurationVector (R)
#define SPDRP_CLASS                       (0x00000007)  // Class (R--tied to ClassGUID)
#define SPDRP_CLASSGUID                   (0x00000008)  // ClassGUID (R/W)
#define SPDRP_DRIVER                      (0x00000009)  // Driver (R/W)
#define SPDRP_CONFIGFLAGS                 (0x0000000A)  // ConfigFlags (R/W)
#define SPDRP_MFG                         (0x0000000B)  // Mfg (R/W)
#define SPDRP_FRIENDLYNAME                (0x0000000C)  // FriendlyName (R/W)
#define SPDRP_LOCATION_INFORMATION        (0x0000000D)  // LocationInformation (R/W)
#define SPDRP_PHYSICAL_DEVICE_OBJECT_NAME (0x0000000E)  // PhysicalDeviceObjectName (R)
#define SPDRP_CAPABILITIES                (0x0000000F)  // Capabilities (R)
#define SPDRP_UI_NUMBER                   (0x00000010)  // UiNumber (R)
#define SPDRP_UPPERFILTERS                (0x00000011)  // UpperFilters (R/W)
#define SPDRP_LOWERFILTERS                (0x00000012)  // LowerFilters (R/W)
#define SPDRP_MAXIMUM_PROPERTY            (0x00000013)  // Upper bound on ordinals
*/

// Implementation
public:
	CUsbDevice();		
	CUsbDevice(const CUsbDevice& Source);
	CUsbDevice(CString szDeviceDescr, CString szClassGuid, CString szFriendlyName);
	~CUsbDevice();        

	const CUsbDevice& operator=(const CUsbDevice& Source);

	void SetProperties(HDEVINFO hDeviceInfoSet, PSP_DEVINFO_DATA ptDevInfo);
	HANDLE Open(CString szDevicePath);
	void Close(HANDLE hDevice);

/*
	void Set(CString sz) { m_sz = sz; }
	CString Get() { return m_sz; }

	void Set(long l ) { m_l = l; }
	long Get() { return m_l; }
*/

	void SetDescription(CString szDescr) { m_szDescription = szDescr; }
	CString GetDescription() { return m_szDescription; }

	void SetHardwareID(CString szHardwareID) { m_szHardwareID = szHardwareID; }
	CString GetHardwareID() { return m_szHardwareID; }

	void SetCompatibleIDs(CString szCompatibleIDs) { m_szCompatibleIDs = szCompatibleIDs; }
	CString GetCompatibleIDs() { return m_szCompatibleIDs; }

	void SetDeviceID(CString szDeviceID) { m_szDeviceID = szDeviceID; }
	CString GetDeviceID() { return m_szDeviceID; }

	void SetState(long lState ) { m_lState = lState; }
	long GetState() { return m_lState; }

	void SetProblem(long lProblem ) { m_lProblem = lProblem; }
	long GetProblem() { return m_lProblem; }

	void SetService(CString szService) { m_szService = szService; }
	CString GetService() { return m_szService; }

	void SetCapabilities(long lCapabilities ) { m_lCapabilities = lCapabilities; }
	long GetCapabilities() { return m_lCapabilities; }

	void SetConfigFlags(long lConfigFlags ) { m_lConfigFlags = lConfigFlags; }
	long GetConfigFlags() { return m_lConfigFlags; }

	void SetDevNode(CString szDevNode) { m_szDevNode = szDevNode; }
	CString GetDevNode() { return m_szDevNode; }

	void SetClass(CString szClass) { m_szClass = szClass; }
	CString GetClass() { return m_szClass; }

	void SetInfFile(CString szInfFile) { m_szInfFile = szInfFile; }
	CString GetInfFile() { return m_szInfFile; }

	void SetManufacturer(CString szManufacturer) { m_szManufacturer = szManufacturer; }
	CString GetManufacturer() { return m_szManufacturer; }

	void SetClassGuid(CString szGuid) { m_szClassGuid = szGuid; }
	CString GetClassGuid() { return m_szClassGuid; }

	void SetLocation(CString szLocation) { m_szLocation = szLocation; }
	CString GetLocation() { return m_szLocation; }

	void SetBusNumber(long lBusNumber ) { m_lBusNumber = lBusNumber; }
	long GetBusNumber() { return m_lBusNumber; }

	void SetEnumeratorName(CString szEnumeratorName) { m_szEnumeratorName = szEnumeratorName; }
	CString GetEnumeratorName() { return m_szEnumeratorName; }

	void SetFriendlyName(CString szDescr) { m_szFriendlyName = szDescr; }
	CString GetFriendlyName() { return m_szFriendlyName; }

	void SetDriver(CString szDriver) { m_szDriver = szDriver; }
	CString GetDriver() { return m_szDriver; }

	void SetPhysicalObjectName(CString szPhysicalObjectName) { m_szPhysicalObjectName = szPhysicalObjectName; }
	CString GetPhysicalObjectName() { return m_szPhysicalObjectName; }

	void SetUINumber(long lUINumber ) { m_lUINumber = lUINumber; }
	long GetUINumber() { return m_lUINumber; }

	void SetUpperFilters(CString szUpperFilters) { m_szUpperFilters = szUpperFilters; }
	CString GetUpperFilters() { return m_szUpperFilters; }

	void SetLowerFilters(CString szLowerFilters) { m_szLowerFilters = szLowerFilters; }
	CString GetLowerFilters() { return m_szLowerFilters; }

	void SetBusTypeGUID(CString szBusTypeGUID) { m_szBusTypeGUID = szBusTypeGUID; }
	CString GetBusTypeGUID() { return m_szBusTypeGUID; }

	void SetLegacyBusType(long lLegacyBusType ) { m_lLegacyBusType = lLegacyBusType; }
	long GetLegacyBusType() { return m_lLegacyBusType; }

	void SetDevicePath(CString szDevicePath) { m_szDevicePath = szDevicePath; }
	CString GetDevicePath() { return m_szDevicePath; }


private:
	long BufferToLong(const char* ptBuff, int bufferSize);
	void CheckError(DWORD dwError);
	void CheckWin32Error();

};
#endif 

