#ifndef __HL_CVEKTOR__
#define __HL_CVEKTOR__

/************************************************************************
 *			 				C V e k t o r . h							*
 ************************************************************************/
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de
		  
typedef struct tagVECT
	{
    double	x;
    double	y;
    double	z;
	} VECT, *PVECT, NEAR *NPVECT, FAR *LPVECT;


//class CVektor : public tagVECT
class CVektor
{
public:
    double	x;
    double	y;
    double	z;

public:
	CVektor (double X=0., double Y=0., double Z=0.);		/* default contructor	*/
    CVektor (const CVektor& other);  			/* copy constructor		*/
    ~CVektor();									/* destructor			*/
	CVektor operator +(const CVektor& V);
	CVektor operator -(const CVektor& V);
	CVektor operator -();
	CVektor operator *(const double fFaktor);
	const CVektor& operator *=(const double fFaktor);

	CVektor& operator =(const CVektor& V);
  	double X (void) const 						// doesnt change this
			{return x;}
	double Y (void) const 						// doesnt change this
			{return y;}
	double Z (void) const 						// doesnt change this
			{return z;}

	void Set (double X=0., double Y=0., double Z=0.);

	double Abs ();
	void Normalize (CVektor& V);
	void Normalize ();
	double SkalarProdukt (CVektor& V2);
	double Det2 (CVektor& V2);
	double Det3 (CVektor& V2, CVektor& V3);
	BOOL LGS2 (CVektor& VX, CVektor& VY);
	BOOL LGS3 (CVektor& VX, CVektor& VY, CVektor& VZ);
	double VektorAngle (CVektor& V2);
	CVektor GrossKreis (CVektor& vLocB, double w2);
	void VektorProdukt (CVektor& V1, CVektor& V2);
	void MultMatrix3 (CVektor& V1, CVektor& V2, CVektor& V3, CVektor& B1);
	void RotateXY (CVektor& V1, CVektor& P, double a);
	CVektor RotateXY (CVektor& P, double a);
	void Rotate (CVektor& P, double a);
	static BOOL CircleIntersections (CVektor& CA, CVektor& CB, double radius,
						   CVektor* ptIntersect1, CVektor* ptIntersect2);

//protected: 					// in abgeleiteten Obj. verfgbar

};

#endif
