/************************************************************************
 *			 			X m l A t t r i b u t e . c p p					*
 ************************************************************************/
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "stdafx.h"
#include "XmlAttribute.h"

/* stores all parameters of an airspace segment. A segment is either	*/
/* a line, a circle or an arc											*/


/************************************************************************
 *  XmlAttribute.cpp		C X m l A t t r i b u t e		CONSTRUCTOR	*
 ************************************************************************/
CXmlAttribute::CXmlAttribute ()
{		
	this->Init();
}
  
/************************************************************************
 *  XmlAttribute.cpp		C X m l A t t r i b u t e		CONSTRUCTOR	*
 ************************************************************************/
CXmlAttribute::CXmlAttribute (CString szName, CString szValue)
{										
	this->Init();

	m_szName = szName;
	m_szValue = szValue;
}  



/************************************************************************
 *  XmlAttribute.cpp		~ C X m l A t t r i b u t e		DESTRUCTOR	*
 ************************************************************************/
CXmlAttribute::~CXmlAttribute()
{
}


/************************************************************************
 *  XmlAttribute.cpp			     I n i t	 						*
 ************************************************************************/
void CXmlAttribute::Init ()
{
	m_szName = "";
	m_szValue = "";
}

/************************************************************************
 *  XmlAttribute.cpp    	W r i t e T e x t							*
 ************************************************************************/
void CXmlAttribute::WriteText(CArchive& ar, CString szText)
{
	int nLen = szText.GetLength();
	ar.Write ((const void*)szText, (UINT)nLen);
}

/************************************************************************
 *  XmlAttribute.cpp    		S e r i a l i z e						*
 ************************************************************************/
void CXmlAttribute::Serialize(CArchive& ar, short nVersion)
{ 
	if (ar.IsStoring())
	{
		// storing code for an attribute 
		
		ar.Write(" ", 1);
		WriteText(ar, m_szName);
		ar.Write("=\"", 2);
		WriteText(ar, m_szValue);   
		ar.Write("\"", 1);

	}
	else
	{       
		// TODO: add loading code here    		
		ar >> m_szName;   
		ar >> m_szValue;   
	}
} 