// XmlDocument.cpp: Implementierungsdatei
// (c) Copyright Softwareentwicklung Heinz Ldert 2012
// http://www.preflight.de

#include "stdafx.h"
#include "XmlDocument.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// CXmlDocument
// Sorts and stores a list of airspace segment objects

IMPLEMENT_DYNCREATE(CXmlDocument, CDocument)

CXmlDocument::CXmlDocument()
{
	m_bConverted = FALSE;
	m_szExt = GetExt();
	this->InitHeader();
}


/************************************************************************
 *  XMLDocument.cpp			C r e a t e D O M		 					*
 ************************************************************************/
void CXmlDocument::CreateDOM(CString szMainTag, CString szNamespaceURI)
{
	m_bConverted = FALSE;
	m_szExt = GetExt();
	this->InitHeader();

	m_ptXmlVersionTag = new CXmlTag("?xml", "");
	m_ptDocumentTag = new CXmlTag(szMainTag, "");

	m_ptDocumentTag->appendAttribute("xmlns", szNamespaceURI);

//	m_ptXmlVersionTag->appendAttribute("version", "1.0");
//	m_ptXmlVersionTag->appendAttribute("encoding", "UTF-8");

}

/************************************************************************
 *  XmlDocument.cpp		O n N e w D o c u m e n t	 					*
 ************************************************************************/
BOOL CXmlDocument::OnNewDocument()
{
	if (!CDocument::OnNewDocument())
		return FALSE;
	return TRUE;
}

CXmlDocument::~CXmlDocument()
{
	if (this->IsModified())  
	{
		CString szPath = this->GetPathName(); 
		this->OnSaveDocument (szPath);
	}

	delete	m_ptXmlVersionTag;
	delete	m_ptDocumentTag;
}

/************************************************************************
 *  XmlDocument.cpp			G e t E x t 						*
 ************************************************************************/
CString CXmlDocument::GetExt()
{
	CString szExt(".xml");
	return szExt;
}


BEGIN_MESSAGE_MAP(CXmlDocument, CDocument)
	//{{AFX_MSG_MAP(CXmlDocument)
		// HINWEIS - Der Klassen-Assistent fgt hier Zuordnungsmakros ein und entfernt diese.
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// Diagnose CXmlDocument

#ifdef _DEBUG
void CXmlDocument::AssertValid() const
{
	CDocument::AssertValid();
}

void CXmlDocument::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG



/************************************************************************
 *  XmlDocument.cpp		D e l e t e C o n t e n t s						*
 *  Called from: OnFileNew and OnFileOpen								*
 ************************************************************************/
void CXmlDocument::DeleteContents()
{
	this->InitHeader();
	delete	m_ptXmlVersionTag;
	delete	m_ptDocumentTag;
}

/************************************************************************
 *  XmlDocument.cpp		O n O p e n D o c u m e n t				*
 ************************************************************************/
BOOL CXmlDocument::OnOpenDocument(LPCTSTR pszPathName)
{
BOOL bOpened = FALSE;
this->SetPathName(pszPathName);

bOpened = CDocument::OnOpenDocument(pszPathName); 

if (bOpened)
	{
	if (m_bConverted)
		{
		if (this->OnSaveDocument (pszPathName))
			{
			m_bConverted = FALSE;
//			if (ptInit->IsSaveSignal())
//				MessageBeep(MB_OK);	
			}
		}
	}

return bOpened;
}


/************************************************************************
 *  XmlDocument.cpp		O n S a v e D o c u m e n t						*
 ************************************************************************/
BOOL CXmlDocument::OnSaveDocument(const char* pszPathName)
{
	BOOL bSaved = TRUE;
	this->SetPathName (pszPathName);

	if (this->IsModified())
	{
		bSaved = CDocument::OnSaveDocument(pszPathName); 

		if (bSaved)
			this->SetModifiedFlag (FALSE);
		
	}

	return bSaved;
}

/************************************************************************
 *  XmlDocument.cpp		getXmlVersionElement							*
 *  Purpose: returns pointer to document xml tag						*
 ************************************************************************/
CXmlTag* CXmlDocument::getXmlVersionElement()
{
	return m_ptXmlVersionTag;
}

/************************************************************************
 *  XmlDocument.cpp				G e t R o o t T a g 					*
 ************************************************************************/
CXmlTag* CXmlDocument::GetRootTag()
{
	return m_ptDocumentTag;
}

/************************************************************************
 *  XmlDocument.cpp			 S e t V e r s i o n						*
 ************************************************************************/
void CXmlDocument::SetVersion(CString szVersion)
{
	if (m_ptXmlVersionTag != NULL)
	{
		m_ptXmlVersionTag->appendAttribute("version", szVersion);
	}
}

/************************************************************************
 *  XmlDocument.cpp			 S e t E n c o d i n g						*
 ************************************************************************/
void CXmlDocument::SetEncoding(CString szEncoding)
{
	if (m_ptXmlVersionTag != NULL)
	{
		m_ptXmlVersionTag->appendAttribute("encoding", szEncoding); 
	}
}

/************************************************************************
 *  XmlDocument.cpp			 S e t S t a n d a l o n e					*
 ************************************************************************/
void CXmlDocument::SetStandalone(BOOL bAlone)
{
	if (m_ptXmlVersionTag != NULL)
	{
		m_ptXmlVersionTag->appendAttribute("standalone", (bAlone? "yes" : "no"));  
	}
}


/************************************************************************
 *  XmlDocument.cpp			A p p e n d C h i l d T a g					*
 ************************************************************************/
CXmlTag* CXmlDocument::AppendChildTag(CXmlTag* ptParentTag, CString szName)
{
	CXmlTag*  ptChildTag = ptParentTag->appendChildTag(szName, "");
	return ptChildTag;
}

/************************************************************************
 *  XmlDocument.cpp			A p p e n d C h i l d T a g					*
 ************************************************************************/
CXmlTag* CXmlDocument::AppendChildTag(CXmlTag* ptParentTag, CString szName, CString szValue)
{
	CXmlTag*  ptChildTag = ptParentTag->appendChildTag(szName, szValue);
	return ptChildTag;
}


/************************************************************************
 *  XmlDocument.cpp			A p p e n d A t t r i b u t e				*
 ************************************************************************/
void CXmlDocument::AppendAttribute(CXmlTag* ptParentTag, CString szName, CString szValue)
{
	ptParentTag->appendAttribute(szName, szValue);
}

/************************************************************************
 *  XmlDocument.cpp			G e t A t t r T e x t 						*
 ************************************************************************/
CString CXmlDocument::GetAttrText(CXmlTag* ptParentTag, CString szName)
{
	// in ptParentTag nach dem Attribut szName suchen und dessen szValue zurckgeben
	return ptParentTag->GetAttributeValue(szName);
}


/************************************************************************
 *  XmlDocument.cpp			ParseXML				*
 ************************************************************************/
CXmlTag* CXmlDocument::ParseXML(CString szXMLSourceFile)
{
	CXmlTag*  ptRootTag = NULL;

	// hier parsen....


	return ptRootTag;
}

/************************************************************************
 *  XmlDocument.cpp				G e t E l e m e n t C n t				*
 ************************************************************************/
unsigned int CXmlDocument::GetElementCnt()
{
	unsigned int nCnt= m_ptDocumentTag->GetElementCnt();
	return nCnt;
}

/************************************************************************
 *  XmlDocument.cpp				G e t C h i l d N o d e s				*
 ************************************************************************/
int CXmlDocument::GetChildNodes(CXmlTag* ptXmlTag, CString szName, CPtrArray* ptChildTags)
{
	unsigned int nCnt= 0;

	// CPtrArray mit gefundenen CXmlTags anlegen...

	return nCnt;
}

/************************************************************************
 *  XmlDocument.cpp				G e t N o d e N a m e					*
 ************************************************************************/
CString CXmlDocument::GetNodeName(CXmlTag* ptXmlTag)
{
	return ptXmlTag->GetName();
}

/************************************************************************
 *  XmlDocument.cpp				G e t N o d e T e x t					*
 ************************************************************************/
CString CXmlDocument::GetNodeText(CXmlTag* ptXmlTag)
{
	return ptXmlTag->GetValue();
}

/************************************************************************
 *  XmlDocument.cpp  		 		C h a n g e								*
 ************************************************************************/
BOOL CXmlDocument::Change(CWnd* ptWnd)
{  
	BOOL 	bChanged = FALSE;
/*
	CXmlTagDlg XmlTagDlg(ptWnd, this);

	int RetVal = XmlTagDlg.DoModal();
	switch (RetVal)
	{
	case IDOK:
		{   
		CString szPath = this->GetPathName(); 
		if (XmlTagDlg.WriteDataBaseIntoDoc()) 
			{             
			bChanged = this->OnSaveDocument (szPath);
 			}     
		}
 		break;
	case IDCANCEL: 
        this->SetModifiedFlag(FALSE);
		break;
	}
*/
	return bChanged;	
} 


/************************************************************************
 *  XmlDocument.cpp			I n i t H e a d e r							*
 ************************************************************************/
void CXmlDocument::InitHeader ()
{  
m_Header.cFlags		= 0;
m_Header.cDummy		= 0;
m_Header.nActIndex	= -1;
m_Header.nEntryCnt	= 0;  
}


/************************************************************************
 *  XmlDocument.cpp  				S e r i a l i z e		 			*
 ************************************************************************/
void CXmlDocument::Serialize(CArchive& ar)
{
	if (ar.IsStoring())
	{
		// ZU ERLEDIGEN: Code zum Speichern hier einfgen
	//	ar.Write (&m_Header, sizeof (XMLTAGHEADER)); 
		if (m_ptXmlVersionTag != NULL)
			m_ptXmlVersionTag->Serialize(ar);

		if (m_ptDocumentTag != NULL)
			m_ptDocumentTag->Serialize(ar);

		m_bConverted = FALSE;
	}
	else
	{
		m_bConverted = FALSE;

		// ZU ERLEDIGEN: Code zum Laden hier einfgen
	//	ar.Read (&m_Header, sizeof (XMLTAGHEADER));
	
		if (m_ptXmlVersionTag != NULL)
			m_ptXmlVersionTag->Serialize(ar);

		if (m_ptDocumentTag != NULL)
			m_ptDocumentTag->Serialize(ar);
	}
}

/////////////////////////////////////////////////////////////////////////////
// Befehle CXmlDocument 
