#if !defined(__XML_DOCUMENT__)
#define __XML_DOCUMENT__

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// XmlTagDoc.h : Header-Datei
//
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "XmlTag.h"


/////////////////////////////////////////////////////////////////////////////
// Dokument CXmlDocument 

typedef struct
	{
	unsigned char cFlags;
	unsigned char cDummy;
	short	nActIndex;
	short	nEntryCnt;
	} XMLTAGHEADER;


class CXmlDocument : public CDocument
{
public:
	CXmlDocument();


protected:
	           // Dynamische Erstellung verwendet geschtzten Konstruktor
	DECLARE_DYNCREATE(CXmlDocument)

// Attribute
protected:
	#define MAX_HEADER_SIZE 20
    
    XMLTAGHEADER	m_Header;     
	CXmlTag*		m_ptXmlVersionTag;
	CXmlTag*		m_ptDocumentTag;
 	BOOL			m_bConverted;
	CString			m_szExt;

// Operationen
public:
	static CString GetExt();

	void CreateDOM(CString szMainTag, CString szNamespaceURI);

	CXmlTag* getXmlVersionElement();
	CXmlTag* GetRootTag();
	void SetVersion(CString szVersion);
	void SetEncoding(CString szEncoding);
	void SetStandalone(BOOL bAlone);
	CXmlTag* AppendChildTag(CXmlTag* ptParentTag, CString szName);
	CXmlTag* AppendChildTag(CXmlTag* ptParentTag, CString szName, CString szValue);
	void AppendAttribute(CXmlTag* ptParentTag, CString szName, CString szValue);
	CString GetAttrText(CXmlTag* ptParentTag, CString szName);
	CXmlTag* ParseXML(CString szXMLSourceFile);

	unsigned int GetElementCnt();

	// zum Lesen:
	int GetChildNodes(CXmlTag* ptXmlTag, CString szName, CPtrArray* ptChildTags);
	CString GetNodeName(CXmlTag* ptXmlTag);
	CString GetNodeText(CXmlTag* ptXmlTag);


	BOOL Change(CWnd* ptWnd);
	
	virtual void DeleteContents();
	short GetActIndex() { return m_Header.nActIndex; }
	short GetXmlTagCnt () { return m_Header.nEntryCnt; }

	void SetActIndex(short nIndex) { m_Header.nActIndex = nIndex; }
	void SetXmlTagCnt (short nCnt) { m_Header.nEntryCnt = nCnt; }


// Operationen
public:

// berschreibungen
	// Vom Klassen-Assistenten generierte virtuelle Funktionsberschreibungen
	//{{AFX_VIRTUAL(CXmlDocument)
	public:
	virtual BOOL OnNewDocument();
	virtual BOOL OnOpenDocument(LPCTSTR lpszPathName);
	virtual BOOL OnSaveDocument(const char* pszPathName);
	virtual void Serialize(CArchive& ar);   // berschrieben fr Dokument-Ein-/Ausgabe
	protected:
	//}}AFX_VIRTUAL

// Implementierung
public:
	virtual ~CXmlDocument();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif


private:
	void InitHeader ();

	// Generierte Nachrichtenzuordnungsfunktionen
protected:
	//{{AFX_MSG(CXmlDocument)
		// HINWEIS - Der Klassen-Assistent fgt hier Member-Funktionen ein und entfernt diese.
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ fgt unmittelbar vor der vorhergehenden Zeile zustzliche Deklarationen ein.

#endif // __XML_DOCUMENT__
