/************************************************************************
 *			 			X m l T a g . c p p								*
 ************************************************************************/
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "stdafx.h"
#include "XmlTag.h"

/* stores all parameters of an airspace segment. A segment is either	*/
/* a line, a circle or an arc											*/


/************************************************************************
 *  XmlTag.cpp				C X m l T a g					CONSTRUCTOR	*
 ************************************************************************/
CXmlTag::CXmlTag ()
{		
	this->Init();
}
  
/************************************************************************
 *  XmlTag.cpp				C X m l T a g					CONSTRUCTOR	*
 ************************************************************************/
CXmlTag::CXmlTag (CString szName, CString szValue)
{										
	this->Init();

	m_szName = szName;
	m_szValue = szValue;
}  


/************************************************************************
 *  XmlTag.cpp			G e t X m l T a g  P t r						*
 *  Purpose: returns pointer to specified CXmlTag						*
 ************************************************************************/
BOOL CXmlTag::GetXmlTagPtr (short nIndex, CXmlTag** ptptXmlTag)
{
	BOOL bDone = FALSE;
	if (nIndex >= 0 && nIndex < m_ChildXmlTags.GetSize())
	{
		CXmlTag* ptXmlTag=NULL;
		ptXmlTag = (CXmlTag*)m_ChildXmlTags.GetAt(nIndex);
		if (ptXmlTag != NULL)
		{
			*ptptXmlTag = ptXmlTag;
			bDone = TRUE;
		}
	}

	return bDone;
}


/************************************************************************
 *  XmlTag.cpp		D e l e t e X m l T a g P t r						*
 *  Purpose: deletes an CXmlTag entry									*
 ************************************************************************/
BOOL CXmlTag::DeleteXmlTagPtr (short nIndex)
{
	BOOL bDone = FALSE;

	CXmlTag* ptXmlTag = NULL;
	if (this->GetXmlTagPtr(nIndex, &ptXmlTag))
	{
		delete ptXmlTag;
		m_ChildXmlTags.RemoveAt(nIndex);
		bDone = TRUE;
	}

	return bDone;
}

/************************************************************************
 *  XmlTag.cpp				~ C X m l T a g					DESTRUCTOR	*
 ************************************************************************/
CXmlTag::~CXmlTag()
{
	DeleteXmlAttributeArray(&m_Attributes);
	DeleteXmlTagArray(&m_ChildXmlTags);
}


/************************************************************************
 *  XmlTag.cpp		D e l e t e X m l A t t r i b u t e A r r a y		*
 ************************************************************************/
void CXmlTag::DeleteXmlAttributeArray (CObArray* ptArray)
{
int i, nEntryCnt;	
											
nEntryCnt = ptArray->GetSize();
for (i=0; i<nEntryCnt; i++)
	{
	CXmlAttribute* ptEntry;
	if ((ptEntry = (CXmlAttribute*)ptArray->GetAt(i)) != NULL)
		{
	//	TRACE ("Deleting CXmlAttribute %d\n", i);
		delete ptEntry;				// delete original element
		}
	}
ptArray->RemoveAll();
}  

/************************************************************************
 *  XmlTag.cpp			D e l e t e X m l T a g A r r a y				*
 ************************************************************************/
void CXmlTag::DeleteXmlTagArray (CObArray* ptArray)
{
int i, nEntryCnt;	
											
nEntryCnt = ptArray->GetSize();
for (i=0; i<nEntryCnt; i++)
	{
	CXmlTag* ptEntry;
	if ((ptEntry = (CXmlTag*)ptArray->GetAt(i)) != NULL)
		{
	//	TRACE ("Deleting CXmlTag %d\n", i);
		delete ptEntry;				// delete original element
		}
	}
ptArray->RemoveAll();
}  


/************************************************************************
 *  XmlTag.cpp					  I n i t		 						*
 ************************************************************************/
void CXmlTag::Init ()
{
	m_szName = "";
	m_szValue = "";

//	CObArray	m_Attributes;             
//	CObArray	m_ChildXmlTags;  

}


/************************************************************************
 *  XmlTagDoc.cpp			appendAttribute								*
 *  Purpose: adds an attribute to a xml tag		 						*
 ************************************************************************/
void CXmlTag::appendAttribute(CString szName, CString szValue)
{
	CXmlAttribute* ptAttr = new CXmlAttribute(szName, szValue);
	m_Attributes.Add(ptAttr);
}


/************************************************************************
 *  XmlTagDoc.cpp			a p p e n d C h i l d T a g 				*
 *  Purpose: adds a child tag to a xml tag		 						*
 ************************************************************************/
CXmlTag* CXmlTag::appendChildTag(CString szName, CString szValue)
{
	CXmlTag* ptChildTag = new CXmlTag(szName, szValue);
	m_ChildXmlTags.Add(ptChildTag);
	return ptChildTag;
}


/************************************************************************
 *  XmlTagDoc.cpp			G e t A t t r i b u t e V a l u e			*
 *  Purpose: to get value of specified attribute		 				*
 ************************************************************************/
CString CXmlTag::GetAttributeValue(CString szName)
{
		// in ptParentTag nach dem Attribut szName suchen und dessen szValue zurckgeben
	CString szValue = "";
	BOOL bFound = FALSE;

	int nEntryCnt = m_Attributes.GetSize();
	int i;
	for (i=0; i<nEntryCnt && !bFound; i++)
	{
		CXmlAttribute* ptEntry;
		if ((ptEntry = (CXmlAttribute*)m_Attributes.GetAt(i)) != NULL)
		{
			if (ptEntry->GetName().Compare((LPCTSTR)szName) == 0)
			{
				bFound = TRUE;
				szValue = ptEntry->GetValue();
			}
		}
	}
	return szValue;
}
	


/************************************************************************
 *  XmlTag.cpp				G e t E l e m e n t C n t					*
 ************************************************************************/
unsigned int CXmlTag::GetElementCnt()
{
	unsigned int nCnt=0;

	int i;
	for (i=0; i<m_ChildXmlTags.GetSize(); i++)
	{
		nCnt++;				// the child tag
							// the childs of the childs...
		CXmlTag* ptChildXmlTag;
		ptChildXmlTag = (CXmlTag*)m_ChildXmlTags.GetAt(i);
		if (ptChildXmlTag != NULL)
			nCnt += ptChildXmlTag->GetElementCnt();
	}


	return nCnt;
}

/************************************************************************
 *  XmlTag.cpp    			W r i t e T e x t							*
 ************************************************************************/
void CXmlTag::WriteText(CArchive& ar, CString szText)
{
	int nLen = szText.GetLength();
	ar.Write ((const void*)szText, (UINT)nLen);
}

/************************************************************************
 *  XmlTag.cpp    			S e r i a l i z e							*
 ************************************************************************/
void CXmlTag::Serialize(CArchive& ar, short nVersion)
{ 
	int i;
	bool isXMLVersionsTag = (m_szName.CompareNoCase("?xml") == 0);

	if (ar.IsStoring())
	{
		// TODO: add storing code here 

			// Start-Tag: <m_szName
		ar.Write("<", 1);
		WriteText(ar, m_szName);


			// Attributes of this Tag:
		for (i=0; i<m_Attributes.GetSize(); i++)
		{
			CXmlAttribute* ptXmlAttribute;
			ptXmlAttribute = (CXmlAttribute*)m_Attributes.GetAt(i);
			if (ptXmlAttribute != NULL)
				ptXmlAttribute->Serialize (ar);  
		}   

		if (isXMLVersionsTag)
		{
			ar.Write("?>", 2);	// close ?xml-Tag
		}
		else
		{
			ar.Write(">", 1);	// close Start Tag

			if (m_szValue.GetLength() > 0)
			{		// insert Value
				WriteText(ar, m_szValue);
			}
			else
			{		// or child tags:
				for (i=0; i<m_ChildXmlTags.GetSize(); i++)
				{
					CXmlTag* ptXmlTag;
					ptXmlTag = (CXmlTag*)m_ChildXmlTags.GetAt(i);
					if (ptXmlTag != NULL)
						ptXmlTag->Serialize (ar);  
				}   
			}

				// End-Tag
			ar.Write("</", 2);
			WriteText(ar, m_szName);
			ar.Write(">", 1);	// close End Tag
		}
	}
	else
	{       
		// TODO: add loading code here    		

		ar >> m_szName;   
		ar >> m_szValue;   

/*		short nCnt = this->GetXmlTagCnt ();
	
		for (i=0; i<nCnt; i++)
		{
			CXmlTag* ptXmlTag = new CXmlTag; 
			if (ptXmlTag != NULL)
			{
				ptXmlTag->Serialize (ar, nVersion);
				m_ChildXmlTags.Add (ptXmlTag);       	// add new Element        
			}
		} 
*/
	}
} 