#ifndef _XML_TAG__
#define _XML_TAG__

/************************************************************************
 *			 					X m l T a g . h							*
 ************************************************************************/
// (c) Copyright Softwareentwicklung Heinz Ldert 2012
// http://www.preflight.de

#include "XmlAttribute.h"


#define ACT_XMLTAG_VERS	1   

class CXmlTag : public CObject
{
public:

public:
	CXmlTag ();					/* default contructor	*/
	CXmlTag (CString szName, CString szValue);
    ~CXmlTag();					/* destructor			*/

	void appendAttribute(CString szName, CString szValue);
	CXmlTag* appendChildTag(CString szName, CString szValue);
	CString GetAttributeValue(CString szName);
	BOOL GetXmlTagPtr (short nIndex, CXmlTag** ptptXmlTag);
	BOOL DeleteXmlTagPtr (short nIndex);
	unsigned int GetElementCnt();

	CString GetName () { return m_szName; }
	CString GetValue () { return m_szValue; }

	void Serialize(CArchive& ar, short nVersion = ACT_XMLTAG_VERS);

//protected: 					// in abgeleiteten Obj. verfgbar

private:
	void Init ();
	void DeleteXmlAttributeArray (CObArray* ptArray);
	void DeleteXmlTagArray (CObArray* ptArray);
	void WriteText(CArchive& ar, CString szText);


private:
	CString m_szName;	
	CString m_szValue;	

	CObArray	m_Attributes;				// array of CXmlAttribute       
	CObArray	m_ChildXmlTags;				// array of CXmlTag

};

#endif
