#ifndef __AIRSPACE__
#define __AIRSPACE__

/************************************************************************
 *			 				 A i r s p a c e . h						*
 ************************************************************************/
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include <math.h>
#include "LatLon.h"			// DRECT
#include "..\CPPTOOLS\Polygon.h"

#define pi 3.1415926

#define SIZEOF_ASP_REGION	32		// see: region.h
#define SIZEOF_ASP_IDENT	10
#define SIZEOF_ASP_NAME		40
#define ACT_SPA_VERS	1   

#define ASP_ACTIVATED 	1
#define ASP_USERDEFINED	2
#define ASP_ANTIPOD		4

class CAirspace : public CObject
{
public:
	enum CLASS 
	{			
		A,		
		B,		
		C,		
		D,		
		E,		
		F,		
		G,		
		NO_CLASS=255
	};

	enum LEVEL
	{
		HIGHLOW,
		HIGH,
		LOW,
		NO_LEVEL=255
	};

	enum TYPE
	{
		ADVISORY_AREA,			// ADVISORY AREA
		ADIZ,					// AIR DEFENSE IDENTIFICATION ZONE
		AIR_RTE_TRAFFIC_CTR,	// AIR ROUTE TRAFFIC CONTROL CENTER
		AREA_CTR,				// AREA CONTROL CENTER
		BUFFER_ZONE,			// BUFFER ZONE
		CONTROL_AREA,			// CONTROL AREA
		CONTROL_ZONE,			// CONTROL ZONE
		FIR,					// FLIGHT INFORMATION REGION
		OCEAN_CTR,				// OCEAN CONTROL AREA
		RADAR_AREA,				// RADAR AREA
		TCR,					// TERMINAL CONTROL AREA
		UPPER_FIR,				// UPPER FLIGHT INFORMATION REGION
		NO_TYPE
    };

	enum INPUTDIRECTION
	{
		COUNTERCLOCKWISE=-1,
		CLOCKWISE=1,
		NO_INPUTDIRECTION=0
	};

public:
	CAirspace ();					/* default contructor	*/
	CAirspace (CString szIdentifier);
	CAirspace (CAirspace& SourceAirspace);
    ~CAirspace();					/* destructor			*/

	void ResetBorderAndIndex ();
	void ExpandBorder(BOOL bInit, double dLat, double dLon);

	const CAirspace& operator=(const CAirspace& Airspace);
	BOOL operator !=(const CAirspace& Airspace);

	BOOL GetTopLeftEdge (double* ptMaxLat, double* ptMinLon);
	BOOL GetBottomRightEdge (double* ptMinLat, double* ptMaxLon);

	void SetIdentifier(CString szIdentifier);
	CString GetIdentifier();

	void SetIdentifier(CString szCC, long lID);
	CString GetCountryCode();
	void SetCountryCode(CString szCC);
	long GetID();
	void SetID(long lID);

	void SetMaxLat(double dLat) { m_dLatMax = dLat; }
	double GetMaxLat() { return m_dLatMax; }

	void SetMinLon(double dLon) { m_dLonMin = dLon; }
	double GetMinLon() { return m_dLonMin; }

	void SetMinLat(double dLat) { m_dLatMin = dLat; }
	double GetMinLat() { return m_dLatMin; }

	void SetMaxLon(double dLon) { m_dLonMax = dLon; }
	double GetMaxLon() { return m_dLonMax; }

	void SetSegmentCnt (short nCnt) { m_nSegmentCnt = nCnt; }
	short GetSegmentCnt () { return m_nSegmentCnt; }

	void SetFirstSegmentIndex (long lIndex) { m_lFirstSegmentIndex = lIndex; }
	long GetFirstSegmentIndex () { return m_lFirstSegmentIndex; }

	void SetInputDirection (int nInpDir) { m_InputDirection = (INPUTDIRECTION)nInpDir; }
	int GetInputDirection () { return (int)m_InputDirection; }

	void SetType (short nType);
	void SetType (TYPE nType) { m_cType = nType; }
	TYPE GetType () { return m_cType; }

	void SetActivated(BOOL bActivated);
	BOOL IsActivated(void);
	void SetUserDefined(BOOL bUserDefined);
	BOOL IsUserDefined(void);
	void SetAntipod(BOOL bAntipod);
	BOOL IsAntipod(void);

	CString GetRegionName();
	void SetRegionName(CString szRegionName);

	CString GetName(); 
	void SetName(CString szName);

	CString GetDisplayName();

	CString GetLabelText();
	CString GetAltText();

	double CourseToTextAngle(double dCourse);
	double CourseToLabelPosition(double dCourse);

	COLORREF GetColor();
	CPen* CreatePen(CDC* pDC);

	short CharToFreqDim(char cDim);

	void SetFrequency(float fFreq, short nFreqDim); 
	void GetFrequency(float* ptFreq, short* ptFreqDim); 

	void SetClass(char cClass);
	void SetClass(CLASS cClass) { m_cClass = cClass; }
	CLASS GetClass () { return m_cClass; }

	void SetLevel(char cLevel);
	void SetLevel(LEVEL cLevel) { m_cLevel = cLevel; }
	LEVEL GetLevel () { return m_cLevel; }

	void SetUpperAlt (long lUpper) { m_lUpperEffAltMSL = lUpper; }
	long GetUpperAlt () { return m_lUpperEffAltMSL; }

	void SetLowerAlt (long lLower) { m_lLowerEffAltMSL = lLower; }
	long GetLowerAlt () { return m_lLowerEffAltMSL; }

	void SetElevDim(short nDim) { m_nElevDim = nDim; }
	short GetElevDim() { return m_nElevDim; }

	void SetPolyPtr(CPolygon* ptPoly) { m_ptPoly = ptPoly; }
	CPolygon* GetPolyPtr() { return m_ptPoly; }

	double LoxoDist (double dLat, double dLon, double* ptCourse);
	BOOL BorderContains (double dLat, double dLon);
	BOOL IsInRect(DRECT rLatLon, double dLat, double dLon);
	BOOL IsInRect(DRECT rLatLon);

	void Serialize(CArchive& ar, short nVersion = ACT_SPA_VERS);



//protected: 					// in abgeleiteten Obj. verfgbar

private:
	void Init ();
	void StringToCharArray(CString szText, char* ptText, short nArrayLen);
	void SetFlagBit (unsigned char FAR* lpFlag, short BitMask, BOOL bSet);


private:
	// Members, defined by CAirspaceDoc::UpdateSegmentBorderAndIndex(CAirspaceSegmentDoc* ptDoc)
							// rough border of airspace:
	double	m_dLatMax;		// top left edge
	double	m_dLonMin;
	double	m_dLatMin;		// bottom right edge
	double	m_dLonMax;
	short	m_nSegmentCnt;
	long	m_lFirstSegmentIndex;	// index of CAirspaceSegmentDoc
	INPUTDIRECTION	m_InputDirection;

	// Members for configuration
	BYTE	m_cFlag;		/* ASP_ACTIVATED:1, ASP_USERDEFINED:2 */


	// Members, defined by DAFIF FormatCode 01
	char m_szIdentifier[SIZEOF_ASP_IDENT];		// e.g.: ED000027

	char m_szName[SIZEOF_ASP_NAME];		// e.g.: Ramstein

	float	m_dFrequency1;
	short	m_nFreqDim1;

	TYPE	m_cType;		// A, B, C, ...
	CLASS	m_cClass;		// 01,01 - A, B, C, D, E, F, G OR SPACE

	// Members, defined by DAFIF FormatCode 02
	LEVEL	m_cLevel;		//	  B - HIGH AND LOW LEVEL
							//	  H - HIGH LEVEL
							//	  L - LOW LEVEL
	char	m_cDummy;
	long m_lUpperEffAltMSL;		// INDICATES THE HIGHEST ALTITUDE (CEILING) 
								// ABOVE MEAN SEA LEVEL (AMSL)
								// OR ABOVE GROUND ELEV. (AGL) IN FEET FOR 
								// THE UPPER VERTICAL LIMIT 
								// OF THE GIVEN AIRSPACE
	long m_lLowerEffAltMSL;
	short m_nElevDim;


private:
	char	m_szRegionName[SIZEOF_ASP_REGION];	
	CPolygon*	m_ptPoly;

};

#endif
