// AirspaceDlg.cpp: Implementierungsdatei
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "stdafx.h"
#include "pf.h"

#include "InitDoc.h"
#include "DimDoc.h"    

#include "AirspaceDoc.h"
#include "AirspaceDlg.h"
#include "AirspaceSegmentDlg.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// Dialogfeld CAirspaceDlg 
// All regions, expect the one currently selected in this dialog, must be deactivated!!
// If more than one region is activated AND a map view is selected, 
// the view may open different regions to draw the airspaces. Thereby the airspace,
// whose pointers are used in this dialog, may be closed.
// That would make the pointers invalid!!


extern CDimDoc*		ptDim;
extern CInitDoc* 	ptInit;  


CAirspaceDlg::CAirspaceDlg(CWnd* pParent, CAirspace* ptAirspace, BOOL bShowAirspace)
	: CDlgTool(CAirspaceDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CAirspaceDlg)
	m_fFreq = 0.0f;
	m_lUpperAlt = 0;
	m_lLowerAlt = 0;
	m_nRegIndex = -1;
	m_nListIndex = -1;
	m_nLevelIndex = -1;
	m_nFreqDimIndex = -1;
	m_nClassIndex = -1;
	m_nTypeIndex = -1;
	m_szName = _T("");
	m_nElevDim = -1;
	m_szCountryCode = _T("");
	m_lID = 0;
	m_bUserDefined = FALSE;
	//}}AFX_DATA_INIT

	m_ptDoc = NULL;
	m_ptAirspace = NULL;
	m_ptWayDoc = NULL;			// for importing airspace from route


	m_bShowAirspace = bShowAirspace;
	if (ptAirspace == NULL)		// m_bShowAirspace MUST be FALSE, if ptAirspace = NULL!!
	{
		m_bShowAirspace = FALSE;
	}
	else
	{		// ptAirspace points to memory allocated by CInteractiveMap::SearchMapAirspaces!!
		m_szRegionToShow = ptAirspace->GetRegionName();
		m_szIdentifierToShow = ptAirspace->GetIdentifier();
	}

	m_ptAirspaceRegionsDoc = ptInit->GetAirspaceRegionsDocPtr();
}

CAirspaceDlg::~CAirspaceDlg()
{
	if (m_ptDoc != NULL)
	{
		delete m_ptDoc;
	}
}

/************************************************************************
 *  AirspaceDlg.cpp	  		S h o w A i r s p a c e O f f				*
 ************************************************************************/
void CAirspaceDlg::ShowAirspaceOff()
{
	m_bShowAirspace = FALSE;	// no longer use airspace selected from map
	this->DisableControl (IDC_ASCHANGE, FALSE);  
	this->DisableControl (IDC_ASDEL, FALSE);  
	this->DisableControl (IDOK, FALSE);
}

/************************************************************************
 *  AirspaceDlg.cpp	  		E n a b l e F o r E n t r y I n L i s t		*
 ************************************************************************/
void CAirspaceDlg::EnableForEntryInList(BOOL bEntryInList)
{
	if (bEntryInList)
	{
		this->DisableControl (IDC_ASCHANGE, FALSE);  
		this->DisableControl (IDC_ASDEL, FALSE);  
		this->DisableControl (IDC_ASSEGMENTS, FALSE);
	}
	else
	{			// all airspaces deleted:
		this->DisableControl (IDC_ASCHANGE, TRUE);  
		this->DisableControl (IDC_ASDEL, TRUE);  
		this->DisableControl (IDC_ASSEGMENTS, TRUE);
	}
}


void CAirspaceDlg::DoDataExchange(CDataExchange* pDX)
{
	this->ActivateDimGroups();

	CDlgTool::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAirspaceDlg)
	DDX_Freq(pDX, IDC_ASFREQ, m_fFreq);
	DDV_FreqOptional(pDX, m_fFreq, 108., 1750.);
	DDX_Alt(pDX, IDC_ASUPPER, m_lUpperAlt);
	DDV_AltOptional(pDX, m_lUpperAlt, -5000, 70000);
	DDX_Alt(pDX, IDC_ASLOWER, m_lLowerAlt);
	DDV_AltOptional(pDX, m_lLowerAlt, -5000, 70000);
	DDX_CBIndex(pDX, IDC_ASREGION, m_nRegIndex);
	DDX_LBIndex(pDX, IDC_ASLIST, m_nListIndex);
	DDX_CBIndex(pDX, IDC_ASLEVEL, m_nLevelIndex);
	DDX_CBIndex(pDX, IDC_ASFREQDIM, m_nFreqDimIndex);
	DDX_CBIndex(pDX, IDC_ASCLASS, m_nClassIndex);
	DDX_CBIndex(pDX, IDC_ASTYPE, m_nTypeIndex);
	DDX_Text(pDX, IDC_ASNAME, m_szName);
	DDX_CBIndex(pDX, IDC_ASELEVDIM, m_nElevDim);
	DDX_Text(pDX, IDC_ASCC, m_szCountryCode);
	DDX_Text(pDX, IDC_ASIDENT, m_lID);
	DDX_Check(pDX, IDC_ASUSER, m_bUserDefined);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CAirspaceDlg, CDlgTool)
	//{{AFX_MSG_MAP(CAirspaceDlg)
	ON_BN_CLICKED(IDC_ASSEGMENTS, OnEditSegments)
	ON_BN_CLICKED(IDC_ASINS, OnInsert)
	ON_BN_CLICKED(IDC_ASCHANGE, OnChange)
	ON_BN_CLICKED(IDC_ASDEL, OnDelete)
	ON_BN_CLICKED(IDOK, OnDone)
	ON_LBN_SELCHANGE(IDC_ASLIST, OnSelChangeList)
	ON_CBN_SELCHANGE(IDC_ASREGION, OnSelChangeRegion)
	ON_LBN_DBLCLK(IDC_ASLIST, OnDblclkList)
	ON_WM_HELPINFO()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/************************************************************************
 *  AirspaceDlg.cpp	  		 	F i l l R e g i o n P U					*
 ************************************************************************/
void CAirspaceDlg::FillRegionPU()
{

	CComboBox* ptComboRegion = (CComboBox*)GetDlgItem (IDC_ASREGION);	
	short nCnt = m_ptAirspaceRegionsDoc->GetCnt();

	for (int i=0; i<nCnt; i++)
	{
		CAirspaceRegion* ptAirspaceRegion = NULL;
		if (m_ptAirspaceRegionsDoc->GetAirspaceRegionPtr(i, &ptAirspaceRegion))
		{
			CString szName = ptAirspaceRegion->GetName();
			ptComboRegion->AddString((LPCTSTR)szName);
		}
	}
	

	if (nCnt > 0)
	{	        									// set actual region
		if (m_szActRegion.GetLength() > 0)
		{
			m_nRegIndex = ptComboRegion->FindString (-1, (LPCTSTR)m_szActRegion);
		}
		else 
		{
			m_nRegIndex = 0;
			ptComboRegion->GetLBText(m_nRegIndex, m_szActRegion);
		}
	}	

}		

/************************************************************************
 *  AirspaceDlg.cpp	  			 G e t L i s t E n t r y				*
 ************************************************************************/
CString CAirspaceDlg::GetListEntry(CAirspace* ptAirspace)
{
	CString szListEntry = ptAirspace->GetDisplayName();
	szListEntry += "   (";
	szListEntry += ptAirspace->GetIdentifier();
	szListEntry += ")";

	return szListEntry;
}

/************************************************************************
 *  AirspaceDlg.cpp	  		 I n s e r t L i s t E n t r y 				*
 *  Adds new list entry to list and										*
 *  adds new ptAirspace to m_ListObjects								*
 ************************************************************************/
short CAirspaceDlg::InsertListEntry(CAirspace* ptAirspace) 
{	
	short nListIndex = -1;

	CListBox* ptList = (CListBox*)GetDlgItem (IDC_ASLIST);    

	CString szListEntry;
	szListEntry = GetListEntry(ptAirspace);

	m_ListObjects.SetAt(szListEntry, ptAirspace);
	nListIndex = ptList->AddString((LPCTSTR)szListEntry);  

	return nListIndex;
}

/************************************************************************
 *  AirspaceDlg.cpp	  		 	C h a n g e L i s t E n t r y 			*
 *  If list entry has changed, the list entry will be updated			*
 ************************************************************************/
short CAirspaceDlg::ChangeListEntry(CAirspace* ptAirspace) 
{
	short nListIndex	= m_nListIndex;
	int nOldIndex		= m_nListIndex;

	CListBox* ptList = (CListBox*)GetDlgItem (IDC_ASLIST);    
	CString szOldListEntry;		// get old list entry from list
	ptList->GetText(nOldIndex, szOldListEntry);


	CString szListEntry;		// get new list entry from airspace
	szListEntry = GetListEntry(ptAirspace);

	if (szListEntry.CompareNoCase((LPCTSTR)szOldListEntry) != 0)
	{                			// change listbox entry	
		ptList->DeleteString(nOldIndex);
		m_ListObjects.RemoveKey(szOldListEntry);	// CAirspaceSegment* will be used with new key

		m_ListObjects.SetAt(szListEntry, ptAirspace);
		nListIndex = ptList->AddString((LPCTSTR)szListEntry);  
	}  

	return nListIndex;
}


/************************************************************************
 *  AirspaceDlg.cpp	  		 D e l e t e L i s t E n t r y 				*
 *  gets text to be deleted from list,									*
 *  removes pointer to already deleted memory from m_ListObjects		*
 *  and deletes old entry from list										*
 ************************************************************************/
void CAirspaceDlg::DeleteListEntry(short nListIndex) 
{
	CListBox* ptList = (CListBox*)GetDlgItem (IDC_ASLIST);    

	CString szListEntry;
	ptList->GetText(nListIndex, szListEntry);

	m_ListObjects.RemoveKey(szListEntry);	// CAirspace* must be already deleted
	ptList->DeleteString(nListIndex);
}

/************************************************************************
 *  AirspaceDlg.cpp	  			 F i l l L i s t 						*
 ************************************************************************/
short CAirspaceDlg::FillList ()
{
	CListBox* ptList = (CListBox*)GetDlgItem (IDC_ASLIST);    
	ptList->ResetContent();
	m_ListObjects.RemoveAll();

	CString szText;
	short i;
	for (i=0; i<m_ptDoc->GetAirspaceCnt(); i++)
	{      
		CAirspace* ptAirspace = NULL;
		if (m_ptDoc->GetAirspacePtr (i, &ptAirspace))
		{
			CString szListEntry = GetListEntry(ptAirspace);

			m_ListObjects.SetAt(szListEntry, ptAirspace);
			ptList->AddString((LPCTSTR)szListEntry);  
		}
	}

	if (m_ptDoc->GetAirspaceCnt() > 0)
	{
		m_nListIndex = 0;
		if (m_bShowAirspace)
		{
			CString szListEntry = GetListEntry(m_ptAirspace);
			m_nListIndex = ptList->FindString (-1, (LPCTSTR)szListEntry);
		}
	}
	else 
	{
		m_nListIndex = -1;
	}

	ptList->SetCurSel(m_nListIndex);
	return m_nListIndex;
}   


/************************************************************************
 *  AirspaceDlg.cpp	  		 	F i l l T y p e P U 					*
 ************************************************************************/
void CAirspaceDlg::FillTypePU ()
{      
	CComboBox* ptType = (CComboBox*)GetDlgItem (IDC_ASTYPE);

	CString szText;
	short i;

	for (i=IDS_ASPTYPE01; i<=IDS_ASPTYPE12; i++)
	{
		szText.LoadString (i);  
		ptType->AddString((LPCTSTR)szText);  
	}
} 

/************************************************************************
 *  AirspaceDlg.cpp	  		 	F i l l C l a s s P U 					*
 ************************************************************************/
void CAirspaceDlg::FillClassPU ()
{      
	CComboBox* ptClass = (CComboBox*)GetDlgItem (IDC_ASCLASS);

	CString szText;
	short i;

	for (i=IDS_ASPCLASS01; i<=IDS_ASPCLASS08; i++)
	{
		szText.LoadString (i);  
		ptClass->AddString((LPCTSTR)szText);  
	}
} 

/************************************************************************
 *  AirspaceDlg.cpp	  		 	F i l l L e v e l P U 					*
 ************************************************************************/
void CAirspaceDlg::FillLevelPU ()
{      
	CComboBox* ptLevel = (CComboBox*)GetDlgItem (IDC_ASLEVEL);

	CString szText;
	short i;

	for (i=IDS_ASPLEVEL01; i<=IDS_ASPLEVEL03; i++)
	{
		szText.LoadString (i);  
		ptLevel->AddString((LPCTSTR)szText);  
	}
} 


/////////////////////////////////////////////////////////////////////////////
// Behandlungsroutinen fr Nachrichten CAirspaceDlg 
BOOL CAirspaceDlg::OnInitDialog() 
{
	m_ptDoc = new CAirspaceDoc;		// airspaces copied for dlg

	CAirspaceDoc* ptSrcDoc = NULL;	// airspaces from data base

	if (m_bShowAirspace && m_szActRegion.CompareNoCase(m_szRegionToShow) != 0)
	{		// airspace to edit is not in actual region!!
		ptSrcDoc = m_ptAirspaceRegionsDoc->GetDocument(m_szRegionToShow);
	}
	else
	{				// get current airspace region

		ptSrcDoc = m_ptAirspaceRegionsDoc->GetDocument();
		if (ptSrcDoc == NULL)
		{									// act airspace regions index yet not defined
			short nAspCnt = m_ptAirspaceRegionsDoc->GetCnt();
			BOOL bFound = FALSE;
			short nTestIndex = 0;			// try first airspcae region of index
			do
			{
				if (nAspCnt > 0)
				{
					m_ptAirspaceRegionsDoc->SetActIndex(nTestIndex);
					ptSrcDoc = m_ptAirspaceRegionsDoc->GetDocument();
					if(ptSrcDoc != NULL)
					{								// file of airspace selected is availble
						bFound = TRUE;
					}
					else
					{								// file of airspace selected is missing!!!
						CString szMsg;
						CString szRegion = m_ptAirspaceRegionsDoc->IndexToName(nTestIndex);
						szMsg.Format(IDF_MISSING_RGN, (LPCTSTR)szRegion);
						AfxMessageBox (szMsg, MB_OK);
						
										// airspace deleted form airspace folder, try next one
						m_ptAirspaceRegionsDoc->DeleteAirspaceRegion(nTestIndex);
						nAspCnt--;
					}
				}
			} while (nAspCnt > 0 && !bFound);
		}
	}

	if (ptSrcDoc != NULL)
	{
		*m_ptDoc = *ptSrcDoc;		// copy data base to dlg

		if (m_bShowAirspace)
			m_ptDoc->GetAirspacePtr(m_szIdentifierToShow, &m_ptAirspace);

		m_szActRegion = m_ptDoc->GetActRegionName();


		this->FillRegionPU();		// defines m_szActRegion, if not already defined

		m_nListIndex = FillList();
		EnableForEntryInList(m_nListIndex >= 0);
	}

	FillTypePU();
	FillClassPU();
	FillLevelPU();

	this->AddDimGroup (IDC_ASFREQ, IDC_ASFREQDIM);

	this->AddDimGroup (IDC_ASUPPER, IDC_ASELEVDIM);
	this->AddDimGroup (IDC_ASLOWER, IDC_ASELEVDIM);
      
	this->FillDimPU (IDC_ASFREQDIM, FREQ);
	this->FillDimPU (IDC_ASELEVDIM, ALTITUDE);

	CDlgTool::OnInitDialog();
	
	// TODO: Zustzliche Initialisierung hier einfgen
	SetSelectedData(m_nListIndex);	// set initial values 

	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX-Eigenschaftenseiten sollten FALSE zurckgeben
}


/************************************************************************
 *  AirspaceDlg.cpp	  		 	O n E d i t S e g m e n t s				*
 *  Segment editor gets its own array of segments to edit				*
 ************************************************************************/
void CAirspaceDlg::OnEditSegments() 
{
	// TODO: Code fr die Behandlungsroutine der Steuerelement-Benachrichtigung hier einfgen

								// get parameters for AirspaceSegmentDlg constructor	
	CAirspaceSegmentDoc* ptAspDlgDoc = m_ptDoc->GetSegmentDocPtr();
	long lStartIndex = m_ptAirspace->GetFirstSegmentIndex();



	CAirspaceSegmentDoc* ptAspSegDlgDoc = new CAirspaceSegmentDoc;
	*ptAspSegDlgDoc = *ptAspDlgDoc;		// copy AirspaceDlg segment doc to 
										// AirspaceSegmentDlg segment doc

	CAirspaceSegmentDlg AirspaceSegmentDlg(this, ptAspSegDlgDoc, 
							m_ptAirspace->GetDisplayName(), 
							m_ptAirspace->GetIdentifier(), 
							lStartIndex);

				// for importing airspace from route
	AirspaceSegmentDlg.SetWayDocPtr(m_ptWayDoc);

	int RetVal = AirspaceSegmentDlg.DoModal();

	switch (RetVal)
	{
	case IDOK:
		if (ptAspSegDlgDoc->IsModified())
		{
			*ptAspDlgDoc = *ptAspSegDlgDoc;	// copy AirspaceSegmentDlg segment doc
											// to AirspaceDlg segment doc
			ptAspDlgDoc->SetModifiedFlag(TRUE);
											// update border and index of AirspaceDlg doc
			m_ptDoc->UpdateSegmentBorderAndIndex(ptAspDlgDoc);
		}
 		break;
	case IDCANCEL: 
		break;
	}

	if (ptAspSegDlgDoc != NULL)
	{
		delete ptAspSegDlgDoc;
	}
}


/************************************************************************
 *  AirspaceDlg.cpp	  			 	O n I n s e r t						*
 ************************************************************************/
void CAirspaceDlg::OnInsert() 
{
	CAirspace* ptAirspace = new CAirspace;
	if(this->GetData(ptAirspace))
	{			// get new entry

		CListBox* ptList = (CListBox*)GetDlgItem (IDC_ASLIST);  
		
		long lID = m_ptDoc->GetNewAirspaceID(m_szCountryCode);
		ptAirspace->SetID(lID);

						// store new airspace in doc
		if (m_ptDoc->AddSortedAirspacePtr(ptAirspace))
		{
			m_ptDoc->SetModifiedFlag(TRUE);

			m_nListIndex = InsertListEntry(ptAirspace);
			ptList->SetCurSel(m_nListIndex); // move selection on new entry
						// m_ptAirspace yet points on selected airspace
			SetSelectedData(m_nListIndex);
						// now m_ptAirspace points on new segment!
			EnableForEntryInList(m_nListIndex >= 0);
		}
	}
	else
	{		// data not valid, delete airspace segment
		delete ptAirspace;
	}
}

/************************************************************************
 *  AirspaceDlg.cpp				O n C h a n g e							*
 ************************************************************************/
void CAirspaceDlg::OnChange() 
{
	// TODO: Code fr die Behandlungsroutine der Steuerelement-Benachrichtigung hier einfgen
	if (m_bShowAirspace)
		this->ShowAirspaceOff();

	if (m_ptAirspace != NULL)
	{
		CAirspace Airspace(*m_ptAirspace);	// use copy constructor to get calculated members
		if(this->GetData(&Airspace))
		{
			if (Airspace != *m_ptAirspace)
			{		// to change record, update content of m_ptAirspace
				CListBox* ptList = (CListBox*)GetDlgItem (IDC_ASLIST);  

				*m_ptAirspace = Airspace;
				m_ptDoc->SetModifiedFlag(TRUE);

				m_nListIndex = ChangeListEntry(m_ptAirspace);
				ptList->SetCurSel(m_nListIndex); // move selection on changed entry
			}
		}
	}	
}

void CAirspaceDlg::OnDelete() 
{	
					// delete all segments of selected airspace
	CAirspaceSegmentDoc* ptSegDoc = m_ptDoc->GetSegmentDocPtr();
	int nSegCnt = m_ptAirspace->GetSegmentCnt();
	if (nSegCnt > 0)
	{
		long lStartIndex = m_ptAirspace->GetFirstSegmentIndex();

		for (int i=0; i<nSegCnt; i++)
		{						// always delete entry at start index
			ptSegDoc->DeleteAirspaceSegmentPtr((short)lStartIndex);
		}
		ptSegDoc->SetModifiedFlag(TRUE);

									// update border and index of AirspaceDlg doc
		m_ptDoc->UpdateSegmentBorderAndIndex(ptSegDoc);
	}



	CString szIdentifier = m_ptAirspace->GetIdentifier();
	if (m_ptDoc->DeleteAirspacePtr(szIdentifier))
	{					// CAirspace deleted from doc
		m_ptDoc->SetModifiedFlag(TRUE);
						// remove entry from list
		CListBox* ptList = (CListBox*)GetDlgItem (IDC_ASLIST);  
		short nSelIndex = ptList->GetCurSel ();	
		DeleteListEntry(nSelIndex);

						// set new list entry
		if (nSelIndex > 0)
			nSelIndex--;
		if (nSelIndex == m_ListObjects.GetCount())
			nSelIndex--;

			// m_ptAirspace yet points on selected segment
		if (nSelIndex >=0 && nSelIndex < m_ListObjects.GetCount())
		{				// now selection points to next entry
			m_nListIndex = nSelIndex;
			SetSelectedData(nSelIndex);
					// now m_ptAirspaceSegment points on next segment!
		}
		else
		{			// all entries deleted
			m_nListIndex = -1;
			m_ptAirspace=NULL;

			m_fFreq = NO_FREQ;
			m_nFreqDimIndex = DIM_MHZ;
			m_nTypeIndex = CAirspace::NO_TYPE;
			m_nClassIndex = CAirspace::NO_CLASS;
			m_nLevelIndex = CAirspace::NO_LEVEL;
			m_lUpperAlt = NO_ALT;
			m_lLowerAlt = NO_ALT;
			m_nElevDim = DIM_FEET;
			m_szName.Empty();
			m_lID = 0;
			m_bUserDefined = FALSE;

			this->UpdateData(FALSE);

			EnableForEntryInList(FALSE);
		}
	}
}

/************************************************************************
 *  AirspaceDlg.cpp	 				D o S a v e							*
 *  if dlg documents are modified, 										*
 *  dlg content will be copied to data base and written to file			*												*
 *  IsModified must be checked on dlg documents, because operator=		*
 *	doesn't copy that flag!												*
 ************************************************************************/
void CAirspaceDlg::DoSave(CAirspaceDoc* ptAspDoc, CAirspaceSegmentDoc* ptAspSegDoc)
{
	CString szFileExt;		// ask only once:
	BOOL bDoSave = FALSE;

							// ask to save airspace segment doc
	if(ptAspSegDoc->IsModified())
		szFileExt = ptAspSegDoc->GetTitle();
	
	if (szFileExt.IsEmpty())
	{						// ask to save airspace doc
		if (ptAspDoc->IsModified())
			szFileExt = ptAspDoc->GetTitle();
	}

	if (!szFileExt.IsEmpty())
	{				// only ask, if something was changed!!
		CString szText;
		szText.Format(IDF_SAVE_FILE, (LPCTSTR)szFileExt);
		bDoSave = (AfxMessageBox ((LPCSTR)szText, MB_YESNO) == IDYES);
	}


	if (bDoSave)
	{
		CAirspaceDoc* ptSrcDoc = m_ptAirspaceRegionsDoc->GetDocument(m_szActRegion);
		*ptSrcDoc = *ptAspDoc;		// copy dlg content to data base											
		
		if(ptAspDoc->IsModified())
			ptSrcDoc->SetModifiedFlag(TRUE);	// mark data base airspaces as modified
	
		if (ptAspSegDoc->IsModified())
		{
			CAirspaceSegmentDoc* ptSrcSegDoc = ptSrcDoc->GetSegmentDocPtr();
			ptSrcSegDoc->SetModifiedFlag(TRUE);	// mark data base segments as modified
		}

		BOOL bConfirm = FALSE;			// user has already been asked
		m_ptAirspaceRegionsDoc->Save(bConfirm);
	}
	ptAspDoc->SetModifiedFlag(FALSE);
	ptAspSegDoc->SetModifiedFlag(FALSE);
}

/************************************************************************
 *  AirspaceDlg.cpp	 				O n D o n e							*
 ************************************************************************/
void CAirspaceDlg::OnDone() 
{
	if (m_ptAirspace != NULL)
	{
		CAirspace Airspace(*m_ptAirspace);	// use copy constructor to get calculated members
		if(this->GetData(&Airspace))
		{	
			if (Airspace != *m_ptAirspace)
			{		// to change record, update content of m_ptAirspaceSegment
				*m_ptAirspace = Airspace;
				m_ptDoc->SetModifiedFlag(TRUE);

				m_nListIndex = ChangeListEntry(m_ptAirspace);		
			}

		}	
	}


	CAirspaceSegmentDoc* ptDlgSegmentDoc = m_ptDoc->GetSegmentDocPtr();
	if (ptDlgSegmentDoc->IsModified() || m_ptDoc->IsModified())
	{			
		this->DoSave(m_ptDoc, ptDlgSegmentDoc);						
		CDialog::OnOK();
	}
	else
	{
		CDialog::OnCancel();
	}

}


/************************************************************************
 *  AirspaceDlg.cpp			G e t S e l e c t e d O b j e c t			*
 *  returns object pointer from m_ListObjects or NULL,					*
 *  if nListIndex is out of range										*
 ************************************************************************/
CAirspace* CAirspaceDlg::GetSelectedObject(short nListIndex)
{
	CAirspace* ptAirspace = NULL;
	CListBox* ptList = (CListBox*)GetDlgItem (IDC_ASLIST);    

	if (nListIndex >= 0 && nListIndex < ptList->GetCount())
	{
		CString szListEntry;
		ptList->GetText(nListIndex, szListEntry);
		if (szListEntry.GetLength() > 0)
		{
			ptAirspace = (CAirspace*)this->m_ListObjects[szListEntry];
		}
	}

	return ptAirspace;
}

/************************************************************************
 *  AirspaceDlg.cpp	 		S e t S e l e c t e d D a t a	 			*
 *  Stores pointer of selected object in m_ptAirspace					*
 *  and uptates dialog items											*
 ************************************************************************/
BOOL CAirspaceDlg::SetSelectedData(short nListIndex)
{
	BOOL bNewDataSet = FALSE;
		// to select a new record, store new pointer in m_ptAirspace
	m_ptAirspace = GetSelectedObject(nListIndex); 
	if (m_ptAirspace != NULL)
	{
		SetData(m_ptAirspace);
		bNewDataSet = TRUE;
	}
	return bNewDataSet;
}

/************************************************************************
 *  AirspaceDlg.cpp	  		 	S e t D a t a		 					*
 ************************************************************************/
void CAirspaceDlg::SetData(CAirspace* ptAirspace)
{
	m_szCountryCode = ptAirspace->GetCountryCode();
	m_lID			= ptAirspace->GetID();

	m_szName = ptAirspace->GetName();

	float fFreq;
	short nFreqDim;
	m_ptAirspace->GetFrequency(&fFreq, &nFreqDim);
	m_fFreq = fFreq;
	m_nFreqDimIndex = ptDim->GetPUIndex(FREQ, nFreqDim);

	m_lUpperAlt = ptAirspace->GetUpperAlt();
	m_lLowerAlt = ptAirspace->GetLowerAlt();

	m_nTypeIndex = -1;
	m_nClassIndex= -1;
	m_nLevelIndex= -1;

	if (ptAirspace->GetType() != CAirspace::NO_TYPE)
		m_nTypeIndex = (int)ptAirspace->GetType();
	if (ptAirspace->GetClass() != CAirspace::NO_CLASS)
		m_nClassIndex = (int)ptAirspace->GetClass();
	if (ptAirspace->GetLevel() != CAirspace::NO_LEVEL)
		m_nLevelIndex = (int)ptAirspace->GetLevel();

	m_nElevDim = ptDim->GetPUIndex (ALTITUDE, ptAirspace->GetElevDim());

	m_bUserDefined = ptAirspace->IsUserDefined();

	UpdateData(FALSE);
}

/************************************************************************
 *  AirspaceDlg.cpp	  		 	G e t D a t a		 					*
 ************************************************************************/
BOOL CAirspaceDlg::GetData(CAirspace* ptAirspace)
{
	BOOL bOK = FALSE;

	if (this->UpdateData(TRUE))
	{
		ptAirspace->SetCountryCode(m_szCountryCode);
		ptAirspace->SetID (m_lID);

		ptAirspace->SetName(m_szName);

		ptAirspace->SetFrequency(m_fFreq, ptDim->GetPUDim (FREQ, m_nFreqDimIndex));

		ptAirspace->SetUpperAlt(m_lUpperAlt);
		ptAirspace->SetLowerAlt(m_lLowerAlt);

		ptAirspace->SetType(CAirspace::NO_TYPE);
		ptAirspace->SetClass(CAirspace::NO_CLASS);
		ptAirspace->SetLevel(CAirspace::NO_LEVEL);

		if (m_nTypeIndex > -1)
			ptAirspace->SetType((CAirspace::TYPE)m_nTypeIndex);
		if (m_nClassIndex > -1)
			ptAirspace->SetClass((CAirspace::CLASS)m_nClassIndex);
		if (m_nLevelIndex > -1)
			ptAirspace->SetLevel((CAirspace::LEVEL)m_nLevelIndex);

		ptAirspace->SetElevDim(ptDim->GetPUDim (ALTITUDE, m_nElevDim));

		ptAirspace->SetUserDefined(m_bUserDefined);

		bOK = TRUE;
	}
	return bOK;
}


/************************************************************************
 *  AirspaceDlg.cpp	  		 O n S e l C h a n g e R e g i o n 			*
 ************************************************************************/
void CAirspaceDlg::OnSelChangeRegion() 
{
	// TODO: Code fr die Behandlungsroutine der Steuerelement-Benachrichtigung hier einfgen
	CComboBox* ptComboRegion = (CComboBox*)GetDlgItem (IDC_ASREGION);
	short nNewIndex = ptComboRegion->GetCurSel();    

	if (m_nRegIndex != nNewIndex)
	{     
		BOOL bClearToChange = TRUE;

		if (m_ptAirspace != NULL)
		{
			CAirspace Airspace(*m_ptAirspace);	// use copy constructor to get calculated members
			if (this->GetData(&Airspace))
			{	
				if (Airspace != *m_ptAirspace)
				{		// to change record, update content of m_ptAirspace
					*m_ptAirspace = Airspace;
					m_ptDoc->SetModifiedFlag(TRUE);
				}
			}      
			else
			{					// data avail, but DDV_... returns false
				bClearToChange = FALSE;   
			}
		}

	
		CAirspaceSegmentDoc* ptDlgSegmentDoc = m_ptDoc->GetSegmentDocPtr();
		if (ptDlgSegmentDoc->IsModified() || m_ptDoc->IsModified())
		{			
			this->DoSave(m_ptDoc, ptDlgSegmentDoc);						
		}			

		if (bClearToChange)
		{
			CString szRegion;   

			short nAspCnt = m_ptAirspaceRegionsDoc->GetCnt();
			BOOL bFound = FALSE;
			do
			{
				ptComboRegion->GetLBText (nNewIndex, szRegion); 
				CAirspaceDoc* ptSrcDoc = m_ptAirspaceRegionsDoc->GetDocument(szRegion);
				if(ptSrcDoc != NULL)
				{								// file of airspace selected is availble
					*m_ptDoc = *ptSrcDoc;		// copy data base to dlg content
					m_szActRegion = m_ptDoc->GetActRegionName();
					bFound = TRUE;
				}
				else
				{								// file of airspace selected is missing!!!
					CString szMsg;
					szMsg.Format(IDF_MISSING_RGN, (LPCTSTR)szRegion);
					AfxMessageBox (szMsg, MB_OK);
					
									// airspace deleted form airspace folder, try next one
					ptComboRegion->DeleteString(nNewIndex);	// remove from combobox
					m_ptAirspaceRegionsDoc->DeleteAirspaceRegion(szRegion);
					nAspCnt--;
					if (nNewIndex == nAspCnt)
						nNewIndex--;
				}
			} while (nAspCnt > 0 && !bFound);

			if (bFound)
			{
				m_nRegIndex 	= nNewIndex;

				m_nListIndex	= this->FillList ();
				SetSelectedData(m_nListIndex);	// set initial values 
				EnableForEntryInList(m_nListIndex >= 0);
			}
		}    
		else
		{				// bad input, reset selection to bad entry 
			ptComboRegion->SetCurSel (m_nRegIndex);
		}
	}
}
	

/************************************************************************
 *  AirspaceDlg.cpp	  		 	O n S e l C h a n g e L i s t 			*
 ************************************************************************/
void CAirspaceDlg::OnSelChangeList() 
{
	CListBox* ptList = (CListBox*)GetDlgItem (IDC_ASLIST);    
	short nNewIndex = ptList->GetCurSel ();
	
	if (m_nListIndex != nNewIndex)
	{
		if (m_ptAirspace != NULL)
		{
			short nOldIndex = m_nListIndex;

			CAirspace Airspace(*m_ptAirspace);	// use copy constructor to get calculated members
			if (this->GetData(&Airspace))
			{	
				if (Airspace != *m_ptAirspace)
				{		// to change record, update CONTENT of m_ptAirspace, NOT pointer!!
					*m_ptAirspace = Airspace;
					m_ptDoc->SetModifiedFlag(TRUE);
				}

						// show selected entry
				if (SetSelectedData(nNewIndex))
					m_nListIndex = nNewIndex;
			}      
			else
			{				// bad input, reset selection to bad entry 
				ptList->SetCurSel (nOldIndex);	
				m_nListIndex = nOldIndex;
			}	
		}
	}
	else
	{					// show selected entry without saving current record (UNDO)
		SetSelectedData(nNewIndex);
	}
}

/************************************************************************
 *  AirspaceDlg.cpp				O n D b l c l k L i s t					*
 ************************************************************************/
void CAirspaceDlg::OnDblclkList() 
{
	// TODO: Code fr die Behandlungsroutine der Steuerelement-Benachrichtigung hier einfgen
	CListBox* ptList = (CListBox*)GetDlgItem (IDC_ASLIST);    
	short nNewIndex = ptList->GetCurSel ();

	if (nNewIndex >= 0)
	{	
		this->OnEditSegments();
	}
}

/************************************************************************
 *  AirspaceDlg.cpp	  			 O n H e l p I n f o					*
 ************************************************************************/
BOOL CAirspaceDlg::OnHelpInfo(HELPINFO* pHelpInfo) 
{
	// TODO: Add your message handler code here and/or call default
	
if (pHelpInfo->iContextType == HELPINFO_WINDOW)
	{
	AfxGetApp()->WinHelp (pHelpInfo->dwContextId, HELP_CONTEXTPOPUP);
	}

return TRUE;
}
