#if !defined(AFX_AIRSPACEDLG_H__21CA5521_E74A_4150_946B_C5C1E3D05CDA__INCLUDED_)
#define AFX_AIRSPACEDLG_H__21CA5521_E74A_4150_946B_C5C1E3D05CDA__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// AirspaceDlg.h : Header-Datei
//
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "DlgTool.h"

/////////////////////////////////////////////////////////////////////////////
// Dialogfeld CAirspaceDlg 

class CAirspaceRegionsDoc;
class CAirspaceDoc;
class CWayDoc;
class CAirspaceDlg : public CDlgTool
{
// Konstruktion
public:
	CAirspaceDlg(CWnd* pParent = NULL, CAirspace* ptAirspace = NULL, 
									BOOL bShowAirspace=FALSE);   // Standardkonstruktor
	~CAirspaceDlg();                                                

// Dialogfelddaten
	//{{AFX_DATA(CAirspaceDlg)
	enum { IDD = IDD_AIRSPACE };
	float	m_fFreq;
	long	m_lUpperAlt;
	long	m_lLowerAlt;
	int		m_nRegIndex;
	int		m_nListIndex;
	int		m_nLevelIndex;
	int		m_nFreqDimIndex;
	int		m_nClassIndex;
	int		m_nTypeIndex;
	CString	m_szName;
	int		m_nElevDim;
	CString	m_szCountryCode;
	long	m_lID;
	BOOL	m_bUserDefined;
	//}}AFX_DATA

public:
					// for importing airspace from route
	void SetWayDocPtr(CWayDoc* ptWayDoc) { m_ptWayDoc = ptWayDoc; }	

private:
	CString			m_szIdentifierToShow;
	CString			m_szRegionToShow;

	CAirspaceDoc* 	m_ptDoc;
	CAirspace*		m_ptAirspace;
	BOOL			m_bShowAirspace;
	CString			m_szActRegion;
	CMapStringToOb	m_ListObjects;
	CAirspaceRegionsDoc*	m_ptAirspaceRegionsDoc;
	CWayDoc*		m_ptWayDoc;




// berschreibungen
	// Vom Klassen-Assistenten generierte virtuelle Funktionsberschreibungen
	//{{AFX_VIRTUAL(CAirspaceDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV-Untersttzung
	//}}AFX_VIRTUAL

// Implementierung
private:
	void ShowAirspaceOff();
	void EnableForEntryInList(BOOL bEntryInList);
	CString GetListEntry(CAirspace* ptAirspace);
	short InsertListEntry(CAirspace* ptAirspace);
	short ChangeListEntry(CAirspace* ptAirspace);
	void DeleteListEntry(short nListIndex);
	void FillRegionPU();
	short FillList();
	void FillTypePU();
	void FillClassPU();
	void FillLevelPU();
	CAirspace* GetSelectedObject(short nListIndex);
	BOOL SetSelectedData(short nListIndex);
	void SetData(CAirspace* ptAirspace);
	BOOL GetData(CAirspace* ptAirspace);
	void DoSave(CAirspaceDoc* ptAspDoc, CAirspaceSegmentDoc* ptAspSegDoc);


protected:

	// Generierte Nachrichtenzuordnungsfunktionen
	//{{AFX_MSG(CAirspaceDlg)
	afx_msg void OnEditSegments();
	afx_msg void OnInsert();
	afx_msg void OnChange();
	afx_msg void OnDelete();
	virtual BOOL OnInitDialog();
	afx_msg void OnDone();
	afx_msg void OnSelChangeList();
	afx_msg void OnSelChangeRegion();
	afx_msg void OnDblclkList();
	afx_msg BOOL OnHelpInfo(HELPINFO* pHelpInfo);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ fgt unmittelbar vor der vorhergehenden Zeile zustzliche Deklarationen ein.

#endif // AFX_AIRSPACEDLG_H__21CA5521_E74A_4150_946B_C5C1E3D05CDA__INCLUDED_
