#if !defined(AFX_AIRSPACEDOC_H__5DE7A7C8_3651_4290_9A87_54AC47D574D9__INCLUDED_)
#define AFX_AIRSPACEDOC_H__5DE7A7C8_3651_4290_9A87_54AC47D574D9__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// AirspaceDoc.h : Header-Datei
//
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "Airspace.h"
#include "AirspaceSegmentDoc.h"			// used for UpdateSegmentBorderAndIndex
#include "LatLon.h"						// DRECT

/////////////////////////////////////////////////////////////////////////////
// Dokument CAirspaceDoc 

#define ASD_xxx1		 	1
#define ASD_xxx2			2
#define ASD_ANTIPOD		4

typedef struct
	{
	char szVersion[14];
	unsigned char cFlags;
	unsigned char cDummy;
	short	nActIndex;
	short	nEntryCnt;
	} AIRSPACEHEADER;


class CAirspaceDoc : public CDocument
{
public:
	CAirspaceDoc();


protected:
	           // Dynamische Erstellung verwendet geschtzten Konstruktor
	DECLARE_DYNCREATE(CAirspaceDoc)


// Attribute
private:
	#define MAX_HEADER_SIZE 20
	#define ASP_SEGMENT_DATA_VALID 1

    AIRSPACEHEADER	m_Header;     
	CObArray		m_Airspaces;             
 	BOOL			m_bConverted;
	CString			m_szExt;
	BOOL			m_bOpenSubDocuments;

	double	m_dMaxLat1;		// top left edge
	double	m_dMinLon1;
	double	m_dMinLat1;		// bottom right edge
	double	m_dMaxLon1;

	CAirspaceSegmentDoc*	m_ptSegmentDoc;

// Operationen
public:
	void NoSubDocuments () { m_bOpenSubDocuments = FALSE; }	// call before OpenDocument

	static CString GetExt();
	CAirspaceSegmentDoc* GetSegmentDocPtr() { return m_ptSegmentDoc; }
	CString GetActRegionName ();

	const CAirspaceDoc& operator=(const CAirspaceDoc& AspDoc);
	short GetSortedIndex (CObArray& Airspaces, CAirspace* ptAirspace);
	short IdentifierToIndex (CString szIdentifier);
	BOOL AddSortedAirspacePtr (CAirspace* ptAirspace);
	BOOL GetAirspacePtr (short nIndex, CAirspace** ptptAirspace);
	BOOL GetAirspacePtr (CString szIdentifier, CAirspace** ptptAirspace);
	BOOL DeleteAirspacePtr (short nIndex);
	BOOL DeleteAirspacePtr (CString szIdentifier);
	CLatLon GetMaxSegmentCenter(CAirspace* ptAirspace, long lStartIndex, double* ptMaxSegCourse);
	
	virtual void DeleteContents();

	void SetAntipod(BOOL bAntipod);
	BOOL IsAntipod(void);

	short GetActIndex() { return m_Header.nActIndex; }
	short GetAirspaceCnt () { return m_Header.nEntryCnt; }

	void SetMaxLat(double dLat) { m_dMaxLat1 = dLat; }
	double GetMaxLat() { return m_dMaxLat1; }

	void SetMinLon(double dLon) { m_dMinLon1 = dLon; }
	double GetMinLon() { return m_dMinLon1; }

	void SetMinLat(double dLat) { m_dMinLat1 = dLat; }
	double GetMinLat() { return m_dMinLat1; }

	void SetMaxLon(double dLon) { m_dMaxLon1 = dLon; }
	double GetMaxLon() { return m_dMaxLon1; }

	void SetActIndex(short nIndex) { m_Header.nActIndex = nIndex; }
	void SetAirspaceCnt (short nCnt) { m_Header.nEntryCnt = nCnt; }

	void SetSegmentDataValid(BOOL bValid);
	BOOL IsSegmentDataValid(void);

	void UpdateSegmentBorderAndIndex(CAirspaceSegmentDoc* ptAspSegDoc);
	BOOL GetAirspaceAt(double dLat, double dLon, CAirspace** ptptAirspace, 
								 short* ptNextAirspaceIndex);
	BOOL GetAirspaceInRect(DRECT rLatLon, CAirspace** ptptAirspace, 
						 short* ptNextRegIndex, short* ptNextAirspaceIndex);

	long GetNewAirspaceID(CString szCC);
	short CopyUserAirspaces(CAirspaceDoc* ptSourceDoc);


// berschreibungen
	// Vom Klassen-Assistenten generierte virtuelle Funktionsberschreibungen
	//{{AFX_VIRTUAL(CAirspaceDoc)
	public:
	virtual BOOL OnNewDocument();
	virtual BOOL OnOpenDocument(LPCTSTR lpszPathName);
	virtual BOOL OnSaveDocument(const char* pszPathName, BOOL bConfirm = TRUE);
	virtual void Serialize(CArchive& ar);   // berschrieben fr Dokument-Ein-/Ausgabe
	protected:
	//}}AFX_VIRTUAL


// Implementierung
public:
	virtual ~CAirspaceDoc();

#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif


private:
	void ExpandBorder(CAirspace* ptAirspace, BOOL bInit, 
								double dLat, double dLon);
	void CircleToPoly(CPolygon* ptPoly,
						 double dCenterX, double dCenterY, double dRad_NM);
	void ArcToPoly(CPolygon* ptPoly, double dStartX, double dStartY, 
						 double dEndX, double dEndY,
						 double dCenterX, double dCenterY, double dRad_NM, 
						 BOOL bClockWiseArc);
	CPolygon* CreatePolygonFor(CAirspace* ptAirspace);
	void OnInputDirectionFound(CAirspace* ptAirspace, BOOL* ptFirstAirspace, double dLastAirspaceMinLon,
									 short nSegmentCnt, int nInpDir);
	void ExpandBorder(CAirspace* ptAirspace, BOOL* ptFirstAirspaceOfDoc);
	BOOL TryToGetAirspacePtr(CAirspace** ptptAirspace, CString szIdentifier);
	void SetFlagBit (unsigned char* lpFlag, short BitMask, BOOL bSet);
	int Compare(CAirspace* ptTestEntry, CAirspace* ptNewEntry);
	int Compare(CAirspace* ptTestEntry, CString szIdentifier);
 	void DeleteArrayOf (CObArray* ptArray);
	short HeaderToVers (char* ptHeader);
	void VersToHeader (LPSTR lpHeader, short nVersion);
	void InitHeader ();

	// Generierte Nachrichtenzuordnungsfunktionen
protected:
	//{{AFX_MSG(CAirspaceDoc)
		// HINWEIS - Der Klassen-Assistent fgt hier Member-Funktionen ein und entfernt diese.
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ fgt unmittelbar vor der vorhergehenden Zeile zustzliche Deklarationen ein.

#endif // AFX_AIRSPACEDOC_H__5DE7A7C8_3651_4290_9A87_54AC47D574D9__INCLUDED_
