/************************************************************************
 *  						E l e v A r r a y . c p p	  				*
 ************************************************************************/
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "stdafx.h"
#include "math.h"					// floor
#include "pf.h"

#include "InitDoc.h"				// DRECT

#include "AirspaceRegion.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// CAirspaceRegion
// holds information about an airspace document, e.g. the bounding rect, the path...


IMPLEMENT_SERIAL(CAirspaceRegion, CObject, 0 /* schema number*/ )

/************************************************************************
 *  Elev.cpp			C A i r s p a c e R e g i o n		Constructor	*
 ************************************************************************/
CAirspaceRegion::CAirspaceRegion()
{ 
	this->Reset();
}

CAirspaceRegion::CAirspaceRegion(CAirspaceRegion& SourceAirspaceRegion)
{ 
*this = SourceAirspaceRegion;
}



/************************************************************************
 *  Elev.cpp			~ C A i r s p a c e R e g i o n	Destructor		*
 ************************************************************************/
CAirspaceRegion::~CAirspaceRegion()
{
	this->Close();
} 


/************************************************************************
 *  Elev.cpp				operator=									*
 ************************************************************************/
const CAirspaceRegion& CAirspaceRegion::operator=(const CAirspaceRegion& AirspaceRegion)
{
	m_szName			= AirspaceRegion.m_szName;
	m_szPath			= AirspaceRegion.m_szPath;
	m_bActivated		= AirspaceRegion.m_bActivated;
	m_bAntipod			= AirspaceRegion.m_bAntipod;

	m_dLonMin           = AirspaceRegion.m_dLonMin;
	m_dLonMax           = AirspaceRegion.m_dLonMax;
	m_dLatMax           = AirspaceRegion.m_dLatMax;
	m_dLatMin           = AirspaceRegion.m_dLatMin;

	m_nAirspaceCnt	= AirspaceRegion.m_nAirspaceCnt;
	m_ptAirspaceDoc	= NULL;

return *this;
}

/************************************************************************
 *  Elev.cpp					R e s e t								*
 ************************************************************************/
void CAirspaceRegion::Reset()
{
	m_szName			= "";
	m_szPath			= "";
	m_bActivated		= TRUE;
	m_bAntipod			= FALSE;

	m_dLonMin           = 0.00000000000;
	m_dLonMax           = 0.00000000000;
	m_dLatMax           = 0.00000000000;
	m_dLatMin           = 0.00000000000;

	m_nAirspaceCnt		= 0;
	m_ptAirspaceDoc		= NULL;
}




/************************************************************************
 *  AirspaceRegion.cpp		 	 S e r i a l i z e						*
 ************************************************************************/
void CAirspaceRegion::Serialize(CArchive& ar, short nVersion)
{ 

//	if (m_szName.CompareNoCase("Germany") == 0)
//		int a=1;

	if (ar.IsStoring())
	{					// TODO: add storing code here 
		ar << (WORD)nVersion;

		ar << m_szName;
		ar << m_szPath;			// path to *.spa file
		ar << m_bActivated;
		ar << m_bAntipod;

		ar << m_dLonMin;
		ar << m_dLonMax;
		ar << m_dLatMax;
		ar << m_dLatMin;

		ar << (WORD)m_nAirspaceCnt;
	}
	else
	{ 					// TODO: add loading code here    	  
		WORD	Word;
		ar >> Word;		nVersion = (short)Word;

 		if (nVersion == ACT_INI_VERS)
		{   
			ar >> m_szName;
			ar >> m_szPath;			// path to *.spa file
			ar >> m_bActivated;
			ar >> m_bAntipod;

			ar >> m_dLonMin;
			ar >> m_dLonMax;
			ar >> m_dLatMax;
			ar >> m_dLatMin;

			ar >> Word;		m_nAirspaceCnt = (short)Word;
		}
		else
		{
			this->Reset();
		}
	}
} 


/************************************************************************
 *  AirspaceRegion.cpp		 		I s E q u a l						*
 ************************************************************************/
BOOL CAirspaceRegion::IsEqual(const CAirspaceRegion& AirspaceRegion)
{ 
	if (m_szName.Compare(AirspaceRegion.m_szName) != 0) return FALSE;
	if (m_szPath.CompareNoCase(AirspaceRegion.m_szPath) != 0) return FALSE;
	if (m_bActivated != AirspaceRegion.m_bActivated) return FALSE;
	if (m_bAntipod != AirspaceRegion.m_bAntipod) return FALSE;

	if (m_dLonMin != AirspaceRegion.m_dLonMin) return FALSE;
	if (m_dLonMax != AirspaceRegion.m_dLonMax) return FALSE;
	if (m_dLatMax != AirspaceRegion.m_dLatMax) return FALSE;
	if (m_dLatMin != AirspaceRegion.m_dLatMin) return FALSE;

	if (m_nAirspaceCnt != AirspaceRegion.m_nAirspaceCnt) return FALSE;
	
return TRUE;
}      

/****************************************************************************
 *	AirspaceRegion.cpp				I s A n t i p o d 						*
 *  Purpose: returns TRUE, if airspace region shows right and left border of map *
 *				and right map side is > 180 degrees							*
 ****************************************************************************/
BOOL CAirspaceRegion::IsAntipod(DRECT rMap)
{
	BOOL bAntipod = FALSE;

	short nVis = 0;

	double dTestLon = rMap.left;
	if ((m_dLonMin <= dTestLon) && (dTestLon <= m_dLonMax))
		nVis++;

	dTestLon = rMap.right - 360;
	if ((m_dLonMin <= dTestLon) && (dTestLon <= m_dLonMax))
		nVis++;

	bAntipod = (nVis == 2);
 
	return bAntipod; 
} 


/************************************************************************
 *  AirspaceRegion.cpp  		G e t A i r s p a c e					*
 ************************************************************************/
BOOL CAirspaceRegion::GetAirspace (double fLat, double fLon, CAirspace* ptAirspace)
{	
	BOOL bFound = FALSE;



	return bFound;
}

/************************************************************************
 *  AirspaceRegion.cpp  	B o r d e r C o n t a i n s					*
 *  returns TRUE, if fLat fLon is within borders of this region			*
 ************************************************************************/
BOOL CAirspaceRegion::BorderContains (double dLat, double dLon)
{	
	BOOL bFound = FALSE;

	if ((m_dLatMax >= dLat && dLat > m_dLatMin) &&
		 (m_dLonMin <= dLon && dLon < m_dLonMax) )
	{
		bFound = m_bActivated;		// TRUE only, if activated!!
	}

	return bFound;
}

/************************************************************************
 *  AirspaceRegion.cpp  			I s I n R e c t						*
 ************************************************************************/
BOOL CAirspaceRegion::IsInRect(DRECT rLatLon, double dLat, double dLon)
{
	BOOL bFound = FALSE;

	if ((rLatLon.top >= dLat && dLat > rLatLon.bottom) &&
		 (rLatLon.left <= dLon && dLon < rLatLon.right) )
	{
		bFound = TRUE;
	}

	return bFound;
}



		//				  TL+---+  Region
		//					|	|
		//			+-------+---+----+ rLatLon.top
		//			|		|	|	 |
		//			+-------+---+----+ rLatLon.bottom
		//					|	|
		//				  BL+---+  


/************************************************************************
 *  AirspaceRegion.cpp  		I s B e t w e e n L o n					*
 ************************************************************************/
BOOL CAirspaceRegion::IsBetweenLon(DRECT rLatLon)
{
	BOOL bFound = FALSE;

	if (m_dLatMax >= rLatLon.top &&		// TL of region north of rLatLon
		m_dLatMin <= rLatLon.bottom)	// BL of region south of rLatLon
	{
		if (rLatLon.left <= m_dLonMin && m_dLonMin <= rLatLon.right)
			bFound = TRUE;
	}

	return bFound;
}


		//				    +---+ rLatLon.top
		//					|	|
		//		TL	+-------+---+----+ TR m_dLatMax
		//			|		|	|	 |
		//			+-------+---+----+ Region
		//					|	|
		//				    +---+  rLatLon.bottom
		//		rLatLon.left     rLatLon.right

/************************************************************************
 *  AirspaceRegion.cpp  		I s B e t w e e n L a t					*
 ************************************************************************/
BOOL CAirspaceRegion::IsBetweenLat(DRECT rLatLon)
{
	BOOL bFound = FALSE;

	if (m_dLonMin <= rLatLon.left &&	// TL of region west of rLatLon
		m_dLonMax >= rLatLon.right)		// TR of region east of rLatLon
	{
		if(rLatLon.bottom <= m_dLatMax && m_dLatMax <= rLatLon.top)
			bFound = TRUE;
	}

	return bFound;
}



/************************************************************************
 *  AirspaceRegion.cpp  	B o r d e r C o n t a i n s					*
 *  creates temp DRECT, required to compare with actual region border	*
 ************************************************************************/
BOOL CAirspaceRegion::BorderContains (DRECT rLatLon)
{	
	BOOL bFound = FALSE;


					// get temp rLatLon to compare it with region border
	DRECT rTmpLatLon;
	rTmpLatLon = rLatLon;

	if (rLatLon.left < -180)
	{		// antipod map lon: -206 ... -138
		if (m_dLonMax > 0)
		{		// east lon region
			rTmpLatLon.left += 360;
			rTmpLatLon.right += 360;
		}
	}

	if (rLatLon.right > 180)
	{		// antipod map lon: 154 ... 222
		if (m_dLonMin < 0)
		{		// west lon region
			rTmpLatLon.left -= 360;
			rTmpLatLon.right -= 360;
		}
	}

	if (this->IsAntipod())
	{			// antipod region, m_dLonMax > 180
		if (0 > rLatLon.left && rLatLon.left >= -180 )
		{		// std. west rLatLon, all lon values > -180
			rTmpLatLon.left += 360;
			rTmpLatLon.right += 360;
		}
	}

			// test, if at least one point of rLatLon is within this region borders

	if (!bFound && BorderContains(rTmpLatLon.top, rTmpLatLon.left))		// TL of rLatLon
		bFound = TRUE;
	if (!bFound && BorderContains(rTmpLatLon.top, rTmpLatLon.right))	// TR of rLatLon
		bFound = TRUE;
	if (!bFound && BorderContains(rTmpLatLon.bottom, rTmpLatLon.right))	// BR of rLatLon
		bFound = TRUE;
	if (!bFound && BorderContains(rTmpLatLon.bottom, rTmpLatLon.left))	// BL of rLatLon
		bFound = TRUE;



		//  test if at least one of this regions borders is within rLatLon
	if (!bFound && IsInRect (rTmpLatLon, m_dLatMax, m_dLonMin))		// TL of region
		bFound = TRUE;
	if (!bFound && IsInRect (rTmpLatLon, m_dLatMax, m_dLonMax))		// TR of region
		bFound = TRUE;
	if (!bFound && IsInRect (rTmpLatLon, m_dLatMin, m_dLonMax))		// BR of region
		bFound = TRUE;
	if (!bFound && IsInRect (rTmpLatLon, m_dLatMin, m_dLonMin))		// BL of region
		bFound = TRUE;


	if (!bFound && IsBetweenLon(rTmpLatLon))
		bFound = TRUE;
	if (!bFound && IsBetweenLat(rTmpLatLon))
		bFound = TRUE;

	if (bFound)
	{
		bFound = m_bActivated;		// TRUE only, if activated!!
	}

	return bFound;
}


/************************************************************************
 *  AirspaceRegion.cpp  					O p e n						*
 ************************************************************************/
BOOL CAirspaceRegion::Open (CString szPath, CString szName, BOOL bOpenSubDocuments)
{	
	CString szNameExt = szName + CAirspaceDoc::GetExt();

	m_szName	= szName;
	m_szPath	= szPath + szNameExt;

	return this->Open(bOpenSubDocuments);
}

/************************************************************************
 *  AirspaceRegion.cpp  					O p e n						*
 ************************************************************************/
BOOL CAirspaceRegion::Open (BOOL bOpenSubDocuments)
{	
	BOOL bOpened = FALSE;
	
									// open an AirspaceDoc here...
	m_ptAirspaceDoc = new CAirspaceDoc();
	m_ptAirspaceDoc->OnNewDocument(); 			// deletes old structures   
	m_ptAirspaceDoc->SetTitle(m_szName + CAirspaceDoc::GetExt());
	m_ptAirspaceDoc->SetPathName(m_szPath);

	if (!bOpenSubDocuments)
		m_ptAirspaceDoc->NoSubDocuments();

	if (CInitDoc::FileExists(m_szPath))
		bOpened = m_ptAirspaceDoc->OnOpenDocument (m_ptAirspaceDoc->GetPathName());

	return bOpened;
}

/************************************************************************
 *  AirspaceRegion.cpp  		R e a d B o r d e r A n d C n t			*
 *  Copies border, cnt and antipod flag from specified airspace doc		*
 *			to airspace region											*
 *  for antipod regions, m_dLonMax is > 180 !!							*
 ************************************************************************/
void CAirspaceRegion::ReadBorderAndCnt(CString szPath, CString szName)
{
	BOOL bOpenSubDocuments = FALSE;		// we don't need segments here
	if (this->Open(szPath, szName, bOpenSubDocuments))
	{	
		m_dLonMin	= m_ptAirspaceDoc->GetMinLon();
		m_dLonMax	= m_ptAirspaceDoc->GetMaxLon();
		m_dLatMax	= m_ptAirspaceDoc->GetMaxLat();
		m_dLatMin	= m_ptAirspaceDoc->GetMinLat();

		m_nAirspaceCnt	= m_ptAirspaceDoc->GetAirspaceCnt();
		m_bAntipod = m_ptAirspaceDoc->IsAntipod();

		this->Close();
	}
}


/************************************************************************
 *  AirspaceRegion.cpp						C l o s e					*
 ************************************************************************/
void CAirspaceRegion::Close ()
{
	if (m_ptAirspaceDoc != NULL)
	{	
//		m_ptAirspaceDoc->OnCloseDocument();
		delete m_ptAirspaceDoc;
		m_ptAirspaceDoc = NULL;
	}
}

/////////////////////////////////////////////////////////////////////////////
// CAirspaceRegion commands
