#ifndef __AIRSPACE_REGION__      
#define __AIRSPACE_REGION__

#include "AirspaceDoc.h"

// AirspaceRegion.h
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

	
class CAirspaceRegion : public CObject
{
	DECLARE_SERIAL(CAirspaceRegion)

// Attributes
public:  
	CString		m_szName;			// "Germany"

// Operations
private:
	CString		m_szPath;			// D:\\Programme\\PreFlight\\Germany.asp
	BOOL		m_bActivated;
	BOOL		m_bAntipod;
	double		m_dLonMin;
	double		m_dLonMax;
	double		m_dLatMax;
	double		m_dLatMin;
	short		m_nAirspaceCnt;

	CAirspaceDoc*	m_ptAirspaceDoc;

// Implementation
public:
	CAirspaceRegion();		
	CAirspaceRegion(CAirspaceRegion& SourceAirspaceRegion);
	~CAirspaceRegion();                                                

	const CAirspaceRegion& operator=(const CAirspaceRegion& AirspaceRegion);
	void Reset();
	BOOL IsEqual(const CAirspaceRegion& Elev);
	BOOL IsAntipod(DRECT rMap);
	BOOL GetAirspace (double fLat, double fLon, CAirspace* ptAirspace);

	BOOL IsInRect(DRECT rLatLon, double dLat, double dLon);
	BOOL IsBetweenLon(DRECT rLatLon);
	BOOL IsBetweenLat(DRECT rLatLon);
	BOOL BorderContains (double dLat, double dLon);
	BOOL BorderContains (DRECT rLatLon);

	void ReadBorderAndCnt(CString szPath, CString szName);

	BOOL Open (CString szPath, CString szName, BOOL bOpenSubDocuments=TRUE);
	BOOL Open (BOOL bOpenSubDocuments=TRUE);
	CAirspaceDoc* GetDoc() { return m_ptAirspaceDoc; }
	void Close ();

 	void Serialize(CArchive& ar, short nVersion);	

	CString GetName() { return m_szName; }
	CString GetPath() { return m_szPath; }
	BOOL IsActiv() { return m_bActivated; }
	BOOL IsAntipod() { return m_bAntipod; }

	double GetLonMin () { return m_dLonMin; }
	double GetLonMax () { return m_dLonMax; }
	double GetLatMin () { return m_dLatMin; }
	double GetLatMax () { return m_dLatMax; }

	short GetAirspaceCnt () { return m_nAirspaceCnt; }



	void SetName (CString szName) { m_szName = szName; }
	void SetPath (CString szPath) { m_szPath = szPath; }
	void SetActiv (BOOL bActiv) { m_bActivated = bActiv; }
	void SetAntipod (BOOL bAntipod) { m_bAntipod = bAntipod; }

	void SetLonMin (double fDegree) { m_dLonMin = fDegree; }
	void SetLonMax (double fDegree) { m_dLonMax = fDegree; }
	void SetLatMin (double fDegree) { m_dLatMin = fDegree; }
	void SetLatMax (double fDegree) { m_dLatMax = fDegree; }

	void SetAirspaceCnt (short nCnt) { m_nAirspaceCnt = nCnt; }


};
#endif 

