// AirspaceRegionsDoc.cpp : implementation of the CAirspaceRegionsDoc class
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de


#include "stdafx.h"
#include "pf.h"

#include "InitDoc.h"
#include "DimDoc.h"

#include "AirspaceRegionsDoc.h"  


#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

extern CInitDoc* 	ptInit;              
extern CDimDoc* 	ptDim;      

 
/////////////////////////////////////////////////////////////////////////////
// CAirspaceRegionsDoc

IMPLEMENT_DYNCREATE(CAirspaceRegionsDoc, CDocument)

BEGIN_MESSAGE_MAP(CAirspaceRegionsDoc, CDocument)
	//{{AFX_MSG_MAP(CAirspaceRegionsDoc)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAirspaceRegionsDoc construction/destruction

CAirspaceRegionsDoc::CAirspaceRegionsDoc()
{
	// TODO: add one-time construction code here  
	m_ptOpenedAirspaceRegion = NULL;
	m_nActIndex = -1;
}

CAirspaceRegionsDoc::~CAirspaceRegionsDoc()
{
	this->DeleteArrayOf (&m_AirspaceRegions);
}
   

/************************************************************************
 *  AirspaceRegionsDoc.cpp		D e l e t e A r r a y O f 				*
 ************************************************************************/
void CAirspaceRegionsDoc::DeleteArrayOf (CObArray* ptArray)
{
int i, nEntryCnt;	
											
nEntryCnt = ptArray->GetSize();
for (i=0; i<nEntryCnt; i++)
	{
	CAirspaceRegion* ptEntry;
	if ((ptEntry = (CAirspaceRegion*)ptArray->GetAt(i)) != NULL)
		{
	//	TRACE ("Deleting AirspaceRegions %d\n", i);
		delete ptEntry;				// delete original element
		}
	}
ptArray->RemoveAll();
}                
 

/************************************************************************
 *  AirspaceRegionsDoc.cpp			G e t A i r s p a c e				*
 ************************************************************************/
BOOL CAirspaceRegionsDoc::GetAirspace (double fLat, double fLon, CAirspace* ptAirspace)
{
	BOOL bFound = FALSE;
	for (int i=0; i<m_AirspaceRegions.GetSize() && !bFound; i++)
	{
		CAirspaceRegion* ptAirspaceRegion;
		ptAirspaceRegion = (CAirspaceRegion*)m_AirspaceRegions.GetAt(i);
		if (ptAirspaceRegion != NULL)
			bFound = ptAirspaceRegion->GetAirspace(fLat, fLon, ptAirspace);  
	}      

	return bFound;
}

/************************************************************************
 *  AirspaceRegionsDoc.cpp			G e t A i r s p a c e 				*
 ************************************************************************/
BOOL CAirspaceRegionsDoc::GetAirspace (CLatLon& LatLon, CAirspace* ptAirspace)
{
	return this->GetAirspace (LatLon.GetLat(), LatLon.GetLon(), ptAirspace);
}




/************************************************************************
 *  AirspaceRegionsDoc.cpp		A c t i v a t e A l l					*
 *  Purpose: sets state of all AirspaceRegions to bActiv				*
 ************************************************************************/
void CAirspaceRegionsDoc::ActivateAll (BOOL bActiv)
{
	for (int i=0; i<m_AirspaceRegions.GetSize(); i++)
	{
		CAirspaceRegion* ptAirspaceRegion;
		ptAirspaceRegion = (CAirspaceRegion*)m_AirspaceRegions.GetAt(i);
		if (ptAirspaceRegion != NULL)
		{
			ptAirspaceRegion->SetActiv(bActiv);
		}
	}
}


/************************************************************************
 *  AirspaceRegionsDoc.cpp		A c t i v a t e F o r					*
 *  Purpose: for each activated location region, activate the airspace	*
 ************************************************************************/
BOOL CAirspaceRegionsDoc::ActivateFor(CObArray* ptLocRegions)
{
	BOOL bChanged = FALSE;

	for (int i=0; i<this->GetCnt(); i++)
	{							// for all airspace regions
		CAirspaceRegion* ptAirspaceRegion = NULL;
		if (this->GetAirspaceRegionPtr(i, &ptAirspaceRegion))
		{
			CString szRegion;
			szRegion = ptAirspaceRegion->GetName();

							// are the locations of this region activated!	
			BOOL bLocFound = FALSE;
			BOOL bLocIsActive = FALSE;
			if (ptLocRegions != NULL)
			{
				for (int j=0; j<ptLocRegions->GetSize() && !bLocFound; j++)
				{					// search location region of same name
					CRegion* ptLocRegion = (CRegion*)ptLocRegions->GetAt(j);
					if (ptLocRegion != NULL)
					{	
						CString szLocRegion;	// compare locRegion and airspace names
						szLocRegion = ptLocRegion->GetName();
						bLocFound = (szLocRegion.CompareNoCase(szRegion) == 0);
						if (bLocFound)
							bLocIsActive = ptLocRegion->IsActiv();
					}
				}
			}

			if (bLocIsActive)
			{					
				if (!ptAirspaceRegion->IsActiv())
					bChanged = TRUE;
				ptAirspaceRegion->SetActiv (TRUE);
			}
			else
			{						// passive region
				if (ptAirspaceRegion->IsActiv())
					bChanged = TRUE;
				ptAirspaceRegion->SetActiv (FALSE);
			}
		}
	} // for all airspace regions

	return bChanged;
}

/************************************************************************
 *  AirspaceRegionsDoc.cpp		I n d e x T o N a m e 					*
 *  Purpose: returns the name of the airspace, specified by index		*
 ************************************************************************/
CString CAirspaceRegionsDoc::IndexToName(short nIndex)
{
	CString szRegion;

	CAirspaceRegion* ptAirspaceRegion=NULL;
	ptAirspaceRegion = (CAirspaceRegion*)m_AirspaceRegions.GetAt(nIndex);
	if (ptAirspaceRegion != NULL)
	{
		szRegion = ptAirspaceRegion->GetName();
	}

	return szRegion;
}

/************************************************************************
 *  AirspaceRegionsDoc.cpp		DeleteAirspaceRegion					*
 *  Purpose: delete AirspaceRegion specified by region name				*
 ************************************************************************/
BOOL CAirspaceRegionsDoc::DeleteAirspaceRegion(CString szRegion)
{
	BOOL bDeleted = FALSE;

	for(int i=0; i<m_AirspaceRegions.GetSize() && !bDeleted; i++)
	{
		CAirspaceRegion* ptAirspaceRegion=NULL;
		ptAirspaceRegion = (CAirspaceRegion*)m_AirspaceRegions.GetAt(i);
		if (ptAirspaceRegion != NULL)
		{
			CString szTestRegion = ptAirspaceRegion->GetName();
			if (szTestRegion.CompareNoCase((LPCTSTR)szRegion) == 0)
				bDeleted = DeleteAirspaceRegion(i);
		}
	}

	return bDeleted;
}

/************************************************************************
 *  AirspaceRegionsDoc.cpp		DeleteAirspaceRegion					*
 *  Purpose: deletes AirspaceRegion specified by index					*
 ************************************************************************/
BOOL CAirspaceRegionsDoc::DeleteAirspaceRegion(short nIndex)
{
	BOOL bDeleted = FALSE;

	short nOldCnt = m_AirspaceRegions.GetSize();
	CAirspaceRegion* ptAirspaceRegion=NULL;
	ptAirspaceRegion = (CAirspaceRegion*)m_AirspaceRegions.GetAt(nIndex);
	if (ptAirspaceRegion != NULL)
	{
		if (m_ptOpenedAirspaceRegion == ptAirspaceRegion)
				this->Close();		// region to be deleted was opened 
									// has to be closed

		delete ptAirspaceRegion;
		m_AirspaceRegions.RemoveAt(nIndex);
	}

	bDeleted = (m_AirspaceRegions.GetSize() < nOldCnt);
	return bDeleted;
}

/************************************************************************
 *  AirspaceRegionsDoc.cpp		G e t A i r s p a c e R e g i o n P t r	*
 *  Purpose: returns pointer to specified AirspaceRegions				*
 ************************************************************************/
BOOL CAirspaceRegionsDoc::GetAirspaceRegionPtr (short nIndex, CAirspaceRegion** ptptAirspaceRegion)
{
	BOOL bDone = FALSE;
	CAirspaceRegion* ptAirspaceRegion=NULL;
	ptAirspaceRegion = (CAirspaceRegion*)m_AirspaceRegions.GetAt(nIndex);
	if (ptAirspaceRegion != NULL)
	{
		*ptptAirspaceRegion = ptAirspaceRegion;
		bDone = TRUE;
	}

	return bDone;
}

/************************************************************************
 *  AirspaceRegionsDoc.cpp	AddSortedAirspaceRegionPtr					*
 ************************************************************************/
BOOL CAirspaceRegionsDoc::AddSortedAirspaceRegionPtr (CAirspaceRegion* ptAirspaceRegion)
{
	BOOL bAdded = FALSE;
	int nOldCnt = m_AirspaceRegions.GetSize();
	
	short nIndex = this->GetSortedIndex (m_AirspaceRegions, ptAirspaceRegion);
	m_AirspaceRegions.InsertAt(nIndex, ptAirspaceRegion);	
	bAdded = (nOldCnt < m_AirspaceRegions.GetSize());

	return bAdded;
}

/************************************************************************
 *  AirspaceRegionsDoc.cpp		AppendAirspaceRegionPtr					*
 ************************************************************************/
BOOL CAirspaceRegionsDoc::AppendAirspaceRegionPtr (CAirspaceRegion* ptAirspaceRegion)
{
	BOOL bAdded = FALSE;
	int nOldCnt = m_AirspaceRegions.GetSize();

	m_AirspaceRegions.Add(ptAirspaceRegion);	
	bAdded = (nOldCnt < m_AirspaceRegions.GetSize());

	return bAdded;
}

/************************************************************************
 *  AirspaceRegionsDoc.cpp				O p e n							*
 *  Purpose: Opens AirspaceDoc, specified by index						*
 ************************************************************************/
BOOL CAirspaceRegionsDoc::Open (short nIndex)
{
	BOOL bOpened = FALSE;

	CAirspaceRegion* ptAirspaceRegion;
	ptAirspaceRegion = (CAirspaceRegion*)m_AirspaceRegions.GetAt(nIndex);
	if (ptAirspaceRegion != NULL)
	{
		if (ptAirspaceRegion != m_ptOpenedAirspaceRegion)
		{			// opened specified airspace document
			this->Close();					
			if (ptAirspaceRegion->Open())
			{
				m_ptOpenedAirspaceRegion = ptAirspaceRegion;
				m_nActIndex = nIndex;

				bOpened = TRUE;
			}
		}
		else
		{		// document was already opened
			bOpened = TRUE;
		}
	}

	return bOpened;
}

/************************************************************************
 *  AirspaceRegionsDoc.cpp				O p e n							*
 *  Purpose: Opens AirspaceDoc, specified by region name				*
 ************************************************************************/
BOOL CAirspaceRegionsDoc::Open (CString szRegion)
{
	BOOL bOpened = FALSE;

	for (int i=0; i<m_AirspaceRegions.GetSize() && !bOpened; i++)
	{				// test all regions
		CAirspaceRegion* ptAirspaceRegion;
		ptAirspaceRegion = (CAirspaceRegion*)m_AirspaceRegions.GetAt(i);
		if (ptAirspaceRegion != NULL)
		{
			if (ptAirspaceRegion->GetName().CompareNoCase(szRegion)==0)
			{						// name found!!
				if (ptAirspaceRegion != m_ptOpenedAirspaceRegion)
				{			// opened specified airspace document
					this->Close();					
					if (ptAirspaceRegion->Open())
					{
						m_ptOpenedAirspaceRegion = ptAirspaceRegion;
						m_nActIndex = i;

						bOpened = TRUE;
					}
				}
				else
				{		// document was already opened
					bOpened = TRUE;
				}
			} // name check
		} // test region
	} // for all regions


	return bOpened;
}

/************************************************************************
 *  AirspaceRegionsDoc.cpp			O p e n								*
 *  Purpose: Opens AirspaceDoc, containing Airspace for fLat/fLon and	*
 *		returns index of opened AirspaceDoc								*
 ************************************************************************/
BOOL CAirspaceRegionsDoc::Open (double fLat, double fLon, short* ptIndex)
{
	BOOL bFound = FALSE;

	for (int i=0; i<m_AirspaceRegions.GetSize() && !bFound; i++)
	{
		CAirspaceRegion* ptAirspaceRegion;
		ptAirspaceRegion = (CAirspaceRegion*)m_AirspaceRegions.GetAt(i);
		if (ptAirspaceRegion != NULL)
		{
			if (ptAirspaceRegion->BorderContains(fLat, fLon))
			{
				if (ptAirspaceRegion != m_ptOpenedAirspaceRegion)
				{			// change open array
					this->Close();					
					if (ptAirspaceRegion->Open())
					{
						m_ptOpenedAirspaceRegion = ptAirspaceRegion;
						m_nActIndex = i;
					}
				}

				if (ptIndex != NULL)
					*ptIndex = i;
				bFound = TRUE;
			}
		}
	}      

	return bFound;
}


/************************************************************************
 *  AirspaceRegionsDoc.cpp				S a v e							*
 *  Purpose: Saves opened AirspaceDoc									*
 ************************************************************************/
BOOL CAirspaceRegionsDoc::Save (BOOL bConfirm)
{
	BOOL bSaved = FALSE;

	if (m_ptOpenedAirspaceRegion != NULL)
	{			// save opened airspace document
		CAirspaceDoc* ptDoc = m_ptOpenedAirspaceRegion->GetDoc();
		if (ptDoc != NULL)
		{
			CString szPath = m_ptOpenedAirspaceRegion->GetPath();
			bSaved = ptDoc->OnSaveDocument(szPath, bConfirm);
		}
	}
	return bSaved;
}


/************************************************************************
 *  AirspaceRegionsDoc.cpp				C l o s e						*
 ************************************************************************/
void CAirspaceRegionsDoc::Close ()
{
	if (m_ptOpenedAirspaceRegion != NULL)
	{
		m_ptOpenedAirspaceRegion->Close();
		m_ptOpenedAirspaceRegion = NULL;
		m_nActIndex = -1;
	}
}


/************************************************************************
 *  AirspaceRegionsDoc.cpp		D e l e t e C o n t e n t s				*
 *  Called from: OnFileNew and OnFileOpen								*
 ************************************************************************/
void CAirspaceRegionsDoc::DeleteContents()
{
	m_nActIndex = -1;
	this->DeleteArrayOf (&m_AirspaceRegions);
}






/************************************************************************
 *  AirspaceRegionsDoc.cpp 		 G e t S o r t e d I n d e x 			*
 ************************************************************************/
short CAirspaceRegionsDoc::GetSortedIndex (CObArray& AirspaceRegions, CAirspaceRegion* ptAirspaceRegion)
{
BOOL	bInsAfter;  
long	IndMin, IndMax, i, OldTestInd;

        								// get new name to insert 
CString	szNewName = ptAirspaceRegion->GetName();

IndMin  = 0;
IndMax  = AirspaceRegions.GetSize();		/* legal ind: 0...cnt-1		*/
i = (IndMin + IndMax) / 2;				/* i always < cnt !!	*/

if (AirspaceRegions.GetSize() > 0)
   {
   do	{  
        CAirspaceRegion* lpTestMap = (CAirspaceRegion*)AirspaceRegions.GetAt((int)i);
        CString szTestName = lpTestMap->GetName();
        
        int iCmp = szNewName.CompareNoCase ((LPCTSTR)szTestName);

	    if (iCmp >=0)	bInsAfter = TRUE;
	    		else	bInsAfter = FALSE;

		if (bInsAfter)	IndMin = i;
				else	IndMax = i;
				
		OldTestInd = i;
		i = (IndMin + IndMax) / 2;
	
		} while (i != OldTestInd);

   if (bInsAfter) i++;
   }                     
   
return (short)i;
}

/************************************************************************
 *  AirspaceRegionsDoc.cpp		G e t D o c u m e n t					*
 *  Purpose: returns pointer of actual or specified airspace doc		*
 ************************************************************************/
CAirspaceDoc* CAirspaceRegionsDoc::GetDocument(CString szRegion)
{
	CAirspaceDoc* ptAirspaceDoc = NULL;
	BOOL bOpened = FALSE;

	if (!szRegion.IsEmpty())
	{				// return airspace doc pointer of specified region
		bOpened = this->Open(szRegion);
	}


	if (!bOpened)
	{		// no szRegion specified or specified region doesn't exist:
		if (m_nActIndex >= 0)
			bOpened = this->Open(m_nActIndex);
	}

	if (bOpened)
		ptAirspaceDoc = m_ptOpenedAirspaceRegion->GetDoc();

	return ptAirspaceDoc;
}


/********************************************************************************
 *  AirspaceRegionsDoc.cpp		G e t A i r s p a c e A t 						*
 *  Purpose: lists all airspaces of current region which are at dLat/dLon		*
 ********************************************************************************/
BOOL CAirspaceRegionsDoc::GetAirspaceAt(double dLat, double dLon, CAirspace** ptptAirspace, 
									 short* ptNextAirspaceIndex)
{
	BOOL bFound = FALSE;

	if (m_ptOpenedAirspaceRegion != NULL)
	{
		CAirspaceDoc* ptAirspaceDoc = NULL;

					// airspace region should now be opened
		ptAirspaceDoc = m_ptOpenedAirspaceRegion->GetDoc();
		if (ptAirspaceDoc != NULL)
		{
			bFound = ptAirspaceDoc->GetAirspaceAt(dLat, dLon, ptptAirspace, ptNextAirspaceIndex);
		}
	}

	return bFound;
}



/********************************************************************************
 *  AirspaceRegionsDoc.cpp		OpenAirspaceRegionForRect						*
 *  Purpose: opens all activated airspace regions which do touch rLatLon		*
 ********************************************************************************/
BOOL CAirspaceRegionsDoc::OpenAirspaceRegionForRect(DRECT rLatLon, short* ptNextRegIndex)
{
	BOOL bFound = FALSE;

	for (int i=*ptNextRegIndex; i<m_AirspaceRegions.GetSize() && !bFound; i++)
	{				// for all regions
		CAirspaceRegion* ptAirspaceRegion;
		ptAirspaceRegion = (CAirspaceRegion*)m_AirspaceRegions.GetAt(i);
		if (ptAirspaceRegion != NULL)
		{
			if (ptAirspaceRegion->IsActiv())
			{
				if (ptAirspaceRegion->BorderContains(rLatLon))
				{						// first simple test succeeded
					if (ptAirspaceRegion != m_ptOpenedAirspaceRegion)
					{			// opened next airspace document
						this->Close();					
						if (ptAirspaceRegion->Open())
						{
							m_ptOpenedAirspaceRegion = ptAirspaceRegion;
							m_nActIndex = i;
						}
						else
						{
							return bFound;
						}
					} // region changed

					(*ptNextRegIndex) = m_nActIndex+1;
					bFound = TRUE;
				}
			}
		}
	}

	return bFound;
}

/********************************************************************************
 *  AirspaceRegionsDoc.cpp		G e t A i r s p a c e I n R e c t				*
 *  Purpose: lists all airspaces of all activated regions						*
 *			which are inside rLatLon											*
 ********************************************************************************/
BOOL CAirspaceRegionsDoc::GetAirspaceInRect(DRECT rLatLon, CAirspace** ptptAirspace, 
									short* ptNextRegIndex, short* ptNextAirspaceIndex)
{
	BOOL bFound = FALSE;
	BOOL bChangeToNextRegion = FALSE;

	for (int i=*ptNextRegIndex; i<m_AirspaceRegions.GetSize() && !bFound; i++)
	{				// for all regions
		CAirspaceRegion* ptAirspaceRegion;
		ptAirspaceRegion = (CAirspaceRegion*)m_AirspaceRegions.GetAt(i);
		if (ptAirspaceRegion != NULL)
		{
			if (ptAirspaceRegion->IsActiv())
			{
				if (ptAirspaceRegion->BorderContains(rLatLon))
				{						// first simple test succeeded
					CAirspaceDoc* ptAirspaceDoc = NULL;

					if (ptAirspaceRegion != m_ptOpenedAirspaceRegion)
					{			// opened next airspace document
						this->Close();					
						if (ptAirspaceRegion->Open())
						{
							m_ptOpenedAirspaceRegion = ptAirspaceRegion;
							m_nActIndex = i;
						}
						else
						{
							return bFound;
						}
					}

								// airspace region should now be opened
					ptAirspaceDoc = m_ptOpenedAirspaceRegion->GetDoc();
					if (ptAirspaceDoc != NULL)
					{
						bChangeToNextRegion = FALSE;
						bFound = ptAirspaceDoc->GetAirspaceInRect(rLatLon, ptptAirspace,
							ptNextRegIndex, ptNextAirspaceIndex);
					}
				} // current region contains rLatLon
				else
				{
					bChangeToNextRegion = TRUE;
				}
			} // current region is active
			else
			{
				bChangeToNextRegion = TRUE;
			}
		} // good region
		else
		{
			bChangeToNextRegion = TRUE;
		}

		if (bChangeToNextRegion)
			(*ptNextRegIndex)++;

	}

	return bFound;
}

/************************************************************************
 *  AirspaceRegionsDoc.cpp		I m p o r t A i r s p a c e s F r o m	*
 *  Purpose: Gets current airspace documents from specified directory	*
 ************************************************************************/
void CAirspaceRegionsDoc::ImportAirspacesFrom(CString szSrcPath)
{
	short nLastActRegion = m_nActIndex;
	this->Close();
	m_nActIndex = nLastActRegion;
	
	          				// get path name for airspace database
	CString szSearchPath = szSrcPath;	// "D:\Update\"
	szSearchPath += "*";
	szSearchPath += CAirspaceDoc::GetExt(); 

	CStringArray Regions;			// get CString array with long file names
	short nCnt = CQuickFind::EnumFiles (&Regions, szSearchPath);  

	short i;
	for (i=0; i<nCnt; i++)			 
	{
		CString szName;

		CString szNameExt = Regions.GetAt(i);
		short nDotIndex = szNameExt.ReverseFind ('.');
		if (nDotIndex > 0)			// remove extension from filenames        
				szName = szNameExt.Left(nDotIndex);
		else	szName = szNameExt;

	}
}


/************************************************************************
 *  AirspaceRegionsDoc.cpp		R e a d B o r d e r s F r o m 			*
 *  Purpose: Gets current airspace documents from specified directory	*
 *  and copies border and counter to airspace regions doc				*
 ************************************************************************/
void CAirspaceRegionsDoc::ReadBordersFrom(CString szPath)
{
	short nLastActRegion = m_nActIndex;
	this->Close();
	m_nActIndex = nLastActRegion;
	
	DeleteArrayOf(&m_AirspaceRegions);	// delete old entries


	          				// get path name for airspace database
	CString szSearchPath = szPath;			// "D:\Code\Cpp_Win\PF40\"
	szSearchPath += "*";
	szSearchPath += CAirspaceDoc::GetExt(); 

	CStringArray Regions;			// get CString array with long file names
	short nCnt = CQuickFind::EnumFiles (&Regions, szSearchPath);  

	short i;
	for (i=0; i<nCnt; i++)	
	{
		CString szName;

		CString szNameExt = Regions.GetAt(i);
		short nDotIndex = szNameExt.ReverseFind ('.');
		if (nDotIndex > 0)			// remove extension from filenames        
				szName = szNameExt.Left(nDotIndex);
		else	szName = szNameExt;

		CAirspaceRegion* ptAirspaceRegion = new CAirspaceRegion();
		if (ptAirspaceRegion != NULL)
		{			
			ptAirspaceRegion->ReadBorderAndCnt(szPath, szName);

			m_AirspaceRegions.Add (ptAirspaceRegion);      // add new Element    
		}
	}
}

/********************************************************************************
 *  AirspaceRegionsDoc.cpp		C h e c k A i r s p a c e P a t h				*
 *  if airspace file is no longer stored at the old path,						*
 *  adjust path entry of all airspace descriptions to new installation path		*
 ********************************************************************************/
void CAirspaceRegionsDoc::CheckAirspacePath(CString szNewDataPath)
{
	BOOL bChanged = FALSE;

	int i=0;
    while (i<this->GetCnt())
    {
        CAirspaceRegion* ptAirspaceRegion;
        if (this->GetAirspaceRegionPtr (i, &ptAirspaceRegion))
        {			// test if *.bin files are stored outside of preflight dir
            CString szOldPath = ptAirspaceRegion->GetPath();	// #include "D:\Orte\Elev\SOUTHAFRICA.BIN"
			if (!CInitDoc::FileExists(szOldPath))
			{								// if file doesn't exist, expect in in current Airspace-dir
				CString szFileExt = CInitDoc::GetFileFromPath(szOldPath);
				CString szNewPath = szNewDataPath + szFileExt;
				
				if (CInitDoc::FileExists(szNewPath))
				{
					ptAirspaceRegion->SetPath(szNewPath);
				}
				else
				{		// cannot find airspace
					if (this->DeleteAirspaceRegion(i))
						i--;		// don't increase index at end of while loop
				}
				bChanged = TRUE;
			}
        }
		i++;
    }

	if (bChanged)
	{				// save during next call to CInitDoc::Serialize
		this->SetModifiedFlag(TRUE);
	}
}

/************************************************************************
 *  AirspaceRegionsDoc.cpp  	 	S e r i a l i z e 					*
 ************************************************************************/
void CAirspaceRegionsDoc::Serialize(CArchive& ar, short nVersion)
{    
	short i, nCnt;

	if (ar.IsStoring())
	{					// TODO: add storing code here    
		nCnt = m_AirspaceRegions.GetSize();

		ar << m_nActIndex;
		ar << nCnt;

		for (i=0; i<m_AirspaceRegions.GetSize(); i++)
		{
			CAirspaceRegion* ptAirspaceRegion;
			ptAirspaceRegion = (CAirspaceRegion*)m_AirspaceRegions.GetAt(i);
			if (ptAirspaceRegion != NULL)
				ptAirspaceRegion->Serialize (ar, nVersion);  
		}      
	}
	else
	{				// TODO: add loading code here   	
		ar >> m_nActIndex;
		ar >> nCnt;
	
		for (i=0; i<nCnt; i++)
		{
			CAirspaceRegion* ptAirspaceRegion = new CAirspaceRegion; 
			if (ptAirspaceRegion != NULL)
			{
				ptAirspaceRegion->Serialize (ar, nVersion);
				m_AirspaceRegions.Add (ptAirspaceRegion);       	// add new Element        
			}
		} 


		if (this->GetActIndex()==-1 && nCnt>0)
			this->SetActIndex(0);		// to select 1. entry in dialog list
 	}  
	
}



/////////////////////////////////////////////////////////////////////////////
// CAirspaceRegionsDoc diagnostics

#ifdef _DEBUG
void CAirspaceRegionsDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CAirspaceRegionsDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CAirspaceRegionsDoc commands
