#ifndef __AIRSPACE_REGIONS_DOC__      
#define __AIRSPACE_REGIONS_DOC__
// AirspaceRegionsDoc.h : interface of the CAirspaceRegionsDoc class
//
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de
/////////////////////////////////////////////////////////////////////////////
#include "AirspaceRegion.h"


class CLatLon;
class CAirspaceRegionsDoc : public CDocument
{         
private:    
	CObArray		m_AirspaceRegions;             
	short			m_nActIndex;

	CAirspaceRegion*		m_ptOpenedAirspaceRegion;
	    
protected: // create from serialization only
	DECLARE_DYNCREATE(CAirspaceRegionsDoc)

// Attributes
public:
// Operations
public:           
 	void DeleteArrayOf (CObArray* ptArray);
	CAirspaceDoc* GetDocument(CString szRegion="");

	BOOL GetAirspaceAt(double dLat, double dLon, CAirspace** ptptAirspace, 
									 short* ptNextAirspaceIndex);

	BOOL OpenAirspaceRegionForRect(DRECT rLatLon, short* ptNextRegIndex);
	BOOL GetAirspaceInRect(DRECT rLatLon, CAirspace** ptptAirspace, 
						short* ptNextRegIndex, short* ptNextAirspaceIndex);
	void ImportAirspacesFrom(CString szPath);
	void ReadBordersFrom(CString szPath);
	void CheckAirspacePath(CString szNewDataPath);

	BOOL GetAirspace (CLatLon& LatLon, CAirspace* ptAirspace);
	BOOL GetAirspace (double fLat, double fLon, CAirspace* ptAirspace);

	CString IndexToName(short nIndex);
	BOOL DeleteAirspaceRegion(CString szRegion);
	BOOL DeleteAirspaceRegion(short nIndex);
	BOOL GetAirspaceRegionPtr (short nIndex, CAirspaceRegion** ptptAirspaceRegion);
	BOOL AddSortedAirspaceRegionPtr (CAirspaceRegion* ptAirspaceRegion);
	BOOL AppendAirspaceRegionPtr (CAirspaceRegion* ptAirspaceRegion);
	CAirspaceRegion* GetOpenedAirspaceRegionPtr () { return m_ptOpenedAirspaceRegion; }

	void ActivateAll (BOOL bActiv);
	BOOL ActivateFor(CObArray* ptLocRegions);
	BOOL Open (short nIndex);
	BOOL Open (CString szRegion);
	BOOL Open (double fLat, double fLon, short* ptIndex = NULL);
	BOOL Save (BOOL bConfirm=TRUE);
	void Close ();

	void SetActIndex(short nIndex) { m_nActIndex = nIndex; }
	short GetActIndex() { return m_nActIndex; }

	short GetCnt () { return m_AirspaceRegions.GetSize(); }
  						  
// Implementation
public:
	CAirspaceRegionsDoc();
	virtual ~CAirspaceRegionsDoc();  
    
	short GetSortedIndex (CObArray& AirspaceRegions, CAirspaceRegion* ptAirspaceRegion);
	
	virtual void DeleteContents();
	virtual void Serialize(CArchive& ar, short nVersion);   // overridden for document i/o
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

	
// Generated message map functions
protected:
	//{{AFX_MSG(CAirspaceRegionsDoc)
		// NOTE - the ClassWizard will add and remove member functions here.
		//    DO NOT EDIT what you see in these blocks of generated code !
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////
#endif