#ifndef __AIRSPACE_SEGMENT__
#define __AIRSPACE_SEGMENT__

/************************************************************************
 *			 			A i r s p a c e S e g m e n t . h				*
 ************************************************************************/
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include <math.h>

#define pi 3.1415926
#define SIZEOF_ASP_IDENT	10

#define ACT_SEG_VERS	1   

class CAirspaceSegment : public CObject
{
public:
	enum SHAPE 
	{					// *.rc: IDS_ASGSHAPE01 ... IDS_ASGSHAPE07
		POINT,				// A: POINT (WITHOUT RADIUS OR BEARING)
		GREATCIRCLE,		// B: GREAT CIRCLE
		CIRCLE,				// C: CIRCLE
		IRREGULAR,			// G: GENERALIZED (IRREGULAR)
		LINE,				// H: RHUMB LINE
		ARCLEFT,			// L: COUNTERCLOCKWISE ARC
		ARCRIGHT			// R: CLOCKWISE ARC	
	};

	/*	
		NOTE: B - GREAT CIRCLE: A CIRCLE THAT IS THE INTERSECTION OF THE SURFACE OF A SPHERE WITH A PLANE PASSING THROUGH THE CENTER OF THE SPHERE.
					
		G - GENERALIZED CONVERTING IRREGULAR BOUNDARIES (BORDER, RIVER, RAILROAD, ETC) INTO GEOGRAPHIC COORDINATE VALUES THESE VALUES ARE DERIVED BY PLOTTING WITHIN 5NM OF THE OUTSIDE OF THE BOUNDARY AND BY USING THE LEAST AMOUNT OF SEGMENTS REQUIRED TO PORTRAY APPROXIMATE BOUNDARY 
		H - RHUMB LINE: THE PATH SHOWN ON A MAP AS A LINE CROSSING ALL MERIDIANS AT THE SAME ANGLE
	*/

public:
	CAirspaceSegment ();					/* default contructor	*/
	CAirspaceSegment (CString szIdentifier, long lSegNum);
	CAirspaceSegment (CAirspaceSegment& SourceAirspaceSegment);
    ~CAirspaceSegment();					/* destructor			*/

	const CAirspaceSegment& operator=(const CAirspaceSegment& AirspaceSegment);
	BOOL operator !=(const CAirspaceSegment& AirspaceSegment);

	void SetIdentifier (CString szIdentifier);
	CString GetIdentifier() { return (CString)m_szIdentifier; }

	CString GetDisplayName();

	void SetSegmentNumber(long lNum) { m_lSegmentNumber = lNum; }
	long GetSegmentNumber() { return m_lSegmentNumber; }

	void SetShape(char cShape);
	void SetShape (SHAPE cShape) { m_cShape = cShape; }
	SHAPE GetShape () { return m_cShape; }

	void SetLat1(double dLat) { m_dLatitude1 = dLat; }
	void SetLon1(double dLon) { m_dLongitude1 = dLon; }
	void SetLat2(double dLat) { m_dLatitude2 = dLat; }
	void SetLon2(double dLon) { m_dLongitude2 = dLon; }

	double GetLat1 ();
	double GetLon1 ();
	double GetLat2 ();
	double GetLon2 ();

	void SetGeodeticLat0(double dLat) { m_dGeodeticLatitude0 = dLat; }
	void SetGeodeticLon0(double dLon) { m_dGeodeticLongitude0 = dLon; }
	double GetGeodeticLat0() { return m_dGeodeticLatitude0; }
	double GetGeodeticLon0() { return m_dGeodeticLongitude0; }

	void SetRadius (double dRad) { m_dRadius1 = dRad; }
	double GetRadius() { return m_dRadius1; }

	void SetDistDim (short nDim) { m_nDistDim = nDim; }
	short GetDistDim() { return m_nDistDim; }

	long GetUndefinedLong() { return m_lUndefined; }

	void Draw(CDC* pDC, long lX1, long lY1, long lX2, long lY2, 
							long lX0, long lY0, long lRadius);
	void DrawLine(CDC* pDC, long lX1, long lY1, long lX2, long lY2);
	void DrawCircle(CDC* pDC, long lX0, long lY0, long lRadius);
	void DrawCounterClockwiseArc(CDC* pDC,
							long lX1, long lY1, long lX2, long lY2, 
							long lX0, long lY0, long lRadius);
	void DrawClockwiseArc(CDC* pDC,
							long lX1, long lY1, long lX2, long lY2, 
							long lX0, long lY0, long lRadius);
	
	void Serialize(CArchive& ar, short nVersion = ACT_SEG_VERS);

//protected: 					// in abgeleiteten Obj. verfgbar

private:
	void Init ();


private:
	char m_szIdentifier[SIZEOF_ASP_IDENT];		// e.g.: ED00027


	// Members, defined by DAFIF FormatCode 03
	long m_lSegmentNumber;	// 01,05 - 0-99999
							// DEFINES THE RELATIVE POSITION OF THE SEGMENT IN THE TOTAL BOUNDARY. 
							// THIS ELEMENT GIVES THE ORDER POSITION OF THE BOUNDARY SEGMENTS. 
							// CONSECUTIVELY SPACED INCREMENTS ARE USED IN ORDER TO PROVIDE FOR 
							// MODIFICATIONS/ ADDITIONS TO THE BOUNDARY i.e., 10, 20, 25, 30, etc., 
							// (25 IS AN ADDED SEGMENT
	SHAPE m_cShape;	
	char m_cDummy;
	double m_dLatitude1;
	double m_dLongitude1;
	double m_dLatitude2;
	double m_dLongitude2;

	
	// Members, defined by DAFIF FormatCode 04
	double m_dGeodeticLatitude0;
	double m_dGeodeticLongitude0;

	double m_dRadius1;		// INDICATES THE RADIUS OF AN ARC OR CIRCLE FROM A CENTER POINT 
							// IN NAUTICAL MILES AND 10TH, 100TH OF NAUTICAL MILES
							// 00001-99999
	short m_nDistDim;
	long m_lUndefined;
};

#endif
