#if !defined(AFX_AIRSPACESEGMENTDLG_H__E09D8608_3258_40A6_BD70_573C3A061FC1__INCLUDED_)
#define AFX_AIRSPACESEGMENTDLG_H__E09D8608_3258_40A6_BD70_573C3A061FC1__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// AirspaceSegmentDlg.h : Header-Datei
//
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "WayDoc.h"
#include "DlgTool.h"

/////////////////////////////////////////////////////////////////////////////
// Dialogfeld CAirspaceSegmentDlg 

class CAirspaceSegmentDoc;
class CAirspaceSegmentDlg : public CDlgTool
{
// Konstruktion
public:
	CAirspaceSegmentDlg(CWnd* pParent = NULL, 
						CAirspaceSegmentDoc* ptDoc=NULL,
						CString szAirspaceName="",
						CString szAirspaceIdentifier="",
						long lStartIndex=-1);   // Standardkonstruktor
	~CAirspaceSegmentDlg();                                                

// Dialogfelddaten
	//{{AFX_DATA(CAirspaceSegmentDlg)
	enum { IDD = IDD_AIRSPACESEGMENT };
	int		m_nListIndex;
	int		m_nFormIndex;
	int		m_nRadDimIndex;
	long	m_lSegNum;
	float	m_fRadius;
	double	m_dLat0;
	double	m_dLon0;
	double	m_dLat1;
	double	m_dLon1;
	double	m_dLat2;
	double	m_dLon2;
	CString	m_szAirspaceName;
	//}}AFX_DATA

public:
					// for importing airspace from route
	void SetWayDocPtr(CWayDoc* ptWayDoc) { m_ptWayDoc = ptWayDoc; }	

private:
	CAirspaceSegmentDoc* 	m_ptDoc;
	long					m_lStartIndex;
	CAirspaceSegment*		m_ptAirspaceSegment;
	CString					m_szIdentifier;
	CMapStringToOb			m_ListObjects;
	CWayDoc*				m_ptWayDoc;
	BOOL					m_bShowFirstIntersection;	// used to toggle

// berschreibungen
	// Vom Klassen-Assistenten generierte virtuelle Funktionsberschreibungen
	//{{AFX_VIRTUAL(CAirspaceSegmentDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV-Untersttzung
	//}}AFX_VIRTUAL

// Implementierung
private:
	void EnableForEntryInList(BOOL bEntryInList);
	void ResetDlgEntries(CString szIdentifier, long lStartIndex);

	void SetEndpointOfSegments(double dOldLat, double dOldLon, BOOL bEnd1, 
								double dNewLat, double dNewLon, long lSegmentId);
	void OnSegmentChanged (CAirspaceSegment oldSegment, CAirspaceSegment newSegment);

	CString GetListEntry (CAirspaceSegment* ptAirspaceSegment);
	void InsertListEntry(CAirspaceSegment* ptAirspaceSegment, short nListIndex);
	void ChangeListEntry(CAirspaceSegment* ptAirspaceSegment, short nListIndex);
	void DeleteListEntry(short nListIndex);
	short FillList();
	void FillShapePU();
	long GetNewSegmentNumber(short nSelIndex);
	CAirspaceSegment* GetSelectedObject(short nListIndex);
	BOOL SetSelectedData(short nListIndex);
	void SetData(CAirspaceSegment* ptAirspaceSegment);
	BOOL GetData (CAirspaceSegment* ptAirspaceSegment);
	void ActRteWptToCircle(short nWptCnt);
	void DeleteAllSegments();
	void RouteToSegments(short nWptCnt);
	void EnableCalcSegmentsFromRte(short nFormIndex);
	BOOL CheckForParamsRequired(short nFormIndex);

protected:

	// Generierte Nachrichtenzuordnungsfunktionen
	//{{AFX_MSG(CAirspaceSegmentDlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnSegmentFromRoute();
	afx_msg void OnInsert();
	afx_msg void OnChange();
	afx_msg void OnDelete();
	afx_msg void OnDone();
	afx_msg void OnSelChangeList();
	afx_msg void OnCalculateCenter();
	afx_msg void OnSelChangeSegForm();
	afx_msg BOOL OnHelpInfo(HELPINFO* pHelpInfo);
	afx_msg void OnCopyEndToStart();
	afx_msg void OnSegmentToRoute();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ fgt unmittelbar vor der vorhergehenden Zeile zustzliche Deklarationen ein.

#endif // AFX_AIRSPACESEGMENTDLG_H__E09D8608_3258_40A6_BD70_573C3A061FC1__INCLUDED_
