// AirspaceSegmentDoc.cpp: Implementierungsdatei
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "stdafx.h"
#include "pf.h"
#include "AirspaceSegmentDoc.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern BOOL bDemo;

/////////////////////////////////////////////////////////////////////////////
// CAirspaceSegmentDoc
// Sorts and stores a list of airspace segment objects

IMPLEMENT_DYNCREATE(CAirspaceSegmentDoc, CDocument)

CAirspaceSegmentDoc::CAirspaceSegmentDoc()
{
	m_bConverted = FALSE;
	m_szExt = GetExt();
	this->InitHeader();
}

BOOL CAirspaceSegmentDoc::OnNewDocument()
{
	if (!CDocument::OnNewDocument())
		return FALSE;
	return TRUE;
}

CAirspaceSegmentDoc::~CAirspaceSegmentDoc()
{
	this->DeleteArrayOf (&m_AirspaceSegments);
}

/************************************************************************
 *  AirspaceSegmentDoc.cpp			G e t E x t 						*
 ************************************************************************/
CString CAirspaceSegmentDoc::GetExt()
{
	CString szExt(".seg");
	return szExt;
}


BEGIN_MESSAGE_MAP(CAirspaceSegmentDoc, CDocument)
	//{{AFX_MSG_MAP(CAirspaceSegmentDoc)
		// HINWEIS - Der Klassen-Assistent fgt hier Zuordnungsmakros ein und entfernt diese.
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// Diagnose CAirspaceSegmentDoc

#ifdef _DEBUG
void CAirspaceSegmentDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CAirspaceSegmentDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG


/************************************************************************
 *  AirspaceSegmentDoc.cpp			operator=							*
 ************************************************************************/
const CAirspaceSegmentDoc& CAirspaceSegmentDoc::operator=(const CAirspaceSegmentDoc& AspSegDoc)
{
	memcpy (&m_Header, &(AspSegDoc.m_Header), sizeof(AIRSPACESEGMENTHEADER)); 
	m_bConverted = AspSegDoc.m_bConverted;
	m_szExt = AspSegDoc.m_szExt;

	DeleteArrayOf (&m_AirspaceSegments);

	int i;
	for (i=0; i<AspSegDoc.m_AirspaceSegments.GetSize(); i++)
	{
		CAirspaceSegment* ptAirspaceSegmentOld;
		ptAirspaceSegmentOld = (CAirspaceSegment*)(AspSegDoc.m_AirspaceSegments.GetAt(i));
		if (ptAirspaceSegmentOld != NULL)
		{					// create memory for copied airspaces
			CAirspaceSegment* ptAirspaceSegmentNew = 
				new CAirspaceSegment(*ptAirspaceSegmentOld);
			if (ptAirspaceSegmentNew != NULL)
				m_AirspaceSegments.Add (ptAirspaceSegmentNew);    // add new Element 
		}	  
	}


	CString szTitle = AspSegDoc.GetTitle();
	SetTitle(szTitle);

	return *this;
}

/************************************************************************
 *  AirspaceSegmentDoc.cpp   T r y T o G e t A i r s p a c e SegmentPtr	*
 ************************************************************************/
BOOL CAirspaceSegmentDoc::TryToGetAirspaceSegmentPtr(CAirspaceSegment** ptptAirspaceSegment, 
													 CString szIdentifier,
													 long lSegNum)
{
	BOOL bAvailable = FALSE;
	
	CAirspaceSegment* ptAirspaceSegment = NULL;
	if (this->GetAirspaceSegmentPtr(szIdentifier, lSegNum, ptptAirspaceSegment))
	{	
		bAvailable = TRUE;
	}
	else
	{			// new airspace, create new entry
		*ptptAirspaceSegment = new CAirspaceSegment(szIdentifier, lSegNum);
		if (*ptptAirspaceSegment != NULL)
		{
			if (this->AddSortedAirspaceSegmentPtr(*ptptAirspaceSegment) >= 0)
				bAvailable = TRUE;
		}
	}
	return bAvailable;
}

/************************************************************************
 *  AirspaceSegmentDoc.cpp		D e l e t e A r r a y O f 				*
 ************************************************************************/
void CAirspaceSegmentDoc::DeleteArrayOf (CObArray* ptArray)
{
int i, nEntryCnt;	
											
nEntryCnt = ptArray->GetSize();
for (i=0; i<nEntryCnt; i++)
	{
	CAirspaceSegment* ptEntry;
	if ((ptEntry = (CAirspaceSegment*)ptArray->GetAt(i)) != NULL)
		{
		TRACE ("Deleting AirspaceSegment %s\n", (LPCTSTR)ptEntry->GetIdentifier());
		delete ptEntry;				// delete original element
		}
	}
ptArray->RemoveAll();
}  

/************************************************************************
 *  AirspaceSegmentDoc.cpp		D e l e t e C o n t e n t s				*
 *  Called from: OnFileNew and OnFileOpen								*
 ************************************************************************/
void CAirspaceSegmentDoc::DeleteContents()
{
this->InitHeader();
this->DeleteArrayOf (&m_AirspaceSegments);
}

/************************************************************************
 *  AirspaceSegmentDoc.cpp		O n O p e n D o c u m e n t				*
 ************************************************************************/
BOOL CAirspaceSegmentDoc::OnOpenDocument(LPCTSTR pszPathName)
{
BOOL bOpened = FALSE;
this->SetPathName(pszPathName);

bOpened = CDocument::OnOpenDocument(pszPathName); 

if (bOpened)
	{
	if (m_bConverted)
		{
		if (this->OnSaveDocument (pszPathName, FALSE))		// don't confirm
			{
			m_bConverted = FALSE;
//			if (ptInit->IsSaveSignal())
//				MessageBeep(MB_OK);	
			}
		}
	}

return bOpened;
}


/************************************************************************
 *  AirspaceSegmentDoc.cpp		O n S a v e D o c u m e n t				*
 ************************************************************************/
BOOL CAirspaceSegmentDoc::OnSaveDocument(const char* pszPathName, BOOL bConfirm)
{
	BOOL bSaved = TRUE;
	this->SetPathName (pszPathName);

	if (this->IsModified())
	{
		bSaved = FALSE;
		BOOL bDoSave;

		if (bConfirm)
		{
			CString szText;
			CString szFileExt = this->GetTitle();
			szText.Format(IDF_SAVE_FILE, (LPCTSTR)szFileExt);
			bDoSave = (AfxMessageBox ((LPCSTR)szText, MB_YESNO) == IDYES);
		}
		else
		{
			bDoSave = TRUE;
		}

		if (bDoSave)
		{
		//	if (bDemo)
		//	{
		//		AfxMessageBox (IDS_SAVE_DISABLED);
		//		return bSaved;
		//	}
		//	else
			{
				bSaved = CDocument::OnSaveDocument(pszPathName); 
			}
		}        
		else
		{   
			this->SetModifiedFlag (FALSE);
		}
	}

	return bSaved;
}


/************************************************************************
 *  AirspaceSegmentDoc.cpp 			C o m p a r e						*
 ************************************************************************/
int CAirspaceSegmentDoc::Compare(CAirspaceSegment* ptTestEntry, CAirspaceSegment* ptNewEntry)
{
        								// get new name to insert 
	CString	szNewName = ptNewEntry->GetIdentifier();
	long lSegNum = ptNewEntry->GetSegmentNumber();
      
    int iCmp = Compare(ptTestEntry, szNewName, lSegNum);

	return iCmp;
}

/************************************************************************
 *  AirspaceSegmentDoc.cpp 			C o m p a r e						*
 ************************************************************************/
int CAirspaceSegmentDoc::Compare(CAirspaceSegment* ptTestEntry, CString szIdentifier, long lSegNum)
{
    CString szTestName = ptTestEntry->GetIdentifier();
        
    int iCmp = szIdentifier.CompareNoCase ((LPCTSTR)szTestName);

	if (iCmp >=0)
	{
		if (iCmp == 0)
		{	// Identifier found, check segment number now

			if (lSegNum > ptTestEntry->GetSegmentNumber())
				iCmp = 1;
			if (lSegNum < ptTestEntry->GetSegmentNumber())
				iCmp = -1;

		}
	}

	return iCmp;
}

/************************************************************************
 *  AirspaceSegmentDoc.cpp 		 G e t S o r t e d I n d e x 			*
 ************************************************************************/
short CAirspaceSegmentDoc::GetSortedIndex (CObArray& AirspaceSegments, CAirspaceSegment* ptAirspaceSegment)
{
BOOL	bInsAfter;  
long	IndMin, IndMax, i, OldTestInd;


IndMin  = 0;
IndMax  = AirspaceSegments.GetSize();		/* legal ind: 0...cnt-1		*/
i = (IndMin + IndMax) / 2;				/* i always < cnt !!	*/

if (AirspaceSegments.GetSize() > 0)
   {
   do	{  
        CAirspaceSegment* ptTestEntry = (CAirspaceSegment*)m_AirspaceSegments.GetAt((int)i);

		int iCmp = Compare(ptTestEntry, ptAirspaceSegment);

	    if (iCmp >=0)	bInsAfter = TRUE;
	    		else	bInsAfter = FALSE;

		if (bInsAfter)	IndMin = i;
				else	IndMax = i;
	
				

		OldTestInd = i;
		i = (IndMin + IndMax) / 2;
	
		} while (i != OldTestInd);

   if (bInsAfter) i++;
   }                     
   
return (short)i;
}

/************************************************************************
 *  AirspaceSegmentDoc.cpp	  	 IdentifierSegNumToIndex	 			*
 *	Finds index of AirspaceSegment for specified identifer				*
 *	and specified segment number										*
 ************************************************************************/
short CAirspaceSegmentDoc::IdentifierSegNumToIndex (CString szIdentifier, long lSegNum)
{
	short	nIndex = -1;
	long	IndMin, IndMax, i, OldTestInd;

	IndMin  = 0;
	IndMax  = m_AirspaceSegments.GetSize();		/* legal ind: 0...cnt-1		*/
	i = (IndMin + IndMax) / 2;				/* i always < cnt !!	*/

	if (m_AirspaceSegments.GetSize() > 0)
	{
		do	
		{  
			CAirspaceSegment* ptTestEntry = (CAirspaceSegment*)m_AirspaceSegments.GetAt((int)i);
        
			int iCmp = Compare(ptTestEntry, szIdentifier, lSegNum);

			if (iCmp >=0)	IndMin = i;
	    			else	IndMax = i;

			if (iCmp == 0)
				nIndex = (short)i;					// store found index

			OldTestInd = i;
			i = (IndMin + IndMax) / 2;
		
		} while ((i != OldTestInd) && (nIndex == -1));

   }                     
 
return nIndex;
}
 
/************************************************************************
 *  AirspaceSegmentDoc.cpp		AddSortedAirspaceSegmentPtr				*
 *  adds segment specified to array of segments.						*
 *  If added successfully, the ablsolute index will be returned, else -1*
 ************************************************************************/
long CAirspaceSegmentDoc::AddSortedAirspaceSegmentPtr (CAirspaceSegment* ptAirspaceSegment)
{
	long lAbsIndex = -1;
	BOOL bAdded = FALSE;
	int nOldCnt = m_AirspaceSegments.GetSize();
	
	lAbsIndex = this->GetSortedIndex (m_AirspaceSegments, ptAirspaceSegment);
	m_AirspaceSegments.InsertAt((int)lAbsIndex, ptAirspaceSegment);	
	bAdded = (nOldCnt < m_AirspaceSegments.GetSize());
	this->SetAirspaceSegmentCnt(m_AirspaceSegments.GetSize());
	if (!bAdded)
		lAbsIndex =-1;

	return lAbsIndex;
}

/************************************************************************
 *  AirspaceSegmentDoc.cpp		G e t AirspaceSegmentP t r				*
 *  Purpose: returns pointer to specified AirspaceSegment				*
 ************************************************************************/
BOOL CAirspaceSegmentDoc::GetAirspaceSegmentPtr (short nIndex, CAirspaceSegment** ptptAirspaceSegment)
{
	BOOL bDone = FALSE;
	if (nIndex >= 0 && nIndex < m_AirspaceSegments.GetSize())
	{
		CAirspaceSegment* ptAirspaceSegment=NULL;
		ptAirspaceSegment = (CAirspaceSegment*)m_AirspaceSegments.GetAt(nIndex);
		if (ptAirspaceSegment != NULL)
		{
			*ptptAirspaceSegment = ptAirspaceSegment;
			bDone = TRUE;
		}
	}

	return bDone;
}

/************************************************************************
 *  AirspaceSegmentDoc.cpp	G e t A i r s p a c e S e g m e n t P t r	*
 *  Purpose: returns pointer to specified AirspaceSegment				*
 ************************************************************************/
BOOL CAirspaceSegmentDoc::GetAirspaceSegmentPtr (CString szIdentifier, 
												 long lSegNum, 
												 CAirspaceSegment** ptptAirspaceSegment)
{
	BOOL bDone = FALSE;

	short nIndex = -1;
	*ptptAirspaceSegment = NULL;

	nIndex = this->IdentifierSegNumToIndex(szIdentifier, lSegNum);
	if (nIndex >= 0)
	{
		bDone = this->GetAirspaceSegmentPtr(nIndex, ptptAirspaceSegment);

	}
	else
	{
	//	AfxMessageBox ("CAirspaceSegmentDoc::GetAirspaceSegmentPtr bad identifier: " + szIdentifier);
		bDone = FALSE;
	}

	return bDone;
}

/************************************************************************
 *  AirspaceSegmentDoc.cpp	D e l e t e A i r s p a c e P t r			*
 *  Purpose: deletes an AirspaceSegment entry							*
 ************************************************************************/
BOOL CAirspaceSegmentDoc::DeleteAirspaceSegmentPtr (short nIndex)
{
	BOOL bDone = FALSE;

	CAirspaceSegment* ptAirspaceSegment = NULL;
	if (this->GetAirspaceSegmentPtr(nIndex, &ptAirspaceSegment))
	{
		delete ptAirspaceSegment;
		m_AirspaceSegments.RemoveAt(nIndex);
		bDone = TRUE;
	}

	return bDone;
}

/************************************************************************
 *  AirspaceSegmentDoc.cpp  		 	C h a n g e 					*
 ************************************************************************/
BOOL CAirspaceSegmentDoc::Change(CWnd* ptWnd)
{  
	BOOL 	bChanged = FALSE;
/*
	CAirspaceSegmentDlg AirspaceSegmentDlg(ptWnd, this);

	int RetVal = AirspaceSegmentDlg.DoModal();
	switch (RetVal)
	{
	case IDOK:
		{   
		CString szPath = this->GetPathName(); 
		if (AirspaceSegmentDlg.WriteDataBaseIntoDoc()) 
			{             
			bChanged = this->OnSaveDocument (szPath);
 			}     
		}
 		break;
	case IDCANCEL: 
        this->SetModifiedFlag(FALSE);
		break;
	}
*/
	return bChanged;	
} 


//     IDS_SEG_VERS            "PF SEG 1.00  "

/************************************************************************
 *  AirspaceSegmentDoc.cpp  	 H e a d e r T o V e r s 				*
 ************************************************************************/
short CAirspaceSegmentDoc::HeaderToVers (char* ptHeader)
{  
short nVersion = 0;
CString szTestVers; 

szTestVers.LoadString (IDS_SEG_VERS);
if (szTestVers.Compare (ptHeader) == 0)
	nVersion = ACT_SEG_VERS;

return nVersion;
} 
     
/************************************************************************
 *  AirspaceSegmentDoc.cpp  	V e r s T o H e a d e r 				*
 ************************************************************************/
void CAirspaceSegmentDoc::VersToHeader (LPSTR lpHeader, short nVersion)
{      
CString szVers;
switch (nVersion)
	{
	case ACT_SEG_VERS:	
			 szVers.LoadString (IDS_SEG_VERS);	break; 
	default: szVers.Empty();	break;
    }

strcpy (lpHeader, (LPCTSTR)szVers);
}      

/************************************************************************
 *  AirspaceSegmentDoc.cpp		I n i t H e a d e r						*
 ************************************************************************/
void CAirspaceSegmentDoc::InitHeader ()
{  
CString		szVers;

szVers.LoadString (IDS_SEG_VERS);
strcpy (m_Header.szVersion, (LPCTSTR)szVers);
m_Header.cFlags		= 0;
m_Header.cDummy		= 0;
m_Header.nActIndex	= -1;
m_Header.nEntryCnt	= 0;  
}

/************************************************************************
 *  AirspaceSegmentDoc.cpp	C o p y A i r s p a c e S e g m e n t s		*
 *  copies segments from ptSrcAspSegDoc to this doc						*
 *  and assigns them to szAspIdent										*
 *	called from CAirspaceDoc::CopyUserAirspaces							*
 ************************************************************************/
short CAirspaceSegmentDoc::CopyAirspaceSegments(CString szAspIdent, 
										 short nStartIndex, short nCnt,
										 CAirspaceSegmentDoc* ptSrcAspSegDoc)
{
	BOOL bStop = FALSE;
	short nSegmentsCopied = 0;

	for (short i=nStartIndex; i<(nStartIndex + nCnt) && !bStop; i++)
	{
		CAirspaceSegment* ptSrcAspSeg = NULL;
		if (ptSrcAspSegDoc->GetAirspaceSegmentPtr (i, &ptSrcAspSeg))
		{		
			BOOL bAdded = FALSE;
			CAirspaceSegment* ptAirspaceSegment = new CAirspaceSegment;
			if (ptAirspaceSegment != NULL)
			{										// new segment created
				*ptAirspaceSegment = *ptSrcAspSeg;	// copy source segment
													// set new airspace identifier
				ptAirspaceSegment->SetIdentifier(szAspIdent);
				if (this->AddSortedAirspaceSegmentPtr(ptAirspaceSegment) >= 0)
				{
					bAdded = TRUE;
					nSegmentsCopied++;
				}
			}
			bStop = (!bAdded);
		}
	}

	return nSegmentsCopied;
}

/************************************************************************
 *  AirspaceSegmentDoc.cpp  	 S e r i a l i z e		 				*
 ************************************************************************/
void CAirspaceSegmentDoc::Serialize(CArchive& ar)
{
	short i, nVersion;

	if (ar.IsStoring())
	{
		// ZU ERLEDIGEN: Code zum Speichern hier einfgen
		nVersion = ACT_SEG_VERS;  
		VersToHeader ((LPSTR)&m_Header.szVersion, nVersion);	
		this->SetAirspaceSegmentCnt (m_AirspaceSegments.GetSize());	// put elev cnt into header

		ar.Write (&m_Header, sizeof (AIRSPACESEGMENTHEADER));   
		
		for (i=0; i<m_AirspaceSegments.GetSize(); i++)
		{
			CAirspaceSegment* ptAirspaceSegment;
			ptAirspaceSegment = (CAirspaceSegment*)m_AirspaceSegments.GetAt(i);
			if (ptAirspaceSegment != NULL)
				ptAirspaceSegment->Serialize (ar);  
		}      
		m_bConverted = FALSE;
	}
	else
	{
		m_bConverted = FALSE;

		// ZU ERLEDIGEN: Code zum Laden hier einfgen
		ar.Read (&m_Header, sizeof (AIRSPACESEGMENTHEADER));
		nVersion = this->HeaderToVers (m_Header.szVersion);  


		short nCnt = this->GetAirspaceSegmentCnt ();
	
		for (i=0; i<nCnt; i++)
		{
			CAirspaceSegment* ptAirspaceSegment = new CAirspaceSegment; 
			if (ptAirspaceSegment != NULL)
			{
				ptAirspaceSegment->Serialize (ar, nVersion);
				m_AirspaceSegments.Add (ptAirspaceSegment);       	// add new Element        
			}
		} 

		if (this->GetActIndex()==-1 && nCnt>0)
			this->SetActIndex(0);		// to select 1. entry in dialog list
	}
}

/////////////////////////////////////////////////////////////////////////////
// Befehle CAirspaceSegmentDoc 
