#if !defined(__AIRSPACE_SEGMENT_DOC__)
#define __AIRSPACE_SEGMENT_DOC__

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// AirspaceSegmentDoc.h : Header-Datei
//
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "AirspaceSegment.h"


/////////////////////////////////////////////////////////////////////////////
// Dokument CAirspaceSegmentDoc 

typedef struct
	{
	char szVersion[14];
	unsigned char cFlags;
	unsigned char cDummy;
	short	nActIndex;
	short	nEntryCnt;
	} AIRSPACESEGMENTHEADER;


class CAirspaceSegmentDoc : public CDocument
{
public:
	CAirspaceSegmentDoc();

protected:
	           // Dynamische Erstellung verwendet geschtzten Konstruktor
	DECLARE_DYNCREATE(CAirspaceSegmentDoc)

// Attribute
private:
	#define MAX_HEADER_SIZE 20
    
    AIRSPACESEGMENTHEADER	m_Header;     
	CObArray				m_AirspaceSegments;             
 	BOOL					m_bConverted;
	CString					m_szExt;

// Operationen
public:
	static CString GetExt();
	short GetSortedIndex (CObArray& AirspaceSegments, CAirspaceSegment* ptAirspaceSegment);
	short IdentifierSegNumToIndex (CString szIdentifier, long lSegNum);

	long AddSortedAirspaceSegmentPtr (CAirspaceSegment* ptAirspaceSegment);
	BOOL GetAirspaceSegmentPtr (short nIndex, CAirspaceSegment** ptptAirspaceSegment);
	BOOL GetAirspaceSegmentPtr (CString szIdentifier, 
								long lSegNum, 
								CAirspaceSegment** ptptAirspaceSegment);

	BOOL DeleteAirspaceSegmentPtr (short nIndex);
	BOOL Change(CWnd* ptWnd);

	const CAirspaceSegmentDoc& operator=(const CAirspaceSegmentDoc& AspSegDoc);
	BOOL TryToGetAirspaceSegmentPtr(CAirspaceSegment** ptptAirspaceSegment, 
													 CString szIdentifier,
													 long lSegNum);
	
	virtual void DeleteContents();
	short GetActIndex() { return m_Header.nActIndex; }
	short GetAirspaceSegmentCnt () { return m_Header.nEntryCnt; }

	void SetActIndex(short nIndex) { m_Header.nActIndex = nIndex; }
	void SetAirspaceSegmentCnt (short nCnt) { m_Header.nEntryCnt = nCnt; }

	short CopyAirspaceSegments(CString szAspIdent, 
								 short nStartIndex, short nCnt,
								 CAirspaceSegmentDoc* ptSrcAspSegDoc);


// Operationen
public:

// berschreibungen
	// Vom Klassen-Assistenten generierte virtuelle Funktionsberschreibungen
	//{{AFX_VIRTUAL(CAirspaceSegmentDoc)
	public:
	virtual BOOL OnNewDocument();
	virtual BOOL OnOpenDocument(LPCTSTR lpszPathName);
	virtual BOOL OnSaveDocument(const char* pszPathName, BOOL bConfirm = TRUE);
	virtual void Serialize(CArchive& ar);   // berschrieben fr Dokument-Ein-/Ausgabe
	protected:
	//}}AFX_VIRTUAL

// Implementierung
public:
	virtual ~CAirspaceSegmentDoc();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif


private:
	int Compare(CAirspaceSegment* ptTestEntry, CAirspaceSegment* ptNewEntry);
	int Compare(CAirspaceSegment* ptTestEntry, CString szIdentifier, long lSegNum);
 	void DeleteArrayOf (CObArray* ptArray);
	short HeaderToVers (char* ptHeader);
	void VersToHeader (LPSTR lpHeader, short nVersion);
	void InitHeader ();

	// Generierte Nachrichtenzuordnungsfunktionen
protected:
	//{{AFX_MSG(CAirspaceSegmentDoc)
		// HINWEIS - Der Klassen-Assistent fgt hier Member-Funktionen ein und entfernt diese.
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ fgt unmittelbar vor der vorhergehenden Zeile zustzliche Deklarationen ein.

#endif // __AIRSPACE_SEGMENT_DOC__
