// AltVw.cpp : implementation of the CAltView class
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "stdafx.h"
#include "pf.h"

#include "InitDoc.h"  

#include "TrackDoc.h"
#include "AltVw.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

extern CInitDoc* 		ptInit;
extern CFontDoc* 		ptFontTool;
extern CDimDoc* 		ptDim;      
extern CTrackDoc*		ptTrackDoc;


extern BOOL bMMText;


/****************************************************************************
 *	AltVw.cpp			A l t S c a l e T e x t Y 							*
 ****************************************************************************/
short AltScaleTextY (double dYval, double dYGrid, CString* ptScale)
{
short	nLen;
char	szScale[32];							
CString	szScaleFormat;
CString szDim;

szScaleFormat.LoadString (IDF_TRACK_SCALE);
ptDim->GetDimCstring (&szDim, ptDim->Altitude());
nLen = sprintf (szScale, szScaleFormat, (long)dYval, (LPCTSTR)szDim);

*ptScale = (CString)szScale;
return nLen;
}

/****************************************************************************
 *  AltVw.cpp					A l t M a p X 								*
 ****************************************************************************/
double AltMapX (double dXval)
{
return dXval;
}

/****************************************************************************
 *  AltVw.cpp					A l t M a p Y 								*
 ****************************************************************************/
double AltMapY (double dYval)
{
return dYval;
}



/////////////////////////////////////////////////////////////////////////////
// CAltView

IMPLEMENT_DYNCREATE(CAltView, CTextViewTool)

BEGIN_MESSAGE_MAP(CAltView, CTextViewTool)
	//{{AFX_MSG_MAP(CAltView)
	ON_COMMAND(ID_EDIT_COPY, OnEditCopy)
	//}}AFX_MSG_MAP
	// Standard printing commands
	ON_COMMAND(ID_FILE_PRINT, CTextViewTool::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CTextViewTool::OnFilePrintPreview)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAltView construction/destruction

/************************************************************************
 *  AltVw.cpp   				C A l t V i e w 			Constructor	*
 ************************************************************************/
CAltView::CAltView()
{
	// TODO: add construction code here
ptFontTool->GetParams (m_FontName, &m_wPointSize);

m_CharX = m_LineY = 0;
m_BCharX = m_BLineY = 0;

CreateBoldFont(&m_BoldFont);
CreateNewFont(&m_PlainFont);

m_ptColor = ptInit->GetColorPtr();

m_ptAltGraph = new CMap (AltMapX, AltMapY, AltMapX, AltMapY,
						TimeScaleTextX, AltScaleTextY, 
						ANISOTROPIC);
m_bInitialView = TRUE;

}

/************************************************************************
 *  AltVw.cpp   				~ C A l t V i e w 			Destructor	*
 ************************************************************************/
CAltView::~CAltView()
{
m_PlainFont.DeleteObject ();
m_BoldFont.DeleteObject ();

delete m_ptAltGraph;

}

/************************************************************************
 *  AltVw.cpp				U p d a t e F o n t s 						*
 ************************************************************************/
void CAltView::UpdateFonts (CDC* pDC)
{
ptFontTool->GetParams (m_FontName, &m_wPointSize);
m_lfHeight = this->Y_PointToLP (pDC, m_wPointSize);  

m_PlainFont.DeleteObject ();
CreateNewFont(&m_PlainFont);
this->GetCharSize (pDC, &m_PlainFont, &m_CharX, &m_LineY); 

m_BoldFont.DeleteObject ();
CreateBoldFont(&m_BoldFont);
this->GetCharSize (pDC, &m_BoldFont, &m_BCharX, &m_BLineY); 
}

/************************************************************************
 *  AltVw.cpp			O n I n i t i a l U p d a t e					*
 ************************************************************************/
void CAltView::OnInitialUpdate()
{
	CTextViewTool::OnInitialUpdate();
	// TODO: calculate the total size of this view

CDC* pDC = GetDC();    
pDC->SetMapMode(MM_LOMETRIC);

this->UpdateFonts (pDC);

ReleaseDC(pDC);     
}

/************************************************************************
 *  AltVw.cpp   				  S e t X T a b s 						*
 ************************************************************************/
void CAltView::SetXTabs (CDC* pDC, CTrackDoc* ptTrackDoc, int CharX)
{
int X_TAB, LogPixXToUse, LogPixYToUse;
GetLogPixToUse(pDC, (int*)&LogPixXToUse, (int*)&LogPixYToUse);   

X_TAB = 4*CharX;
m_dX = LogPixXToUse - 2*X_TAB;
m_dY = LogPixYToUse;
m_Xleft  = X_TAB;
m_Xright = m_dX;
}


/************************************************************************
 *  AltVw.cpp				P r e p a r e X T a b s						* 
 ************************************************************************/
void CAltView::PrepareXTabs (CDC* pDC)
{
CTrackDoc* pDoc = GetDocument();
ASSERT_VALID(pDoc);  

if (pDoc != NULL)
	{	        
	pDC->SetMapMode(MM_LOMETRIC);
	this->UpdateFonts (pDC);					// defines m_CharX
	CFont* ptOldFont = (CFont*)pDC->SelectObject (&m_BoldFont);		
    this->SetXTabs (pDC, pDoc, m_CharX);
	pDC->SelectObject (ptOldFont);
	}
}

/************************************************************************
 *  AltVw.cpp					O n U p d a t e 						* 
 *  Called on FileNew, FileOpen, Doc.UpdateAllViews 					*
 ************************************************************************/
void CAltView::OnUpdate (CView* pSender, LPARAM lHint, CObject* pHint)
{
CTrackDoc* pDoc = GetDocument();

if (pDoc != NULL)
	{	        
	CDC* pDC = GetDC();    
	this->PrepareXTabs(pDC);
	ReleaseDC(pDC);     
	
	CTextViewTool::OnUpdate (pSender, lHint, pHint);
	}	 
}

/************************************************************************
 *  AltVw.cpp   			 O n P r e p a r e D C						*
 ************************************************************************/
void CAltView::OnPrepareDC(CDC* pDC, CPrintInfo* pInfo) 
{
	// TODO: Add your specialized code here and/or call the base class

CTrackDoc* pDoc = GetDocument();
ASSERT_VALID(pDoc);  

if (pDoc != NULL)
	{	        
	m_bForPrinter = pDC->IsPrinting();	  // important to get correct update after printing
	this->PrepareXTabs(pDC);
	}
		
if (!m_bForPrinter)
	CTextViewTool::OnPrepareDC(pDC, pInfo);	 // sets bContinuePrinting = TRUE if SetMaxPage is set
}

/************************************************************************
 *  AltVw.cpp					G e t M a x R e c t L P					*
 ************************************************************************/
void CAltView::GetMaxRectLP (CDC* pDC, CWnd* ptWnd, LPRECT lpRectMax, BOOL bPrinter)
{
					 //normal: CapsX = 52, LineY = 60
if (bPrinter)
    {
    int Width_pix, Height_lines;
    POINT   Offset, Pixels;

    Width_pix = pDC->GetDeviceCaps (HORZRES);	/* 960 pixels	*/
    Height_lines = pDC->GetDeviceCaps (VERTRES);	/* 841 lines	*/

    Pixels.x = Width_pix;
    Pixels.y = Height_lines;
	
	pDC->DPtoLP((LPPOINT)&Pixels, 1);   /* W=2032, H=-2967	    */
    Offset.x = (int)(0.05* Pixels.x);	    /* start 05% of pagewidth */
    Offset.y = (int)(0.08* Pixels.y);	    /* start 08% of pageheight*/
    Pixels.x = (int)(0.9 * Pixels.x);	    /* use 90% of pagewidth */
    Pixels.y = (int)(0.85* Pixels.y);	    /* use 85% of pageheight*/
    SetRect (lpRectMax, Offset.x, Offset.y, 
						Pixels.x, Pixels.y);
    }
else{					    /* use actual window size*/
    ptWnd->GetClientRect (lpRectMax);
	pDC->DPtoLP((LPPOINT)lpRectMax, 2);
    }
}


/************************************************************************
 *  AltVw.cpp				G e t U s e a b l e R e c t L P				*
 ************************************************************************/
CRect CAltView::GetUseableRectLP (CDC* pDC)
{
CRect rView, rBorderLP;

if (m_bForPrinter && pDC != NULL)
	{
	this->GetMaxRectLP (pDC, this, rView, m_bForPrinter);
	short nFrameX = (short)((double)(rView.right - rView.left) / 50);
	short nFrameY = (short)((double)(rView.bottom - rView.top) / 70);

	rBorderLP.top	= rView.top		+ 3*nFrameY;
	rBorderLP.left	= rView.left	+ 6*nFrameX;
	rBorderLP.right	= rView.right	- 0*nFrameX;
	rBorderLP.bottom = rView.bottom	- 1*nFrameY;
	}
else{
	CClientDC dc (this);
	dc.SetMapMode (MM_LOMETRIC);

	GetClientRect (rView);
	dc.DPtoLP((LPPOINT)&rView, 2);
	rBorderLP.top	= rView.top		+ 4*m_LineY;
	rBorderLP.left	= rView.left	+ 4*m_CharX;
	rBorderLP.right	= rView.right	- 4*m_CharX;
	rBorderLP.bottom = rView.bottom	- 2*m_LineY;
	}  

return rBorderLP;
}

/****************************************************************************
 *	AltVw.cpp					D r a w O n M a p 							*
 ****************************************************************************/
void CAltView::DrawOnMap (CDC* pDC, BOOL bAntipod)
{

CTrackDoc* pDoc = GetDocument();
ASSERT_VALID(pDoc);

	// TODO: add draw code for native data here            

if (pDoc != NULL)
	{
	long		LPx1, LPy1;
	short		i, nCnt;
	short		nAltDim;
	CTrackPoint TrackPt;

	LPx1 = LPy1 = 0;
	nCnt	= pDoc->GetCnt();
	nAltDim = pDoc->GetAltDim();

	m_ptColor->SelectRoutePen (pDC, TRUE);
	m_ptAltGraph->Clip(TRUE);			/* draw on map only		*/


	CElevArrayDoc* ptElevArrayDoc = ptInit->GetElevArrayDocPtr();
	if (ptElevArrayDoc != NULL)
	{
		long LPx, LPy, LPbottom;

		m_ptColor->SelectElevArrayPen (pDC, TRUE);

										// get LP bottom, used to draw elev lines
		long lAlt = (long)m_rMap.bottom;
		m_ptAltGraph->XYtoLP (0, lAlt, &LPx, &LPy);											
		LPbottom = LPy;

		for (i=0; i<nCnt; i++)
		{
			long lTime, lAlt;
			if (pDoc->GetTrackPointPtr (i, &TrackPt))
			{
				double dLat, dLon;
				if (TrackPt.GetLatLon(&dLat, &dLon))
				{
					short nElev_m;
					if (ptElevArrayDoc->GetElev_m(dLat, dLon, &nElev_m))
					{
						lTime = TrackPt.GetSec ();
						lAlt = (long)ptDim->ConvertDist (nElev_m, DIM_METER, ptDim->Altitude());
						m_ptAltGraph->XYtoLP (lTime, lAlt, &LPx1, &LPy1);

						pDC->MoveTo (LPx1, LPy1);
						pDC->LineTo (LPx1, LPbottom);
					}
				}
			}
		}



		m_ptColor->SelectElevArrayPen (pDC, FALSE);

	} // ptElevArrayDoc != NULL




	for (i=0; i<nCnt; i++)
	{
		long lTime, lAlt;
		if (pDoc->GetTrackPointPtr (i, &TrackPt))
		{
			if (TrackPt.GetAlt (&lAlt))
			{
				lTime = TrackPt.GetSec ();
				lAlt = (long)ptDim->ConvertDist (lAlt, nAltDim, ptDim->Altitude());
				m_ptAltGraph->XYtoLP (lTime, lAlt, &LPx1, &LPy1);

				if (i==0)	pDC->MoveTo (LPx1, LPy1);
					else	pDC->LineTo (LPx1, LPy1);
			}
		}

	}

	if (ptElevArrayDoc != NULL)
		ptElevArrayDoc->ArrayClose();

	m_ptAltGraph->Clip(FALSE);
	m_ptColor->SelectRoutePen (pDC, FALSE);
	}
}


/************************************************************************
 *  AltVw.cpp    		 	 D r a w T r a c k A l t					*
 ************************************************************************/
BOOL CAltView::DrawTrackAlt (CDC* pDC, CTrackDoc* ptTrackDoc, 
						DWORD* ptIndex,
					    int* ptY, BOOL bDraw)
{
int		X, Y;
CString szText;
CFont* ptOldFont;
//CRect	rMapLP;

ActivateDrawing (bDraw);

ptOldFont = (CFont*)pDC->SelectObject (&m_PlainFont);
Y = m_LineY;
  
CRect rView = this->GetUseableRectLP (pDC);


long lMinX, lMaxX, lMinY, lMaxY;
short	nGridX, nGridY;

DRECT rMinMap;
ptTrackDoc->GetAltMapBorders (&lMinX, &lMaxX, &lMinY, &lMaxY, &nGridX, &nGridY);
rMinMap.top		= lMaxY;
rMinMap.bottom  = lMinY;
rMinMap.left	= lMinX;
rMinMap.right	= lMaxX;

m_rMap = rMinMap;

m_ptAltGraph->CalculateGraph (pDC, m_rMap, rView, m_bForPrinter, nGridX, nGridY);


//rMapLP = m_ptAltGraph->GetGridRect();	// returns m_rGridLP
if (m_bForPrinter)
	{
	m_ptAltGraph->SetTitle (ptTrackDoc->GetTitle());
	}

m_ptAltGraph->DrawGrid (pDC, m_CharX, m_LineY, &X, &Y);

					// draws altitude or speed with virtual function
this->DrawOnMap (pDC, FALSE);	 // bAntipod = FALSE;


pDC->SelectObject (ptOldFont);

return FALSE;
}

/////////////////////////////////////////////////////////////////////////////
// CAltView drawing


/************************************************************************
 *  AltVw.cpp   			  P r i n t P a g e							*
 ************************************************************************/
void CAltView::PrintPage (CDC* pDC, int nPageToPrint)
{
CTrackDoc* pDoc = GetDocument();
ASSERT_VALID(pDoc);

int	Y;
int	X_TAB;
int	nPage = 1;


DWORD dwIndex = 0;

if (pDoc != NULL)
	{
	BOOL bDraw;

	do	{
		X_TAB = 4*m_CharX;
		Y = 3*m_LineY;

		bDraw = (nPage == nPageToPrint);
		m_bMore = DrawTrackAlt (pDC, pDoc, &dwIndex, &Y, bDraw);
		nPage++;
		} while (!bDraw);
	}    
}                                  

/************************************************************************
 *  AltVw.cpp   					  O n D r a w						*
 ************************************************************************/
void CAltView::OnDraw(CDC* pDC)
{
	CTrackDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);

	// TODO: add draw code for native data here            

int	Y = m_LineY;

if (pDoc != NULL)
	{
	BOOL	bMore = FALSE;
	DWORD 	dwIndex = 0;

	bMore = DrawTrackAlt (pDC, pDoc, &dwIndex, &Y, m_bDraw);
	}	
}


/////////////////////////////////////////////////////////////////////////////
// CAltView printing


/************************************************************************
 *  AltVw.cpp   		  O n P r e p a r e P r i n t i n g				*
 ************************************************************************/
BOOL CAltView::OnPreparePrinting(CPrintInfo* pInfo)
{			 // called before the display of the print dialog
	// default preparation
m_bMore = TRUE;	               

UINT nMinPage = 1;						// Number of the first page of the document
UINT nMaxPage = 1;						// Number of the last page of the document
pInfo->SetMinPage (nMinPage);
pInfo->SetMaxPage (nMaxPage);

return DoPreparePrinting(pInfo);
}

/************************************************************************
 *  AltVw.cpp  			O n B e g i n P r i n t i n g					*
 ************************************************************************/
void CAltView::OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo)
{			   // called after the print dialog exists
	// TODO: add extra initialization before printing
CTrackDoc* pDoc = GetDocument();
ASSERT_VALID(pDoc);  

if (pDoc != NULL)
	{	        
//	pDC->SetMapMode(MM_LOMETRIC);

//	this->UpdateFonts (pDC);					// defines m_CharX

//    this->SetXTabs (pDC, pDoc, m_CharX);
	}
							// 2. possibility to set the document length 
}

/************************************************************************
 *  AltVw.cpp   		 		 O n P r i n t							*
 ************************************************************************/
void CAltView::OnPrint(CDC* pDC, CPrintInfo* pInfo) 
{
	// TODO: Add your specialized code here and/or call the base class
this->PrintPage (pDC, pInfo->m_nCurPage);
}

/************************************************************************
 *  AltVw.cpp  			O n E n d P r i n t i n g					*
 ************************************************************************/
void CAltView::OnEndPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add cleanup after printing
}

/////////////////////////////////////////////////////////////////////////////
// CAltView diagnostics

#ifdef _DEBUG
void CAltView::AssertValid() const
{
	CTextViewTool::AssertValid();
}

void CAltView::Dump(CDumpContext& dc) const
{
	CTextViewTool::Dump(dc);
}
#endif //_DEBUG

CTrackDoc* CAltView::GetDocument() // non-debug version  w a s  inline
{
//	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CTrackDoc)));
//	return (CTrackDoc*)m_pDocument;
	return ptTrackDoc;
}

/////////////////////////////////////////////////////////////////////////////
// CAltView message handlers

void CAltView::OnEditCopy() 
{
	// TODO: Add your command handler code here
this->CopyToClipboard();		
}
