#ifndef __ALTVIEW__
#define __ALTVIEW__

// AltVw.h : interface of the CAltView class
//
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de
/////////////////////////////////////////////////////////////////////////////
#include "..\CPPTOOLS\TxVwTool.h"
#include "Map.h"				// includes CBorder class

class CAltView : public CTextViewTool
{
public:
	CFont	m_PlainFont; 
	CFont	m_BoldFont; 
	int		m_CharX, m_LineY;
	int		m_BCharX, m_BLineY;

	CMap*	m_ptAltGraph;
	DRECT	m_rMapBorder;	// lat lon on rVirtLP
	BOOL	m_bInitialView;

	DRECT	m_rMap;			// lat lon on visible map area


protected: // create from serialization only
	DECLARE_DYNCREATE(CAltView)

	CColorDoc* 	m_ptColor;

// Attributes
public:
	CTrackDoc* GetDocument();

// Operations
public:

// Implementation
public:
	CAltView();
	virtual ~CAltView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:
	void UpdateFonts (CDC* pDC);
	void SetXTabs (CDC* pDC, CTrackDoc* ptTrackDoc, int CharX);
	void PrepareXTabs (CDC* pDC);

	void GetMaxRectLP (CDC* pDC, CWnd* ptWnd, LPRECT lpRectMax, BOOL bPrinter);
	CRect GetUseableRectLP (CDC* pDC);

	void DrawOnMap (CDC* pDC, BOOL bAntipod);

	BOOL DrawTrackAlt (CDC* pDC, CTrackDoc* ptTrackDoc, DWORD* ptIndex,
					int* ptY, BOOL bDraw = TRUE);

	void PrintPage (CDC* pDC, int nPageToPrint);

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CMusterView)
public:
	virtual void OnDraw(CDC* pDC);  // overridden to draw this view
	virtual void OnPrepareDC(CDC* pDC, CPrintInfo* pInfo = NULL);
protected:
	virtual void OnUpdate (CView* pSender, LPARAM lHint, CObject* pHint);
	virtual void OnInitialUpdate(); // called first time after construct
	virtual BOOL OnPreparePrinting(CPrintInfo* pInfo);
	virtual void OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo);
	virtual void OnPrint(CDC* pDC, CPrintInfo* pInfo); 
	virtual void OnEndPrinting(CDC* pDC, CPrintInfo* pInfo);
	//}}AFX_VIRTUAL



// Generated message map functions
protected:
	//{{AFX_MSG(CAltView)
	afx_msg void OnEditCopy();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

//#ifndef _DEBUG  // debug version in AltVw.cpp
//inline CTrackDoc* CAltView::GetDocument()
//   { return (CTrackDoc*)m_pDocument; }
//#endif

/////////////////////////////////////////////////////////////////////////////
#endif
