// appnddlg.cpp : implementation file
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "stdafx.h"
#include "pf.h"    

#include "AppndDoc.h"
#include "AppndDlg.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// CAppendixDlg dialog

CAppendixDlg::CAppendixDlg(CWnd* pParent, CAppendixDoc* ptDoc)
	: CDlgTool(CAppendixDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CAppendixDlg)  
	//}}AFX_DATA_INIT
	m_bWindInfo = ptDoc->IsWindInfo();
	m_bFuelInfo = ptDoc->IsFuelInfo();
	m_bSunInfo = ptDoc->IsSunInfo();
	m_bUseText1 = ptDoc->IsTextActiv(0);
	m_bUseText2 = ptDoc->IsTextActiv(1);
	m_bUseText3 = ptDoc->IsTextActiv(2);
	ptDoc->GetUserText(0, &m_szText1);
	ptDoc->GetUserText(1, &m_szText2);
	ptDoc->GetUserText(2, &m_szText3);    
}
 
 
void CAppendixDlg::GetAppendix (CAppendixDoc* ptDoc)
{
	ptDoc->SetWindInfo(m_bWindInfo);
	ptDoc->SetFuelInfo(m_bFuelInfo);
	ptDoc->SetSunInfo(m_bSunInfo);
	ptDoc->ActivateText(0, m_bUseText1);
	ptDoc->ActivateText(1, m_bUseText2);
	ptDoc->ActivateText(2, m_bUseText3); 
	
	ptDoc->SetUserText(0, m_szText1);
	ptDoc->SetUserText(1, m_szText2);
	ptDoc->SetUserText(2, m_szText3);
}


void CAppendixDlg::DoDataExchange(CDataExchange* pDX)
{
	CDlgTool::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAppendixDlg)
	DDX_Check(pDX, IDC_APWINDINFO, m_bWindInfo);
	DDX_Check(pDX, IDC_APFUELINFO, m_bFuelInfo);
	DDX_Check(pDX, IDC_APSUNINFO, m_bSunInfo);
	DDX_Check(pDX, IDC_APUSETEXT1, m_bUseText1);
	DDX_Check(pDX, IDC_APUSETEXT2, m_bUseText2);
	DDX_Check(pDX, IDC_APUSETEXT3, m_bUseText3);
	DDX_Text(pDX, IDC_APTEXT1, m_szText1);
	DDV_MaxChars(pDX, m_szText1, 80);
	DDX_Text(pDX, IDC_APTEXT2, m_szText2);
	DDV_MaxChars(pDX, m_szText2, 80);
	DDX_Text(pDX, IDC_APTEXT3, m_szText3);
	DDV_MaxChars(pDX, m_szText3, 80);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAppendixDlg, CDlgTool)
	//{{AFX_MSG_MAP(CAppendixDlg)
	ON_BN_CLICKED(IDC_APUSETEXT1, OnUseText1)
	ON_BN_CLICKED(IDC_APUSETEXT2, OnUseText2)
	ON_BN_CLICKED(IDC_APUSETEXT3, OnUseText3)
	ON_WM_HELPINFO()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CAppendixDlg message handlers

void CAppendixDlg::OnUseText1()
{
	// TODO: Add your control notification handler code here
this->DisableControl (IDC_APTEXT1, !this->GetControl (IDC_APUSETEXT1));
}

void CAppendixDlg::OnUseText2()
{
	// TODO: Add your control notification handler code here
this->DisableControl (IDC_APTEXT2, !this->GetControl (IDC_APUSETEXT2));
}

void CAppendixDlg::OnUseText3()
{
	// TODO: Add your control notification handler code here
this->DisableControl (IDC_APTEXT3, !this->GetControl (IDC_APUSETEXT3));
}

BOOL CAppendixDlg::OnInitDialog()
{
	CDlgTool::OnInitDialog();
	
	// TODO: Add extra initialization here
	
	this->OnUseText1();
	this->OnUseText2();
	this->OnUseText3();
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}


/************************************************************************
 *  AppndDlg.cpp	 			 O n H e l p I n f o					*
 ************************************************************************/
BOOL CAppendixDlg::OnHelpInfo(HELPINFO* pHelpInfo) 
{
	// TODO: Add your message handler code here and/or call default
	
if (pHelpInfo->iContextType == HELPINFO_WINDOW)
	{
	AfxGetApp()->WinHelp (pHelpInfo->dwContextId, HELP_CONTEXTPOPUP);
	}

return TRUE;
}

