/************************************************************************
 *  						A p p n d D o c . c p p  					*
 ************************************************************************/
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "stdafx.h"
#include "pf.h"

#include "AppndDlg.h"				// dialog to set appendix pref parameters
#include "AppndDoc.h"  

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAppendixDoc
IMPLEMENT_DYNCREATE(CAppendixDoc, CDocument)

BEGIN_MESSAGE_MAP(CAppendixDoc, CDocument)
	//{{AFX_MSG_MAP(CAppendixDoc)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAppendixDoc construction/destruction

CAppendixDoc::CAppendixDoc()
{                                      
m_bWindInfo = FALSE;		    
m_bFuelInfo = FALSE;
m_bSunInfo 	= FALSE;
m_bUseText1 = FALSE;
m_bUseText2 = FALSE;
m_bUseText3 = FALSE;
m_szText1[0] = 0;	    /* User text	    */
m_szText2[0] = 0;
m_szText3[0] = 0;
}

CAppendixDoc::~CAppendixDoc()
{
}

/************************************************************************
 *  AppndDoc.cpp	  	 		 S e t U s e r T e x t					*
 ************************************************************************/
void CAppendixDoc::SetUserText(short nIndex, CString szText)
{ 
char* ptUserText;

switch (nIndex)
	{
	case 0:	ptUserText = m_szText1;	break;
	case 1:	ptUserText = m_szText2;	break;
	case 2:	ptUserText = m_szText3;	break;
	default:
		AfxMessageBox ("SetUsetText - bad index");
		break;
	}
	
strcpy (ptUserText, (LPCTSTR)szText);
}         

/************************************************************************
 *  AppndDoc.cpp		 		 G e t U s e r T e x t					*
 ************************************************************************/
void CAppendixDoc::GetUserText(short nIndex, CString* ptText)
{
switch (nIndex)
	{
	case 0:	*ptText = (CString)m_szText1;	break;
	case 1:	*ptText = (CString)m_szText2;	break;
	case 2:	*ptText = (CString)m_szText3;	break; 
	default:	ptText->Empty();			break;
	}
}         

/************************************************************************
 *  AppndDoc.cpp	  	 		A c t i v a t e T e x t					*
 ************************************************************************/
void CAppendixDoc::ActivateText (short nIndex, BOOL bActivate)
{
switch (nIndex)
	{
	case 0:	m_bUseText1 = bActivate;	break;
	case 1:	m_bUseText2 = bActivate;	break;
	case 2:	m_bUseText3 = bActivate;	break; 
    }
}

/************************************************************************
 *  AppndDoc.cpp	  	 		I s T e x t A c t i v 					*
 ************************************************************************/
BOOL CAppendixDoc::IsTextActiv (short nIndex)
{
BOOL bActiv = FALSE;
switch (nIndex)
	{
	case 0:	bActiv = m_bUseText1;	break;
	case 1:	bActiv = m_bUseText2;	break;
	case 2:	bActiv = m_bUseText3;	break; 
    }    
return bActiv;
}                                                     

/************************************************************************
 *  AppndDoc.cpp	  			I s A p p e n d i x  					*
 ************************************************************************/
BOOL CAppendixDoc::IsAppendix()
{
BOOL bAppendix = (m_bWindInfo || m_bFuelInfo || m_bSunInfo ||
				  m_bUseText1 || m_bUseText2 || m_bUseText3);
return bAppendix;
}

/************************************************************************
 *  AppndDoc.cpp	  		 		 C h a n g e 						*
 ************************************************************************/
BOOL CAppendixDoc::Change(CWnd* ptWnd)
{
	BOOL bChanged = FALSE;
	
	CAppendixDlg AppendixDlg(ptWnd, this);

	int RetVal = AppendixDlg.DoModal();
	switch (RetVal)
		{
		case IDOK:   
			AppendixDlg.GetAppendix (this);  
			bChanged = TRUE;
			break;
		case IDCANCEL:
			break;
		}

	return bChanged;	
} 


/************************************************************************
 *  AppndDoc.cpp	  	 		 S e r i a l i z e 						*
 ************************************************************************/
void CAppendixDoc::Serialize(CArchive& ar)
{    
WORD	Word;

if (ar.IsStoring())
	{
		// TODO: add storing code here   
	ar << (WORD)m_bWindInfo;      
	ar << (WORD)m_bFuelInfo;      
	ar << (WORD)m_bSunInfo;      
	ar << (WORD)m_bUseText1;      
	ar << (WORD)m_bUseText2;      
	ar << (WORD)m_bUseText3;      

	ar.Write (&m_szText1, USERTEXT_SIZE);		   
	ar.Write (&m_szText2, USERTEXT_SIZE);		   
	ar.Write (&m_szText3, USERTEXT_SIZE);		   
	}
else{
		// TODO: add loading code here  
	ar >> Word;		m_bWindInfo  = (BOOL)Word; 		   
	ar >> Word;		m_bFuelInfo  = (BOOL)Word; 		   
	ar >> Word;		m_bSunInfo   = (BOOL)Word; 		   
	ar >> Word;		m_bUseText1  = (BOOL)Word; 		   
	ar >> Word;		m_bUseText2  = (BOOL)Word; 		   
	ar >> Word;		m_bUseText3  = (BOOL)Word; 		   
    
    ar.Read (m_szText1, USERTEXT_SIZE);
    ar.Read (m_szText2, USERTEXT_SIZE);
    ar.Read (m_szText3, USERTEXT_SIZE);
	}
}


 