// ArmsDlg.cpp : implementation file
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "stdafx.h"
#include "pf.h"

#include "InitDoc.h"
#include "DimDoc.h"    
     
#include "PlaneDoc.h"
#include "ArmsDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern CDimDoc*		ptDim;
extern CInitDoc* 	ptInit;  

//extern float	g_fNoArm;		// undefined value (99m) indicator in actual dimension, see DlgTool.cpp 

/////////////////////////////////////////////////////////////////////////////
// CArmsDlg dialog


CArmsDlg::CArmsDlg(CWnd* pParent, CPlane* ptPlane)
	: CDlgTool(CArmsDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CArmsDlg)
	m_nArmDim = -1;
	//}}AFX_DATA_INIT

m_ptPlane = ptPlane;
m_bChanged = FALSE;           

this->SetData(m_ptPlane);
}

CArmsDlg::~CArmsDlg()
{

}


/************************************************************************
 *  ArmsDlg.cpp	  		 	S e t D a t a  							*
 ************************************************************************/
void CArmsDlg::SetData (CPlane* ptPlane)
{  
short nArmDim;

nArmDim = ptPlane->GetLeverArmDim();
m_nArmDim = ptDim->GetPUIndex (ARM, nArmDim);

short nIndex = 0;
m_fRowArm0 = ptPlane->GetRowArm(nIndex);
m_fLugArm0 = ptPlane->GetLugArm(nIndex);

nIndex = 1;
m_fRowArm1 = ptPlane->GetRowArm(nIndex);
m_fLugArm1 = ptPlane->GetLugArm(nIndex);

nIndex = 2;
m_fRowArm2 = ptPlane->GetRowArm(nIndex);
m_fLugArm2 = ptPlane->GetLugArm(nIndex);

nIndex = 3;
m_fRowArm3 = ptPlane->GetRowArm(nIndex);
m_fLugArm3 = ptPlane->GetLugArm(nIndex);

nIndex = 4;
m_fRowArm4 = ptPlane->GetRowArm(nIndex);
m_fLugArm4 = ptPlane->GetLugArm(nIndex);
}	

/************************************************************************
 *  ArmsDlg.cpp	  				G e t D a t a  							*
 ************************************************************************/
void CArmsDlg::GetData (CPlane* ptPlane)
{                            
short nArmDim	= ptDim->GetPUDim (ARM, m_nArmDim);

ptPlane->SetLeverArmDim(nArmDim);

short nIndex = 0;
ptPlane->SetRowArm(nIndex, m_fRowArm0);
ptPlane->SetLugArm(nIndex, m_fLugArm0);

nIndex = 1;
ptPlane->SetRowArm(nIndex, m_fRowArm1);
ptPlane->SetLugArm(nIndex, m_fLugArm1);

nIndex = 2;
ptPlane->SetRowArm(nIndex, m_fRowArm2);
ptPlane->SetLugArm(nIndex, m_fLugArm2);

nIndex = 3;
ptPlane->SetRowArm(nIndex, m_fRowArm3);
ptPlane->SetLugArm(nIndex, m_fLugArm3);

nIndex = 4;
ptPlane->SetRowArm(nIndex, m_fRowArm4);
ptPlane->SetLugArm(nIndex, m_fLugArm4);
}	


/************************************************************************
 *  ArmsDlg.cpp	  				DoDataExchange							*
 ************************************************************************/
void CArmsDlg::DoDataExchange(CDataExchange* pDX)
{
this->ActivateDimGroups();

	CDlgTool::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CArmsDlg)
	DDX_CBIndexArmDim(pDX, ID_LAARMDIM, m_nArmDim);
	DDX_Arm(pDX, ID_LAROWARM0, m_fRowArm0);
	DDV_Arm(pDX, m_fRowArm0, -5.f, 10.f);
	DDX_ArmOpt(pDX, ID_LAROWARM1, m_fRowArm1);
	DDV_ArmOpt(pDX, m_fRowArm1, -5.f, 10.f);
	DDX_ArmOpt(pDX, ID_LAROWARM2, m_fRowArm2);
	DDV_ArmOpt(pDX, m_fRowArm2, -5.f, 10.f);
	DDX_ArmOpt(pDX, ID_LAROWARM3, m_fRowArm3);
	DDV_ArmOpt(pDX, m_fRowArm3, -5.f, 10.f);
	DDX_ArmOpt(pDX, ID_LAROWARM4, m_fRowArm4);
	DDV_ArmOpt(pDX, m_fRowArm4, -5.f, 10.f);
	DDX_ArmOpt(pDX, ID_LALUGARM0, m_fLugArm0);
	DDV_ArmOpt(pDX, m_fLugArm0, -5.f, 10.f);
	DDX_ArmOpt(pDX, ID_LALUGARM1, m_fLugArm1);
	DDV_ArmOpt(pDX, m_fLugArm1, -5.f, 10.f);
	DDX_ArmOpt(pDX, ID_LALUGARM2, m_fLugArm2);
	DDV_ArmOpt(pDX, m_fLugArm2, -5.f, 10.f);
	DDX_ArmOpt(pDX, ID_LALUGARM3, m_fLugArm3);
	DDV_ArmOpt(pDX, m_fLugArm3, -5.f, 10.f);
	DDX_ArmOpt(pDX, ID_LALUGARM4, m_fLugArm4);
	DDV_ArmOpt(pDX, m_fLugArm4, -5.f, 10.f);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CArmsDlg, CDlgTool)
	//{{AFX_MSG_MAP(CArmsDlg)
	ON_WM_HELPINFO()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CArmsDlg message handlers

BOOL CArmsDlg::OnInitDialog() 
{
this->AddDimGroup (ID_LAROWARM0, ID_LAARMDIM);
this->AddDimGroup (ID_LAROWARM1, ID_LAARMDIM);
this->AddDimGroup (ID_LAROWARM2, ID_LAARMDIM);
this->AddDimGroup (ID_LAROWARM3, ID_LAARMDIM);
this->AddDimGroup (ID_LAROWARM4, ID_LAARMDIM);

this->AddDimGroup (ID_LALUGARM0, ID_LAARMDIM);
this->AddDimGroup (ID_LALUGARM1, ID_LAARMDIM);
this->AddDimGroup (ID_LALUGARM2, ID_LAARMDIM);
this->AddDimGroup (ID_LALUGARM3, ID_LAARMDIM);
this->AddDimGroup (ID_LALUGARM4, ID_LAARMDIM);

this->FillDimPU (ID_LAARMDIM, ARM);


	// TODO: Add extra initialization here

CDlgTool::OnInitDialog();
return TRUE;  // return TRUE unless you set the focus to a control
	          // EXCEPTION: OCX Property Pages should return FALSE
}

/************************************************************************
 *  ArmsDlg.cpp	  				 O n H e l p I n f o					*
 ************************************************************************/
BOOL CArmsDlg::OnHelpInfo(HELPINFO* pHelpInfo) 
{
	// TODO: Add your message handler code here and/or call default
	
if (pHelpInfo->iContextType == HELPINFO_WINDOW)
	{
	AfxGetApp()->WinHelp (pHelpInfo->dwContextId, HELP_CONTEXTPOPUP);
	}

return TRUE;
}
