// AuKoDlg.cpp: Implementierungsdatei
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "stdafx.h"
#include "pf.h"
#include "InitDoc.h"

#include "LocDoc.h"			// for CategoryToIndex
#include "AuKoDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// Dialogfeld CAutoKoordDlg


CAutoKoordDlg::CAutoKoordDlg(CWnd* pParent, 
						CLocation* ptLoc, 
						CQuickFind* ptQuickFind,
						CNameList* ptNameList)
	: CDialog(CAutoKoordDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CAutoKoordDlg)
	m_nListIndex = -1;
	m_szCategory = _T("");
	m_szRegion = _T("");
	//}}AFX_DATA_INIT

m_ptQuickFind= ptQuickFind;
m_ptNameList = ptNameList;
m_ptLoc			= ptLoc;
}


void CAutoKoordDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAutoKoordDlg)
	DDX_LBIndex(pDX, IDC_AKLIST, m_nListIndex);
	DDX_Text(pDX, IDC_AKCATEGORY, m_szCategory);
	DDV_MaxChars(pDX, m_szCategory, 32);
	DDX_Text(pDX, IDC_AKREGION, m_szRegion);
	DDV_MaxChars(pDX, m_szRegion, 32);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CAutoKoordDlg, CDialog)
	//{{AFX_MSG_MAP(CAutoKoordDlg)
	ON_LBN_SELCHANGE(IDC_AKLIST, OnSelchangeList)
	ON_LBN_DBLCLK(IDC_AKLIST, OnDblclkList)
	ON_BN_CLICKED(IDC_AKREGIONS, OnRegions)
	ON_WM_HELPINFO()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// Behandlungsroutinen fr Nachrichten CAutoKoordDlg 

/************************************************************************
 *  AuKoDlg.cpp	  		 F i l l L o c a t i o n L i s t 				*
 ************************************************************************/
void CAutoKoordDlg::FillLocationList (CLocation* ptLoc)
{
	CListBox* ptList = (CListBox*)GetDlgItem (IDC_AKLIST);    
	ptList->ResetContent();

	long lFirstIndex = -1;
	long lLastIndex = -1;
	CString	szName;

	szName = m_ptLoc->GetNameForRte();
					
	if (m_ptNameList->GetSortedIndexRange ((LPCTSTR)szName, 
			&lFirstIndex, &lLastIndex))
	m_nListIndex = (short)lFirstIndex;				// TODO: use long value for list

	long i;
	NAMEINDEXTYPE* ptEntry=NULL;
	for (i=0; i<m_ptNameList->GetSize(); i++)
	{      
		ptEntry = m_ptNameList->GetEntryPtr (i);
		if (ptEntry != NULL)
		{
			ptList->AddString((LPCTSTR)ptEntry->szName);  
		}
	}              
}                             

/************************************************************************
 *  AuKoDlg.cpp    		 		S e t D a t a							*
 ************************************************************************/
void CAutoKoordDlg::SetData(NAMEINDEXTYPE* ptEntry) 
{
CString szCategory;
short nCategory = ptEntry->nCategory;
CATEGORYINDEX CatIndex = CLocDoc::CategoryToIndex (nCategory);
m_szCategory.LoadString (ID_CA_AIRPORT+(short)CatIndex);  

							// set new region
short nRegIndex = ptEntry->nRegionIndex;
m_szRegion = m_ptNameList->GetRegionName (nRegIndex);
}

/************************************************************************
 *  AuKoDlg.cpp    		 		O n I n i t D i a l o g 				*
 ************************************************************************/
BOOL CAutoKoordDlg::OnInitDialog() 
{
this->FillLocationList (m_ptLoc);
 
if (m_nListIndex >= 0)
	{
	NAMEINDEXTYPE* ptEntry=NULL;
	ptEntry = m_ptNameList->GetEntryPtr (m_nListIndex);
	if (ptEntry != NULL)
		this->SetData(ptEntry);
	}


CDialog::OnInitDialog();

// TODO: Zustzliche Initialisierung hier einfgen

return TRUE;  // return TRUE unless you set the focus to a control
	          // EXCEPTION: OCX-Eigenschaftenseiten sollten FALSE zurckgeben
}

/************************************************************************
 *  AuKoDlg.cpp    	 		O n S e l c h a n g e L i s t				*
 ************************************************************************/
void CAutoKoordDlg::OnSelchangeList() 
{
	// TODO: Code fr die Behandlungsroutine der Steuerelement-Benachrichtigung hier einfgen
CListBox* ptList = (CListBox*)GetDlgItem (IDC_AKLIST);    
short nNewIndex = ptList->GetCurSel ();

if (m_nListIndex != nNewIndex)
	{	
	NAMEINDEXTYPE* ptEntry=NULL;
	ptEntry = m_ptNameList->GetEntryPtr (nNewIndex);
	if (ptEntry != NULL)
		{
		this->SetData(ptEntry);

		m_nListIndex = nNewIndex;
 		this->UpdateData(FALSE);
		}
	}
}

/************************************************************************
 *  AuKoDlg.cpp	  		 O n D b l c l k L i s t 						*
 ************************************************************************/
void CAutoKoordDlg::OnDblclkList() 
{
	// TODO: Add your control notification handler code here
this->OnOK();
}

/************************************************************************
 *  AuKoDlg.cpp    		 		G e t L o c 							*
 ************************************************************************/
BOOL CAutoKoordDlg::GetLoc (CLocation* ptLoc, short* ptRegIndex)
{
BOOL bFound = FALSE;

bFound = m_ptNameList->GetLoc (ptLoc, m_nListIndex, ptRegIndex);
return bFound;	
}

/************************************************************************
 *  AuKoDlg.cpp    		 		O n R e g i o n s						*
 ************************************************************************/
void CAutoKoordDlg::OnRegions() 
{
	// TODO: Code fr die Behandlungsroutine der Steuerelement-Benachrichtigung hier einfgen
if (m_ptQuickFind->Change (this))
	{
	this->FillLocationList (m_ptLoc);
 
	if (m_nListIndex >= 0)
		{
		NAMEINDEXTYPE* ptEntry=NULL;
		ptEntry = m_ptNameList->GetEntryPtr (m_nListIndex);
		if (ptEntry != NULL)
			this->SetData(ptEntry);
		}
	}		
}

/************************************************************************
 *  AuKoDlg.cpp    		 			O n O K								*
 ************************************************************************/
void CAutoKoordDlg::OnOK() 
{
	// TODO: Zustzliche Prfung hier einfgen
	
	CDialog::OnOK();
}

/************************************************************************
 *  AuKoDlg.cpp	  				 O n H e l p I n f o					*
 ************************************************************************/
BOOL CAutoKoordDlg::OnHelpInfo(HELPINFO* pHelpInfo) 
{
	// TODO: Add your message handler code here and/or call default
	
if (pHelpInfo->iContextType == HELPINFO_WINDOW)
	{
	AfxGetApp()->WinHelp (pHelpInfo->dwContextId, HELP_CONTEXTPOPUP);
	}

return TRUE;
}
