// BearDlg.cpp: Implementierungsdatei
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "stdafx.h"
#include "pf.h"

#include "InitDoc.h"
#include "WayPoint.h"
#include "BearDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern CInitDoc* 	ptInit;  

/////////////////////////////////////////////////////////////////////////////
// Dialogfeld CBearDlg 

CBearDlg::CBearDlg(CWnd* pParent, CWayPoint* ptWpt)
	: CDlgTool(CBearDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CBearDlg)
	m_szBearing1 = _T("");
	m_szBearing2 = _T("");
	m_szWptName = _T("");
	m_nBearing = -1;
	m_nListIndex = -1;
	//}}AFX_DATA_INIT
m_ptWpt = ptWpt;
m_BearWpt = *ptWpt;
m_ptLaLoList = ptInit->GetLaLoListPtr();
}

/************************************************************************
 *  BearDlg.cpp					~ C B e a r D l g						*
 ************************************************************************/
CBearDlg::~CBearDlg()
{
this->DeleteArrayOf(&m_Facilities);
}

/************************************************************************
 *  BearDlg.cpp				D e l e t e A r r a y O f 					*
 ************************************************************************/
void CBearDlg::DeleteArrayOf (CObArray* ptArray)
{
int i, nEntryCnt;	
											
nEntryCnt = ptArray->GetSize();
for (i=0; i<nEntryCnt; i++)
	{
	CLocation* ptEntry;
	if ((ptEntry = (CLocation*)ptArray->GetAt(i)) != NULL)
		{
		TRACE ("Deleting Bearing Facility %d\n", i);
		delete ptEntry;				// delete original element
		}
	}
ptArray->RemoveAll();
}


/************************************************************************
 *  BearDlg.cpp				DoDataExchange 					*
 ************************************************************************/
void CBearDlg::DoDataExchange(CDataExchange* pDX)
{
	CDlgTool::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CBearDlg)
	DDX_Text(pDX, ID_BEBEAR1, m_szBearing1);
	DDX_Text(pDX, ID_BEBEAR2, m_szBearing2);
	DDX_Text(pDX, ID_BEORT, m_szWptName);
	DDX_Radio(pDX, ID_BEANL1, m_nBearing);
	DDX_LBIndex(pDX, ID_BELIST, m_nListIndex);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CBearDlg, CDlgTool)
	//{{AFX_MSG_MAP(CBearDlg)
	ON_LBN_SELCHANGE(ID_BELIST, OnSelchangeFacility)
	ON_LBN_DBLCLK(ID_BELIST, OnDblclkFacility)
	ON_BN_CLICKED(ID_BEDEL, OnBearDelete)
	ON_BN_CLICKED(ID_BEANL1, OnUseFacility1)
	ON_BN_CLICKED(ID_BEANL2, OnUseFacility2)
	ON_BN_CLICKED(ID_BECALC, OnBearCalculate)
	ON_WM_HELPINFO()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// Behandlungsroutinen fr Nachrichten CBearDlg 

/************************************************************************
 *  BearDlg.cpp	  				D i s t C m p				 			*
 ************************************************************************/
short CBearDlg::DistCmp (double dDist1, double dDist2)
{
short nCmp;

if (dDist1 == dDist2)
		nCmp = 0;
else	nCmp = (dDist1 < dDist2)? -1 : 1;

return nCmp;
}

/************************************************************************
 *  BearDlg.cpp	  				D i s t A d d S o r t e d 	 			*
 ************************************************************************/
BOOL CBearDlg::DistAddSorted (CDWordArray* ptDistances, short* ptIndex, double dDist)
{
BOOL	bOK;
BOOL	bInsAfter;
long	lMinIndex, lMaxIndex, i, OldTestInd;

lMinIndex = 0;
lMaxIndex = ptDistances->GetSize();		/* legal ind: 0...cnt-1		*/
i = (lMinIndex + lMaxIndex) / 2;		/* i always < cnt !!		*/

if (lMaxIndex > 0)
   {
   do	{
		DWORD dwDist = ptDistances->GetAt(i);
		if (CBearDlg::DistCmp (dDist, (double)dwDist/10) >=0)
				bInsAfter = TRUE;
		else	bInsAfter = FALSE;

		if (bInsAfter)	lMinIndex = i;
				else	lMaxIndex = i;
		OldTestInd = i;
		i = (lMinIndex + lMaxIndex) / 2;

		} while (i != OldTestInd);

   if (bInsAfter) i++;
   }


TRY
	{
	ptDistances->InsertAt ((int)i, (DWORD)(dDist*10));
	bOK = TRUE;
	}
CATCH( CMemoryException, e )
	{
	bOK = FALSE;
	}
END_CATCH


if (bOK)
    {
    *ptIndex = (short)i;
    }
   
return bOK;
}

/************************************************************************
 *  BearDlg.cpp	  		 F i l l F a c i l i t y L i s t				*
 ************************************************************************/
void CBearDlg::FillFacilityList (CObArray* ptFacilities)
{
short	i;
CLocation	Loc;
double	dDist;			// dummy
CDWordArray	Distances;
short nActRegIndex = 0;

CListBox* ptList = (CListBox*)GetDlgItem (ID_BELIST);    


DRECT rLatLon = m_BearWpt.RadiusToDRECT (m_BearWpt.GetLat(), m_BearWpt.GetLon(), 2); // degrees

if (m_ptLaLoList->PrepareGetLoc (rLatLon))
	{
	while (m_ptLaLoList->GetLocationInRect (&Loc, rLatLon, &nActRegIndex))
		{		// is Loc a facility near to ActLoc?
		if (Loc.IsFacilityInRange(m_BearWpt, &dDist))
			{
			CBearDlg::DistAddSorted (&Distances, &i, dDist);
			CLocation* ptLoc = new CLocation(Loc);
			ptFacilities->InsertAt (i, ptLoc);
			CString szLoc = Loc.GetName();
			ptList->InsertString(i, (LPCTSTR)szLoc);  
			}
		}
	}
} 

/************************************************************************
 *  BearDlg.cpp	  		 S e l e c t F a c i l i t y L i s t 			*
 ************************************************************************/
short CBearDlg::SelectFacilityList (short nFacility)
{
short	nIndex, i;
CString szSelName;
BOOL	bFound = FALSE;

CListBox* ptList = (CListBox*)GetDlgItem (ID_BELIST);    

szSelName = m_BearWpt.GetBearingName(nFacility);


nIndex = 0;				// search name of actual nav in completed list
for (i=0; i<ptList->GetCount() && !bFound; i++)
	{
	CString szListStr;
	ptList->GetText (i, szListStr);
	if (szSelName.Compare (szListStr) == 0)
		{
		bFound = TRUE;
		nIndex = i;		// store list index of actual nav
		}
	}

return nIndex;
} 


/************************************************************************
 *  BearDlg.cpp	  				 S e t B e a r i n g		  			*
 ************************************************************************/
void CBearDlg::SetBearing()
{
m_BearWpt.GetBearString (0, &m_szBearing1);
this->SetText (ID_BEBEAR1, m_szBearing1);

m_BearWpt.GetBearString (1, &m_szBearing2);
this->SetText (ID_BEBEAR2, m_szBearing2);

m_szWptName = m_BearWpt.GetNameForRte();	
this->SetText (ID_BEORT, m_szWptName);
}

/************************************************************************
 *  BearDlg.cpp	  			 O n I n i t D i a l o g		 			*
 ************************************************************************/
BOOL CBearDlg::OnInitDialog() 
{
	// TODO: Zustzliche Initialisierung hier einfgen
BOOL bBearing = FALSE;
CString	szActNav;

szActNav.Empty();
m_szWptName = m_BearWpt.GetNameForRte();	

m_nBearing = 0;					// first facility

if (m_BearWpt.HasBearing(0))
	{					
	bBearing = TRUE;
	}
else{
	if (m_BearWpt.HasBearing(1))
		{					
		m_nBearing = 1;		// second facility
		bBearing = TRUE;
		}
	}


this->FillFacilityList (&m_Facilities);
if (!bBearing)
	this->DisableControl (ID_BEDEL, TRUE);

m_nListIndex = this->SelectFacilityList (m_nBearing);

this->SetBearing ();


CDlgTool::OnInitDialog();
	
return TRUE;	// return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX-Eigenschaftenseiten sollten FALSE zurckgeben
}

/************************************************************************
 *  BearDlg.cpp	  		 OnSelchangeFacility 			*
 ************************************************************************/
void CBearDlg::OnSelchangeFacility() 
{
	// TODO: Code fr die Behandlungsroutine der Steuerelement-Benachrichtigung hier einfgen
CListBox* ptList = (CListBox*)GetDlgItem (ID_BELIST);    
m_nListIndex = ptList->GetCurSel ();
}

/************************************************************************
 *  BearDlg.cpp	  		 OnDblclkFacility 			*
 ************************************************************************/
void CBearDlg::OnDblclkFacility() 
{
	// TODO: Code fr die Behandlungsroutine der Steuerelement-Benachrichtigung hier einfgen
this->OnBearCalculate(); 
}

/************************************************************************
 *  BearDlg.cpp	  		 OnBearDelete 			*
 ************************************************************************/
void CBearDlg::OnBearDelete() 
{
	// TODO: Code fr die Behandlungsroutine der Steuerelement-Benachrichtigung hier einfgen
if (m_nBearing == 0)
	{				/* delete 1. bearing	*/
	m_BearWpt.DeleteBearing(0);
	m_szBearing1.Empty();
	this->SetText (ID_BEBEAR1, m_szBearing1);
	}
if (m_nBearing == 1)
	{				/* delete 2. bearing	*/
	m_BearWpt.DeleteBearing(1);
	m_szBearing2.Empty();
	this->SetText (ID_BEBEAR2, m_szBearing2);
	}
this->DisableControl (ID_BEDEL, TRUE);
}

/************************************************************************
 *  BearDlg.cpp	  			 O n U s e F a c i l i t y 1				*
 ************************************************************************/
void CBearDlg::OnUseFacility1() 
{
	// TODO: Code fr die Behandlungsroutine der Steuerelement-Benachrichtigung hier einfgen
m_nBearing = 0;	

BOOL bBearing = m_BearWpt.HasBearing(m_nBearing);
this->DisableControl (ID_BEDEL, !bBearing);

if (bBearing)
	{
	m_nListIndex = this->SelectFacilityList (m_nBearing);
	this->UpdateData (FALSE);
	}
}

/************************************************************************
 *  BearDlg.cpp	  			 O n U s e F a c i l i t y 2				*
 ************************************************************************/
void CBearDlg::OnUseFacility2() 
{
	// TODO: Code fr die Behandlungsroutine der Steuerelement-Benachrichtigung hier einfgen
m_nBearing = 1;	

BOOL bBearing = m_BearWpt.HasBearing(m_nBearing);
this->DisableControl (ID_BEDEL, !bBearing);

if (bBearing)
	{
	m_nListIndex = this->SelectFacilityList (m_nBearing);
	this->UpdateData (FALSE);
	}
}


/************************************************************************
 *  BearDlg.cpp				G e t B e a r i n g							*
 ************************************************************************/
BOOL CBearDlg::GetBearing (short nBearIndex)
{
BOOL bOK = FALSE;

if (m_nListIndex >=0 && m_nListIndex < m_Facilities.GetSize())
	{
	CLocation* ptNav = (CLocation*)m_Facilities.GetAt(m_nListIndex);
	if (ptNav != NULL)
		{
		m_BearWpt.CalculateBearing (nBearIndex, *ptNav);
		bOK = TRUE;
		}
	}

if (!bOK)
	m_BearWpt.DeleteBearing (nBearIndex);

return bOK;
}

/************************************************************************
 *  BearDlg.cpp				O n B e a r C a l c u l a t e				*
 ************************************************************************/
void CBearDlg::OnBearCalculate() 
{
	// TODO: Code fr die Behandlungsroutine der Steuerelement-Benachrichtigung hier einfgen
BOOL	bWasDeleted;

if (m_nBearing == 0)
	{
	bWasDeleted = !m_BearWpt.HasBearing(0);
	if (this->GetBearing (0))
		{
		m_BearWpt.GetBearString (0, &m_szBearing1);
		this->SetText (ID_BEBEAR1, m_szBearing1);

		if (bWasDeleted)
			this->DisableControl (ID_BEDEL, FALSE);
		}
	}

if (m_nBearing == 1)
	{
	bWasDeleted = !m_BearWpt.HasBearing(1);
	if (this->GetBearing (1))
		{
		m_BearWpt.GetBearString (1, &m_szBearing2);
		this->SetText (ID_BEBEAR2, m_szBearing2);

		if (bWasDeleted)
			this->DisableControl (ID_BEDEL, FALSE);
		}
	}
	
}

/************************************************************************
 *  BearDlg.cpp	  					 O n O K							*
 ************************************************************************/
void CBearDlg::OnOK() 
{
	// TODO: Zustzliche Prfung hier einfgen
*m_ptWpt = m_BearWpt;
	
CDlgTool::OnOK();
}

/************************************************************************
 *  BearDlg.cpp	  				 O n H e l p I n f o					*
 ************************************************************************/
BOOL CBearDlg::OnHelpInfo(HELPINFO* pHelpInfo) 
{
	// TODO: Add your message handler code here and/or call default
	
if (pHelpInfo->iContextType == HELPINFO_WINDOW)
	{
	AfxGetApp()->WinHelp (pHelpInfo->dwContextId, HELP_CONTEXTPOPUP);
	}

return TRUE;
}
