// BmpView.cpp: Implementierungsdatei
// (c) Copyright Softwareentwicklung Heinz Ldert 2008

#include "stdafx.h"
#include "afxpriv.h"		// for WM_RECALCPARENT
#include "BmpView.h"    


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CBitmapView

	// standard GDI mapping modes are > 0
BEGIN_MESSAGE_MAP(CBitmapView, CView)
	//{{AFX_MSG_MAP(CBitmapView)
	ON_WM_SIZE()
	ON_WM_VSCROLL()
	ON_WM_HSCROLL()
	ON_WM_PAINT()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

// Special mapping modes just for CScrollView implementation
#define MM_NONE             0
#define MM_SCALETOFIT       (-1)


CBitmapView::CBitmapView()
{
	AFX_ZERO_INIT_OBJECT(CView);

	m_nMapMode = MM_NONE;
	m_bInsideUpdate = FALSE;

// for bitmap scrolling
m_pdcDisplayMemory	= new CDC;  
m_pBitmap			= new CBitmap;   
}

CBitmapView::~CBitmapView()
{
delete m_pdcDisplayMemory;	// already deselected!! 
delete m_pBitmap;           
}

/************************************************************************
 *  BmpView.cpp   		 C o p y T o C l i p b o a r d					*
 ************************************************************************/
void CBitmapView::CopyToClipboard()
{
    CBitmap     cBmp;
    CClientDC   cWndDC(this);   // View is an hWnd, so we can use "this"
    CDC         cMemDC;         // Handle to a memory DC
    CRect     rWndLP, rWndDP;   // For storing the size of the window
 
    cMemDC.CreateCompatibleDC(&cWndDC); // Create the memory DC.
 
	OnPrepareDC(&cMemDC);


	GetClientRect (rWndDP);	
	rWndLP = rWndDP;
	cMemDC.DPtoLP(&rWndLP);

    cBmp.CreateCompatibleBitmap(&cMemDC, rWndDP.Width(),rWndDP.Height() );
						// Keep the old bitmap
    CBitmap* pOldBitmap = cMemDC.SelectObject(&cBmp);
 

							// to erase background
	CBrush backgroundBrush ((COLORREF) ::GetSysColor(COLOR_WINDOW));
	CBrush* pOldBrush = cMemDC.SelectObject (&backgroundBrush);
							// PatBlt erases background
	if (cMemDC.PatBlt (rWndLP.left, rWndLP.top, rWndLP.Width(), rWndLP.Height(), PATCOPY)!=0)
		{
		OnDraw(&cMemDC);  // draw contens of actual view
		}
	cMemDC.SelectObject (pOldBrush);
 
    // here are the actual clipboard functions.
    AfxGetApp()->m_pMainWnd->OpenClipboard() ;
    EmptyClipboard() ;
    SetClipboardData (CF_BITMAP, cBmp.GetSafeHandle() ) ;
    CloseClipboard () ;
        // next we select the old bitmap back into the memory DC
        // so that our bitmap is not deleted when cMemDC is destroyed.
        // Then we detach the bitmap handle from the cBmp object so that
        // the bitmap is not deleted when cBmp is destroyed.
    cMemDC.SelectObject(pOldBitmap);
    cBmp.Detach();
}

/////////////////////////////////////////////////////////////////////////////
// Zeichnung CBitmapView 

/****************************************************************************
 *	BmpView.cpp				O n P r e p a r e D C							*
 ****************************************************************************/
void CBitmapView::OnPrepareDC(CDC* pDC, CPrintInfo* pInfo)
{
	ASSERT_VALID(pDC);

#ifdef _DEBUG
	if (m_nMapMode == MM_NONE)
	{
		TRACE0("Error: must call SetScrollSizes() or SetScaleToFitSize()");
		TRACE0("\tbefore painting scroll view.\n");
		ASSERT(FALSE);
		return;
	}
#endif //_DEBUG
	ASSERT(m_totalDev.cx >= 0 && m_totalDev.cy >= 0);


	CView::OnPrepareDC(pDC, pInfo);     // For default Printing behavior
}


/****************************************************************************
 *	BmpView.cpp				S e t S c r o l l S i z e s						*
 ****************************************************************************/
void CBitmapView::SetScrollSizes(int nMapMode, SIZE sizeTotal,
	const SIZE& sizePage, const SIZE& sizeLine)
{
	ASSERT(sizeTotal.cx >= 0 && sizeTotal.cy >= 0);
	ASSERT(nMapMode > 0);
	ASSERT(nMapMode != MM_ISOTROPIC && nMapMode != MM_ANISOTROPIC);

	int nOldMapMode = m_nMapMode;
	m_nMapMode = nMapMode;
	m_totalLog = sizeTotal;

	//BLOCK: convert logical coordinate space to device coordinates
	{
		CWindowDC dc(NULL);
		ASSERT(m_nMapMode > 0);
		dc.SetMapMode(m_nMapMode);

		// total size
		m_totalDev = m_totalLog;
		dc.LPtoDP((LPPOINT)&m_totalDev);
		m_pageDev = sizePage;
		dc.LPtoDP((LPPOINT)&m_pageDev);
		m_lineDev = sizeLine;
		dc.LPtoDP((LPPOINT)&m_lineDev);
		if (m_totalDev.cy < 0)
			m_totalDev.cy = -m_totalDev.cy;
		if (m_pageDev.cy < 0)
			m_pageDev.cy = -m_pageDev.cy;
		if (m_lineDev.cy < 0)
			m_lineDev.cy = -m_lineDev.cy;
	} // release DC here

	// now adjust device specific sizes
	ASSERT(m_totalDev.cx >= 0 && m_totalDev.cy >= 0);
	if (m_pageDev.cx == 0)
		m_pageDev.cx = m_totalDev.cx / 10;
	if (m_pageDev.cy == 0)
		m_pageDev.cy = m_totalDev.cy / 10;
	if (m_lineDev.cx == 0)
		m_lineDev.cx = m_pageDev.cx / 10;
	if (m_lineDev.cy == 0)
		m_lineDev.cy = m_pageDev.cy / 10;

	if (m_hWnd != NULL)
	{
		// window has been created, invalidate now
		UpdateBars();
		if (nOldMapMode != m_nMapMode)
			Invalidate(TRUE);
	}
}


/////////////////////////////////////////////////////////////////////////////
// Getting information

/****************************************************************************
 *	BmpView.cpp				G e t S c r o l l P o s i t i o n				*
 ****************************************************************************/
CPoint CBitmapView::GetScrollPosition() const   // logical coordinates
{
	if (m_nMapMode == MM_SCALETOFIT)
	{
		return CPoint(0, 0);    // must be 0,0
	}

	CPoint pt = GetDeviceScrollPosition();
	// pt may be negative if m_bCenter is set

	if (m_nMapMode != MM_TEXT)
	{
		ASSERT(m_nMapMode > 0); // must be set
		CWindowDC dc(NULL);
		dc.SetMapMode(m_nMapMode);
		dc.DPtoLP((LPPOINT)&pt);
	}
	return pt;
}

/****************************************************************************
 *	BmpView.cpp				G e t T o t a l S i z e							*
 ****************************************************************************/
CSize CBitmapView::GetTotalSize() const             // logical size
{
return m_totalLog;
}

/****************************************************************************
 *	BmpView.cpp				S c r o l l T o P o s i t i o n					*
 ****************************************************************************/
void CBitmapView::ScrollToPosition(POINT pt)    // logical coordinates
{
	ASSERT(m_nMapMode > 0);     // not allowed for shrink to fit
	if (m_nMapMode != MM_TEXT)
	{
		CWindowDC dc(NULL);
		dc.SetMapMode(m_nMapMode);
		dc.LPtoDP((LPPOINT)&pt);
	}

	// now in device coordinates - limit if out of range
	int xMax = GetScrollLimit(SB_HORZ);
	int yMax = GetScrollLimit(SB_VERT);
	if (pt.x < 0)
		pt.x = 0;
	else if (pt.x > xMax)
		pt.x = xMax;
	if (pt.y < 0)
		pt.y = 0;
	else if (pt.y > yMax)
		pt.y = yMax;

	ScrollToDevicePosition(pt);
}

/****************************************************************************
 *	BmpView.cpp			G e t D e v i c e S c r o l l P o s i t i o n		*
 ****************************************************************************/
CPoint CBitmapView::GetDeviceScrollPosition() const
{
	CPoint pt(GetScrollPos(SB_HORZ), GetScrollPos(SB_VERT));
	ASSERT(pt.x >= 0 && pt.y >= 0);

	if (m_bCenter)
	{
		CRect rect;
		GetClientRect(&rect);

		// if client area is larger than total device size,
		// the scroll positions are overridden to place origin such that
		// output is centered in the window
		// GetDeviceScrollPosition() must reflect this

		if (m_totalDev.cx < rect.Width())
			pt.x = -((rect.Width() - m_totalDev.cx) / 2);
		if (m_totalDev.cy < rect.Height())
			pt.y = -((rect.Height() - m_totalDev.cy) / 2);
	}

	return pt;
}

/****************************************************************************
 *	BmpView.cpp			S c r o l l T o D e v i c e P o s i t i o n			*
 ****************************************************************************/
void CBitmapView::ScrollToDevicePosition(POINT ptDev)
{
	ASSERT(ptDev.x >= 0);
	ASSERT(ptDev.y >= 0);

	// Note: ScrollToDevicePosition can and is used to scroll out-of-range
	//  areas as far as CScrollView is concerned -- specifically in
	//  the print-preview code.  Since OnScrollBy makes sure the range is
	//  valid, ScrollToDevicePosition does not vector through OnScrollBy.

	int xOrig = GetScrollPos(SB_HORZ);
	SetScrollPos(SB_HORZ, ptDev.x);
	int yOrig = GetScrollPos(SB_VERT);
	SetScrollPos(SB_VERT, ptDev.y);
	ScrollWindow(xOrig - ptDev.x, yOrig - ptDev.y);
}


/////////////////////////////////////////////////////////////////////////////
// Other helpers

void CBitmapView::OnSize(UINT nType, int cx, int cy) 
{
CView::OnSize(nType, cx, cy);

	// TODO: Code fr die Behandlungsroutine fr Nachrichten hier einfgen

if (m_nMapMode == MM_SCALETOFIT)
	{
		// force recalculation of scale to fit parameters
	//SetScaleToFitSize(m_totalLog);
	}
else{// UpdateBars() handles locking out recursion
	UpdateBars();
	}
}

/////////////////////////////////////////////////////////////////////////////
// Tie to scrollbars and CWnd behaviour

/****************************************************************************
 *	BmpView.cpp				G e t S c r o l l B a r S i z e s				*
 ****************************************************************************/
void CBitmapView::GetScrollBarSizes(CSize& sizeSb)
{
	sizeSb.cx = sizeSb.cy = 0;
	DWORD dwStyle = GetStyle();

	if (GetScrollBarCtrl(SB_VERT) == NULL)
	{
		// vert scrollbars will impact client area of this window
	//	sizeSb.cx = afxData.cxVScroll;
		sizeSb.cx = GetSystemMetrics (SM_CXVSCROLL);
		if (dwStyle & WS_BORDER)
		//	sizeSb.cx -= CX_BORDER;
			sizeSb.cx -= GetSystemMetrics (SM_CXBORDER);
	}
	if (GetScrollBarCtrl(SB_HORZ) == NULL)
	{
		// horz scrollbars will impact client area of this window
//		sizeSb.cy = afxData.cyHScroll;
		sizeSb.cy = GetSystemMetrics (SM_CYHSCROLL);
		if (dwStyle & WS_BORDER)
		//	sizeSb.cy -= CY_BORDER;
			sizeSb.cy -= GetSystemMetrics (SM_CYBORDER);
	}
}

/****************************************************************************
 *	BmpView.cpp			G e t T r u e C l i e n t S i z e					*
 ****************************************************************************/
BOOL CBitmapView::GetTrueClientSize(CSize& size, CSize& sizeSb)
	// return TRUE if enough room to add scrollbars if needed
{
	CRect rect;
	GetClientRect(&rect);
	ASSERT(rect.top == 0 && rect.left == 0);
	size.cx = rect.right;
	size.cy = rect.bottom;
	DWORD dwStyle = GetStyle();

	// first get the size of the scrollbars for this window
	GetScrollBarSizes(sizeSb);

	// first calculate the size of a potential scrollbar
	// (scroll bar controls do not get turned on/off)
	if (sizeSb.cx != 0 && (dwStyle & WS_VSCROLL))
	{
		// vert scrollbars will impact client area of this window
		size.cx += sizeSb.cx;   // currently on - adjust now
	}
	if (sizeSb.cy != 0 && (dwStyle & WS_HSCROLL))
	{
		// horz scrollbars will impact client area of this window
		size.cy += sizeSb.cy;   // currently on - adjust now
	}

	// return TRUE if enough room
	return (size.cx > sizeSb.cx && size.cy > sizeSb.cy);
}


// helper to return the state of the scrollbars without actually changing
//  the state of the scrollbars

/****************************************************************************
 *	BmpView.cpp			G e t S c r o l l B a r S t a t e 					*
 ****************************************************************************/
void CBitmapView::GetScrollBarState(CSize sizeClient, CSize& needSb,
	CSize& sizeRange, CPoint& ptMove, BOOL bInsideClient)
{
	// get scroll bar sizes (the part that is in the client area)
	CSize sizeSb;
	GetScrollBarSizes(sizeSb);

	// enough room to add scrollbars
	sizeRange = m_totalDev - sizeClient;
		// > 0 => need to scroll
	ptMove = GetDeviceScrollPosition();
		// point to move to (start at current scroll pos)

	BOOL bNeedH = sizeRange.cx > 0;
	if (!bNeedH)
		ptMove.x = 0;                       // jump back to origin
	else if (bInsideClient)
		sizeRange.cy += sizeSb.cy;          // need room for a scroll bar

	BOOL bNeedV = sizeRange.cy > 0;
	if (!bNeedV)
		ptMove.y = 0;                       // jump back to origin
	else if (bInsideClient)
		sizeRange.cx += sizeSb.cx;          // need room for a scroll bar

	if (bNeedV && !bNeedH && sizeRange.cx > 0)
	{
		ASSERT(bInsideClient);
		// need a horizontal scrollbar after all
		bNeedH = TRUE;
		sizeRange.cy += sizeSb.cy;
	}

	// if current scroll position will be past the limit, scroll to limit
	if (sizeRange.cx > 0 && ptMove.x >= sizeRange.cx)
		ptMove.x = sizeRange.cx;
	if (sizeRange.cy > 0 && ptMove.y >= sizeRange.cy)
		ptMove.y = sizeRange.cy;

	// now update the bars as appropriate
	needSb.cx = bNeedH;
	needSb.cy = bNeedV;

	// needSb, sizeRange, and ptMove area now all updated
}



/****************************************************************************
 *	BmpView.cpp					U p d a t e B a r s 						*
 ****************************************************************************/
void CBitmapView::UpdateBars()
{
	// UpdateBars may cause window to be resized - ignore those resizings
	if (m_bInsideUpdate)
		return;         // Do not allow recursive calls

	// Lock out recursion
	m_bInsideUpdate = TRUE;

	// update the horizontal to reflect reality
	// NOTE: turning on/off the scrollbars will cause 'OnSize' callbacks
	ASSERT(m_totalDev.cx >= 0 && m_totalDev.cy >= 0);

	CRect rectClient;
	BOOL bCalcClient = TRUE;

	// allow parent to do inside-out layout first
	CWnd* pParentWnd = GetParent();
	if (pParentWnd != NULL)
	{
		// if parent window responds to this message, use just
		//  client area for scroll bar calc -- not "true" client area
		if ((BOOL)pParentWnd->SendMessage(WM_RECALCPARENT, 0,
			(LPARAM)(LPCRECT)&rectClient) != 0)
		{
			// use rectClient instead of GetTrueClientSize for
			//  client size calculation.
			bCalcClient = FALSE;
		}
	}

	CSize sizeClient;
	CSize sizeSb;

	if (bCalcClient)
	{
		// get client rect
		if (!GetTrueClientSize(sizeClient, sizeSb))
		{
			// no room for scroll bars (common for zero sized elements)
			CRect rect;
			GetClientRect(&rect);
			if (rect.right > 0 && rect.bottom > 0)
			{
				// if entire client area is not invisible, assume we have
				//  control over our scrollbars
				EnableScrollBarCtrl(SB_BOTH, FALSE);
			}
			m_bInsideUpdate = FALSE;
			return;
		}
	}
	else
	{
		// let parent window determine the "client" rect
		GetScrollBarSizes(sizeSb);
		sizeClient.cx = rectClient.right - rectClient.left;
		sizeClient.cy = rectClient.bottom - rectClient.top;
	}

	// enough room to add scrollbars
	CSize sizeRange;
	CPoint ptMove;
	CSize needSb;

	// get the current scroll bar state given the true client area
	GetScrollBarState(sizeClient, needSb, sizeRange, ptMove, bCalcClient);
	if (needSb.cx)
		sizeClient.cy -= sizeSb.cy;
	if (needSb.cy)
		sizeClient.cx -= sizeSb.cx;

	// first scroll the window as needed
	ScrollToDevicePosition(ptMove); // will set the scroll bar positions too

	// this structure needed to update the scrollbar page range
	SCROLLINFO info;
	info.fMask = SIF_PAGE|SIF_RANGE;
	info.nMin = 0;

	// now update the bars as appropriate
	EnableScrollBarCtrl(SB_HORZ, needSb.cx);
	if (needSb.cx)
	{
		info.nPage = sizeClient.cx;
		info.nMax = m_totalDev.cx-1;
		if (!SetScrollInfo(SB_HORZ, &info, TRUE))
			SetScrollRange(SB_HORZ, 0, sizeRange.cx, TRUE);
	}
	EnableScrollBarCtrl(SB_VERT, needSb.cy);
	if (needSb.cy)
	{
		info.nPage = sizeClient.cy;
		info.nMax = m_totalDev.cy-1;
		if (!SetScrollInfo(SB_VERT, &info, TRUE))
			SetScrollRange(SB_VERT, 0, sizeRange.cy, TRUE);
	}

	// remove recursion lockout
	m_bInsideUpdate = FALSE;
}

/////////////////////////////////////////////////////////////////////////////
// CScrollView scrolling


/****************************************************************************
 *	BmpView.cpp				O n H S c r o l l								*
 ****************************************************************************/
void CBitmapView::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	// TODO: Code fr die Behandlungsroutine fr Nachrichten hier einfgen und/oder Standard aufrufen


if (pScrollBar != NULL && pScrollBar->SendChildNotifyLastMsg())
	return;     // eat it

// ignore scroll bar msgs from other controls
if (pScrollBar != GetScrollBarCtrl(SB_HORZ))
	return;

OnScroll(MAKEWORD(nSBCode, -1), nPos);
}


/****************************************************************************
 *	BmpView.cpp					O n V S c r o l l							*
 ****************************************************************************/
void CBitmapView::OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	// TODO: Code fr die Behandlungsroutine fr Nachrichten hier einfgen und/oder Standard aufrufen
	if (pScrollBar != NULL && pScrollBar->SendChildNotifyLastMsg())
		return;     // eat it

	// ignore scroll bar msgs from other controls
	if (pScrollBar != GetScrollBarCtrl(SB_VERT))
		return;

	OnScroll(MAKEWORD(-1, nSBCode), nPos);
}


/****************************************************************************
 *	BmpView.cpp					O n S c r o l l		 						*
 ****************************************************************************/
BOOL CBitmapView::OnScroll(UINT nScrollCode, UINT nPos, BOOL bDoScroll) 
{
	// TODO: Speziellen Code hier einfgen und/oder Basisklasse aufrufen

	// calc new x position
	int x = GetScrollPos(SB_HORZ);
	int xOrig = x;

	switch (LOBYTE(nScrollCode))
	{
	case SB_TOP:
		x = 0;
		break;
	case SB_BOTTOM:
		x = INT_MAX;
		break;
	case SB_LINEUP:
		x -= m_lineDev.cx;
		break;
	case SB_LINEDOWN:
		x += m_lineDev.cx;
		break;
	case SB_PAGEUP:
		x -= m_pageDev.cx;
		break;
	case SB_PAGEDOWN:
		x += m_pageDev.cx;
		break;
	case SB_THUMBTRACK:
		x = nPos;
		break;
	}

	// calc new y position
	int y = GetScrollPos(SB_VERT);
	int yOrig = y;

	switch (HIBYTE(nScrollCode))
	{
	case SB_TOP:
		y = 0;
		break;
	case SB_BOTTOM:
		y = INT_MAX;
		break;
	case SB_LINEUP:
		y -= m_lineDev.cy;
		break;
	case SB_LINEDOWN:
		y += m_lineDev.cy;
		break;
	case SB_PAGEUP:
		y -= m_pageDev.cy;
		break;
	case SB_PAGEDOWN:
		y += m_pageDev.cy;
		break;
	case SB_THUMBTRACK:
		y = nPos;
		break;
	}

	BOOL bResult = OnScrollBy(CSize(x - xOrig, y - yOrig), bDoScroll);
	if (bResult && bDoScroll)
		UpdateWindow();

	return bResult;
}


/****************************************************************************
 *	BmpView.cpp			OnScrollBy						*
 ****************************************************************************/
BOOL CBitmapView::OnScrollBy(CSize sizeScroll, BOOL bDoScroll) 
{
	// TODO: Speziellen Code hier einfgen und/oder Basisklasse aufrufen
	int xOrig, x;
	int yOrig, y;

	// don't scroll if there is no valid scroll range (ie. no scroll bar)
	CScrollBar* pBar;
	DWORD dwStyle = GetStyle();
	pBar = GetScrollBarCtrl(SB_VERT);
	if ((pBar != NULL && !pBar->IsWindowEnabled()) ||
		(pBar == NULL && !(dwStyle & WS_VSCROLL)))
	{
		// vertical scroll bar not enabled
		sizeScroll.cy = 0;
	}
	pBar = GetScrollBarCtrl(SB_HORZ);
	if ((pBar != NULL && !pBar->IsWindowEnabled()) ||
		(pBar == NULL && !(dwStyle & WS_HSCROLL)))
	{
		// horizontal scroll bar not enabled
		sizeScroll.cx = 0;
	}

	// adjust current x position
	xOrig = x = GetScrollPos(SB_HORZ);
	int xMax = GetScrollLimit(SB_HORZ);
	x += sizeScroll.cx;
	if (x < 0)
		x = 0;
	else if (x > xMax)
		x = xMax;

	// adjust current y position
	yOrig = y = GetScrollPos(SB_VERT);
	int yMax = GetScrollLimit(SB_VERT);
	y += sizeScroll.cy;
	if (y < 0)
		y = 0;
	else if (y > yMax)
		y = yMax;

	// did anything change?
	if (x == xOrig && y == yOrig)
		return FALSE;

	if (bDoScroll)
	{
		// do scroll and update scroll positions
		ScrollWindow(-(x-xOrig), -(y-yOrig));
		if (x != xOrig)
			SetScrollPos(SB_HORZ, x);
		if (y != yOrig)
			SetScrollPos(SB_VERT, y);
	}
	return TRUE;
}
	

/////////////////////////////////////////////////////////////////////////////
// Diagnose CBitmapView

#ifdef _DEBUG
void CBitmapView::AssertValid() const
{
	CView::AssertValid();
}

void CBitmapView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

#endif //_DEBUG


IMPLEMENT_DYNAMIC(CBitmapView, CView)


/************************************************************************
 *  BmpView.cpp    		 	 S c r o l l W i n d o w					*
 ************************************************************************/
void CBitmapView::ScrollWindow (int xAmount, int yAmount)
{
if (xAmount != 0 || yAmount != 0)
	{
				  // void InvalidateRect( LPCRECT lpRect, BOOL bErase = TRUE );
	InvalidateRect(NULL, FALSE);
	}
}


/////////////////////////////////////////////////////////////////////////////
// Behandlungsroutinen fr Nachrichten CBitmapView 

						
/************************************************************************
 *  BmpView.cpp    		 	 O n I n i t i a l U p d a t e				*
 ************************************************************************/
void CBitmapView::OnInitialUpdate() 
{
CView::OnInitialUpdate();

if (m_pdcDisplayMemory->GetSafeHdc()==NULL)
	{
	CRect rectMax;
	CClientDC dc(this);
					//		 // Width and height, in pixels, of the screen. 
	rectMax.SetRect (0,0, GetSystemMetrics(SM_CXSCREEN), GetSystemMetrics(SM_CYSCREEN));
	if (m_pdcDisplayMemory->CreateCompatibleDC(&dc) != 0)
		{			// makes bitmap same size as display window
		if (m_pBitmap->CreateCompatibleBitmap (&dc, rectMax.right, rectMax.bottom) != 0)
			m_pdcDisplayMemory->SetMapMode (m_nMapMode);
		}
	}
}


/************************************************************************
 *  BmpView.cpp    		 			O n P a i n t						*
 ************************************************************************/
void CBitmapView::OnPaint() 
{
CPaintDC DC(this); // device context for painting
	
	// TODO: Code fr die Behandlungsroutine fr Nachrichten hier einfgen


CRect rUpdateLP;
OnPrepareDC (&DC);

GetClientRect (rUpdateLP);	
DC.DPtoLP(&rUpdateLP);

//dc.GetClipBox (&rUpdateLP);

CBitmap* pOldBitmap = m_pdcDisplayMemory->SelectObject (m_pBitmap);
m_pdcDisplayMemory->SelectClipRgn (NULL);
//m_pdcDisplayMemory->IntersectClipRect (&rUpdateLP);
CBrush backgroundBrush ((COLORREF) ::GetSysColor(COLOR_WINDOW));
CBrush* pOldBrush = m_pdcDisplayMemory->SelectObject (&backgroundBrush);

if (m_pdcDisplayMemory->PatBlt (rUpdateLP.left, rUpdateLP.top,
							rUpdateLP.Width(), rUpdateLP.Height(), PATCOPY)!=0)
	{
	OnDraw(m_pdcDisplayMemory);

	if (DC.BitBlt (rUpdateLP.left, rUpdateLP.top,
			rUpdateLP.Width(), rUpdateLP.Height(),
			m_pdcDisplayMemory, rUpdateLP.left, rUpdateLP.top, SRCCOPY))
		{
		// everything OK;
		} 
	}
m_pdcDisplayMemory->SelectObject (pOldBitmap);
m_pdcDisplayMemory->SelectObject (pOldBrush);

	// Kein Aufruf von CBitmapView::OnPaint() fr Zeichnungsnachrichten
}
