#ifndef __BMPVIEW__
#define __BMPVIEW__

// BmpView.h : Header-Datei
//
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de


class CBitmapView : public CView
{
	DECLARE_DYNAMIC(CBitmapView)

public:
	CBitmapView();           // Dynamische Erstellung verwendet geschtzten Konstruktor

// Operationen
public:
	static AFX_DATA const SIZE sizeDefault;
		// used to specify default calculated page and line sizes

	// in logical units - call one of the following Set routines
//	void SetScaleToFitSize(SIZE sizeTotal);
	void SetScrollSizes(int nMapMode, SIZE sizeTotal,
				const SIZE& sizePage = sizeDefault,
				const SIZE& sizeLine = sizeDefault);


public:
	void CopyToClipboard();
	CPoint GetScrollPosition() const;   // logical coordinates
	CSize GetTotalSize() const;             // logical size

	void ScrollToPosition(POINT pt);    // logical coordinates

	// for device units
	CPoint GetDeviceScrollPosition() const;


// Operations
public:


// Attribute
protected:
	int m_nMapMode;
	CSize m_totalLog;           // total size in logical units (no rounding)
	CSize m_totalDev;           // total size in device units
	CSize m_pageDev;            // per page scroll size in device units
	CSize m_lineDev;            // per line scroll size in device units

	BOOL m_bCenter;             // Center output if larger than total size
	BOOL m_bInsideUpdate;       // internal state for OnSize callback

	CDC*		m_pdcDisplayMemory;
	CBitmap*	m_pBitmap;

	void ScrollToDevicePosition(POINT ptDev); // explicit scrolling no checking

protected:
	virtual void OnDraw(CDC* pDC) = 0;      // pass on pure virtual
	virtual void OnPrepareDC(CDC* pDC, CPrintInfo* pInfo = NULL);

	void UpdateBars();
	BOOL GetTrueClientSize(CSize& size, CSize& sizeSb);
		// size with no bars
	void GetScrollBarSizes(CSize& sizeSb);
	void GetScrollBarState(CSize sizeClient, CSize& needSb,
			CSize& sizeRange, CPoint& ptMove, BOOL bInsideClient);
	void ScrollWindow (int xAmount, int yAmount);

protected:
	virtual ~CBitmapView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif


	// scrolling implementation support for OLE
	virtual BOOL OnScroll(UINT nScrollCode, UINT nPos, BOOL bDoScroll = TRUE);
	virtual BOOL OnScrollBy(CSize sizeScroll, BOOL bDoScroll = TRUE);

// berschreibungen
	// Vom Klassen-Assistenten generierte virtuelle Funktionsberschreibungen
	//{{AFX_VIRTUAL(CBitmapView)
	public:
	virtual void OnInitialUpdate();
	//}}AFX_VIRTUAL




	// Generierte Nachrichtenzuordnungsfunktionen
protected:
	//{{AFX_MSG(CBitmapView)
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg void OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg void OnPaint();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};
//	afx_msg void OnPaint();

/////////////////////////////////////////////////////////////////////////////

#endif // __BMPVIEW__
