#ifndef __RTECALC__      
#define __RTECALC__

// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "..\CPPTOOLS\Vektor.h"

class CWayDoc;
class CMetDoc;
class CWayPoint;
class CPlane;

typedef struct
	{
	double dWCA;
	double dVgr;
	double dRWK;
	double dDistLeg_NM;		// exakte Entfernung
	double dDistLeg;		// gerundet auf ganze NM
	double dMC;
	double dMH;
	double dTimeLeg_min;	// exakte Zeit
	double dTimeLeg;		// gerundet auf ganze Minuten
	} LEGTYPE;

typedef struct
	{
	double	fRoute_NM;
	double	fRoute_min;
	float	fRoute_l;
	CLocation	LandLoc;
	int			nLandRoll_m;
	int			nLandObst_m;
	float		fLandMass_kg;
	} ALTERNATECONS;

typedef struct
	{
	BOOL	bNoFuel;
	float	fTotalFuel_l[PL_MAX_TANK];	/* total fuel [Liter]	*/
	float	fFillDegr_Pc[PL_MAX_TANK];	/* Ausnutzung Tankvol. [%]*/
	float	fAvailFuel_l;	/* tatschlich ausfliegbarer Kraftstoff [l]	*/

	BOOL	bBadBalance;
	float	fTotal_kg;
	float	fTotal_mkg;
	double	fCoG_m;		/* aktuelle Lage des Schwerpunktes [m]	*/
	double	fMinCoG_m, fMaxCoG_m;	/* aktuelle Schwerpunktgrenzen		*/

	BOOL	bBadFuel1;
	BOOL	bBadFuel2;
	double	fEnRoute_NM;
	double	fEnRoute_min;
	float	fPowered_min;	/* can be <= nEnRoute_min	    */
	float	fEnRoute_l; 

	ALTERNATECONS forAlternate[2];
	float	fAlternateRoute_l;
	double	fAlternateRoute_min;

	int		nTaxi_min;
	float	fTaxi_l; 
	int		nDepArv_min;  
	float	fDepArv_l;
	float	fTaxiDepArv_l;
	int		nSafeRes_min;
	float	fSafeRes_l;
	int		nExtra_min;
	float	fExtra_l;
	int		nReq_min; 
	float	fReq_l;   
	int		nSafe_min;
	float	fSafe_l;
	int		nMaxSafe_min;
	float	fMaxSafe_l;
 
	float	fLandMass_kg;

	short	nBadRowLoad;
	short	nBadLugLoad;
	short	nBadFuelLoad;

	BOOL		bBadElev1;
	BOOL		bBadElev2;
	BOOL		bBadStart;
	BOOL		bBadLand;
	CLocation	StartLoc;
	int			nStartRoll_m;
	int			nStartObst_m;
	CLocation	LandLoc;
	int			nLandRoll_m;
	int			nLandObst_m;

	float		fCostDepArv;
	float		fCostTaxi;
	} CONSUMTYPE;


template <class Type> 
class CStructList
{
public:
	CStructList();
 	virtual ~CStructList();  

	long GetSize ();
	BOOL Add (Type Entry);
	BOOL InsertAt (long i, Type Entry);
	BOOL SetAt (long i, Type Entry);
	BOOL RemoveAt (long i);
	BOOL GetAt (long i, Type* ptEntry);
	Type GetAt (long i);
	void RemoveAll ();

// Implementation
private:
	CPtrArray m_Array;
};


class CCalculate : public CObject
{

#define DB180 180.		
#define DB360 360. 
#define NO_KOORD	1000.	/* undefined val of Lat or Lon		*/


// Attributes
private:    
// Operations
protected:
	CWayDoc*	m_ptWayDoc;
	CPlane*		m_ptPlane;
	CWayPoint*	m_ptWpt;
	BOOL		m_bChanged;
	double		m_dRemainDist;
	double		m_dRemainTime;
	double		m_dTotalDist;
	double		m_dTotalTime;
	double		m_dFuel;
	LEGTYPE		m_Test;

	CStructList<LEGTYPE> m_Legs;
	CStructList<LEGTYPE> m_AlternateLegs;

	CONSUMTYPE	m_Cons;

// Implementation
public:
	CCalculate(CWayDoc* ptWayDoc = NULL);		
	~CCalculate();        

	void Activate (CPlane* ptPlane);
	void DeActivate ();

	void SetPlaneSpeed(CPlane& Plane);

	void InsertOrtho ();
	void DeleteOrtho ();

	void InsertSemi ();

	BOOL InsertUpDown (CPlane* ptPlane, CMetDoc* ptMet);
	void DeleteUpDown ();


	void CourseTime();
	void AlternateCourseTime();

	LEGTYPE FlugDaten(double dLatOld, double dLonOld, CWayPoint* ptWptNew);

	LEGTYPE GetAt (short nIndex);
	LEGTYPE GetAlternateAt (short nIndex);

	void WeightAndBalance (CPlane* ptPlane,
						CLoadDoc* ptLoad, float* ptActUseFuel_kg);
	void ActualizeTimeAndFuel (float fFuel_l, float fActCons);

	BOOL CalculateFuel (CPlane* ptPlane, float* ptActUseFuel_kg);
	void RequiredRWY (CPlane* ptPlane, CMetDoc* ptMet);
	void CalcLandingDistances(CLocation& Loc, float fLandMass_kg,
									  double fTemp, double fQNH, CPlane* ptPlane,
									 int* ptLandRoll_m, int* ptLandObst_m);
	BOOL DoConsumCalc (CPlane* ptPlane, CMetDoc* ptMet, CLoadDoc* ptLoad);

	BOOL NoFuel () { return m_Cons.bNoFuel; }
	CONSUMTYPE* GetConsPtr () { return &m_Cons; }
	UINT GetTotalEET ();
	UINT GetEndurance ();

private:
	BOOL IsLoadingForPlaneOK(CLoadDoc* ptLoad, CPlane* ptPlane);

};
#endif 

