// calcdlg.cpp : implementation file
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "stdafx.h"
#include "pf.h"   
    
#include "DimDoc.h"         
#include "CalcDoc.h"
#include "calcdlg.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

extern CDimDoc* ptDim;

/////////////////////////////////////////////////////////////////////////////
// CCalcDlg dialog


CCalcDlg::CCalcDlg(CWnd* pParent, CCalcDoc* ptDoc)
	: CDlgTool(CCalcDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CCalcDlg)
	m_nDay = 0;
	m_nMonth = 0;
	m_nYear = 0;   
	m_nOrthoDim = -1;
	m_nRouteDim = -1;
	m_nSemiDim = -1;
	m_nUpDownDim = -1;
	m_nDepArv_min = 0;
	m_nTaxi_min = 0;
	m_nSafeRes_min = 0;
	m_lPlAlt = 0;
	m_nPlAltDim = -1;
	//}}AFX_DATA_INIT

m_ptDoc = ptDoc;
this->SetCalcPref (m_ptDoc);
}

void CCalcDlg::DoDataExchange(CDataExchange* pDX)
{
this->ActivateDimGroups();  

	CDlgTool::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CCalcDlg)
	DDX_Text(pDX, ID_CADAY, m_nDay);
	DDV_MinMaxUInt(pDX, m_nDay, 1, 31);
	DDX_Text(pDX, ID_CAMONTH, m_nMonth);
	DDV_MinMaxUInt(pDX, m_nMonth, 1, 12);
	DDX_Text(pDX, ID_CAYEAR, m_nYear);
	DDV_MinMaxUInt(pDX, m_nYear, 1990, 2037);
	DDX_Alt(pDX, ID_CAUPDOWNDIFF, m_lUpDownDiff);
	DDV_Alt(pDX, m_lUpDownDiff, 500, 10000);
	DDX_Alt(pDX, ID_CASEMISTART, m_lSemiStart);
	DDV_Alt(pDX, m_lSemiStart, 500, 5000);
	DDX_Dist(pDX, ID_CAORTHODIFF, m_lOrthoDiff);
	DDV_Dist(pDX, m_lOrthoDiff, 250, 5000);
	DDX_Dist(pDX, ID_CAROUTEDIFF, m_lRouteDiff);
	DDV_Dist(pDX, m_lRouteDiff, 10, 100);
	DDX_Radio(pDX, ID_CAQUALLOW, m_nRouteQual);
	DDX_CBIndex(pDX, ID_CAORTHODIM, m_nOrthoDim);
	DDX_CBIndex(pDX, ID_CAROUTEDIM, m_nRouteDim);
	DDX_CBIndex(pDX, ID_CASEMIDIM, m_nSemiDim);
	DDX_CBIndex(pDX, ID_CAUPDOWNDIM, m_nUpDownDim);
	DDX_Text(pDX, ID_CADEPARV, m_nDepArv_min);
	DDX_Text(pDX, ID_CATAXI, m_nTaxi_min);
	DDX_Text(pDX, ID_CASAFERES, m_nSafeRes_min);
	DDX_Text(pDX, ID_CAPLALT, m_lPlAlt);
	DDX_CBIndex(pDX, ID_CAPLALTDIM, m_nPlAltDim);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CCalcDlg, CDlgTool)
	//{{AFX_MSG_MAP(CCalcDlg)
	ON_BN_CLICKED(ID_CARESET, OnReset)
	ON_WM_HELPINFO()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CCalcDlg message handlers

/************************************************************************
 *  CalcDlg.cpp   			   S e t C a l c P r e f					*
 ************************************************************************/
void CCalcDlg::SetCalcPref (CCalcDoc* ptDoc)
{                                       
 	m_nUpDownDim = ptDim->GetPUIndex (ALTITUDE, ptDoc->GetUpDownDim());  
 	m_nSemiDim = ptDim->GetPUIndex (ALTITUDE, ptDoc->GetSemiDim());  
 	m_nOrthoDim = ptDim->GetPUIndex (DISTANCE, ptDoc->GetOrthoDim());  
	m_nRouteDim = ptDim->GetPUIndex (DISTANCE, ptDoc->GetRouteDim());  
	m_nPlAltDim = ptDim->GetPUIndex (ALTITUDE, ptDoc->GetPlAltDim());  

	ptDoc->GetTime (&m_nDay, &m_nMonth, &m_nYear);

	m_lUpDownDiff = ptDoc->GetUpDownDiff();
	m_lSemiStart = ptDoc->GetSemiStart();
	m_lOrthoDiff = ptDoc->GetOrthoDiff();
	m_lRouteDiff = ptDoc->GetRouteDiff();
	m_lPlAlt	 = ptDoc->GetPlAlt();
	m_nRouteQual = ptDoc->GetRouteQual() - CCalcDoc::RQ_LOW;

	m_nDepArv_min	= ptDoc->GetDepArvTime();
	m_nTaxi_min		= ptDoc->GetTaxiTime();
	m_nSafeRes_min	= ptDoc->GetSafeResTime();
}


/************************************************************************
 *  CalcDlg.cpp   			   G e t C a l c P r e f					*
 ************************************************************************/
void CCalcDlg::GetCalcPref (CCalcDoc* ptDoc)
{                                       
 	ptDoc->SetUpDownDim(ptDim->GetPUDim (ALTITUDE, m_nUpDownDim));
	ptDoc->SetSemiDim(ptDim->GetPUDim (ALTITUDE, m_nSemiDim));
	ptDoc->SetOrthoDim(ptDim->GetPUDim (DISTANCE, m_nOrthoDim));
	ptDoc->SetRouteDim(ptDim->GetPUDim (DISTANCE, m_nRouteDim));
	ptDoc->SetPlAltDim(ptDim->GetPUDim (ALTITUDE, m_nPlAltDim));

 	ptDoc->SetTime (m_nDay, m_nMonth, m_nYear);

	ptDoc->SetUpDownDiff(m_lUpDownDiff);
	ptDoc->SetSemiStart(m_lSemiStart);
	ptDoc->SetOrthoDiff(m_lOrthoDiff);
	ptDoc->SetRouteDiff(m_lRouteDiff);
	ptDoc->SetRouteQual(m_nRouteQual + CCalcDoc::RQ_LOW);
	ptDoc->SetPlAlt(m_lPlAlt);

	ptDoc->SetDepArvTime (m_nDepArv_min);
	ptDoc->SetTaxiTime   (m_nTaxi_min);
	ptDoc->SetSafeResTime(m_nSafeRes_min);
}     

/************************************************************************
 *  CalcDlg.cpp   			   O n I n i t D i a l o g					*
 ************************************************************************/
BOOL CCalcDlg::OnInitDialog()
{
this->AddDimGroup (ID_CAUPDOWNDIFF, ID_CAUPDOWNDIM);
this->AddDimGroup (ID_CASEMISTART, ID_CASEMIDIM);
this->AddDimGroup (ID_CAORTHODIFF, ID_CAORTHODIM);
this->AddDimGroup (ID_CAROUTEDIFF, ID_CAROUTEDIM);  
this->AddDimGroup (ID_CAPLALT, ID_CAPLALTDIM);  

this->FillDimPU (ID_CAUPDOWNDIM, ALTITUDE);
this->FillDimPU (ID_CASEMIDIM, ALTITUDE);
this->FillDimPU (ID_CAORTHODIM, DISTANCE);
this->FillDimPU (ID_CAROUTEDIM, DISTANCE);
this->FillDimPU (ID_CAPLALTDIM, ALTITUDE);
	// TODO: Add extra initialization here
CDlgTool::OnInitDialog();
return TRUE;  // return TRUE  unless you set the focus to a control
}

/************************************************************************
 *  CalcDlg.cpp   			   O n R e s e t						*
 ************************************************************************/
void CCalcDlg::OnReset() 
{
	// TODO: Code fr die Behandlungsroutine der Steuerelement-Benachrichtigung hier einfgen
m_ptDoc->GetActualTime (&m_nDay, &m_nMonth, &m_nYear);
	
//	m_ptDoc->SetTime (m_nDay, m_nMonth, m_nYear);

m_lUpDownDiff = 1500;		    /* for calculation	   */
m_nUpDownDim = ptDim->GetPUIndex (ALTITUDE, DIM_FEET);  
m_lSemiStart = 2500;
m_nSemiDim = ptDim->GetPUIndex (ALTITUDE, DIM_FEET);  
m_lOrthoDiff = 1000;
m_nOrthoDim = ptDim->GetPUIndex (DISTANCE, DIM_NM);  
m_lRouteDiff = 40;
m_nRouteDim = ptDim->GetPUIndex (DISTANCE, DIM_NM);  
m_nRouteQual = CCalcDoc::RQ_MEDIUM - CCalcDoc::RQ_LOW;

m_nTaxi_min		= 10;		// default: 10 min
m_nDepArv_min	= 10;		// default: 10 min
m_nSafeRes_min	= 30;		// default: 30 min

m_lPlAlt	= 4500;
m_nPlAltDim = ptDim->GetPUIndex (ALTITUDE, DIM_FEET);

this->UpdateData (FALSE);	
}

/************************************************************************
 *  CalcDlg.cpp	  				 O n H e l p I n f o					*
 ************************************************************************/
BOOL CCalcDlg::OnHelpInfo(HELPINFO* pHelpInfo) 
{
	// TODO: Add your message handler code here and/or call default
	
if (pHelpInfo->iContextType == HELPINFO_WINDOW)
	{
	AfxGetApp()->WinHelp (pHelpInfo->dwContextId, HELP_CONTEXTPOPUP);
	}

return TRUE;
}
