/************************************************************************
 *  						C a l c D o c . c p p  						*
 ************************************************************************/
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "stdafx.h"
#include "pf.h"

#include "InitDoc.h"					// for ACT_INI_VERS
#include "DimDoc.h"

#include "CalcDlg.h"				// dialog to set calculation pref parameters
#include "CalcDoc.h"  

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

extern CDimDoc*		ptDim;            

/////////////////////////////////////////////////////////////////////////////
// CCalcDoc
IMPLEMENT_DYNCREATE(CCalcDoc, CDocument)

BEGIN_MESSAGE_MAP(CCalcDoc, CDocument)
	//{{AFX_MSG_MAP(CCalcDoc)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCalcDoc construction/destruction

CCalcDoc::CCalcDoc()
{       
	time (&m_Time);

	m_nUpDownDiff = 1500;		    /* for calculation	   */
	m_nUpDownDim = DIM_FEET;
	m_nSemiStart = 2500;
	m_nSemiDim = DIM_FEET;
	m_nOrthoDiff = 1000;
	m_nOrthoDim = DIM_NM;
	m_nRouteDiff = 40;
	m_nRouteDim = DIM_NM;
	m_nRouteQual = RQ_MEDIUM;

	m_nTaxiTime		= 10;		// default: 10 min
	m_nDepArvTime	= 10;		// default: 10 min
	m_nSafeResTime	= 30;		// default: 30 min

	m_nPlAlt	= 4500;
	m_nPlAltDim = DIM_FEET;
}

CCalcDoc::~CCalcDoc()
{
}

/************************************************************************
 *  CalcDoc.cpp	  		 		G e t P l A l t							*
 ************************************************************************/
long CCalcDoc::GetPlAlt (short nAltDim)
{
	double dConvert = ptDim->ConvertDist(m_nPlAlt, m_nPlAltDim, nAltDim);
	return (long)(dConvert + 0.5);
}

/************************************************************************
 *  CalcDoc.cpp	  		 		 G e t T i m e							*
 ************************************************************************/
void CCalcDoc::GetTime (UINT* ptDay, UINT* ptMonth, UINT* ptYear)
{
time_t	ltime;
struct	tm LogTime, *ptLogTime;

ltime = m_Time;
ptLogTime = &LogTime;
ptLogTime = localtime (&ltime);		/* get actual date		*/

*ptDay		= (UINT)ptLogTime->tm_mday;
*ptMonth	= (UINT)ptLogTime->tm_mon + 1;
*ptYear		= (UINT)ptLogTime->tm_year + 1900;
}

/************************************************************************
 *  CalcDoc.cpp	  		 	G e t A c t u a l T i m e					*
 ************************************************************************/
void CCalcDoc::GetActualTime (UINT* ptDay, UINT* ptMonth, UINT* ptYear)
{
	time (&m_Time);
	this->GetTime (ptDay, ptMonth, ptYear);
}



/************************************************************************
 *  CalcDoc.cpp	  		 		 G e t T i m e							*
 ************************************************************************/
time_t CCalcDoc::GetTime ()
{
return m_Time;
}

/************************************************************************
 *  CalcDoc.cpp	  		 		 S e t T i m e							*
 ************************************************************************/
void CCalcDoc::SetTime (short nDay, short nMonth, short nYear)
{
struct	tm LogTime;

LogTime.tm_mday	= nDay;
LogTime.tm_mon	= nMonth;
LogTime.tm_mon	-= 1;
LogTime.tm_year =  nYear;
LogTime.tm_year -= 1900;

LogTime.tm_hour  = 12;
LogTime.tm_min	 = 0;
LogTime.tm_sec	 = 0;
LogTime.tm_wday  = 0;
LogTime.tm_yday  = 0;
LogTime.tm_isdst = 0;

m_Time = mktime(&LogTime);
}

/************************************************************************
 *  CalcDoc.cpp	  		 		 C h a n g e 							*
 ************************************************************************/
void CCalcDoc::Change(CWnd* ptWnd)
{
CCalcDlg CalcDlg(ptWnd, this);

int RetVal = CalcDlg.DoModal();
switch (RetVal)
	{
	case IDOK:   
		CalcDlg.GetCalcPref (this);      
 		ptWnd->InvalidateRect(NULL);
		break;
	case IDCANCEL:
		break;
	}	
} 



/************************************************************************
 *  CalcDoc.cpp	  		 		 S e r i a l i z e 						*
 ************************************************************************/
void CCalcDoc::Serialize(CArchive& ar, short nReadVers)
{    
	WORD	Word;

	if (ar.IsStoring())
	{
		// TODO: add storing code here   
		ar.Write (&m_nUpDownDiff, sizeof(short));		    /* for calculation	   */
		ar.Write (&m_nUpDownDim, sizeof(short));
		ar.Write (&m_nSemiStart, sizeof(short));
		ar.Write (&m_nSemiDim, sizeof(short));
		ar.Write (&m_nOrthoDiff, sizeof(short));
		ar.Write (&m_nOrthoDim, sizeof(short));
		ar.Write (&m_nRouteDiff, sizeof(short));
		ar.Write (&m_nRouteDim, sizeof(short));
		ar.Write (&m_nRouteQual, sizeof(short));

		ar.Write (&m_nTaxiTime, sizeof(short));
		ar.Write (&m_nDepArvTime,sizeof(short));
		ar.Write (&m_nSafeResTime, sizeof(short));

		ar.Write (&m_nPlAlt, sizeof(short));
		ar.Write (&m_nPlAltDim, sizeof(short));
	}
	else
	{
		// TODO: add loading code here  
		ar >> Word;		m_nUpDownDiff  = (short)Word; 
		ar >> Word;		m_nUpDownDim  = (short)Word; 
		ar >> Word;		m_nSemiStart  = (short)Word; 
		ar >> Word;		m_nSemiDim  = (short)Word; 
		ar >> Word;		m_nOrthoDiff  = (short)Word; 
		ar >> Word;		m_nOrthoDim  = (short)Word; 
		ar >> Word;		m_nRouteDiff  = (short)Word; 
		ar >> Word;		m_nRouteDim  = (short)Word; 
		ar >> Word;		m_nRouteQual  = (RouteQual)Word; 

		ar >> Word;		m_nTaxiTime	   = (short)Word; 
		ar >> Word;		m_nDepArvTime  = (short)Word; 
		ar >> Word;		m_nSafeResTime = (short)Word; 	


		if (nReadVers <= 30)
		{
			m_nPlAlt = 4500;				// <-- preferred planned alt for autorouting	
			m_nPlAltDim = DIM_FEET;			// <-- planned alt dimension					
		}


		if (nReadVers == 32 ||
			nReadVers == ACT_INI_VERS)
	    {				
			ar >> Word;		m_nPlAlt  = (short)Word; 
			ar >> Word;		m_nPlAltDim  = (short)Word; 
		}

	}
}
 