#ifndef __CALCDOC__
#define __CALCDOC__

/************************************************************************
 *  						C a l c D o c . h 	 						*
 ************************************************************************/
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

class CCalcDoc : public CDocument
{ 
protected: // create from serialization only
	DECLARE_DYNCREATE(CCalcDoc)

public:   
	enum RouteQual {RQ_LOW = 2,			
					RQ_MEDIUM,			
					RQ_HIGH
					};

// Attributes
public:                      
	time_t	m_Time;

	short	m_nUpDownDiff;		    /* for calculation	   */
	short	m_nUpDownDim;
	short	m_nSemiStart;
	short	m_nSemiDim;
	short	m_nOrthoDiff;
	short	m_nOrthoDim;
	short	m_nRouteDiff;
	short	m_nRouteDim; 
	short	m_nPlAlt;			// preferred planned alt for autorouting
	short	m_nPlAltDim;
	short	m_nTaxiTime;		// default: 10 min
	short	m_nDepArvTime;		// default: 10 min
	short	m_nSafeResTime;		// default: 30 min
	RouteQual	m_nRouteQual;	/* RQ_LOW, RQ_MEDIUM, RQ_HIGH	    */
// Operations
public:
	CCalcDoc();	
	~CCalcDoc();   
	void Change (CWnd* ptWnd);
	void Serialize(CArchive& ar, short nReadVers);

  	void SetUpDownDim(short nDim){m_nUpDownDim = nDim;}         
	void SetSemiDim(short nDim){m_nSemiDim = nDim;}         
	void SetOrthoDim(short nDim){m_nOrthoDim = nDim;}  
	void SetRouteDim(short nDim){m_nRouteDim = nDim;}      
	void SetPlAltDim(short nDim) { m_nPlAltDim = nDim; } 


    short GetUpDownDim(){return m_nUpDownDim;}
    short GetSemiDim(){return m_nSemiDim;}
    short GetOrthoDim(){return m_nOrthoDim;}
    short GetRouteDim(){return m_nRouteDim;}
    short GetPlAltDim(){return m_nPlAltDim;}

	long GetPlAlt (short nAltDim);
	time_t GetTime ();
	void GetTime (UINT* ptDay, UINT* ptMonth, UINT* ptYear);
	void GetActualTime (UINT* ptDay, UINT* ptMonth, UINT* ptYear);
	void SetTime (short nDay, short nMonth, short nYear);

    long GetUpDownDiff(){return (long)m_nUpDownDiff;}
    long GetSemiStart(){return (long)m_nSemiStart;}
    long GetOrthoDiff(){return (long)m_nOrthoDiff;}
    long GetRouteDiff(){return (long)m_nRouteDiff;}
    long GetPlAlt(){return (long)m_nPlAlt;}

    short GetRouteQual(){return (short)m_nRouteQual;}
	short GetTaxiTime () { return m_nTaxiTime; }
	short GetDepArvTime (){ return m_nDepArvTime; }
	short GetSafeResTime () { return m_nSafeResTime; }

 	void SetUpDownDiff(long lUpDown){m_nUpDownDiff = (short)lUpDown;}
	void SetSemiStart(long lSemi){m_nSemiStart = (short)lSemi;}
	void SetOrthoDiff(long lOrtho){m_nOrthoDiff = (short)lOrtho;}
	void SetRouteDiff(long lRteDiff){m_nRouteDiff = (short)lRteDiff;}
	void SetPlAlt(long lPlAlt){m_nPlAlt = (short)lPlAlt;}
	void SetRouteQual(short nRteQual){m_nRouteQual = (RouteQual)nRteQual;}
	void SetTaxiTime (short	nTime) { m_nTaxiTime = nTime; }
	void SetDepArvTime (short nTime) { m_nDepArvTime = nTime; }
	void SetSafeResTime (short nTime) { m_nSafeResTime = nTime;	}

// Implementation
private:
	short GetCalcVers (CArchive& ar, WORD* ptWord);


	// Generated message map functions
protected:
	//{{AFX_MSG(CCalcDoc)
		// NOTE - the ClassWizard will add and remove member functions here.
		//    DO NOT EDIT what you see in these blocks of generated code !
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};
#endif 
