// ColPrDlg.cpp: Implementierungsdatei
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "stdafx.h"
#include "pf.h"

#include "InitDoc.h"  

#include "ColorDoc.h"
#include "ColPrDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern CInitDoc* 		ptInit;

/////////////////////////////////////////////////////////////////////////////
// Dialogfeld CColorPrefDlg 


CColorPrefDlg::CColorPrefDlg(CWnd* pParent, CColorDoc* ptDoc, BOOL bMapSelected)
	: CDlgTool(CColorPrefDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CColorPrefDlg)
	m_nSizeLineMap = 0;
	m_nSizeLineScMap = 0;
	m_nSizeBearScMap = 0;
	m_nSizeBearMap = 0;
	m_bActivateFlightCT = FALSE;
	m_bActivateSeaCT = FALSE;
	//}}AFX_DATA_INIT

m_ptDoc = ptDoc;
m_bMapSelected = bMapSelected;

m_ptDoc->GetMapLine (&m_ColMapLine, &m_nSizeLineMap);				 
m_ptDoc->GetMapBear (&m_ColMapBear, &m_nSizeBearMap);				 
m_ColMapLabel		= m_ptDoc->GetColMapLabel ();
m_ColMapSel			= m_ptDoc->GetColMapSel ();
m_ColMapFrame		= m_ptDoc->GetColMapFrame ();
m_ColMapPos			= m_ptDoc->GetColMapPos ();

m_ptDoc->GetScMapLine (&m_ColScMapLine, &m_nSizeLineScMap);				 
m_ptDoc->GetScMapBear (&m_ColScMapBear, &m_nSizeBearScMap);				 
m_ColScMapLabel		= m_ptDoc->GetColScMapLabel ();
m_ColScMapSel		= m_ptDoc->GetColScMapSel ();
m_ColScMapText		= m_ptDoc->GetColScMapText();
m_ColScMapPos		= m_ptDoc->GetColScMapPos();

m_bActivateSeaCT	= m_ptDoc->IsActivateSeaCT();
m_bActivateFlightCT	= m_ptDoc->IsActivateFlightCT();
}


void CColorPrefDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CColorPrefDlg)
	DDX_Text(pDX, IDC_CP_SIZE_MAP_LINE, m_nSizeLineMap);
	DDV_MinMaxInt(pDX, m_nSizeLineMap, 1, 50);
	DDX_Text(pDX, IDC_CP_SIZE_SCMAP_LINE, m_nSizeLineScMap);
	DDV_MinMaxInt(pDX, m_nSizeLineScMap, 1, 50);
	DDX_Text(pDX, IDC_CP_SIZE_SCMAP_BEAR, m_nSizeBearScMap);
	DDV_MinMaxInt(pDX, m_nSizeBearScMap, 1, 50);
	DDX_Text(pDX, IDC_CP_SIZE_MAP_BEAR, m_nSizeBearMap);
	DDV_MinMaxInt(pDX, m_nSizeBearMap, 1, 50);
	DDX_Check(pDX, IDC_CP_ACT_FLIGHT, m_bActivateFlightCT);
	DDX_Check(pDX, IDC_CP_ACT_SEA, m_bActivateSeaCT);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CColorPrefDlg, CDialog)
	//{{AFX_MSG_MAP(CColorPrefDlg)
	ON_BN_CLICKED(IDC_CP_CHANGE_MAP_LINE, OnChangeColMapLine)
	ON_WM_PAINT()
	ON_BN_CLICKED(IDC_CP_CHANGE_MAP_BEAR, OnChangeColMapBear)
	ON_BN_CLICKED(IDC_CP_CHANGE_MAP_FRAME, OnChangeColMapFrame)
	ON_BN_CLICKED(IDC_CP_CHANGE_MAP_LABEL, OnChangeColMapLabel)
	ON_BN_CLICKED(IDC_CP_CHANGE_MAP_SEL, OnChangeColMapSel)
	ON_BN_CLICKED(IDC_CP_CHANGE_SCMAP_BEAR, OnChangeColScMapBear)
	ON_BN_CLICKED(IDC_CP_CHANGE_SCMAP_LABEL, OnChangeColScMapLabel)
	ON_BN_CLICKED(IDC_CP_CHANGE_SCMAP_LINE, OnChangeColScMapLine)
	ON_BN_CLICKED(IDC_CP_CHANGE_SCMAP_SEL, OnChangeColScMapSel)
	ON_WM_HELPINFO()
	ON_BN_CLICKED(IDC_CP_CHANGE_SCMAP_TEXT, OnChangeColScMapText)
	ON_BN_CLICKED(IDC_CP_CHANGE_MAP_POS, OnChangeColMapPos)
	ON_BN_CLICKED(IDC_CP_CHANGE_SCMAP_POS, OnChangeColScMapPos)
	ON_BN_CLICKED(IDC_CP_RESET_MAP, OnResetMapColors)
	ON_BN_CLICKED(IDC_CP_RESET_SCMAP, OnResetScMapColors)
	ON_BN_CLICKED(IDC_CP_ELEV_FLIGHT, OnEditFlightCT)
	ON_BN_CLICKED(IDC_CP_ELEV_SEA, OnEditSeaCT)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/************************************************************************
 *  ColPrDlg.cpp	  		 	D r a w R e c t							*
 ************************************************************************/
void CColorPrefDlg::DrawRect (UINT uID, COLORREF Col)
{
CBrush* ptBrush = new	CBrush (Col);

	CWnd* ptWnd = this->GetDlgItem (uID);
	CDC* pDC = ptWnd->GetDC();	
//	pDC->SetBkColor (m_ColMapLine);
	CRect rClient;
	ptWnd->GetClientRect(&rClient);

	CBrush* ptOldBrush = (CBrush*)pDC->SelectObject (ptBrush);
	pDC->Rectangle (rClient);
	pDC->SelectObject (ptOldBrush);
	ptWnd->ReleaseDC(pDC);
delete ptBrush;	 	
}

/////////////////////////////////////////////////////////////////////////////
// Behandlungsroutinen fr Nachrichten CColorPrefDlg 

/************************************************************************
 *  ColPrDlg.cpp	  		O n I n i t D i a l o g						*
 ************************************************************************/
BOOL CColorPrefDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
		
	this->DisableControl (IDC_CP_CHANGE_SCMAP_TEXT, !m_bMapSelected);  

	// TODO: Zustzliche Initialisierung hier einfgen
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX-Eigenschaftenseiten sollten FALSE zurckgeben
}


/************************************************************************
 *  ColPrDlg.cpp	  		C h a n g e C o l o r D l g					*
 ************************************************************************/
void CColorPrefDlg::ChangeColorDlg (UINT uFrameID, COLORREF* ptCol)
{
DWORD dwFlags = 0;
CColorDialog ColDlg (*ptCol, dwFlags, this);

int ret = ColDlg.DoModal();
if (ret == IDOK)
	{
	*ptCol = ColDlg.GetColor(); 
		// to force color update after closing ColDlg
	this->DrawRect (uFrameID, *ptCol);	
	}
}

/************************************************************************
 *  ColPrDlg.cpp	  		 	 O n O K							*
 ************************************************************************/
void CColorPrefDlg::OnOK() 
{
	// TODO: Zustzliche Prfung hier einfgen
if (this->UpdateData (TRUE))
	{
	m_ptDoc->SetMapLine (m_ColMapLine, m_nSizeLineMap);				 
	m_ptDoc->SetMapBear (m_ColMapBear, m_nSizeBearMap);				 
	m_ptDoc->SetColMapLabel   (m_ColMapLabel	);
	m_ptDoc->SetColMapSel (m_ColMapSel);
	m_ptDoc->SetColMapFrame   (m_ColMapFrame	);
	m_ptDoc->SetColMapPos   (m_ColMapPos	);

	m_ptDoc->SetScMapLine (m_ColScMapLine, m_nSizeLineScMap);				 
	m_ptDoc->SetScMapBear (m_ColScMapBear, m_nSizeBearScMap);				 
	m_ptDoc->SetColScMapLabel (m_ColScMapLabel	);
	m_ptDoc->SetColScMapSel (m_ColScMapSel);
	m_ptDoc->SetColScMapText (m_ColScMapText);
	m_ptDoc->SetColScMapPos (m_ColScMapPos);

	m_ptDoc->SetActivateSeaCT(m_bActivateSeaCT);
	m_ptDoc->SetActivateFlightCT(m_bActivateFlightCT);

	CDialog::OnOK();
	}
else{					
	CDialog::OnCancel();
	}

}


/************************************************************************
 *  ColPrDlg.cpp	  		 O n P a i n t 								*
 ************************************************************************/
void CColorPrefDlg::OnPaint() 
{
	CPaintDC dc(this); // device context for painting
	
	// TODO: Code fr die Behandlungsroutine fr Nachrichten hier einfgen
	this->DrawRect (IDC_CP_COL_MAP_LINE,	m_ColMapLine);	
	this->DrawRect (IDC_CP_COL_MAP_BEAR,	m_ColMapBear);
	this->DrawRect (IDC_CP_COL_MAP_LABEL,	m_ColMapLabel);
	this->DrawRect (IDC_CP_COL_MAP_SEL,		m_ColMapSel);
	this->DrawRect (IDC_CP_COL_MAP_FRAME,	m_ColMapFrame);
	this->DrawRect (IDC_CP_COL_MAP_POS,		m_ColMapPos);
										               
	this->DrawRect (IDC_CP_COL_SCMAP_LINE,	m_ColScMapLine);
	this->DrawRect (IDC_CP_COL_SCMAP_BEAR,	m_ColScMapBear);
	this->DrawRect (IDC_CP_COL_SCMAP_LABEL,m_ColScMapLabel);
	this->DrawRect (IDC_CP_COL_SCMAP_SEL,	m_ColScMapSel);
	this->DrawRect (IDC_CP_COL_SCMAP_TEXT,	m_ColScMapText);
	this->DrawRect (IDC_CP_COL_SCMAP_POS,	m_ColScMapPos);


	// Kein Aufruf von CDialog::OnPaint() fr Zeichnungsnachrichten
}


/************************************************************************
 *  ColPrDlg.cpp	  		O n C h a n g e C o l M a p x x x			*
 ************************************************************************/
void CColorPrefDlg::OnChangeColMapLine() 
{
this->ChangeColorDlg(IDC_CP_COL_MAP_LINE, &m_ColMapLine);
}

void CColorPrefDlg::OnChangeColMapBear() 
{
this->ChangeColorDlg(IDC_CP_COL_MAP_BEAR, &m_ColMapBear);
}

void CColorPrefDlg::OnChangeColMapLabel() 
{
	// TODO: Code fr die Behandlungsroutine der Steuerelement-Benachrichtigung hier einfgen
this->ChangeColorDlg(IDC_CP_COL_MAP_LABEL, &m_ColMapLabel);
}

void CColorPrefDlg::OnChangeColMapSel() 
{
	// TODO: Code fr die Behandlungsroutine der Steuerelement-Benachrichtigung hier einfgen
this->ChangeColorDlg(IDC_CP_COL_MAP_SEL, &m_ColMapSel);
}

void CColorPrefDlg::OnChangeColMapFrame() 
{
this->ChangeColorDlg(IDC_CP_COL_MAP_FRAME, &m_ColMapFrame);
}

void CColorPrefDlg::OnChangeColMapPos() 
{
this->ChangeColorDlg(IDC_CP_COL_MAP_POS, &m_ColMapPos);
}


										               
/************************************************************************
 *  ColPrDlg.cpp	  	O n C h a n g e C o l S c M a p x x x			*
 ************************************************************************/

void CColorPrefDlg::OnChangeColScMapLine() 
{
	// TODO: Code fr die Behandlungsroutine der Steuerelement-Benachrichtigung hier einfgen
this->ChangeColorDlg(IDC_CP_COL_SCMAP_LINE, &m_ColScMapLine);
}


void CColorPrefDlg::OnChangeColScMapBear() 
{
	// TODO: Code fr die Behandlungsroutine der Steuerelement-Benachrichtigung hier einfgen
this->ChangeColorDlg(IDC_CP_COL_SCMAP_BEAR, &m_ColScMapBear);
}

void CColorPrefDlg::OnChangeColScMapLabel() 
{
	// TODO: Code fr die Behandlungsroutine der Steuerelement-Benachrichtigung hier einfgen
this->ChangeColorDlg(IDC_CP_COL_SCMAP_LABEL, &m_ColScMapLabel);
}

void CColorPrefDlg::OnChangeColScMapSel() 
{
	// TODO: Code fr die Behandlungsroutine der Steuerelement-Benachrichtigung hier einfgen
this->ChangeColorDlg(IDC_CP_COL_SCMAP_SEL, &m_ColScMapSel);
}

void CColorPrefDlg::OnChangeColScMapText() 
{
	// TODO: Add your control notification handler code here
this->ChangeColorDlg(IDC_CP_COL_SCMAP_TEXT, &m_ColScMapText);
}

void CColorPrefDlg::OnChangeColScMapPos() 
{
	// TODO: Add your control notification handler code here
this->ChangeColorDlg(IDC_CP_COL_SCMAP_POS, &m_ColScMapPos);
}



/************************************************************************
 *  ColPrDlg.cpp	  			 O n H e l p I n f o					*
 ************************************************************************/
BOOL CColorPrefDlg::OnHelpInfo(HELPINFO* pHelpInfo) 
{
	// TODO: Add your message handler code here and/or call default
	
if (pHelpInfo->iContextType == HELPINFO_WINDOW)
	{
	AfxGetApp()->WinHelp (pHelpInfo->dwContextId, HELP_CONTEXTPOPUP);
	}

return TRUE;
}



/************************************************************************
 *  ColPrDlg.cpp	  	O n R e s e t M a p C o l o r s					*
 ************************************************************************/
void CColorPrefDlg::OnResetMapColors() 
{
	// TODO: Code fr die Behandlungsroutine der Steuerelement-Benachrichtigung hier einfgen

	if (this->UpdateData(TRUE))
	{
		m_nSizeLineMap = 10;		// for MM_LOMETRIC: Line strength= 1,0 mm
		m_nSizeBearMap = 5;
		m_ColMapLine = RGB (255, 0, 255);
		m_ColMapBear = RGB (255, 0, 0);
		m_ColMapLabel = RGB (255, 255,0);
		m_ColMapSel = RGB (0, 255, 0);
		m_ColMapFrame = RGB (128, 128, 0);
		m_ColMapPos = RGB (255, 0, 0);

		m_bActivateFlightCT = TRUE;
		m_bActivateSeaCT = TRUE;

		this->UpdateData(FALSE);

		this->DrawRect (IDC_CP_COL_MAP_LINE,	m_ColMapLine);	
		this->DrawRect (IDC_CP_COL_MAP_BEAR,	m_ColMapBear);
		this->DrawRect (IDC_CP_COL_MAP_LABEL,	m_ColMapLabel);
		this->DrawRect (IDC_CP_COL_MAP_SEL,		m_ColMapSel);
		this->DrawRect (IDC_CP_COL_MAP_FRAME,	m_ColMapFrame);
		this->DrawRect (IDC_CP_COL_MAP_POS,		m_ColMapPos);
	}
}

/************************************************************************
 *  ColPrDlg.cpp	  	O n R e s e t S c M a p C o l o r s				*
 ************************************************************************/
void CColorPrefDlg::OnResetScMapColors() 
{
	// TODO: Code fr die Behandlungsroutine der Steuerelement-Benachrichtigung hier einfgen
	
	if (this->UpdateData(TRUE))
	{
		m_nSizeLineScMap = 10;		// for MM_LOMETRIC: Line strength= 1,0 mm
		m_nSizeBearScMap = 5;
		m_ColScMapLine= RGB (255, 255,0);
		m_ColScMapBear = RGB (255, 0, 0); 
		m_ColScMapLabel = RGB (255, 255,0);
		m_ColScMapSel = RGB (0, 255, 0);
		m_ColScMapText = RGB (0,0,0);
		m_ColScMapPos = RGB (0,255,255);

		this->UpdateData(FALSE);
														   
		this->DrawRect (IDC_CP_COL_SCMAP_LINE,	m_ColScMapLine);
		this->DrawRect (IDC_CP_COL_SCMAP_BEAR,	m_ColScMapBear);
		this->DrawRect (IDC_CP_COL_SCMAP_LABEL, m_ColScMapLabel);
		this->DrawRect (IDC_CP_COL_SCMAP_SEL,	m_ColScMapSel);
		this->DrawRect (IDC_CP_COL_SCMAP_TEXT,	m_ColScMapText);
		this->DrawRect (IDC_CP_COL_SCMAP_POS,	m_ColScMapPos);
	}
}


void CColorPrefDlg::OnEditSeaCT() 
{
	// TODO: Code fr die Behandlungsroutine der Steuerelement-Benachrichtigung hier einfgen
	CElevColorDoc* ptElevColorDoc = ptInit->GetElevColorDocPtr(CElevColorDoc::SEA_BASED);
	if (ptElevColorDoc != NULL)
		ptElevColorDoc->Change(this);
	
}

void CColorPrefDlg::OnEditFlightCT() 
{
	// TODO: Code fr die Behandlungsroutine der Steuerelement-Benachrichtigung hier einfgen
	CElevColorDoc* ptElevColorDoc = ptInit->GetElevColorDocPtr(CElevColorDoc::FLIGHT_BASED);
	if (ptElevColorDoc != NULL)
		ptElevColorDoc->Change(this);
	
}
