// ColTbDoc.cpp : implementation of the CColorTableDoc class
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "stdafx.h"
#include "resource.h"

//#include "ColTbDlg.h"
#include "ColTbDoc.h"  

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

extern BOOL bDemo;
 
/////////////////////////////////////////////////////////////////////////////
// CColorTableDoc

IMPLEMENT_DYNCREATE(CColorTableDoc, CDocument)

BEGIN_MESSAGE_MAP(CColorTableDoc, CDocument)
	//{{AFX_MSG_MAP(CColorTableDoc)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CColorTableDoc construction/destruction

CColorTableDoc::CColorTableDoc(short nCnt)
{							// nCnt: number of manually defined colors
	// TODO: add one-time construction code here  
	CString szFileExt = "KeinName.ctb";
	this->SetTitle(szFileExt);
									// define default color table
	m_nFinalCnt = 256;
	InitTable(nCnt);
}

CColorTableDoc::~CColorTableDoc()
{   
if (this->IsModified())  
	{
	CString szPath = this->GetPathName(); 
	this->OnSaveDocument (szPath);
	}

this->DeleteArrayOf (&m_IndexColors);
}
   
/************************************************************************
 *  ColTbDoc.cpp				I n i t T a b l e  						*
 ************************************************************************/
void CColorTableDoc::InitTable(int nCnt)
{
	for (short i=0; i<nCnt; i++)
	{
		INDEXCOLOR* ptEntry = new INDEXCOLOR; 
		if (ptEntry != NULL)
		{
			ptEntry->nIndex = i*m_nFinalCnt/nCnt;

			BYTE byte = m_nFinalCnt-1 - ptEntry->nIndex;

			ptEntry->rgbQuad.rgbBlue = byte;
			ptEntry->rgbQuad.rgbGreen= byte;
			ptEntry->rgbQuad.rgbRed	 = byte;
			ptEntry->rgbQuad.rgbReserved = 0;
			m_IndexColors.Add (ptEntry);       	// add new Element        
		}
 	}  
}


/************************************************************************
 *  ColTbDoc.cpp			D e l e t e A r r a y O f 					*
 ************************************************************************/
void CColorTableDoc::DeleteArrayOf (CPtrArray* ptArray)
{
short i, nEntryCnt;	
											
nEntryCnt = ptArray->GetSize();
for (i=0; i<nEntryCnt; i++)
	{
	INDEXCOLOR* ptEntry;
	if ((ptEntry = (INDEXCOLOR*)ptArray->GetAt(i)) != NULL)
		{
		TRACE ("Deleting INDEXCOLOR %d\n", i);
		delete ptEntry;				// delete original element
		}
	}
ptArray->RemoveAll();
}                
 
/************************************************************************
 *  ColTbDoc.cpp				C o p y C o l o r s						*
 ************************************************************************/
void CColorTableDoc::CopyColors (CPtrArray* ptDest, CPtrArray* ptSource)
{
	short i;
	for (i=0; i<ptSource->GetSize(); i++) 
	{
		INDEXCOLOR*	ptEntry = NULL;         

		ptEntry = (INDEXCOLOR*)ptSource->GetAt (i);    
		if (ptEntry != NULL)
		{
			INDEXCOLOR* ptNewIndexCol = new INDEXCOLOR;	 
			if (ptNewIndexCol != NULL)
			{
				TRACE ("CColorTableDoc::CopyColors Create %d\n", i);

				ptNewIndexCol->nIndex= ptEntry->nIndex;
				ptNewIndexCol->rgbQuad = ptEntry->rgbQuad; 
				ptDest->Add (ptNewIndexCol);    
			}
		}
	}
}


/************************************************************************
 *  ColTbDoc.cpp			C a l c R g b Q u a d s						*
 ************************************************************************/
void CColorTableDoc::CalcRgbQuads (RGBQUAD* ptQuads, INDEXCOLOR* ptIndCol_1, INDEXCOLOR* ptIndCol_2)
{

	short nCnt = ptIndCol_2->nIndex - ptIndCol_1->nIndex;

	BYTE Red_1	= ptIndCol_1->rgbQuad.rgbRed;
	BYTE Green_1= ptIndCol_1->rgbQuad.rgbGreen;
	BYTE Blue_1	= ptIndCol_1->rgbQuad.rgbBlue;

	BYTE Red_2	= ptIndCol_2->rgbQuad.rgbRed;
	BYTE Green_2= ptIndCol_2->rgbQuad.rgbGreen;
	BYTE Blue_2	= ptIndCol_2->rgbQuad.rgbBlue;


	double Fakt_R = (double)(Red_2 - Red_1)/nCnt;
	double Fakt_G = (double)(Green_2 - Green_1)/nCnt;
	double Fakt_B = (double)(Blue_2 - Blue_1)/nCnt;

	for (short i=0; i< nCnt; i++)
	{
		short nActIndex = i + ptIndCol_1->nIndex;

		RGBQUAD NewQuad;

		NewQuad.rgbRed = (BYTE)(Fakt_R * (nActIndex - ptIndCol_1->nIndex) + Red_1);
		NewQuad.rgbGreen = (BYTE)(Fakt_G * (nActIndex - ptIndCol_1->nIndex) + Green_1);
		NewQuad.rgbBlue = (BYTE)(Fakt_B * (nActIndex - ptIndCol_1->nIndex) + Blue_1);
		NewQuad.rgbReserved = 0;
		
		if (nActIndex < m_nFinalCnt)
			*(ptQuads + nActIndex) = NewQuad;
		else AfxMessageBox ("nActIndex >= m_nFinalCnt!!");
	}
}
        
/************************************************************************
 *  ColTbDoc.cpp			C r e a t e R G B Q u a d s					*
 *  Purpose: creates memory for RGBQUAD array and returns pointer to it	*
 *			returns number of entries in ptCnt							*
 ************************************************************************/
RGBQUAD* CColorTableDoc::CreateRGBQuads(short* ptCnt)
{
	RGBQUAD* ptQuads = NULL;
	*ptCnt = 0;

	if (m_nFinalCnt > 0)
	{
		ptQuads = new RGBQUAD[m_nFinalCnt];
		if (ptQuads != NULL)
		{
			*ptCnt = m_nFinalCnt;
			
			INDEXCOLOR* ptIndCol_1 = (INDEXCOLOR*)m_IndexColors.GetAt(0);
			if (ptIndCol_1 != NULL)
			{
				int i;
				for (i=1; i<m_IndexColors.GetSize(); i++)
				{
					INDEXCOLOR* ptIndCol_2 = (INDEXCOLOR*)m_IndexColors.GetAt(i);
					if (ptIndCol_2 != NULL)
					{
						CalcRgbQuads (ptQuads, ptIndCol_1, ptIndCol_2);
					}

					ptIndCol_1 = ptIndCol_2;
				} // for (i...

							// fill rest of table with last entry
				for (i = ptIndCol_1->nIndex; i<m_nFinalCnt; i++)
					*(ptQuads + i) = ptIndCol_1->rgbQuad;

			} // ptIndCol_1
		}
	} // m_nFinalCnt > 0

	return ptQuads;
}

/************************************************************************
 *  ColTbDoc.cpp			G e t D a t a B a s e 						*
 ************************************************************************/
void CColorTableDoc::GetDataBase (CPtrArray* ptColorList)
{    
                              	// copy database from Doc to Dlg
this->DeleteArrayOf (ptColorList);
this->CopyColors (ptColorList, &m_IndexColors);   
}   

/************************************************************************
 *  ColTbDoc.cpp			S e t D a t a B a s e						*
 ************************************************************************/
void CColorTableDoc::SetDataBase (CPtrArray* ptColorList)
{     
                          		 // copy database from Dlg to Doc
this->DeleteArrayOf (&m_IndexColors);
this->CopyColors (&m_IndexColors, ptColorList);   
}

/*
#define RGB(r,g,b)          ((COLORREF)(((BYTE)(r)|((WORD)((BYTE)(g))<<8))|(((DWORD)(BYTE)(b))<<16)))

#define GetRValue(rgb)      ((BYTE)(rgb))
#define GetGValue(rgb)      ((BYTE)(((WORD)(rgb)) >> 8))
#define GetBValue(rgb)      ((BYTE)((rgb)>>16))


typedef struct  tagPALETTEENTRY
    {
    BYTE peRed;
    BYTE peGreen;
    BYTE peBlue;
    BYTE peFlags;
    }	PALETTEENTRY;

  typedef struct tagRGBQUAD {
        BYTE    rgbBlue;
        BYTE    rgbGreen;
        BYTE    rgbRed;
        BYTE    rgbReserved;
} RGBQUAD;

*/

/************************************************************************
 *  ColTbDoc.cpp			C o l o r R e f T o R G B Q u a d			*
 ************************************************************************/
RGBQUAD CColorTableDoc::ColorRefToRGBQuad(COLORREF Color)
{
	RGBQUAD quad;
	memset (&quad, 0, sizeof (RGBQUAD));
	quad.rgbBlue = GetBValue(Color);
	quad.rgbGreen= GetGValue(Color);
	quad.rgbRed  = GetRValue(Color);

	return quad;
}

/************************************************************************
 *  ColTbDoc.cpp			R G B Q u a d T o C o l o r R e f			*
 ************************************************************************/
COLORREF CColorTableDoc::RGBQuadToColorRef (RGBQUAD quad)
{
	COLORREF Color;
	
	Color = RGB(quad.rgbRed, quad.rgbGreen, quad.rgbBlue);
	return Color;
}

/************************************************************************
 *  ColTbDoc.cpp			A p p e n d C o l o r						*
 ************************************************************************/
BOOL CColorTableDoc::AppendColor (short nTableIndex, COLORREF Color)
{
	BOOL bAppended = FALSE;

	INDEXCOLOR* ptEntry = new INDEXCOLOR;
	if (ptEntry != NULL)
	{  
		ptEntry->nIndex = nTableIndex;
		ptEntry->rgbQuad = this->ColorRefToRGBQuad(Color);
		m_IndexColors.Add (ptEntry);       	// add new Element  

		TRACE ("CColorTableDoc::AppendColor INDEXCOLOR %d\n", m_IndexColors.GetSize());

		bAppended = TRUE;      
	}
	return bAppended;
}

/************************************************************************
 *  ColTbDoc.cpp				I n s e r t C o l o r					*
 ************************************************************************/
BOOL CColorTableDoc::InsertColor (short nIndex, short nTableIndex, COLORREF Color)
{
	BOOL bInserted = FALSE;

	INDEXCOLOR* ptEntry = new INDEXCOLOR;
	if (ptEntry != NULL)
	{  
		ptEntry->nIndex = nTableIndex;
		ptEntry->rgbQuad = this->ColorRefToRGBQuad(Color);
		m_IndexColors.InsertAt (nIndex, ptEntry);       // insert new Element 

		TRACE ("CColorTableDoc:InsertColor INDEXCOLOR %d\n", nIndex);

		bInserted = TRUE;      
	}

return bInserted;
}

/************************************************************************
 *  ColTbDoc.cpp			G e t I n d e x C o l o r					*
 ************************************************************************/
BOOL CColorTableDoc::GetIndexColor (short nIndex, short* ptTableIndex, COLORREF* ptColor)
{
	BOOL bDefined = FALSE;

	if (nIndex >= 0 && nIndex < m_IndexColors.GetSize())
	{ 
		INDEXCOLOR* ptEntry = (INDEXCOLOR*)m_IndexColors.GetAt(nIndex);
		if (ptEntry != NULL)
		{  
			TRACE ("CColorTableDoc::GetColor %d\n", nIndex);

			*ptTableIndex = ptEntry->nIndex;
			*ptColor = this->RGBQuadToColorRef(ptEntry->rgbQuad);
			bDefined = TRUE;      
		}
	}

return bDefined;
}

/************************************************************************
 *  ColTbDoc.cpp			G e t I n d e x C o l o r					*
 ************************************************************************/
COLORREF CColorTableDoc::GetIndexColor (short nIndex, short* ptTableIndex)
{
	COLORREF Color;

	if (nIndex >= 0 && nIndex < m_IndexColors.GetSize())
	{ 
		INDEXCOLOR* ptEntry = (INDEXCOLOR*)m_IndexColors.GetAt(nIndex);
		if (ptEntry != NULL)
		{  
			TRACE ("CColorTableDoc::GetColor %d\n", nIndex);

			*ptTableIndex = ptEntry->nIndex;
			Color = this->RGBQuadToColorRef(ptEntry->rgbQuad);
		}
	}

return Color;
}


/************************************************************************
 *  ColTbDoc.cpp				C h a n g e C o l o r					*
 ************************************************************************/
BOOL CColorTableDoc::ChangeColor (short nIndex, INDEXCOLOR IndexColor)
{
BOOL bChanged = FALSE;

if (nIndex >= 0 && nIndex < m_IndexColors.GetSize())
	{ 
	INDEXCOLOR* ptEntry = (INDEXCOLOR*)m_IndexColors.GetAt(nIndex);
	if (ptEntry != NULL)
		{  
		TRACE ("CColorTableDoc::ChangeColor %d\n", nIndex);

									// copy Color into memory of array
		ptEntry->nIndex = IndexColor.nIndex;
		ptEntry->rgbQuad = IndexColor.rgbQuad;

		bChanged = TRUE;      
		}
	}

return bChanged;
}

/************************************************************************
 *  ColTbDoc.cpp			D e l e t e C o l o r						*
 ************************************************************************/
BOOL CColorTableDoc::DeleteColor (short nIndex)
{
BOOL bDeleted = FALSE;

if (nIndex >= 0 && nIndex < m_IndexColors.GetSize())
	{ 
	INDEXCOLOR* ptEntry = (INDEXCOLOR*)m_IndexColors.GetAt(nIndex);
	if (ptEntry != NULL)
		{  
		TRACE ("CColorTableDoc::DeleteColor INDEXCOLOR %d\n", nIndex);
		delete ptEntry;
		m_IndexColors.RemoveAt(nIndex);

		bDeleted = TRUE;      
		}
	}

return bDeleted;
}

/************************************************************************
 *  ColTbDoc.cpp					G e t C n t							*
 *  Purpose: returns number of manually defined colors					*
 ************************************************************************/
short CColorTableDoc::GetCnt()
{
	return m_IndexColors.GetSize();
}

/************************************************************************
 *  ColTbDoc.cpp			D e l e t e C o n t e n t s					*
 *  Called from: OnFileNew and OnFileOpen								*
 ************************************************************************/
void CColorTableDoc::DeleteContents()
{
this->DeleteArrayOf (&m_IndexColors);
}


/************************************************************************
 *  ColTbDoc.cpp			O n S a v e D o c u m e n t					*
 ************************************************************************/
BOOL CColorTableDoc::OnSaveDocument(const char* pszPathName, BOOL bConfirm)
{
BOOL bSaved = FALSE;
BOOL bDoSave;

if (bConfirm)
	{
	CString szText;
	CString szFileExt = this->GetTitle();
	szText.Format(IDF_SAVE_FILE, (LPCTSTR)szFileExt);
	bDoSave = (AfxMessageBox ((LPCSTR)szText, MB_YESNO) == IDYES);
	}
else{
	bDoSave = TRUE;
	}

if (bDoSave)
	{
	if (bDemo)
		{
		AfxMessageBox (IDS_SAVE_DISABLED);
		return bSaved;
		}
	else{
		bSaved = CDocument::OnSaveDocument(pszPathName); 
		}
	}        
else{   
    this->SetModifiedFlag (FALSE);
	}

return bSaved;
}

/************************************************************************
 *  ColTbDoc.cpp			G e t A c t u a l P a t h					*
 ************************************************************************/
CString CColorTableDoc::GetActualPath()
{
	CString szActualPath;          				// get path name for application
	szActualPath.Empty();
	char szIniPath[256];
	if (GetCurrentDirectory (256, szIniPath))
		szActualPath = (CString)szIniPath + "\\";

	return szActualPath;
}

/************************************************************************
 *  ColTbDoc.cpp					O p e n								*
 ************************************************************************/
BOOL CColorTableDoc::Open(CWnd* ptWnd) 
{
	// TODO: Add your control notification handler code here
BOOL bOpened = FALSE;
							// ask for new file name
//static char szFilter[] = "DeltaDoc (*.ddc) | *.ddc | Text Files (*.txt) | *.txt | All Files (*.*) | *.* ||"; 
static char BASED_CODE szFilter[] = "Farbtabelle (*.ctb)|*.ctb||"; 

CFileDialog dlg(TRUE, 	  					// File Open dialog
				(LPCTSTR)"ctb",				// default extension: "*.ctb"
				NULL,						// no initial filename
				OFN_HIDEREADONLY |	  		// dwFlags
				OFN_OVERWRITEPROMPT,
				szFilter,
				ptWnd);						// parent window

//CString szPath = this->GetActualPath();	// without NameExt
//dlg.m_ofn.lpstrInitialDir = (LPCTSTR)szPath;

int ret = dlg.DoModal();
if (ret == IDOK)
	{
	CString szNameNew = dlg.GetPathName();  
	if (this->OnOpenDocument (szNameNew))
		{
		this->SetPathName(szNameNew);
		bOpened = TRUE;
		}
	}

return bOpened;
}

/************************************************************************
 *  ColTbDoc.cpp					S a v e								*
 ************************************************************************/
BOOL CColorTableDoc::Save()
{
	BOOL bSaved=FALSE;
	
	CString szPath = this->GetPathName();
	bSaved = this->OnSaveDocument (szPath);

	return bSaved;	
}

/************************************************************************
 *  ColTbDoc.cpp					S a v e A s							*
 ************************************************************************/
BOOL CColorTableDoc::SaveAs(CWnd* ptWnd, BOOL bConfirm)
{
	// TODO: Add your control notification handler code here
BOOL bSaved=FALSE;
BOOL bDoSave;

if (bConfirm)
	{
	CString szText;
	CString szFileExt = this->GetTitle();
	szText.Format(IDF_SAVE_FILE, (LPCTSTR)szFileExt);
	bDoSave = (AfxMessageBox ((LPCTSTR)szText, MB_YESNO) == IDYES);
	}
else{
	bDoSave = TRUE;
	}

if (bDoSave)
	{							// ask for new file name
	static char szFilter[] = "Farbtabelle (*.ctb)|*.ctb||"; 

	CString szInitialName;
	szInitialName = this->GetTitle();

	CFileDialog dlg(FALSE, 	  					// File SaveAs dialog
					(LPCTSTR)"ctb",				// default extension "*.ctb"
					(LPCTSTR)szInitialName,		// initial filename
					OFN_HIDEREADONLY |	  		// dwFlags
					OFN_OVERWRITEPROMPT,
					szFilter,
					ptWnd);						// parent window

//	CString szPath = this->GetActualPath();	// without NameExt
//	dlg.m_ofn.lpstrInitialDir = (LPCTSTR)szPath;

	int ret = dlg.DoModal();
	if (ret == IDOK)
		{
		CString szPath = dlg.GetPathName();  
		this->SetPathName (szPath);

		if (this->OnSaveDocument (szPath))
			{	
			bSaved = TRUE;
			}
		}
	}

return (bSaved || !bDoSave);
}


/************************************************************************
 *  ColTbDoc.cpp  				S e r i a l i z e 						*
 ************************************************************************/
void CColorTableDoc::Serialize(CArchive& ar)
{    
	short i, nCnt;

	if (ar.IsStoring())
	{					// TODO: add storing code here  

		nCnt = m_IndexColors.GetSize();
		ar << m_nFinalCnt;		// final number of color table entries
		ar << nCnt;				// number of manually defined colors

		for (i=0; i<nCnt; i++)
		{
			INDEXCOLOR* ptEntry;
			ptEntry = (INDEXCOLOR*)m_IndexColors.GetAt(i);
			if (ptEntry != NULL)
			{
				ar << ptEntry->nIndex;
				ar.Write(&ptEntry->rgbQuad, sizeof(RGBQUAD));  
			}
		}      
	}
	else
	{				// TODO: add loading code here   
		this->DeleteArrayOf (&m_IndexColors);

		ar >> m_nFinalCnt;		// final number of color table entries
		ar >> nCnt;				// number of manually defined colors
		
		for (i=0; i<nCnt; i++)
		{
			INDEXCOLOR* ptEntry = new INDEXCOLOR; 
			if (ptEntry != NULL)
			{
				ar >> ptEntry->nIndex;
				ar.Read(&ptEntry->rgbQuad, sizeof (RGBQUAD));
				m_IndexColors.Add (ptEntry);       	// add new Element        
			}
 		}  
	}
}



/////////////////////////////////////////////////////////////////////////////
// CColorTableDoc diagnostics

#ifdef _DEBUG
void CColorTableDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CColorTableDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CColorTableDoc commands
